<?php

namespace App\Domain\Core\Datatables;

use App\Domain\Core\Models\Statistic;
use App\Support\Dashboard\Datatables\BaseDatatable;
use App\Support\Dashboard\Datatables\Columns\ImageColumn;
use App\Support\Dashboard\Datatables\Columns\ToggleSwitchColumn;
use Illuminate\Database\Eloquent\Builder;
use Yajra\DataTables\Html\Column;

class StatisticDatatable extends BaseDatatable
{
    protected ?int $defaultOrder = 5;
    public $defaultSort = 'asc' ;

    public function query(): Builder
    {
        return Statistic::query();
    }

    protected function columns(): array
    {
        return [
            Column::make('title.ar')->title(__('Title AR')),
            Column::make('title.en')->title(__('Title EN')),
            Column::make('number.ar')->title(__('Number AR')),
            Column::make('number.en')->title(__('Number EN')),
            Column::make('status')->title(__('Status')),
            Column::computed('image')->title(__('image')),
        ];
    }


    protected function orders(): array
    {
        return [
            'title.ar' => fn($i, $k) => $i->orderBy('title', $k),
            'title.en' => fn($i, $k) => $i->orderBy('title', $k),
            'number.ar' => fn($i, $k) => $i->orderBy('number', $k),
            'number.en' => fn($i, $k) => $i->orderBy('number', $k),

        ];
    }

    protected function filters(): array
    {
        return [
            'title.ar' => fn($i, $k) => $i->where('title', 'like', "%$k%"),
            'title.en' => fn($i, $k) => $i->where('title', 'like', "%$k%"),
            'number.ar' => fn($i, $k) => $i->where('number', 'like', "%$k%"),
            'number.en' => fn($i, $k) => $i->where('number', 'like', "%$k%"),  
        ];
    }

    public function customColumns(): array
    {
        return [
            'status' => function ($model) {
                return ToggleSwitchColumn::render($model->id , $model->status == 'active' ? true : false  , route('dashboard.core.statistics.update' , ['statistic' => $model->id  , 'updateStatus' => true]));
            },
            'image' => function ($model) {

                if ($model->getFirstMediaUrl() == null) {
                    return null;
                }
                return ImageColumn::render($model->getFirstMediaUrl());

            }
        ];
    }

}
