<?php

namespace App\Domain\Core\Models;

use App\Support\Concerns\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Spatie\Translatable\HasTranslations;

class City extends Model
{
    use HasFactory, HasTranslations, SoftDeletes;

    protected $guarded = [];

    protected array $translatable = ['title'];

    public function areas()
    {
        return $this->belongsTo(Area::class,'area_id');
    }

    public function states()
    {
        return $this->hasMany(State::class);
    }

    public function branches()
    {
        return $this->hasMany(Branch::class);
    }
}
