<?php

namespace App\Support\Traits;
use App\Support\Utils\ResponseUtil;
use Response;
/**
 * @mixin \Eloquent
 **/
trait ApiTrait
{
    public function sendResponse($result, $message)
    {
        return Response::json(ResponseUtil::makeResponse($message, $result));
    }

    public function sendError($error, $code = 200)
    {
        return Response::json(ResponseUtil::makeError($error), $code);
    }

    public function sendSuccess($message)
    {
        return Response::json([
            'status' => true,
            'message' => $message,
        ], 200);
    }
}

