<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Domain\Core\Models\Article;
use Illuminate\Support\Facades\Hash;
use App\Domain\Core\Models\Placeholder;
use App\Domain\Core\Models\Administration\User;
use HsmFawaz\UI\Services\RolesAndPermissions\RolesEnum;
use HsmFawaz\UI\Services\RolesAndPermissions\RolesSeeder;
use Codebase\PageBuilder\Database\Seeders\StaticPageSeeder;

class DatabaseSeeder extends Seeder
{
    public function run()
    {
        $this->call(RolesSeeder::class);
        $this->createCompanyUser('Company', 'company@admin.com', '+9665000000001');
        $this->setupUsers();
        $this->createPlaceholders();
    }

    private function setupUsers()
    {
        User::updateOrCreate(['email' => 'admin@admin.com'], [
            'phone' => '+20100000000',
            'first_name' => 'admin',
            'last_name' => 'Administrator',
            'password' => Hash::make('123456'),
        ])->assignRole(RolesEnum::super()->value);
        echo 'Admins Created Successfully' . PHP_EOL;
    }
    private function createCompanyUser($name, $email, $phone)
    {
        $company = User::updateOrCreate(['email' => $email], [
            'name' => 'company',
            'phone' => $phone,
            'first_name' => $name,
            'last_name' => $name,
            'password' => Hash::make('123456'),
        ])->assignRole(RolesEnum::company()->value);

    }

    public function createPlaceholders(){
        $placeholders = [
            ['name' => 'ar', 'value' => 'رقم الهاتف, مثال:  0100 123 4567'],
            ['name' => 'cs', 'value' => 'Víc se uč'],
            ['name' => 'da', 'value' => 'NU REGISTREREN'],
            ['name' => 'de', 'value' => '010 01234567'],
            ['name' => 'en', 'value' => 'Telephone, e.g.  0100 123 4567'],
            ['name' => 'es', 'value' => '010 01234567'],
            ['name' => 'fi', 'value' => '010 01234567'],
            ['name' => 'fr', 'value' => 'telefon'],
            ['name' => 'gr', 'value' => '010 01234567'],
            ['name' => 'hr', 'value' => 'telefon'],
            ['name' => 'hu', 'value' => 'telefon'],
            ['name' => 'id', 'value' => 'Telepon'],
            ['name' => 'is', 'value' => '010 01234567'],
            ['name' => 'it', 'value' => 'Telefono, es.  0100 123 4567'],
            ['name' => 'ja', 'value' => '電話'],
            ['name' => 'ko', 'value' => '전화번호 0100 123 4567'],
            ['name' => 'nl', 'value' => '010 01234567'],
            ['name' => 'no', 'value' => 'Telefon, f.eks. 0100 123 4567'],
            ['name' => 'ph', 'value' => 'Telepon'],
            ['name' => 'pl', 'value' => 'Víc se uč'],
            ['name' => 'pt', 'value' => 'Telefone'],
            ['name' => 'ro', 'value' => 'Telefon'],
            ['name' => 'ru', 'value' => 'Телефон, например 0100 123 4567'],
            ['name' => 'sk', 'value' => 'Telefón , e.g.  0100 123 4567'],
            ['name' => 'sv', 'value' => 'Telefón , e.g.  0100 123 4567'],
            ['name' => 'tr', 'value' => 'Telefon, ör.  0100 123 4567'],
            ['name' => 'zh', 'value' => '电话, e.g.  0100 123 4567'],
        ];

        foreach ($placeholders as $placeholder) {
            Placeholder::updateOrCreate(['name' => $placeholder['name']], $placeholder);
        }
    }
}
