<?php

namespace Codebase\PageBuilder\Editor;

use Codebase\PageBuilder\Models\EditablePage;
use Illuminate\Support\Facades\File;

class PersistPageContent
{
    public static function persist(EditablePage $page, ?string $html, ?string $css)
    {
        $path = EditablePage::getPagePath($page);
        static::writable($path);

        File::put($page->getCssPath(), $css);
        File::put($page->getHtmlPath(), $html);
    }

    protected static function writable(string $path): void
    {
        if (! File::isDirectory($path)) {
            File::makeDirectory($path, 493, true, true);
        }
        throw_if(! File::isWritable($path), \RuntimeException::class,
            'Pages Directory is not writable');
    }
}
