<?php $__env->startPush('meta'); ?>
    <title><?php echo e("$website_title | Reglene for bruksvilkårene"); ?></title>
    <meta name="description" content="<?php echo e("Vennligst se gjennom vilkårene våre før du bruker $website_title. De markerer dine rettigheter og forpliktelser, noe som hjelper med sikker bruk."); ?>" />
<?php $__env->stopPush(); ?>
<?php $__env->startSection('content'); ?>
    <div class="container page-inner pt-5">
        <h1><?php echo e(aiTrans('Vilkår for bruk')); ?></h1>
        <main>
            <p><span
                    style="font-weight: 400;"><?php echo e(aiTrans('Leverandør (den "Selskap", "oss", "vår" eller "vi") tilbyr vikarierende gjennom sitt utpekte programvare og nettsted (det "Nettsted") visse markedsførings-, annonserings-, promotering- og relaterte tjenester (den "Tjeneste"; brukere av Tjenesten skal omtales som "Brukere", "du" eller "ditt"). Disse vilkårene for bruk (de "Vilkårene") regulerer Brukernes tilgang til og bruk av Nettstedet og Tjenestene. Brukerne må godta disse Vilkårene før de bruker Nettstedet.')); ?></span>
            </p>
            <p><span style="font-weight: 400;"><?php echo e(aiTrans('Vennligst les disse Vilkårene nøye. Disse Vilkårene regulerer din tilgang til og bruk av Nettstedet og Tjenestene. Ved å få tilgang til, registrere deg for bruk, laste ned, dele eller på annen måte bruke Nettstedet eller bruke programvareskript som tilbys av oss for å gjøre Nettstedet tilgjengelig eller brukbart, signaliserer du din samtykke til både disse Vilkårene og vår personvernpolicy, som kan endres fra tid til annen etter vårt eget skjønn. Din fortsatte bruk av Nettstedet vil bli ansett som aksept av eventuelle endrede eller oppdaterte vilkår.')); ?>

                </span><span
                    style="font-weight: 400;"><?php echo e(aiTrans('Hvis du ikke godtar noen av disse Vilkårene, vennligst ikke klikk "AKSEPTER" og ikke bruk Nettstedet.')); ?></span>
            </p>
            <p><strong><?php echo e(aiTrans('Nettsted')); ?></strong> <?php echo e(aiTrans('refererer til [website_title] ',
                            $locale,
                            ['website_title' => $website_title],
                        )); ?>, tilgjengelig fra  <a
                    href="<?php echo e(route('home',$country)); ?>"><?php echo e($website_title); ?></a></p>
            <div id="toc_container" class="no_bullets">
                <ul class="toc_list">
                    <ul>
                        <li><a href="#1_Bruk_av_Nettsted_og_Tjenester"><span class="toc_number toc_depth_2">0.1</span>
                                <?php echo e(aiTrans('1. Bruk av Nettsted og Tjenester')); ?></a></li>
                    </ul>
                    <li><a href="#2_Beingrepsrestriksjoner"><span class="toc_number toc_depth_1">1</span>
                            <?php echo e(aiTrans('2. Restriksjoner')); ?></a></li>
                    <li><a href="#3_Promoteringsmateriell_og_Nyhetsbrev"><span class="toc_number toc_depth_1">2</span>
                            <?php echo e(aiTrans('3. Promoteringsmateriell og Nyhetsbrev')); ?></a></li>
                    <li><a href="#4_Intellektuell_eiendom"><span class="toc_number toc_depth_1">3</span>
                            <?php echo e(aiTrans('4. Intellektuell eiendom')); ?></a></li>
                    <li><a href="#5_Personvern"><span class="toc_number toc_depth_1">4</span> <?php echo e(aiTrans('5. Personvern')); ?></a>
                    </li>
                    <li><a href="#6_Lenker"><span class="toc_number toc_depth_1">5</span> <?php echo e(aiTrans('6. Lenker')); ?></a></li>
                    <li><a href="#7_Prohiberte_bruk"><span class="toc_number toc_depth_1">6</span>
                            <?php echo e(aiTrans('7. Prohiberte bruksområder')); ?></a></li>
                    <li><a href="#8_Støtte"><span class="toc_number toc_depth_1">7</span> <?php echo e(aiTrans('8. Støtte')); ?></a>
                    </li>
                    <li><a href="#9_Ansvarsfraskrivelse"><span class="toc_number toc_depth_1">8</span>
                            <?php echo e(aiTrans('9. Ansvarsfraskrivelse')); ?></a></li>
                    <li><a href="#10_Limitation_of_Liability"><span class="toc_number toc_depth_1">9</span>
                            <?php echo e(aiTrans('10. Begrensning av ansvar')); ?></a></li>
                    <li><a href="#11_Indemnification"><span class="toc_number toc_depth_1">10</span>
                            <?php echo e(aiTrans('11. Indemnification')); ?></a></li>
                    <li><a href="#12_Variasjoner"><span class="toc_number toc_depth_1">11</span>
                            <?php echo e(aiTrans('12. Diverse')); ?></a></li>
                </ul>
            </div>
            <h5><span id="1_Bruk_av_Nettsted_og_Tjenester"><b><?php echo e(aiTrans('1. Bruk av Nettsted og Tjenester')); ?></b></span></h5>
            <p><span
                    style="font-weight: 400;"><?php echo e(aiTrans('Med forbehold om vilkårene og betingelsene angitt her, kan du få tilgang til og bruke Nettstedet for formålet med å bruke Tjenestene på en ikke-eksklusiv basis. Du erkjenner at Selskapet kan, etter eget skjønn og når som helst, endre, oppdatere eller på annen måte endre Nettstedet eller Tjenestene, inkludert å avslutte levering av deler eller hele Nettstedet og/eller Tjenestene eller endre eller slette noe innhold tilgjengelig gjennom Nettstedet eller Tjenestene, uten forvarsel.')); ?></span>
            </p>
            <p><span
                    style="font-weight: 400;"><?php echo e(aiTrans('Bruken av Nettstedet og Tjenestene er ugyldig der det er forbudt. Ved å bruke Nettstedet og Tjenestene representerer og garanterer du at: (a) all informasjon du sender (hvis aktuelt) er sannferdig og nøyaktig; (b) du vil opprettholde nøyaktigheten av slik informasjon; (c) du er minst myndig i din jurisdiksjon; og (d) din bruk av Nettstedet eller Tjenestene ikke bryter med eller fremmer brudd på noen gjeldende lov eller forskrift eller noen juridisk eller kontraktsmessig forpliktelse du måtte ha overfor en tredjepart, og du har og vil til enhver tid overholde alle gjeldende lover, regler og forskrifter i forbindelse med din bruk av Tjenestene og Nettstedet, alle tjenester som er ordnet gjennom Tjenestene og Nettstedet, inkludert, men ikke begrenset til slike tjenester knyttet på noen måte til Produktene eller Tredjepartene, slik som vilkår er definert her.')); ?></span>
            </p>
            <p><span style="font-weight: 400;"><?php echo e(aiTrans('Underseksjoner (a)-(d) skal omtales, samlet, som')); ?>

                </span><b><?php echo e(aiTrans('“Brukernes forpliktelser og garantier“')); ?></b><span style="font-weight: 400;">.</span>
            </p>
            <p><span
                    style="font-weight: 400;"><?php echo e(aiTrans('Ved å bruke Tjenestene eller Nettstedet forstår og godtar du at Selskapet kan etter eget skjønn, men ikke er forpliktet til, å verifisere at noen eller alle Brukernes forpliktelser og garantier er oppfylt av noen Bruker, og du godtar videre at Selskapet ikke er ansvarlig for å sikre at Brukernes forpliktelser og garantier er oppfylt eller for noen unnlatelse av å suspendere, avslutte eller forhindre bruken av Tjenestene eller Nettstedet av Brukere som ikke oppfyller Brukernes forpliktelser og garantier. Du forstår at du alene er ansvarlig for å gjøre dine egne vurderinger, beslutninger og vurderinger om hvorvidt du skal inngå samarbeid med noen Tredjepart eller på annen måte samhandle med noen Tredjepart på noen måte. Hvis du blir klar over noen brudd på Brukernes forpliktelser og garantier, oppfordres du til å rapportere det til Selskapet.')); ?></span>
            </p>
            <p><span
                    style="font-weight: 400;"><?php echo e(aiTrans('Selskapet forbeholder seg retten til ikke å gi deg noen Tjenester med eller uten varsel etter eget skjønn, enten det blir gjort kjent for brudd på Brukernes forpliktelser og garantier (enten ved rapporter som er gitt til det av andre Brukere eller på annen måte) av deg eller noen annen Bruker, eller av en annen grunn. Uten å fravike fra det ovennevnte, fraskriver Selskapet seg uttrykkelig, og du fraskriver deg uttrykkelig Selskapet fra, ethvert og alt ansvar for enhver kontrovers, krav, søksmål, skader, tap, skade og/eller skader som oppstår fra og/eller på noen måte relatert til: (i) eventuelle unøyaktigheter, uriktige opplysninger eller ufullstendigheter i en Brukers eller Tredjeparts representasjoner; og (ii) feilopplysninger og/eller feilrepresentasjoner gjort, enten i forbindelse med eller av noen av Tredjepartene eller andre Brukere, Produkter eller på annen måte. Ved å bruke Nettstedet og Tjenestene forstår og godtar du at Tjenestene kun tilbyr en plattform utpekt for å hjelpe Brukere med å nå, kjøpe og/eller bruke ulike produkter og tjenester levert av tredjepartsleverandører og/eller tjenesteleverandører, gjennom annonser eller kampanjer som drives av oss (henholdsvis "Produktene" og "Tredjepartene", henholdsvis).')); ?></span>
            </p>
            <p><span
                    style="font-weight: 400;"><?php echo e(aiTrans('Du forstår og godtar at Selskapet: (a) ikke ansetter, anbefaler eller støtter noen Tredjepart eller Produkter, etter hva som er relevant, eller noen tilknyttede parter, og har ingen kontroll over handlingene eller unnlatelsene til noen Tredjepart, deres virksomhet, produkter eller tjenester; (b) gir ingen representasjoner eller garantier om Tredjepartene og Produktene, inkludert deres kvalitet, prising, kompatibilitet, tilgjengelighet eller noen andre funksjoner, eller om dine interaksjoner eller avtaler med noen Tredjepart; (c) gir ingen representasjoner eller garantier om de eiendomsrettslige rettighetene eller andre rettigheter eller funksjoner eller regulatoriske aspekter relatert til Produktene, inkludert eventuell nødvendig autorisasjon, tillatelser eller lisenser for opplasting, deling eller på annen måte gjøre tilgjengelig, og for bruken, salget og kjøpet av slike Produkter; og (d) ikke er ansvarlig for ytelsen eller oppførselen til noen Bruker eller andre tredjepart på noen måte ved bruk av eller har brukt Tjenestene, og/eller på eller utenfor Nettstedet. Selskapet er ikke forpliktet til å screene eller på annen måte verifisere noen informasjon angående Tredjepartene og/eller Brukerne, Produktene eller noen annen funksjon relatert til Nettstedet eller Tjenestene, og derfor bør du utvise forsiktighet og utføre dine egne undersøkelser og sjekker før du inngår samarbeid med noen gjennom Tjenestene eller Nettstedet eller på annen måte interagerer med noen.')); ?></span>
            </p>
            <p><span
                    style="font-weight: 400;"><?php echo e(aiTrans('Selskapet fraskriver seg uttrykkelig, og du fraskriver deg uttrykkelig Selskapet fra, ethvert og alt ansvar for enhver kontrovers, krav, søksmål, skader, tap, skade og/eller skader som oppstår fra og/eller på noen måte relatert til Tredjepartene, Produktene, Tjenestene og Nettstedet eller dine interaksjoner eller avtaler med noen Tredjepart, inkludert uten begrensning noen handlinger og/eller unnlatelser fra Tredjepartene på noen måte ved bruk eller i forbindelse med Tjenestene eller Nettstedet. Ved å bruke Tjenestene eller Nettstedet, erkjenner du at du er alene ansvarlig for slik bruk og forbindelser, interaksjoner, kjøp eller enhver annen handling du gjør og at all bruk av Tjenestene eller Nettstedet er på din egen risiko. For å unngå tvil, selger ikke Selskapet, lisenserer ikke eller på annen måte gjør tilgjengelig for deg noen Produkter eller tjenester (annet enn Tjenestene) og skal ikke ha noe ansvar for noen Produkter eller tjenester kjøpt av deg fra noen Tredjepart, inkludert uten begrensning, med hensyn til noen støtte og vedlikehold, mangler, feil, feil, skader eller kostnader av noe slag.')); ?></span>
            </p>
            <h4><span id="2_Beingrepsrestriksjoner"><span style="font-weight: 400;"><?php echo e(aiTrans('2. Restriksjoner')); ?></span></span>
            </h4>
            <p><span
                    style="font-weight: 400;"><?php echo e(aiTrans('Uten å fravike fra bestemmelsene i Seksjon 1, skal du ikke, og skal ikke tillate noen tredjepart, å: (a) reverse engineer eller forsøke å finne den underliggende koden til Nettstedet eller Tjenestene; (b) bruke Nettstedet eller Tjenestene i strid med noen gjeldende lov eller forskrift, inkludert, men ikke begrenset til, å legge ut, publisere, dele eller på annen måte overføre noe ulovlig eller støtende materiale; (c) kopiere, modifisere eller opprette derivative verk av Nettstedet, Tjenestene eller innholdet av noen av Nettstedet eller Tjenestene; (d) forsøke å deaktivere eller omgå noen sikkerhets- eller tilgangskontrollmekanisme for Nettstedet eller Tjenestene; (e) designe eller bistå i å designe juksemidler, utnyttelser, automatiseringsprogramvare, bots, hacks, moduser eller annen uautorisert tredjeparts programvare for å modifisere eller forstyrre Nettstedet eller Tjenestene; (f) bruke Nettstedet eller Tjenestene eller engasjere deg med andre Brukere for noe formål som er i strid med noen gjeldende lov eller forskrift; (g) forsøke å oppnå uautorisert tilgang til Nettstedet eller Tjenestene, andre Brukerkontoer, som definert nedenfor, eller annen enhet, datasystem, telefonsystem eller nettverk tilknyttet Nettstedet eller Tjenestene; og (h) innhente eller på annen måte samle informasjon om Brukere uten deres samtykke.')); ?></span>
            </p>
            <p><span
                    style="font-weight: 400;"><?php echo e(aiTrans('Hvis du legger ut, publiserer, deler eller på annen måte overfører gjennom Nettstedet og/eller bruker Tjenestene noe innhold, representerer og garanterer du at slikt innhold gir et nøyaktig og fullstendig bilde av eventuelle produkter eller tjenester beskrevet der, overholder disse Vilkårene her, og ikke: (a) krenker intellektuelle eiendoms-, moralske eller publisitet rettigheter til noen tredjepart; (b) inneholder noe ærekrenkende, skadelig, usømmelig, seksuelt forslag eller på annen måte støtende innhold (inkludert materiale som fremmer eller glorifiserer hat, vold eller bigotteri); (c) inneholder noen ormer, virus eller på annen måte ondsinnet programvare; (d) bryter med noen gjeldende lov eller forskrift, inkludert noen lov eller forskrift som gjelder reklame eller markedsføring; og (e) foretar noen handling som pålegger en urimelig eller uforholdsmessig stor belastning på vår infrastruktur.')); ?></span>
            </p>
            <p><span
                    style="font-weight: 400;"><?php echo e(aiTrans('Ved å legge ut, laste opp, publisere, dele eller på annen måte overføre noe innhold ved bruk av Nettstedet eller Tjenestene, gir du herved uopprettelig Selskapet og eventuelle tilknyttede selskaper og/eller underlisenser en verdensomspennende, ikke-eksklusiv, evigvarende, royalty-fri lisens til å publisere, dele, vise og på annen måte overføre slikt innhold i enhver rimelig form som Selskapet bestemmer etter eget skjønn. Selskapet forbeholder seg retten til å fjerne, suspendere tilgangen til eller permanent slette noe innhold i samsvar med sitt eget skjønn uten forvarsel, inkludert uten begrensning noe innhold som bryter med garantiene angitt ovenfor eller Selskapets forretningsinteresser, og du skal ikke ha noen rett eller krav med hensyn til noen slike avgjørelser og handlinger.')); ?></span>
            </p>
            <p><span
                    style="font-weight: 400;"><?php echo e(aiTrans('Selskapet er ikke, og skal ikke være, ansvarlig for noe innhold som tilbys, legges ut, lastes opp, deles eller på annen måte gjøres tilgjengelig av Brukere, noen produkter eller tjenester relatert til slikt innhold som tilbys, legges ut, lastes opp, deles eller på annen måte gjøres tilgjengelig av Brukere. Hver Bruker som bruker Nettstedet eller Tjenestene representerer herved at de tar fullt ansvar for dette, og Selskapet skal ikke pådra seg noe ansvar med hensyn til det foregående.')); ?></span>
            </p>
            <h4><span id="3_Promoteringsmateriell_og_Nyhetsbrev"><span
                        style="font-weight: 400;"><?php echo e(aiTrans('3. Promoteringsmateriell og Nyhetsbrev')); ?></span></span>
            </h4>
            <p><span
                    style="font-weight: 400;"><?php echo e(aiTrans('I tillegg til bestemmelsene i Seksjon 3 ovenfor, gir Brukeren sitt uttrykkelige samtykke til Selskapet om å gi Brukeren promotering materiell og nyhetsbrev (de "Promoteringsmateriellet og Nyhetsbrevene") med alle tilgjengelige midler, inkludert via e-post, tekst og SMS-meldinger, faks, post, automatiserte ringetjenester eller andre midler, alt i samsvar med Selskapets eget skjønn som kan endres fra tid til annen, og å motta slike Promoteringsmateriell og Nyhetsbrev.')); ?></span>
            </p>
            <p><span
                    style="font-weight: 400;"><?php echo e(aiTrans('Brukeren erkjenner videre at Promoteringsmateriellet og Nyhetsbrevene kan inkludere annonsering fra tredjeparter, og han gir uttrykkelig sitt samtykke til å motta slike annonser som en del av Promoteringsmateriellet og Nyhetsbrevene. Brukeren kan kontakte Selskapet når som helst ved å sende en forespørsel via e-post som varsler Selskapet om sin avvisning av å motta ytterligere Promoteringsmateriell og Nyhetsbrev.')); ?></span>
            </p>
            <h4><span id="4_Intellektuell_eiendom"><span
                        style="font-weight: 400;"><?php echo e(aiTrans('4. Intellektuell eiendom')); ?></span></span></h4>
            <p><span
                    style="font-weight: 400;"><?php echo e(aiTrans('Selskapet er eier av alle rettigheter, titler og interesser over hele verden i: (a) Nettstedet og Tjenestene, forbedringer, derivater, feilrettinger eller forbedringer til Nettstedet og Tjenestene; og (b) forretningsnavn, varemerker og logoer til Selskapet, og skal til enhver tid forbli utelukkende hos Selskapet. Alle referanser i disse Vilkårene eller i andre kommunikasjoner til salg, videresalg eller kjøp av det foregående skal bety bare retten til å bruke Nettstedet og Tjenestene i henhold til disse Vilkårene. Brukerne bærer alene ansvaret for alt og alt innhold, inkludert eventuelle immaterielle rettigheter, som er levert, delt eller på annen måte gjort tilgjengelig av Brukerne som bruker Nettstedet og/eller Tjenestene, og Selskapet gir ingen representasjon med hensyn til noe slikt innhold. Selskapet skal ikke være ansvarlig for eventuelle tap eller skader påført av slikt innhold, og Brukerne godtar å holde Selskapet skadesløs for eventuelle skader eller tap som oppstår fra det ovennevnte.')); ?></span>
            </p>
            <h4><span id="5_Personvern"><span style="font-weight: 400;"><?php echo e(aiTrans('5. Personvern')); ?></span></span></h4>
            <p><span
                    style="font-weight: 400;"><?php echo e(aiTrans('Du forplikter deg til ikke å lagre, samle eller på annen måte opprettholde i din besittelse og bruke noe innhold levert av Tjenestene og Nettstedet uten Selskapets skriftlige forhåndssamtykke. Du erkjenner videre at Selskapet forbeholder seg retten, etter eget skjønn, til å lagre, samle eller på annen måte opprettholde i sin besittelse og bruke noe innhold og offentlig informasjon, inkludert informasjon som kan identifisere deg personlig eller enhver annen Bruker eller Tredjepart eller beskrive dine personlige interesser. Selskapet forbeholder seg retten til å gjøre enhver og all tillatt bruk i henhold til gjeldende lov av slikt innhold og offentlig informasjon som angitt i Selskapets personvernpolicy. Uten å fravike fra bestemmelsene i Seksjon 1 ovenfor, gjennomgår ikke Selskapet, tester, bekrefter, godkjenner eller på annen måte verifiserer noe slikt innhold eller offentlig informasjon. Hver Bruker som legger ut, laster opp, deler eller på annen måte gjør tilgjengelig slikt innhold eller offentlig informasjon skal bære det fulle ansvaret for innholdet eller den offentlige informasjonen, inkludert all informasjon fra tredjeparter og nødvendige samtykker. Selskapet skal ikke være ansvarlig for noe tap eller skade påført ved å ikke overholde det ovennevnte, og du godtar å holde Selskapet skadesløs for eventuelle skader eller tap som oppstår fra det ovennevnte. TIL TROSS FOR DET FOREGÅENDE, FORSTÅR DU OG ERKJENNER AT Selskapet IKKE ER EN INNHOLDSLAGRINGSTJENESTE. SELSKAPET SKAL IKKE HA NOE ANSVAR FOR TAPTE ELLER SLETTET INNHOLD ELLER OFFENTLIG INFORMASJON. DU BØR VÆRE OPPMERKSOM PÅ AT NOE INNHOLD SOM LEGGER UT, LASTER OPP, DELER ELLER PÅ ANNET MÅTE GJØRES TILGJENGELIG KAN BLI LEST, INNHENTET OG BRUKT AV ANDRE BRUKERE, OG KAN BRUKES TIL Å SENDE UBEGJERT INNHOLD.')); ?></span>
            </p>
            <h4><span id="6_Lenker"><span style="font-weight: 400;"><?php echo e(aiTrans('6. Lenker')); ?></span></span></h4>
            <p><span
                    style="font-weight: 400;"><?php echo e(aiTrans('Nettstedet eller Tjenestene kan inneholde lenker eller annet innhold relatert til nettsteder, annonsører, forleggere eller Produkter tilbudt av tredjeparter. Selskapet har ingen kontroll og gir ingen representasjon med hensyn til det samme eller noen informasjon gitt eller overført via det samme, eller på annen måte gitt av noen slik tredjepart. DU FORSTÅR OG GODTAR AT BRUK AV SLIKE LENKER ELLER ANNET INNHOLD ER PÅ DIN EGEN RISIKO, AT SLIKE LENKER ELLER ANNET INNHOLD REGULERES AV SLIKE TREDJEPARTERS VILKÅR FOR BRUK OG PERSONVERNPOLICYER, OG AT SELSKAPET IKKE ER ANSVARLIG FOR PERSONVERNET ELLER FORRETNINGS-PRAKSISENE ELLER ANDRE RETNINGSLINJER FOR SLIKE TREDJEPARTER. DU bør nøye gjennomgå de gjeldende vilkårene og retningslinjene som gjelder for noen SLIKE Tredjepart. SELSKAPET ER IKKE ANSVARLIG ELLER REGISTRERT PÅ NOE MÅTE FOR SLIKE TREDJEPARTER, ELLER FOR NOE TAP ELLER SKADE AV NOEN SLAG PÅFØRT SOM FØLGE AV DET, OG SELSKAPET FRASKRIVER SEG UTTRYKKELIG, OG DU FRASKRIVER DEG UTTRYKKELIG SELSKAPET FRA, ETHVERT OG ALT ANSVAR FOR NOEN OG ALL HVA SOM HELST FOR EVENTYRE, KRAV, SØKSMÅL, SKADER, TAP, SKADE OG/ELLER SKADER, SOM OPPSTÅR FRA OG/ELLER PÅ NOEN MÅTE RELATERT TIL SLIKE TREDJEPARTENE, INKLUDERT UTEN BEGRENSNING RELATENDE TIL TILGJENGELIGHET, VILKÅR FOR BRUK, PERSONVERN, INFORMASJON, INNHOLD, MATERIALER, ANNONCERING, KOSTNADER, PRODUKTER OG/ELLER TJENESTER.')); ?></span>
            </p>
            <h4><span id="7_Prohiberte_bruk"><span
                        style="font-weight: 400;"><?php echo e(aiTrans('7. Prohiberte bruksområder')); ?></span></span></h4>
            <p><span
                    style="font-weight: 400;"><?php echo e(aiTrans('Nettstedet og Tjenestene må ikke brukes i forbindelse med noen kommersielle bestrebelser (med mindre annet er tillatt av Selskapet i forbindelse med Brukere til noen Tredjepart) uten uttrykkelig skriftlig samtykke fra Selskapet. Nettstedet og Tjenestene må ikke brukes av noen person eller organisasjon for å rekruttere for et annet nettsted, be om, annonsere eller kontakte på noen form Brukere for ansettelse, kontraktering eller noe annet formål for en virksomhet som ikke er tilknyttet Selskapet uten uttrykkelig skriftlig tillatelse fra Selskapet. Du samtykker i å ikke bruke Tjenestene og Nettstedet for å kontakte, annonsere, be om eller selge til noen annen Bruker uten deres uttrykkelige samtykke, med mindre annet er tillatt under disse Vilkårene.')); ?></span>
            </p>
            <h4><span id="8_Støtte"><span style="font-weight: 400;"><?php echo e(aiTrans('8. Støtte')); ?></span></span></h4>
            <p><span
                    style="font-weight: 400;"><?php echo e(aiTrans('Brukere kan kontakte Selskapet angående støtte for Nettstedet og Tjenestene ved å sende en e-post')); ?></span>
            </p>
            <h4><span id="9_Ansvarsfraskrivelse"><span style="font-weight: 400;"><?php echo e(aiTrans('9. Ansvarsfraskrivelse')); ?></span></span></h4>
            <p><span
                    style="font-weight: 400;"><?php echo e(aiTrans('Selskapet gjør rimelige anstrengelser for å sikre at teknologien holder Nettstedet og Tjenestene sikre. Imidlertid er ingen teknologi 100% sikker. Derfor, selv om vi streber etter å bruke kommersielt akseptable midler for å beskytte dine personopplysninger, kan vi ikke garantere dens absolutte sikkerhet. Med mindre det uttrykkelig er angitt her, er din bruk av Nettstedet og Tjenestene på din egen risiko. Nettstedet og Tjenestene tilbys på en "SOM DET ER" og "SOM TILGJENGELIG" basis uten garantier av noe slag. Selskapet fraskriver seg uttrykkelig alle underforståtte eller lovbestemte garantier av noe slag relatert til Nettstedet og Tjenestene, inkludert uten begrensning garantier om tittel, salgbarhet, egnethet for et bestemt formål, ikke-inngripen av eiendomsrettigheter, handlingsforløp eller ytelse. Selskapet gir ingen råd angående risikoen eller egnetheten for noen handel, transaksjon eller engasjement. Selskapet påtar seg intet ansvar for noen transaksjon eller engasjement gjort av deg, og du erkjenner at du alene er ansvarlig for vurderingen av dine transaksjoner og engasjementer. Du skal ikke holde Selskapet, dets ledere, ansatte eller tilknyttede selskaper ansvarlige for eventuelle transaksjoner eller engasjementsvalg gjort av deg. Ingen råd eller informasjon, enten muntlig eller skriftlig, oppnådd av deg fra Selskapet eller dets ledere, ansatte eller tilknyttede selskaper, skal skape noen garanti som ikke uttrykkelig er angitt i disse Vilkårene. Hvis du velger å stole på slik informasjon, gjør du det utelukkende på egen risiko. Noen stater eller jurisdiksjoner tillater ikke ekskludering av visse garantier. Følgelig kan noen av de ovennevnte unntakene ikke gjelde for deg.')); ?></span>
            </p>
            <h4><span id="10_Begrensning_av_ansvar"><span
                        style="font-weight: 400;"><?php echo e(aiTrans('10. Begrensning av ansvar')); ?></span></span></h4>
            <p><span
                    style="font-weight: 400;"><?php echo e(aiTrans('Selskapet garanterer ikke verdien, kvaliteten, kompatibiliteten eller noen annen funksjon av Tredjepartene, Produktene eller annen informasjon som er gitt, konsumert eller på annen måte gjort tilgjengelig (heretter i denne Seksjonen: "Funksjoner"). Enhver Funksjon er under det utelukkende ansvaret til den aktuelle Tredjeparten eller Brukeren som bruker den, etter hva som er aktuelt, eller bruker Tjenestene eller Nettstedet. Selskapet påtar seg ikke å overvåke slik overholdelse og kan handle der brudd på oppdages etter eget skjønn, som beskrevet i disse Vilkårene. Du forstår og godtar at du kan bli utsatt for innhold eller annen informasjon som er unøyaktig, upassende, uegnet for barn, eller på annen måte ikke egnet for deg.')); ?></span>
            </p>
            <p><span
                    style="font-weight: 400;"><?php echo e(aiTrans('Selskapet er ikke ansvarlig for eventuelle problemer eller tekniske feil i noen telefonnettverk eller linjer, datamaskin online-systemer, servere eller leverandører, datamaskinutstyr, programvare, feil av noen e-post på grunn av tekniske problemer eller trafikkbelastning på Internett eller på noen av Nettstedet eller Tjenestene eller en kombinasjon derav, inkludert enhver skade eller skade på Brukere eller på noen persons datamaskin, mobiltelefon eller annen enhet relatert til eller som følger av deltakelse eller nedlasting av materialer i forbindelse med Nettstedet eller Tjenestene. Under ingen omstendigheter skal Selskapet være ansvarlig for oppførselen til tredjeparter, inkludert noen Brukere, enten online eller offline, og operatører av eksterne nettsteder.')); ?></span>
            </p>
            <p><span
                    style="font-weight: 400;"><?php echo e(aiTrans('I ingen tilfelle skal Selskapet eller noen av dets ledere, direktører, ansatte eller agenter være ansvarlige overfor deg for eventuelle indirekte, tilfeldige, spesielle, straffende eller følgeskader, som oppstår fra eller i forbindelse med din bruk av Nettstedet eller Tjenestene, enten skadene er forutsigbare eller ikke og enten Selskapet har blitt informert om muligheten for slike skader. Den ovennevnte begrensningen av ansvar skal gjelde i størst mulig grad tillatt av loven i den aktuelle jurisdiksjonen.')); ?></span>
            </p>
            <h4><span id="11_Indemnification"><span
                        style="font-weight: 400;"><?php echo e(aiTrans('11. Indemnification')); ?></span></span></h4>
            <p><span
                    style="font-weight: 400;"><?php echo e(aiTrans('Du vil forsvare, erstatte og holde Selskapet skadesløs fra og mot alle søksmål, prosesser, påstander, skader, kostnader, forpliktelser eller utgifter (inkludert rettskostnader og rimelige advokaters honorarer) som Selskapet måtte lide eller pådra seg i forbindelse med ethvert faktisk krav, etterspørsel, handling eller annen prosedyre fra enhver tredjepart som oppstår fra eller relatert til ethvert brudd på disse Vilkårene av deg eller enhver bruk av Nettstedet eller Tjenestene av deg ikke i samsvar med gjeldende lov.')); ?></span>
            </p>
            <h4><span id="12_Variasjoner"><span
                        style="font-weight: 400;"><?php echo e(aiTrans('12. Diverse')); ?></span></span></h4>
            <p><span
                    style="font-weight: 400;"><?php echo e(aiTrans('Disse Vilkårene skal reguleres av lovene i England, eksklusiv valg av lov regler, og uten hensyn til FNs konvensjon om internasjonal salg av varer. Din oppførsel kan også være underlagt andre lokale, statlige og nasjonale lover. Enhver tvist som oppstår under disse Vilkårene eller angående Nettstedet eller Tjenesten skal endelig avgjøres av de kompetente domstolene i England. Du kan ikke fremme noen gruppesøksmål mot Selskapet, og ved å bruke Nettstedet eller Tjenestene godtar du å gi avkall på rettighetene dine til å fremme slike gruppesøksmål.')); ?></span>
            </p>
            <p><span
                    style="font-weight: 400;"><?php echo e(aiTrans('Enhver årsak til handling mot Selskapet må bringes innen ett (1) år fra datoen slik årsak til handling oppsto. I tilfelle noen bestemmelse i disse Vilkårene holdes ugyldig, skal slik bestemmelse erstattes med en håndhevelig bestemmelse som nærmest oppnår effekten av den opprinnelige bestemmelsen, og de gjenværende vilkårene i disse Vilkårene skal forbli i full kraft og virkning. Ingenting i disse Vilkårene skaper noe agentur, ansettelses-, joint venture- eller partnerskapsforhold mellom deg og Selskapet eller gjør det mulig for deg å handle på vegne av Selskapet. Med mindre det uttrykkelig er angitt i disse Vilkårene, utgjør disse Vilkårene hele avtalen mellom Selskapet og deg vedrørende emnet her.')); ?></span>
            </p>
            <p><span
                    style="font-weight: 400;"><?php echo e(aiTrans('Enhver melding som vi måtte være forpliktet til å gi deg, enten under lov eller i henhold til disse Vilkårene, kan gis av Selskapet til enhver kontaktinformasjon du har oppgitt i kontoinformasjonen din eller på annen måte, enten direkte eller indirekte, inkludert via e-post. Du samtykker uttrykkelig til å motta slike kommunikasjoner og meldinger på en slik måte.')); ?></span>
            </p>
            <p><span
                    style="font-weight: 400;"><?php echo e(aiTrans('Du kan ikke overføre noen rettigheter herunder uten vårt skriftlige forhåndssamtykke. Ingenting i disse Vilkårene skal tolkes som å begrense handlingene eller rettsmidlene tilgjengelige for Selskapet med hensyn til enhver forbudt aktivitet eller oppførsel. Manglende håndhevelse av noen bestemmelse i disse Vilkårene utgjør ikke samtykke eller avkall, og Selskapet forbeholder seg retten til å håndheve slik bestemmelse etter eget skjønn. Ingen avkall på brudd eller mislighold herunder skal anses som et avkall på noe tidligere eller påfølgende brudd eller mislighold.')); ?></span>
            </p>
            <p> </p>
        </main>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/enng1/public_html/immediate13.com/resources/views/frontend/no/terms.blade.php ENDPATH**/ ?>