
<?php $__env->startPush('meta'); ?>
    <title><?php echo e("$website_title | Descubre más acerca de nuestro sitio"); ?></title>
    <meta name="description" content="<?php echo e("Incrementa tus habilidades de trading en criptomonedas a un alto nivel con $website_title. Disfruta de soporte completo y herramientas revolucionarias para alcanzar tus metas."); ?>" />
<?php $__env->stopPush(); ?>
<?php $__env->startSection('content'); ?>
<div class="about_page">
    <section class="about-bg">
        <div class="container text-center" style="max-width: 1120px;">
            <h1 class="about-header white">
                <?php echo e(aiTrans(
                    'Descubre [website_title] ',
                    $locale,
                    ['website_title' => $website_title],
                )); ?>

                </h1>
        </div>
    </section>

    <section class="about-half-1">
        <div class="container">
            <div class="row">
                <div class="col-md-8">
                    <h2 class="title">
                        
                        <?php echo e(aiTrans(
                            'El origen de [website_title] ',
                            $locale,
                            ['website_title' => $website_title],
                        )); ?></h2>
                    <p><b>
                        
                        <?php echo e(aiTrans(
                            'Todo gran viaje comienza con una visión. Para [website_title], esa visión surgió de un grupo de innovadores unidos por un propósito común: simplificar el aprendizaje de inversiones para todos. Unidos por su pasión por el conocimiento, este equipo se propuso eliminar las barreras entre los inversores principiantes y la educación experta.',
                            $locale,
                            ['website_title' => $website_title],
                        )); ?>

                        </b></p>
                    <p>
                        <?php echo e(aiTrans(
                            'Al identificar una necesidad crítica de educación financiera accesible y de alta calidad, fundaron [website_title]. Esta plataforma fue creada como una ruta directa y gratuita para democratizar el conocimiento de inversiones para todos.',
                            $locale,
                            ['website_title' => $website_title],
                        )); ?>

                        </p>
                </div>
            </div>
        </div>
    </section>

    <section class="padding-60 pt-2">
        <div class="container mb-4 mb-md-5">
            <p>
                <?php echo e(aiTrans(
                    'En un ámbito frecuentemente visto como complejo e intimidante, [website_title] se erige como un faro de guía. Sus creadores se propusieron establecer una plataforma que conecte sin esfuerzo a aquellos apasionados por las inversiones con mentores educativos de primer nivel.',
                    $locale,
                    ['website_title' => $website_title],
                )); ?>

                </p>
            <p>
                <?php echo e(aiTrans(
                    '[website_title] es una prueba de la sinergia entre la curiosidad y la oportunidad, creando vías para aquellos deseosos de adentrarse en el mundo de la inversión, ofreciendo claridad y empoderamiento.',
                    $locale,
                    ['website_title' => $website_title],
                )); ?>

                </p>
        </div>
        <div class="container" style="max-width: 1300px;">
            <div class="row">
                <div class="col-md-6">
                    <div class="count-item">
                        <h3 class="count-item-title count-item-title--check count-item-title--gray">
                            <?php echo e(aiTrans(
                                'La evolución de [website_title]: Del concepto a la realidad',
                                $locale,
                                ['website_title' => $website_title],
                            )); ?>

                            </h3>
                        <div class="count-item-content">
                            <p>
                                <?php echo e(aiTrans(
                                    '¿Interesado en la historia de [website_title] y su transformación en la entidad que es hoy?',
                                    $locale,
                                    ['website_title' => $website_title],
                                )); ?>

                                </p>
                            <div class="group-text-wrap">
                                <input type="checkbox" id="group-text-1">
                                <div class="group-text">
                                    <p>
                                        <?php echo e(aiTrans(
                                            'Un grupo de pensadores innovadores diseñó [website_title], con el propósito de hacer más claro el campo de la inversión para un público amplio. Su camino hacia la iluminación financiera reveló una necesidad evidente: la falta de educación financiera accesible y de calidad para el público en general.',
                                            $locale,
                                            ['website_title' => $website_title],
                                        )); ?>

                                        </p>
                                    <p>
                                        <?php echo e(aiTrans(
                                            'Esta comprensión impulsó la creación de [website_title], diseñado para llenar este vacío. Más que una plataforma, es una comunidad que conecta a los aprendices con recursos educativos de élite. Funciona como un centro de intercambio de conocimientos, asegurando que los consejos de inversión perspicaces estén disponibles para todos.',
                                            $locale,
                                            ['website_title' => $website_title],
                                        )); ?>

                                        </p>
                                    <p>
                                        <?php echo e(aiTrans(
                                            'Al facilitar las conexiones entre los inversores en ciernes y las instituciones educativas de primer nivel, [website_title] abre un mundo de conocimiento profundo sobre la inversión, fomentando una cultura donde la educación financiera prospera.',
                                            $locale,
                                            ['website_title' => $website_title],
                                        )); ?>

                                        </p>
                                </div>
                                <label for="group-text-1" class="group-text-more"><?php echo e(aiTrans('Descubre más')); ?></label>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="count-item">
                        <h3 class="count-item-title count-item-title--check count-item-title--gray">
                            <?php echo e(aiTrans(
                                'Alimentando la Visión de [website_title]',
                                $locale,
                                ['website_title' => $website_title],
                            )); ?>

                            </h3>
                        <div class="count-item-content">
                            <div class="group-text-wrap">
                                <input type="checkbox" id="group-text-2">
                                <div class="group-text">
                                    <p>
                                        <?php echo e(aiTrans(
                                            'La fundación de [website_title] fue impulsada por la ambición de universalizar la educación en inversión. Reconociendo los desafíos que muchos enfrentaban para encontrar información confiable sobre inversión, los fundadores se propusieron crear una plataforma que eliminara estos obstáculos.',
                                            $locale,
                                            ['website_title' => $website_title],
                                        )); ?>

                                        </p>
                                    <p>
                                        <?php echo e(aiTrans(
                                            '[website_title] simboliza el pináculo de la educación en inversión accesible, proporcionando un puente a través de las complejidades de los mercados financieros. Se dirige a aprendices de todos los orígenes, desmitificando los conceptos de inversión y fomentando un mundo de estrategias de inversión informadas.',
                                            $locale,
                                            ['website_title' => $website_title],
                                        )); ?>

                                        </p>
                                </div>
                                <label for="group-text-2" class="group-text-more"><?php echo e(aiTrans('Saber más')); ?></label>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="text-center">
                <a href="<?php echo e(route('home',$country)); ?>" class="main-form-btn"><?php echo e(aiTrans('REGÍSTRATE GRATIS AHORA')); ?></a>
            </div>
        </div>
    </section>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/enng1/public_html/immediate13.com/resources/views/frontend/es/about.blade.php ENDPATH**/ ?>