<?php

namespace App\Domain\Tenant\Job;


use App\Domain\Core\Models\Administration\User;
use App\Domain\Tenant\Models\Tenant;
use HsmFawaz\UI\Services\RolesAndPermissions\RolesEnum;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;

class CreateTenantAdmin implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    /**
     * Create a new job instance.
     */
    public function __construct(public Tenant $tenant)
    {
        //
    }
    /**
     * Execute the job.
     */
    public function handle(): void
    {
        $this->tenant->run(function ($tenant) {
            User::create($tenant->only('name', 'email', 'password','phone'))->assignRole(RolesEnum::super()->value);
        });
    }
}