<?php

namespace App\Http\Controllers\Dashboard\Link;
use App\Http\Controllers\Dashboard\DashboardController;
use App\Support\Dashboard\Crud\WithDatatable;
use App\Support\Dashboard\Crud\WithDestroy;
use App\Domain\Core\Enums\CorePermissions;
use App\Support\Dashboard\Crud\WithForm;
use App\Support\Dashboard\Crud\WithStore;
use App\Support\Dashboard\Crud\WithUpdate;
use Illuminate\Database\Eloquent\Model;
use App\Domain\Link\Datatables\LinkDatatable;
use App\Domain\Link\Models\Link;

class LinkController extends DashboardController
{
    use WithDatatable,  WithForm , WithStore ,WithUpdate , WithDestroy;

    protected string $name = 'Link';
    protected string $path = 'dashboard.link.links';
    protected string $datatable = LinkDatatable::class;
    protected string $model = Link::class;
    protected array $permissions = [CorePermissions::class, 'links'];


    protected function rules()
    {
        return [
            'url'=>'required|string'
        ];
    }

    protected function formData(?Model $model = null): array
    {
        return [

        ];
    }
}
