<?php

namespace App\Http\Resources\API\Driver;

use App\Domain\Order\OrderStatus\Enums\AppointmentOrderStatusEnum;
use App\Domain\Order\OrderStatus\Enums\SparePartOrderStatusEnum;
use App\Domain\Order\OrderStatus\Enums\WenchOrderStatusEnum;
use App\Http\Resources\API\Order\OrderDetailsResource;
use App\Http\Resources\API\Order\ServiceOrderResource;
use App\Http\Resources\API\Job\OfferResource;
use App\Http\Resources\API\Order\SparePartOrderResource;
use App\Http\Resources\API\Job\SparePartResource;
use App\Http\Resources\API\User\VendorResource;
use App\Support\Traits\WithPagination;
use Carbon\Carbon;
use Illuminate\Http\Resources\Json\JsonResource;

class DriverWenchRequestDetailsResource extends JsonResource
{
    use WithPagination;

    /**
     * Transform the resource into an array.
     *
     * @param \Illuminate\Http\Request $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {

        return [
            'id' => $this->id,
            'is_return' => $this->is_return,
            'pickup_lat' => $this->pickup_lat,
            'pickup_lng' => $this->pickup_lng,
            'pickup_address' => $this->pickup_address,
            'return_lat' => $this->return_lat,
            'return_lng' => $this->return_lng,
            'return_address' => $this->return_address,
            'delivery_direction' => __($this->delivery_direction),
            'status' => $this->status,
            'status_value' => WenchOrderStatusEnum::{$this->status}()->value,
            'order' => new WenchOrderResource($this->order),
        ];
    }

}
