<?php

namespace App\Http\Resources\API\Order;

use App\Domain\Order\Actions\CanSelectServicesOrSparePartAction;
use App\Support\Traits\WithPagination;
use Illuminate\Http\Resources\Json\JsonResource;

class OfferOrderResource extends JsonResource
{
    use WithPagination;

    /**
     * Transform the resource into an array.
     *
     * @param \Illuminate\Http\Request $request
     * @return array
     */
    public function toArray($request)
    {

        return [
            'id' => $this->id,
            'title' => $this->offer?->title,
            'price' => $this->price,
            'qty' => $this->qty,
            'image' => !empty($this->offer->getFirstMediaUrl('image')) ? $this->offer->getFirstMediaUrl('image') : asset('brands/car-service.png'),
            'is_accepted' => $this->status === 'accepted',
            'allow_selectable' => $this->paid === 0 && (new CanSelectServicesOrSparePartAction())($this->order),
        ];
    }
}
