<?php

namespace App\Http\Resources\API;

use App\Domain\Catalog\Models\Category;
use App\Domain\Catalog\Models\Product;
use App\Domain\Core\Models\Slider;
use App\Http\Resources\API\Catalog\CategoryResource;
use App\Http\Resources\API\Catalog\ProductResource;
use App\Http\Resources\API\Core\SliderResource;
use Illuminate\Http\Resources\Json\JsonResource;

class SettingsResource extends JsonResource
{

    /**
     * Transform the resource into an array.
     *
     * @param \Illuminate\Http\Request $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {

        $data = [
            'primary_color' => $this['primary_color'] ?? '',
            'secondary_color' => $this['secondary_color'] ?? '',
            'button_text_color' => $this['button_text_color'] ?? '',
            'button_background_color' => $this['button_background_color'] ?? '',
            'out_of_stock_color' => $this['out_of_stock_color'] ?? '',
            'logo' => $this['logo'] ? url('storage/'.$this['logo']) : '',
        ];

        return $data;

    }

}
