<?php

namespace App\Notifications;

use App\Channels\MsegatChannel;
use App\Support\HsmFireBase\FireBaseChannel;
use App\Support\HsmFireBase\FireBaseModel;
use App\Support\HsmFireBase\HasFirebaseChannel;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;

class GeneralNotification extends Notification implements ShouldQueue, HasFirebaseChannel
{
    use Queueable;

    /**
     * Create a new notification instance.
     *
     * @return void
     */
    public function __construct(public $dataPass)
    {

    }

    /**
     * Get the notification's delivery channels.
     *
     * @param mixed $notifiable
     * @return array
     */
    public function via($notifiable)
    {
        $channels = ['database'];
        if (in_array('mail', $this->dataPass->channels)) {
            $channels[] = 'mail';
        }
        if (in_array('sms', $this->dataPass->channels)) {
            $channels[] = MsegatChannel::class;
        }
        if (in_array('firebase', $this->dataPass->channels)) {
            $channels[] = FireBaseChannel::class;
        }
        return $channels;
    }

    public function toMsegat($notifiable)
    {
        return $this->dataPass->smsMessage;
    }

    /**
     * Get the array representation of the notification.
     *
     * @param mixed $notifiable
     * @return array
     */
    public function toArray($notifiable)
    {
        $data = [];
        $data['type'] = $this->dataPass->type ?? 'general';
        $data['title'] = $this->dataPass->title;
        $data['message'] = $this->dataPass->message;
        $data['smsMessage'] = $this->dataPass->smsMessage;
        if ($this->dataPass->relatedData) {
            $data['related_data'] = $this->dataPass->relatedData;
        }

        return $data;
    }

    /**
     * Get the mail representation of the notification.
     *
     * @param mixed $notifiable
     * @return \Illuminate\Notifications\Messages\MailMessage
     */
    public function toMail($notifiable)
    {
        return (new MailMessage)
            ->line('Mr/s ' . $notifiable->name . ',')
            ->line($this->dataPass->title)
            ->line($this->dataPass->message)
            ->line('Thank you for using our application!');
    }

    public function toFirebase($notifiable): FireBaseModel
    {
        return new FireBaseModel(
            $this->dataPass->type ?? 'general',
            $this->dataPass->title['ar'],
            $this->dataPass->message['ar'],
        );
    }
}
