<?php

namespace App\Support\Dashboard\Datatables\Columns;

use App\Domain\Order\OrderStatus\Enums\AppointmentOrderStatusEnum;
use App\Domain\Order\OrderStatus\Enums\SparePartOrderStatusEnum;
use App\Domain\Order\OrderStatus\Enums\WenchOrderStatusEnum;

class OrderStatusColumn
{
    private $statusColor = [
        'success',
        'danger',
        'primary',
        'warning',
    ];

    public static function getStatusColorAttribute($status)
    {

        switch ($status) {
            case AppointmentOrderStatusEnum::booking_done()->label:
            case AppointmentOrderStatusEnum::car_under_inspection()->label:
            case AppointmentOrderStatusEnum::report_ready()->label:
            case AppointmentOrderStatusEnum::car_under_maintenance()->label:
            case AppointmentOrderStatusEnum::car_ready()->label:
            case WenchOrderStatusEnum::pending()->label:
            case WenchOrderStatusEnum::on_our_date()->label:
            case WenchOrderStatusEnum::truck_is_on_its_way_to_you()->label:
            case WenchOrderStatusEnum::your_car_is_on_its_way_to_branch()->label:
            case WenchOrderStatusEnum::under_examination()->label:
            case WenchOrderStatusEnum::the_inspection_report_is_ready()->label:
            case WenchOrderStatusEnum::car_under_maintenance()->label:
            case WenchOrderStatusEnum::car_ready()->label:
            case WenchOrderStatusEnum::the_car_is_on_way_to_you()->label:
            case SparePartOrderStatusEnum::in_preparation()->label:
                return 'warning';
            case AppointmentOrderStatusEnum::canceled()->label:
            case WenchOrderStatusEnum::canceled()->label:
            case SparePartOrderStatusEnum::canceled()->label:
                return 'danger';
            case SparePartOrderStatusEnum::pricing_entry()->label:
            case SparePartOrderStatusEnum::pricing_has_been_completed()->label:
                return 'primary';
            default:
                return 'success';

        }
    }

    public static function render($model, $status): string
    {
        $color = self::getStatusColorAttribute($model->status);
        return "<span class='badge badge-$color fs-7 fw-bold'>$status</span>";
    }
}
