
<?php $__env->startPush('meta'); ?>
    <title><?php echo e("$website_title | Sporazum o zaštiti privatnosti"); ?></title>
    <meta name="description" content="<?php echo e("Pročitajte o koracima koje $website_title poduzima za zaštitu vaših podataka. Naša politika o privatnosti osigurava sigurnost informacija."); ?>" />
<?php $__env->stopPush(); ?>
<?php $__env->startSection('content'); ?>
    <div class="banner uk-text-center">
        <h1><?php echo e(aiTrans('Izjava o privatnosti', $locale)); ?></h1>
    </div>

    <section class="section2 section-dark2">
        <div class="uk-container">
            <div>
                <section class="section2 section-dark2">
                    <div class="uk-container">
                        <div>
                            <p><?php echo e(aiTrans('Predani smo zaštiti vaših osobnih podataka i vaše privatnosti.', $locale)); ?>

                            </p>
                            <p><?php echo e(aiTrans('Ova pravila o privatnosti stvorena su kako bismo vas informirali o tome kako upravljamo, prikupljamo, pohranjujemo i koristimo podatke koje nam dajete u vezi s našom web stranicom [website_title] ("web stranica").', $locale, ['website_title' => $website_title])); ?>

                            </p>
                            <p><?php echo e(aiTrans('Poštivat ćemo sljedeća načela:', $locale)); ?></p>
                            <ul>
                                <li aria-level="1">
                                    <b><?php echo e(aiTrans('Budite transparentni u vezi prikupljanja i obrade osobnih podataka o vama:', $locale)); ?></b>
                                </li>
                            </ul>
                            <p><?php echo e(aiTrans('Važno nam je da u svakom trenutku imate sve potrebne informacije kako biste mogli donositi informirane odluke o postupanju sa svojim osobnim podacima. Da bismo to učinili, koristit ćemo se raznim tehnikama i mjerama kojima ćemo vam pružiti relevantne informacije o obradi vaših osobnih podataka, u odgovarajućem obliku i u odgovarajuće vrijeme.', $locale)); ?>

                            </p>
                            <p><?php echo e(aiTrans('Osim toga, ako smatramo da je potrebno da vam pružimo određene informacije, pružit ćemo vam ih u odgovarajuće vrijeme i na odgovarajućem mjestu.', $locale)); ?>

                            </p>
                            <p class="gt-block">
                                <?php echo e(aiTrans('Također ćemo rado odgovoriti na sva vaša pitanja i dati sva pojašnjenja koja su vam potrebna, u skladu sa zakonskim ograničenjima. Da biste to učinili, možete nas kontaktirati slanjem e-pošte na sljedeću adresu: info@[website_title]', $locale, ['website_title' => $website_title])); ?>

                            </p>
                            <ul>
                                <li aria-level="1">
                                    <b><?php echo e(aiTrans('Obrađivati ​​osobne podatke o vama samo u svrhe navedene u Politici:', $locale)); ?></b>
                                </li>
                            </ul>
                            <p><?php echo e(aiTrans('Svrhe u koje možemo obrađivati ​​osobne podatke o vama uključuju, između ostalog, stavljanje naše web stranice na raspolaganje vama i pružanje usluga koje sadrži („Usluge“), poboljšanje korisničkog iskustva na našoj web stranici, poboljšanje naših usluga (uključujući web stranicu ), štitimo naša prava i interese, provodimo komercijalne i administrativne aktivnosti koje podupiru pružanje naših usluga našim korisnicima i/ili udovoljavaju svim zakonskim i/ili regulatornim zahtjevima.', $locale)); ?>

                            </p>
                            <p><?php echo e(aiTrans('Osim toga, obrađivat ćemo vaše osobne podatke kako bismo razumjeli vaše osobne potrebe i preferencije.', $locale)); ?>

                            </p>
                            <ul>
                                <li aria-level="1">
                                    <b><?php echo e(aiTrans('Uložite značajna sredstva za poštovanje vaših prava u vezi s osobnim podacima o vama:', $locale)); ?></b>
                                </li>
                            </ul>
                            <ul>
                                <li>
                                    <ul>
                                        <li aria-level="1">
                                            <?php echo e(aiTrans('Primjenjujemo značajne pravne lijekove kako bismo vam omogućili ostvarivanje svojih prava kao nositelja podataka. Stoga nas možete kontaktirati u bilo kojem trenutku kada želite pregledati osobne podatke o vama, promijeniti ih, izbrisati, prestati ih koristiti u određene svrhe ili općenito, ili ih prenijeti vama ili trećoj strani. Vaše želje ćemo ispuniti u skladu sa zakonom.', $locale)); ?>

                                        </li>
                                    </ul>
                                </li>
                            </ul>
                            <ul>
                                <li aria-level="1">
                                    <b><?php echo e(aiTrans('Osiguravanje osobnih podataka o vama:', $locale)); ?></b>
                                </li>
                            </ul>
                            <p><?php echo e(aiTrans('Iako ne možemo obećati apsolutnu zaštitu osobnih podataka o vama, možemo obećati da koristimo i nastavit ćemo koristiti širok raspon sredstava i mjera kako bismo osigurali sigurnost osobnih podataka o vama.', $locale)); ?>

                            </p>
                            <p><?php echo e(aiTrans('Naša potpuna politika privatnosti.', $locale)); ?></p>
                            <ol>
                                <li><b><?php echo e(aiTrans('Opseg?', $locale)); ?></b></li>
                            </ol>
                            <p><?php echo e(aiTrans('Ova Politika opisuje vrstu osobnih podataka koje Društvo prikuplja o fizičkim osobama, te kako ih prikuplja, koristi, dijeli s trećim stranama, štiti, obrađuje itd.', $locale)); ?>

                            </p>
                            <p><?php echo e(aiTrans('U ovoj Politici, "Osobni podaci" odnose se na bilo koju informaciju koja se odnosi na identificiranu ili identificiranu fizičku osobu. Fizička osoba koja se može identificirati je ona koja se može identificirati, izravno ili u kombinaciji s dodatnim informacijama koje imamo ili kojima imamo pristup.', $locale)); ?>

                            </p>
                            <p><?php echo e(aiTrans('U ovoj Politici, "postupanje" s osobnim podacima odnosi se na bilo koju radnju ili skup operacija koje se provode na osobnim podacima, uključujući prikupljanje, registraciju, organizaciju, strukturiranje, pohranu, prilagodbu ili izmjenu, oporavak, savjetovanje, korištenje, otkrivanje prijenosom , širenje ili na drugi način stavljanje na raspolaganje, usklađivanje ili kombiniranje, ograničavanje, brisanje ili uništavanje osobnih podataka.', $locale)); ?>

                            </p>
                            <p><?php echo e(aiTrans('Naše usluge su namijenjene široj javnosti i nisu namijenjene djeci mlađoj od 18 godina. Ne prikupljamo svjesno niti tražimo informacije od bilo koga mlađeg od 18 godina niti svjesno dopuštamo takvim osobama pristup našim Uslugama. Ako saznamo da su podaci o djetetu prikupljeni, poduzet ćemo razumne korake da te podatke izbrišemo što je prije moguće.', $locale)); ?>

                            </p>
                            <ol start="2">
                                <li><b><?php echo e(aiTrans('Kada prikupljamo vaše osobne podatke?', $locale)); ?></b>
                                </li>
                            </ol>
                            <p><?php echo e(aiTrans('O vama prikupljamo osobne podatke kad god koristite naše usluge, koristite naše kanale usluga, koristite web stranicu i/ili nas kontaktirate. U nekim slučajevima ćete nam aktivno dati osobne podatke, au drugim slučajevima prikupljat ćemo osobne podatke o vama ispitivanjem i analizom vaše upotrebe naših usluga i/ili kanala naših usluga.', $locale)); ?>

                            </p>
                            <ol start="3">
                                <li><b><?php echo e(aiTrans('Ne postoji obveza davanja osobnih podataka tvrtki i njezinih implikacija', $locale)); ?></b>
                                </li>
                            </ol>
                            <p><?php echo e(aiTrans('Niste nam dužni dati nikakve osobne podatke o sebi. Međutim, u nekim slučajevima, nepružanje takvih osobnih podataka spriječit će nas da vam pružimo Usluge, spriječit će vašu upotrebu web-mjesta i/ili uzrokovati neispravan rad naših usluga i web-mjesta.', $locale)); ?>

                            </p>
                            <ol start="4">
                                <li><b><?php echo e(aiTrans('Koje osobne podatke o vama prikupljamo?', $locale)); ?></b>
                                </li>
                            </ol>
                            <p><?php echo e(aiTrans('Osobni podaci Prikupljamo svaki put kada pregledavate web stranicu: ove informacije uključuju zapisnike aktivnosti na mreži, informacije o prometu (uključujući, bez ograničenja, IP adresu, vrijeme pristupa, datum pristupa, datum(e) ) posjećene web i mobilne stranice , korišteni jezik, izvješća o padu softvera i tip korištenog preglednika, informacije o uređaju koji ste koristili. Neke od ovih informacija možda vas neće osobno identificirati i stoga ne predstavljaju osobne podatke.', $locale)); ?>

                            </p>
                            <p><?php echo e(aiTrans('Osobni podaci koje primamo od vas: svi osobni podaci koje nam dajete svojom voljom kada nas kontaktirate.', $locale)); ?>

                            </p>
                            <p><?php echo e(aiTrans('Osobni podaci koje nam dajete posebno za prijenos trećim stranama: ti podaci uključuju vaše ime i adresu e-pošte.', $locale)); ?>

                            </p>
                            <ol start="5">
                                <li><b><?php echo e(aiTrans('Svrhe obrade osobnih podataka i njezina pravna osnova', $locale)); ?></b>
                                </li>
                            </ol>
                            <p><?php echo e(aiTrans('Tvrtka obrađuje vaše osobne podatke za jednu ili više svrha opisanih u ovom odjeljku iu skladu s odgovarajućom pravnom osnovom.', $locale)); ?>

                            </p>
                            <p><?php echo e(aiTrans('Tvrtka neće obrađivati ​​osobne podatke o vama osim ako ne postoji zakonska osnova za takvu obradu. Pravne osnove na kojima Društvo može obrađivati ​​osobne podatke o vama su sljedeće:', $locale)); ?>

                            </p>
                            <ol>
                                <li aria-level="1">
                                    <b><?php echo e(aiTrans('Dali ste privolu za obradu Vaših osobnih podataka za jednu ili više specifičnih svrha. To se odnosi na slučajeve u kojima nam izričito dajete svoje podatke putem web stranice, kako bismo ih mi prezentirali trećim stranama.', $locale)); ?></b>
                                </li>
                                <li aria-level="1">
                                    <b><?php echo e(aiTrans('Tretman je neophodan u svrhu ostvarivanja legitimnih interesa Društva ili treće strane. Na primjer, u svrhu poboljšanja naših usluga ili za ostvarivanje ili obranu pravnih zahtjeva.', $locale)); ?></b>
                                </li>
                                <li aria-level="1">
                                    <b><?php echo e(aiTrans('Tretman je neophodan za ispunjenje zakonske obveze kojoj Društvo podliježe.', $locale)); ?></b>
                                </li>
                            </ol>
                            <p class="gt-block">
                                <?php echo e(aiTrans('U bilo kojem trenutku možete nas kontaktirati slanjem obavijesti na e-mail adresu info@[website_title], kako biste dobili informacije o pregledu koji smo izvršili. To je tako da možete zaključiti da možemo obrađivati ​​osobne podatke o vama jer je takva obrada nužna u svrhe legitimnih interesa koje provodi Društvo ili treća strana.', $locale, ['website_title' => $website_title])); ?>

                            </p>
                            <p><?php echo e(aiTrans('Sljedeći popis opisuje svrhe u koje možemo obrađivati ​​osobne podatke o vama i pravnu osnovu za takvu obradu:', $locale)); ?>

                            </p>
                            <table>
                                <tbody>
                                    <tr>
                                        <td>
                                            <p class="gt-block"><b><?php echo e(aiTrans('#', $locale)); ?></b></p>
                                        </td>
                                        <td>
                                            <p class="gt-block"><b><?php echo e(aiTrans('svrha', $locale)); ?></b></p>
                                        </td>
                                        <td>
                                            <p class="gt-block">
                                                <b><?php echo e(aiTrans('Pravne osnove', $locale)); ?></b>
                                            </p>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <p class="gt-block"><b><?php echo e(aiTrans('1', $locale)); ?></b></p>
                                        </td>
                                        <td>
                                            <p class="gt-block">
                                                <b><?php echo e(aiTrans('Predstaviti svoje podatke trećim stranama na vaš zahtjev', $locale)); ?></b>
                                            </p>
                                            <p><?php echo e(aiTrans('Možemo prikupljati osobne podatke o vama kako bismo ih prezentirali trećim stranama, ako to izričito zatražite.', $locale)); ?>

                                            </p>
                                        </td>
                                        <td>
                                            <p><?php echo e(aiTrans('Dali ste privolu za obradu Vaših osobnih podataka za jednu ili više specifičnih svrha.', $locale)); ?>

                                            </p>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <p class="gt-block"><b><?php echo e(aiTrans('2', $locale)); ?></b></p>
                                        </td>
                                        <td>
                                            <p class="gt-block">
                                                <b><?php echo e(aiTrans('Za odgovore na vaše upite, zahtjeve i/ili zahtjeve', $locale)); ?></b>
                                            </p>
                                            <p><?php echo e(aiTrans('Obrada Vaših osobnih podataka neophodna je za odgovor na upite koje postavljate u vezi s korištenjem Usluga.', $locale)); ?>

                                            </p>
                                        </td>
                                        <td>
                                            <p><?php echo e(aiTrans('Tretman je neophodan u svrhu ostvarivanja legitimnih interesa Društva ili treće strane.', $locale)); ?>

                                            </p>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <p class="gt-block"><b><?php echo e(aiTrans('3', $locale)); ?></b></p>
                                        </td>
                                        <td>
                                            <p class="gt-block">
                                                <b><?php echo e(aiTrans('Poštivanje bilo koje pravne obveze ili sudskog ili administrativnog naloga', $locale)); ?></b>
                                            </p>
                                            <p><?php echo e(aiTrans('Vaše osobne podatke obrađujemo u skladu s našim raznim zakonskim obvezama.', $locale)); ?>

                                            </p>
                                        </td>
                                        <td>
                                            <p><?php echo e(aiTrans('Tretman je neophodan za ispunjenje zakonske obveze kojoj Društvo podliježe.', $locale)); ?>

                                            </p>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <p class="gt-block"><b><?php echo e(aiTrans('4', $locale)); ?></b></p>
                                        </td>
                                        <td>
                                            <p class="gt-block">
                                                <b><?php echo e(aiTrans('Za poboljšanje naših usluga', $locale)); ?></b>
                                            </p>
                                            <p><?php echo e(aiTrans('Vaše osobne podatke možemo koristiti za poboljšanje naših usluga. Takva obrada uključivat će, između ostalog, sve zapisnike o padu ili druga izvješća o kvarovima dobivena u vezi s Uslugama.', $locale)); ?>

                                            </p>
                                        </td>
                                        <td>
                                            <p><?php echo e(aiTrans('Tretman je neophodan u svrhu ostvarivanja legitimnih interesa Društva ili treće strane.', $locale)); ?>

                                            </p>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <p class="gt-block"><b><?php echo e(aiTrans('5', $locale)); ?></b></p>
                                        </td>
                                        <td>
                                            <p class="gt-block">
                                                <b><?php echo e(aiTrans('Kako bismo spriječili prijevaru, zlonamjerno korištenje naših usluga', $locale)); ?></b>
                                            </p>
                                        </td>
                                        <td>
                                            <p><?php echo e(aiTrans('Tretman je neophodan u svrhu ostvarivanja legitimnih interesa Društva ili treće strane.', $locale)); ?>

                                            </p>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <p class="gt-block"><b><?php echo e(aiTrans('6', $locale)); ?></b></p>
                                        </td>
                                        <td>
                                            <p class="gt-block">
                                                <b><?php echo e(aiTrans('Za obavljanje i održavanje različitih aktivnosti koje podržavaju pružanje naših usluga.', $locale)); ?></b>
                                            </p>
                                            <p><?php echo e(aiTrans('Takve aktivnosti uključuju back-office funkcije, aktivnosti razvoja poslovanja, strateško donošenje odluka, mehanizme praćenja itd.', $locale)); ?>

                                            </p>
                                        </td>
                                        <td>
                                            <p><?php echo e(aiTrans('Tretman je neophodan u svrhu ostvarivanja legitimnih interesa Društva ili treće strane.', $locale)); ?>

                                            </p>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <p class="gt-block"><b><?php echo e(aiTrans('7', $locale)); ?></b></p>
                                        </td>
                                        <td>
                                            <p class="gt-block">
                                                <b><?php echo e(aiTrans('Za obavljanje analiza, uključujući statističke', $locale)); ?></b>
                                            </p>
                                            <p><?php echo e(aiTrans('Koristimo se raznim analitičkim mjerama (uključujući statistiku) za donošenje odluka o raznim pitanjima.', $locale)); ?>

                                            </p>
                                        </td>
                                        <td>
                                            <p><?php echo e(aiTrans('Tretman je neophodan u svrhu ostvarivanja legitimnih interesa Društva ili treće strane.', $locale)); ?>

                                            </p>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <p class="gt-block"><b><?php echo e(aiTrans('8', $locale)); ?></b></p>
                                        </td>
                                        <td>
                                            <p class="gt-block">
                                                <b><?php echo e(aiTrans('Za zaštitu naših interesa, prava i imovine te interesa trećih strana, uključujući pokretanje, ostvarivanje ili obranu pravnih zahtjeva', $locale)); ?></b>
                                            </p>
                                            <p><?php echo e(aiTrans('Možemo obrađivati ​​osobne podatke o vama radi zaštite naših interesa, prava i imovine ili interesa trećih strana, u skladu s bilo kojim zakonom, uredbom ili sporazumom, uključujući bilo koje naše')); ?>

                                        </td>
                                        <td>
                                            <p><?php echo e(aiTrans('Tretman je neophodan u svrhu ostvarivanja legitimnih interesa Društva ili treće strane.', $locale)); ?>

                                            </p>
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                            <ol start="6">
                                <li><b><?php echo e(aiTrans('Prijenos osobnih podataka trećim stranama', $locale)); ?></b>
                                </li>
                            </ol>
                            <p><?php echo e(aiTrans('Tvrtka također može dijeliti osobne podatke o vama s trećim stranama koje nam pružaju usluge, kao što su davatelji usluga pohrane i hostinga, informacije o IP adresi, analiza korisničkog iskustva i usluge istraživanja, analize, tehničke i dijagnostike.', $locale)); ?>

                            </p>
                            <p><?php echo e(aiTrans('Osim toga, možete izričito zatražiti da određene osobne podatke o vama pošaljemo platformama za trgovanje Bitcoinima trećih strana. U takvim slučajevima ćemo osobne podatke koje nam date u tu svrhu podijeliti s tim trećim stranama, a njihova upotreba vaših osobnih podataka bit će podložna njihovim vlastitim politikama privatnosti.', $locale)); ?>

                            </p>
                            <p><?php echo e(aiTrans('Tvrtka također može dijeliti osobne podatke o vama sa svojim povezanim subjektima i poslovnim partnerima, koji joj pružaju resurse koji omogućuju Društvu da obogati i poboljša razinu usluga i proizvoda koje nudi svojim korisnicima.', $locale)); ?>

                            </p>
                            <p><?php echo e(aiTrans('Tvrtka može dijeliti osobne podatke o vama s državnim, lokalnim, službenim i regulatornim tijelima, kao i ako je takvo otkrivanje potrebno za zaštitu naših interesa, prava i imovine te onih trećih strana, uključujući pokretanje, ostvarivanje ili obranu pravnih zahtjeva.', $locale)); ?>

                            </p>
                            <p><?php echo e(aiTrans('Osim toga, možemo otkriti vaše osobne podatke potencijalnim kupcima ili investitorima Društva i/ili bilo koje tvrtke u skupini tvrtki čiji je dio Društvo, ili zajmodavcima ili u slučaju bilo koje slične transakcije (uključujući prodaja imovine Društva). Društvo i/ili bilo koje društvo u grupi društava čiji je dio Društvo), i/ili u vezi s bilo kojim spajanjem, reorganizacijom, konsolidacijom ili stečajem Društva i/ili bilo kojeg društva u grupi društava čiji je dio tvrtka.', $locale)); ?>

                            </p>
                            <ol start="7">
                                <li><b><?php echo e(aiTrans('Kolačići i usluge trećih strana', $locale)); ?></b></li>
                            </ol>
                            <p><?php echo e(aiTrans('Možemo koristiti određene usluge trećih strana, kao što su analitičke tvrtke ili tvrtke koje poslužuju oglase na našoj web stranici, koje također mogu koristiti kolačiće ili druge tehnologije, a te prakse i pružatelji usluga podliježu njihovim vlastitim pravilima.', $locale)); ?>

                            </p>
                            <p><?php echo e(aiTrans('Kolačići (koji su mala tekstualna datoteka) se instaliraju na uređaj putem kojeg posjećujete ili pristupate web stranici. Kolačići nam omogućuju prikupljanje informacija o vama i vašem ponašanju kako bismo poboljšali vaše korisničko iskustvo, zapamtili vaše preferencije i postavke te personalizirali i ponudili vam proizvode i usluge koji bi vas mogli zanimati. Kolačići se također mogu koristiti za prikupljanje statistike i analizu.', $locale)); ?>

                            </p>
                            <p><?php echo e(aiTrans('Neki od kolačića koje možemo koristiti su kolačići sesije, koji se privremeno preuzimaju na vaš uređaj i traju dok ne zatvorite svoj web preglednik, dok su drugi trajni kolačići, koji ostaju na vašem uređaju nakon što prestanete pregledavati web stranicu i mogu se koristiti kao pomoć web stranica vas pamti kao ponovnog posjetitelja kada ga ponovno posjetite.', $locale)); ?>

                            </p>
                            <p class="gt-block"><b><?php echo e(aiTrans('Vrste kolačića:', $locale)); ?></b></p>
                            <p><?php echo e(aiTrans('Kolačići koje možemo koristiti klasificirani su prema njihovoj funkcionalnosti, kako slijedi:', $locale)); ?>&nbsp;
                            </p>
                            <table>
                                <tbody>
                                    <tr>
                                        <td>
                                            <p class="gt-block">
                                                <b><?php echo e(aiTrans('tip kolačića', $locale)); ?></b>
                                            </p>
                                        </td>
                                        <td>
                                            <p class="gt-block"><b><?php echo e(aiTrans('svrha', $locale)); ?></b></p>
                                        </td>
                                        <td>
                                            <p class="gt-block">
                                                <b><?php echo e(aiTrans('dodatne informacije', $locale)); ?></b>
                                            </p>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <p><?php echo e(aiTrans('Strogo neophodni kolačići', $locale)); ?></p>
                                        </td>
                                        <td>
                                            <p><?php echo e(aiTrans('Ovi kolačići su striktno potrebni kako bi vam omogućili navigaciju web-mjestom i korištenje značajki koje ste zatražili. Koriste se za pružanje sadržaja, proizvoda i usluga koje ste zatražili.', $locale)); ?>

                                            </p>
                                            <p><?php echo e(aiTrans('Ovi kolačići su neophodni za pomoć vašem uređaju u preuzimanju ili prijenosu informacija kako biste se mogli kretati web-mjestom, koristiti njezine značajke i vraćati se na stranice koje ste prethodno posjetili.', $locale)); ?>

                                            </p>
                                        </td>
                                        <td>
                                            <p><?php echo e(aiTrans('Ovi kolačići prikupljaju osobne podatke o vama, kao što su korisničko ime i datum zadnje prijave, i identificiraju vas kao spojenog na web stranicu.', $locale)); ?>

                                            </p>
                                            <p><?php echo e(aiTrans('Ovi kolačići se brišu kada zatvorite svoj web preglednik (kolačići sesije).', $locale)); ?>

                                            </p>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <p><?php echo e(aiTrans('Kolačići funkcionalnosti', $locale)); ?></p>
                                        </td>
                                        <td>
                                            <p><?php echo e(aiTrans('Ovi kolačići se koriste kako bismo vas prepoznali kada se vratite na web stranicu i omogućili nam da zapamtimo vaše izbore i preferencije.', $locale)); ?>

                                            </p>
                                        </td>
                                        <td>
                                            <p><?php echo e(aiTrans('Ovi kolačići preživljavaju zatvaranje vašeg web preglednika i traju do njihovog primjenjivog vremena isteka.', $locale)); ?>

                                            </p>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <p><?php echo e(aiTrans('Kolačići izvedbe', $locale)); ?></p>
                                        </td>
                                        <td>
                                            <p><?php echo e(aiTrans('Ovi kolačići se koriste za pružanje zbirne statistike o uspješnosti web stranice te za testiranje i poboljšanje takve izvedbe, kako bi se pružilo bolje korisničko iskustvo. Osim toga, omogućuju nam obavljanje analitičkih funkcija na web stranici.', $locale)); ?>

                                            </p>
                                        </td>
                                        <td>
                                            <p><?php echo e(aiTrans('Ovi kolačići prikupljaju anonimne podatke koji se ne odnose na identificiranu ili identificiranu fizičku osobu.', $locale)); ?>

                                            </p>
                                            <p><?php echo e(aiTrans('Ovi kolačići vrijede za različita razdoblja; neki se brišu nakon što zatvorite preglednik, dok drugi vrijede na neodređeno vrijeme.', $locale)); ?>

                                            </p>
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                            <p><?php echo e(aiTrans('Blokiranje i brisanje kolačića', $locale)); ?></p>
                            <p><?php echo e(aiTrans('Možete promijeniti postavke preglednika da blokirate i izbrišete neke ili sve kolačiće. Molimo pogledajte sljedeće veze za upute kako to učiniti za neke od najpopularnijih web preglednika:', $locale)); ?>

                            </p>
                            <ul>
                                <li aria-level="1"><a href="https://support.mozilla.org/en-US/kb/Cookies">Firefox</a></li>
                                <li aria-level="1"><a
                                        href="https://support.microsoft.com/en-gb/help/17442/windows-internet-explorer-delete-manage-cookies">Internet
                                        Explorer</a></li>
                                <li aria-level="1"><a
                                        href="https://support.google.com/chrome/bin/answer.py?hl=en&amp;answer=95647">Google
                                        Chrome</a></li>
                                <li aria-level="1"><a
                                        href="https://support.apple.com/en-ph/guide/safari/sfri11471/mac">Safari</a>
                                </li>
                            </ul>
                            <p><?php echo e(aiTrans('Međutim, imajte na umu da ako to učinite, neke ili sve značajke i funkcionalnost web-mjesta možda neće funkcionirati kako je predviđeno.', $locale)); ?>

                            </p>
                            <p class="gt-block">
                                <b><?php echo e(aiTrans('OBAVIJEST O ONLINE PRAĆENJU', $locale)); ?></b>
                            </p>
                            <p class="gt-block">
                                <b><?php echo e(aiTrans('U OVO VRIJEME, OVA SERVIS NE PODRŽAVA NEMOJTE PRATI SIGNALI.', $locale)); ?></b>
                            </p>
                            <ol start="8">
                                <li><b><?php echo e(aiTrans('Čuvanje vaših osobnih podataka', $locale)); ?></b></li>
                            </ol>
                            <p><?php echo e(aiTrans('Tvrtka će čuvati osobne podatke o vama onoliko vremena koliko je potrebno za ispunjenje svrhe obrade osobnih podataka kako je navedeno u ovoj politici, ili dulje kako je propisano zakonom, propisima, politikama i nalozima koji se odnose na nas.', $locale)); ?>

                            </p>
                            <p><?php echo e(aiTrans('Kako bismo osigurali da se osobni podaci o vama ne čuvaju dulje nego što je potrebno, povremeno pregledavamo osobne podatke koje zadržavamo kako bismo ispitali mogu li se neki osobni podaci izbrisati.', $locale)); ?>

                            </p>
                            <ol start="9">
                                <li><b><?php echo e(aiTrans('Prijenos osobnih podataka u treću zemlju ili međunarodnu organizaciju', $locale)); ?></b>
                                </li>
                            </ol>
                            <p><?php echo e(aiTrans('Osobni podaci o vama mogu se prenijeti u treću zemlju (tj. u jurisdikcije koje nisu u mjestu gdje živite) ili u međunarodne organizacije. U takvim okolnostima, tvrtka će poduzeti odgovarajuće sigurnosne mjere kako bi zajamčila zaštitu vaših osobnih podataka i jamčila da zainteresirane strane mogu ostvariti svoja prava i imati učinkovite pravne lijekove.', $locale)); ?>

                            </p>
                            <p><?php echo e(aiTrans('Ako ste stanovnik EGP-a (Europskog ekonomskog prostora), imajte na umu da će ove zaštitne mjere i zaštita biti dostupne ako je ispunjen bilo koji od sljedećih uvjeta:', $locale)); ?>

                            </p>
                            <ul>
                                <li aria-level="1">
                                    <?php echo e(aiTrans('Prijenos je u treću zemlju ili međunarodnu organizaciju za koju je Komisija EU odlučila da pruža odgovarajuću razinu zaštite osobnih podataka koji su joj preneseni u skladu s člankom 45. stavkom 3. Uredbe (EU) 2016 /679 Europskog parlamenta i Vijeća, od 27. travnja 2016. (“GDPR”), uključujući svaki prijenos u skladu s Okvirom zaštite privatnosti EU-SAD;', $locale)); ?>

                                </li>
                                <li aria-level="1">
                                    <?php echo e(aiTrans('Prijenos je u skladu sa pravno obvezujućim i provedivim instrumentom između javnih tijela ili tijela u skladu s člankom 46. stavkom 2. točkom a) RGPD-a; ili', $locale)); ?>

                                </li>
                                <li aria-level="1">
                                    <?php echo e(aiTrans('Prijenos je u skladu sa standardnim klauzulama o zaštiti podataka koje je usvojila Komisija EU u skladu s člankom 46. stavkom 2. točkom c) RGPD-a. Klauzule koje je usvojila Komisija EU mogu se pogledati na&nbsp;', $locale)); ?><a
                                        href="https://ec.europa.eu/info/law/law-topic/data-protection/data-transfers-outside-eu/model-contracts-transfer-personal-data-third-countries_en">https://ec.europa.eu/info/law/law-topic/data-protection/data-transfers-outside-eu/model-contracts-transfer-personal-data-third-countries_en</a>.&nbsp;
                                </li>
                                <li aria-level="1">
                                    <?php echo e(aiTrans('Možete zatražiti da vam Društvo dostavi pojedinosti o zaštitnim mjerama koje Društvo koristi za zaštitu osobnih podataka o vama koji se prenose u treću zemlju ili međunarodnu organizaciju slanjem e-pošte na sljedeću adresu:&nbsp;info@', $locale, ['website_title' => $website_title])); ?>

                                </li>
                            </ul>
                            <ol start="10">
                                <li><b><?php echo e(aiTrans('Zaštita vaših osobnih podataka', $locale)); ?></b></li>
                            </ol>
                            <p><?php echo e(aiTrans('Primjenjujemo odgovarajuće tehničke i organizacijske mjere kako bismo jamčili odgovarajuću razinu sigurnosti osobnih podataka, uzimajući u obzir rizike koje predstavlja postupanje, posebno slučajno ili nezakonito uništenje, gubitak, promjenu, neovlašteno otkrivanje ili pristup prenesenim osobnim podacima, pohranjene ili na drugi način obrađene.', $locale)); ?>

                            </p>
                            <p><?php echo e(aiTrans('Zbog zakonskih ili drugih obveza izvan naše kontrole, možda ćemo morati prenijeti osobne podatke o vama trećim stranama, kao što su javna tijela. U takvim okolnostima imamo ograničenu kontrolu nad razinom zaštite koju te treće strane pružaju osobnim podacima o vama.', $locale)); ?>

                            </p>
                            <p><?php echo e(aiTrans('Svaki prijenos osobnih podataka putem interneta ne može biti potpuno siguran. Stoga tvrtka ne može jamčiti zaštitu vaših osobnih podataka kada nam se prenose putem interneta.', $locale)); ?>

                            </p>
                            <ol start="11">
                                <li><b><?php echo e(aiTrans('Veze na web stranice trećih strana', $locale)); ?></b></li>
                            </ol>
                            <p><?php echo e(aiTrans('Web stranica može pružati poveznice na web stranice i/ili aplikacije trećih strana. Tvrtka ne kontrolira takve web stranice i aplikacije, odnosno prikupljanje i/ili obradu osobnih podataka o vama putem takvih web stranica i aplikacija, te nismo odgovorni za takve web stranice i aplikacije, ili njihove politike privatnosti i aktivnosti. privatnost i zaštita podataka . Ova se Politika ne primjenjuje ni na kakve radnje poduzete putem takvih web stranica i/ili aplikacija.', $locale)); ?>

                            </p>
                            <p><?php echo e(aiTrans('Kad god pristupate web stranicama i/ili aplikacijama takvih trećih strana, preporučujemo da pažljivo pregledate njihova pravila privatnosti prije korištenja takvih web-mjesta i/ili aplikacija i prije nego što otkrijete bilo kakve osobne podatke o sebi.', $locale)); ?>

                            </p>
                            <ol start="12">
                                <li><b><?php echo e(aiTrans('Promjene ove politike', $locale)); ?></b></li>
                            </ol>
                            <p><?php echo e(aiTrans('Možemo s vremena na vrijeme izmijeniti uvjete ove Politike. Kad god promijenimo ovu Politiku, obavijestit ćemo vas o takvim promjenama objavljivanjem ažurirane Politike na web stranici. Osim toga, kada unesemo materijalne promjene u ovu Politiku, nastojat ćemo vas obavijestiti o takvim promjenama putem sredstava komunikacije koja smatramo razumno prikladnima da vas obavijestimo o takvim promjenama i objavljivanjem obavijesti o takvim promjenama na web stranici. Osim ako nije drugačije navedeno, sve promjene stupit će na snagu nakon objave ažurirane Politike na našoj web stranici.', $locale)); ?>

                            </p>
                            <ol start="13">
                                <li><b><?php echo e(aiTrans('Vaša prava u vezi s osobnim podacima o vama', $locale)); ?></b></li>
                            </ol>
                            <p><?php echo e(aiTrans('Općenito, imate pravo zatražiti da potvrdimo prikupljamo li osobne podatke o vama, zatražiti da se takvi podaci pregledaju, da po potrebi ispravimo sadržaj i izbrišemo osobne podatke koji nam više nisu potrebni. Također možete ograničiti svoj pristanak na određenu obradu vaših osobnih podataka.', $locale)); ?>

                            </p>
                            <p><?php echo e(aiTrans('Ako ste stanovnik EGP-a, pročitajte ovaj odjeljak:', $locale)); ?></p>
                            <p class="gt-block">
                                <?php echo e(aiTrans('Imate sljedeća prava u vezi s osobnim podacima koji se odnose na vas. Za ostvarivanje ovih prava možete poslati zahtjev za ostvarivanje svojih prava na sljedeću adresu e-pošte:&nbsp;info@[website_title]', $locale, ['website_title' => $website_title])); ?>

                            </p>
                            <p class="gt-block"><b><?php echo e(aiTrans('Pravo pristupa', $locale)); ?></b></p>
                            <p><?php echo e(aiTrans('Imate pravo dobiti potvrdu od Društva o tome obrađuju li se osobni podaci o vama ili ne i, ako je tako, pristup osobnim podacima i sljedećim informacijama (1) svrhe obrade; (2) kategorije osobnih podataka o kojima je riječ; (3) primatelji ili kategorije primatelja kojima su osobni podaci bili ili će biti otkriveni, posebno primatelji u trećim zemljama izvan Europskog gospodarskog prostora (EEA) ili međunarodnim organizacijama; (4) ako je moguće, očekivano razdoblje čuvanja osobnih podataka ili, ako nije moguće, kriterije koji se koriste za određivanje tog razdoblja; (5) postojanje prava zahtijevati od Društva ispravak ili brisanje osobnih podataka ili ograničenje obrade osobnih podataka o vama ili prigovoriti takvoj obradi; (6) pravo na podnošenje zahtjeva nadzornom tijelu; (7) ako osobni podaci nisu prikupljeni od vas, sve dostupne informacije o njihovom podrijetlu; (8) postojanje profiliranja; i (9) ako se osobni podaci prenose u treću zemlju izvan EGP-a ili u međunarodnu organizaciju, odgovarajuće zaštitne mjere u vezi s prijenosom.',$locale)); ?>

                            </p>
                            <p><?php echo e(aiTrans('Tvrtka će vam dati kopiju osobnih podataka koji se obrađuju i može naplatiti razumnu naknadu za sve druge kopije koje zatražite. Ako zahtjev podnesete elektroničkim putem i osim ako ne zatražite drugačije, informacije će biti dostavljene u uobičajenom elektroničkom formatu.', $locale)); ?>

                            </p>
                            <p><?php echo e(aiTrans('Pravo na dobivanje kopije osobnih podataka neće negativno utjecati na prava i slobode drugih. Stoga, ako zahtjev šteti pravima i slobodama drugih, Društvo možda neće ispuniti vaš zahtjev ili to može učiniti na ograničen način.', $locale)); ?>&nbsp;
                            </p>
                            <p class="gt-block"><b><?php echo e(aiTrans('Pravo na ispravak', $locale)); ?></b></p>
                            <p><?php echo e(aiTrans('Imate pravo zatražiti od Društva ispravak netočnih osobnih podataka o vama. Uzimajući u obzir svrhe obrade, imate pravo dopuniti nepotpune osobne podatke o vama, uključujući i davanje dopunske izjave.', $locale)); ?>

                            </p>
                            <p class="gt-block"><b><?php echo e(aiTrans('Pravo na brisanje', $locale)); ?></b></p>
                            <p><?php echo e(aiTrans('Imate pravo zatražiti od Društva brisanje osobnih podataka koji se odnose na vas ako je jedan od sljedećih razloga primjenjiv: (a) Osobni podaci više nisu potrebni u odnosu na svrhe za koje su prikupljeni ili na drugi način obrađeni; (b) povučete svoju privolu na kojoj se obrada temelji i nema druge pravne osnove za obradu; (c) prigovorite u bilo kojem trenutku, iz razloga koji se odnose na vašu konkretnu situaciju, na obradu osobnih podataka o vama koja se temelji na legitimnim interesima kojima težimo mi ili treća strana, a ne postoje uvjerljivi legitimni razlozi za obradu; (d) prigovarate obradi osobnih podataka o vama u svrhe izravnog marketinga; (e) osobni podaci su nezakonito obrađeni; ili (f) Osobni podaci o vama moraju biti izbrisani kako bi se ispunila zakonska obveza zakonodavstva Europske unije ili države članice kojoj Društvo podliježe.', $locale)); ?>

                            </p>
                            <p><?php echo e(aiTrans('Ovo se pravo ne primjenjuje u mjeri u kojoj je obrada potrebna (a) za usklađenost sa zakonskom obvezom koja zahtijeva obradu prema zakonu Europske unije ili države članice kojoj Društvo podliježe; ili (b) za uspostavljanje, ostvarivanje ili obranu pravnih zahtjeva.', $locale)); ?>

                            </p>
                            <p class="gt-block"><b><?php echo e(aiTrans('Pravo na ograničenje obrade', $locale)); ?></b></p>
                            <p><?php echo e(aiTrans('Imate pravo zatražiti od Društva ograničenje obrade vaših osobnih podataka ako se dogodi jedna od sljedećih okolnosti (a) osporavate točnost osobnih podataka tijekom razdoblja koje omogućuje Društvu da provjeri točnost osobnih podataka o vama; (b) obrada je nezakonita i vi se protivite brisanju osobnih podataka o vama i umjesto toga tražite ograničenje njihove uporabe; (c) Tvrtki više nisu potrebni osobni podaci o vama za potrebe obrade, ali su vam osobni podaci potrebni za uspostavljanje, ostvarivanje ili obranu pravnih zahtjeva; (d) ako je obrada osobnih podataka o vama nužna za legitimne interese tvrtke ili treće strane, osim ako ne pokažemo uvjerljive legitimne razloge za obradu koja nadmašuju vaše interese, prava i slobode ili za osnivanje, ostvarivanje ili obrana pravnih zahtjeva; ili (e) ako se osobni podaci o vama obrađuju u svrhe izravnog marketinga, uključujući profiliranje, u mjeri koja je povezana s takvim izravnim marketingom.', $locale)); ?>

                            </p>
                            <p><?php echo e(aiTrans('Ako je obrada Vaših osobnih podataka ograničena nakon Vašeg zahtjeva, takvi osobni podaci, s iznimkom pohrane, obrađivati ​​će se samo uz Vašu privolu ili za uspostavljanje, ostvarivanje ili obranu pravnih zahtjeva ili za zaštitu osobnih podataka. prava druge fizičke ili pravne osobe ili iz razloga važnog javnog interesa Europske unije ili države članice.', $locale)); ?>

                            </p>
                            <p class="gt-block"><b><?php echo e(aiTrans('Pravo na prijenos podataka', $locale)); ?></b></p>
                            <p><?php echo e(aiTrans('Imate pravo primiti osobne podatke o vama, koje ste dali Društvu, u strukturiranom, uobičajeno korištenom i strojno čitljivom formatu, kao i pravo na prijenos takvih osobnih podataka drugom voditelju obrade, ako (a) obrada se temelji na vašem pristanku ili ugovoru u kojem ste stranka, i (b) obrada se provodi automatiziranim sredstvima.', $locale)); ?>

                            </p>
                            <p><?php echo e(aiTrans('Ostvarujući svoje pravo na prenosivost podataka, imate pravo da Društvo izravno prenese osobne podatke koji se odnose na vas drugom voditelju obrade podataka, kad god je to tehnički moguće. Ostvarivanje vašeg prava na prenosivost podataka razumijeva se ne dovodeći u pitanje vaša prava i prava Društva na temelju vašeg prava na brisanje. Osim toga, pravo na prenosivost podataka neće negativno utjecati na prava i slobode drugih ljudi.', $locale)); ?>

                            </p>
                            <p class="gt-block"><b><?php echo e(aiTrans('Pravo na protivljenje', $locale)); ?></b></p>
                            <p><?php echo e(aiTrans('Imate pravo prigovoriti u bilo kojem trenutku, iz razloga povezanih s vašom konkretnom situacijom, na obradu vaših osobnih podataka na temelju legitimnih interesa koje provodi Društvo ili treća strana, uključujući profiliranje na temelju takvih legitimnih interesa. U tom slučaju prestat ćemo obrađivati ​​osobne podatke o vama, osim ako ne pokažemo uvjerljive legitimne razloge za obradu koji imaju prednost nad vašim interesima, pravima i slobodama ili za uspostavljanje, ostvarivanje ili obranu pravnih zahtjeva.', $locale)); ?>

                            </p>
                            <p><?php echo e(aiTrans('Imate pravo u bilo kojem trenutku uložiti prigovor na obradu vaših osobnih podataka u svrhe izravnog marketinga, uključujući profiliranje, u mjeri u kojoj je to povezano s takvim izravnim marketingom.', $locale)); ?>

                            </p>
                            <p class="gt-block"><b><?php echo e(aiTrans('Pravo na povlačenje privole', $locale)); ?></b></p>
                            <p><?php echo e(aiTrans('Privolu koju ste nam dali za obradu Vaših osobnih podataka možete povući u bilo kojem trenutku, bez utjecaja na zakonitost postupanja na temelju Vaše privole prije njenog povlačenja.', $locale)); ?>

                            </p>
                            <p class="gt-block">
                                <b><?php echo e(aiTrans('Pravo na podnošenje zahtjeva nadzornom tijelu', $locale)); ?></b></p>
                            <p><?php echo e(aiTrans('Imate pravo podnijeti pritužbu nadzornom tijelu koje je osnovala država članica radi zaštite temeljnih prava i sloboda fizičkih osoba u vezi s obradom osobnih podataka u Europskoj uniji.', $locale)); ?>

                            </p>
                            <p><?php echo e(aiTrans('Vaša prava u vezi s osobnim podacima koji se odnose na vas, kao što je navedeno u ovom odjeljku 13, mogu biti ograničena zakonodavstvom Europske unije ili država članica kojima Društvo podliježe.', $locale)); ?>

                            </p>
                            <p><?php echo e(aiTrans('Pružit ćemo vam tražene informacije u skladu s vašim pravima opisanim u ovom odjeljku 13 bez nepotrebnog odgađanja i, u svakom slučaju, u roku od mjesec dana od primitka zahtjeva. Taj se rok po potrebi može produžiti za još dva mjeseca, uzimajući u obzir složenost i broj zahtjeva. Obavijestit ćemo vas o svakom takvom produljenju u roku od mjesec dana od primitka vašeg zahtjeva, zajedno s razlozima kašnjenja.', $locale)); ?>

                            </p>
                            <p><?php echo e(aiTrans('Informacije zatražene u skladu s vašim pravima navedenim u ovom odjeljku 13 bit će dostavljene besplatno, osim ako je drugačije navedeno u ovom odjeljku 13. Ako su zahtjevi očito neutemeljeni ili pretjerani, osobito zbog njihove prirode ponavljanja, možemo (a) naplatiti razumnu naknadu, uzimajući u obzir administrativne troškove pružanja informacija ili komunikacije ili poduzimanja tražene radnje; ili (b) odbiti udovoljiti zahtjevu.', $locale)); ?>

                            </p>
                            <p><?php echo e(aiTrans('Tvrtka može zatražiti od vas da dostavite dodatne podatke potrebne za potvrdu vašeg identiteta kako bi ispunili vaš zahtjev u skladu s vašim pravima opisanim u ovom odjeljku 13, ako imamo razumne sumnje u identitet fizičke osobe koja podnosi zahtjev.', $locale)); ?>

                            </p>
                        </div>

                    </div>
                </section>
            <?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/enng1/public_html/immediate13.com/resources/views/frontend/hr/privacy.blade.php ENDPATH**/ ?>