<?php

namespace App\Domain\Blog\Datatables;

use App\Domain\Blog\Models\PostCategory;
use App\Support\Dashboard\Datatables\BaseDatatable;
use Illuminate\Database\Eloquent\Builder;
use Yajra\DataTables\Html\Column;

class PostCategoryDatatable extends BaseDatatable
{
    protected bool $indexer = false;

    public function query(): Builder
    {
        return PostCategory::query();
    }

    protected function columns(): array
    {
        return [

            Column::make('id')->title(__('ID')),
            Column::make('name.'.app()->getLocale())->title(__('Name')),
        ];
    }
}
