<?php

namespace App\Domain\Core\Enums\Traits;

use Closure;
use Illuminate\Support\Str;
use Illuminate\Support\Collection;

trait HasOptions
{

    public static function options(): Collection
    {

        return collect(self::toArray());
    }

    public static function getValue($label)
    {
        return static::toSelectArray()[$label];
    }

    /**
     * Get the enum values as key-value pairs for a select dropdown.
     *
     * @return array
     */
    public static function toSelectArray(): array
    {
        return array_combine(static::toLabels(), static::toValues());
    }
}
