<?php

namespace App\Domain\Link\Datatables;

use App\Domain\Link\Models\Link;
use App\Support\Dashboard\Datatables\BaseDatatable;
use App\Support\Dashboard\Datatables\Columns\ImageColumn;
use Illuminate\Database\Eloquent\Builder;
use Yajra\DataTables\Html\Column;

class LinkDatatable extends BaseDatatable
{
    public function query(): Builder
    {
        return Link::with('differences');
    }

    protected function columns(): array
    {
        return [
            Column::make('url')->title(__('Link')),
            Column::make('difference')->title(__('Last 3 Difference Score')),
            Column::make('old_image')->title(__('Old Image')),
            Column::make('new_image')->title(__('New Image')),
        ];
    }
    public function customColumns(): array
    {
        return  [
            'difference' => function($model) {
                // Check if the model has any differences
                if ($model->differences->isEmpty()) {
                    return 'No differences';
                }

                // Get the last 3 differences
                $recentDifferences = $model->differences->sortByDesc('created_at')->take(3);

                // Loop through these recent differences and format each one with its created_at timestamp
                $formattedDifferences = $recentDifferences->map(function($difference) {
                    return $difference->difference_score . '% on ' . $difference->created_at->toDateTimeString();
                });

                // Join all formatted differences with a line break for display
                return implode('<br>', $formattedDifferences->toArray());
            },
            'old_image' => function($model) {
                return $model->old_screenshot_path
                    ? '<a href="' . asset('storage/' . $this->getRelativePath($model->old_screenshot_path)) . '" target="_blank">
                          <img src="' . asset('storage/' . $this->getRelativePath($model->old_screenshot_path)) . '" width="100" height="100">
                       </a>'
                    : 'No old image';
            },
            'new_image' => function($model) {
                return $model->new_screenshot_path
                    ? '<a href="' . asset('storage/' . $this->getRelativePath($model->new_screenshot_path)) . '" target="_blank">
                          <img src="' . asset('storage/' . $this->getRelativePath($model->new_screenshot_path)) . '" width="100" height="100">
                       </a>'
                    : 'No new image';
            }
        ];
    }
    /**
     * Extracts the relative path from the full storage path for web accessibility.
     */
    private function getRelativePath(string $fullPath): string
    {
        return str_replace(storage_path('app/public/'), '', $fullPath);
    }
}
