<?php

namespace App\Domain\Service\Datatables;

use App\Domain\Service\Models\Service;
use App\Support\Dashboard\Datatables\BaseDatatable;
use App\Support\Dashboard\Datatables\Columns\ImageColumn;
use Illuminate\Database\Eloquent\Builder;
use Yajra\DataTables\Html\Column;

class ServiceDatatable extends BaseDatatable
{
    public function query(): Builder
    {
        return Service::query();
    }

    protected function filters(): array
    {
        return [
            'name.ar' => function ($q, $keyword) {
                return $q->where('name', 'like', '%' . $keyword . '%');
            },
            'name.en' => function ($q, $keyword) {
                return $q->where('name', 'like', '%' . $keyword . '%');
            }
        ];
    }

    protected function customColumns(): array
    {
        return [

            'image' => function ($model) {
                return ImageColumn::render($model->getFirstMediaUrl('image'));
            }
        ];
    }


    protected function columns(): array
    {
        return [
            Column::make('name.ar')->title(__('Name') . ' ' . __('Ar'))
                ->content(''),
            Column::make('name.en')->title(__('Name') . ' ' . __('En'))
                ->content(''),

            Column::make('image')->title(__('Image')),

        ];
    }
}
