<?php

namespace App\Http\Controllers\Dashboard\User;
use App\Http\Controllers\Dashboard\DashboardController;
use App\Support\Dashboard\Crud\WithDatatable;
use App\Support\Dashboard\Crud\WithDestroy;
use App\Domain\Core\Enums\CorePermissions;
use App\Support\Dashboard\Crud\WithForm;
use App\Support\Dashboard\Crud\WithStore;
use App\Support\Dashboard\Crud\WithUpdate;
use Illuminate\Database\Eloquent\Model;
use App\Domain\User\Datatables\WithdrawalDatatable;
use App\Domain\User\Models\Withdrawal;

class WithdrawalController extends DashboardController
{
    use WithDatatable,  WithForm , WithStore ,WithUpdate , WithDestroy;

    protected string $name = 'Withdrawal';
    protected string $path = 'dashboard.user.withdrawals';
    protected string $datatable = WithdrawalDatatable::class;
    protected string $model = Withdrawal::class;
    protected array $permissions = [CorePermissions::class, 'withdrawals'];


    protected function rules()
    {
        return [

        ];
    }

    protected function formData(?Model $model = null): array
    {
        return [

        ];
    }
}
