<?php

namespace App\Http\Middleware;

use App\Domain\FormsBuilder\Models\Form;
use App\Domain\FormsBuilder\Models\FormValue;
use App\Domain\Shareholder\Models\Shareholder;
use App\Http\Controllers\Frontend\User\Actions\UpdateFormValueOnRequest;
use Closure;
use Illuminate\Http\Request;

class LockShareholderIfEmptyValues
{
    /**
     * Handle an incoming request.
     *
     * @param \Illuminate\Http\Request $request
     * @param \Closure(\Illuminate\Http\Request): (\Illuminate\Http\Response|\Illuminate\Http\RedirectResponse) $next
     * @return \Illuminate\Http\Response|\Illuminate\Http\RedirectResponse
     */
    public function handle(Request $request, Closure $next)
    {
        $missingAndEmpty = [];
        $checkLockedFields = Form::where('related_model', Shareholder::class)->first();
        $user = auth()->user();
        $formValues = $checkLockedFields->FormValue()
            ->where('formable_id', $user?->shareholder?->id)
            ->where('formable_type', Shareholder::class)
            ->first();
        if (!$user->shareholder?->attachment
            ->where('type', 'iban_certificate')->first()) {
            $missingAndEmpty[] = 'iban_certificate';
        }
        if (!$user->shareholder?->bank) {
            $missingAndEmpty[] = 'bank';
        }
        if (!$user->shareholder?->iban) {
            $missingAndEmpty[] = 'iban';
        }
        if (!$user->shareholder?->city_id) {
            $missingAndEmpty[] = 'city';
        }
        if (!$user->shareholder?->specialization) {
            $missingAndEmpty[] = 'specialization';
        }
        if (!$user->shareholder?->qualification) {
            $missingAndEmpty[] = 'qualification';
        }
        if ($missingAndEmpty && $user->hasRole('user')) {
            session()->flash('error', __('Complete Your Profile First'));
            return redirect()->route('frontend.user.profile');
        }
        if (json_decode($checkLockedFields->json, true) == null) {
            return $next($request);
        }

        $lockedValues = collect(json_decode($checkLockedFields->json, true)[0])->filter(function ($item) {
            if (isset($item['lock'])) {
                return $item['lock'] == true;
            }
        })->pluck('name')->all();

        $collectionValuesEntered = isset(json_decode($formValues?->json)[0]) ?
            collect(json_decode($formValues?->json)[0])->pluck('value', 'name')->all() : [];

        if ($formValues?->json) {
            // check for radio
            foreach (json_decode($formValues?->json)[0] as $values) {
                if ($values->type == 'radio-group' || $values->type == 'select') {
                    $selected = collect($values->values)->where('selected', '!=', null)->first()?->value;
                    if ($selected) {
                        $collectionValuesEntered[$values->name] = $selected;
                    }
                }
            }
        }


        foreach ($lockedValues as $key) {
            if (array_key_exists($key, $collectionValuesEntered)) {
                $value = $collectionValuesEntered[$key];
                if ($value === null || $value === '') {
                    $missingAndEmpty[] = $key;
                }
            } else {
                $missingAndEmpty[] = $key;
            }
        }


        if ($missingAndEmpty && $user->hasRole('user')) {

            $form = Form::where('related_model', Shareholder::class)->first();
            $form_value = FormValue::where([
                ['formable_type', Shareholder::class],
                ['formable_id', $user->shareholder?->id],
            ])->first();

            if ($form_value) {
                (new UpdateFormValueOnRequest())($request, $form, $form_value, $user->shareHolder);
            }

            session()->flash('error', __('Complete Your Profile First'));
            return redirect()->route('frontend.user.profile');
        }
        return $next($request);
    }
}
