<?php

namespace App\Http\Resources\API\User;

use App\Support\Resources\WithPagination;
use Illuminate\Http\Resources\Json\JsonResource;

class NotificationResource extends JsonResource
{
    use WithPagination;

    /**
     * Transform the resource into an array.
     *
     * @param \Illuminate\Http\Request $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'type' => $this->data['type'] ?? '',
            'title' => $this->data['title'][app()->getLocale()] ?? '',
            'message' => $this->data['message'][app()->getLocale()] ?? '',
            'related_data' => $this->data['related_data'] ?? null,
            'created_at' => $this['created_at']->diffForHumans(),
            'read_at' => $this['read_at'],
            'icon' => asset('icon.png'),
        ];
    }
}
