@props(['id'=>'','name', 'value'=>1, 'label'=>'', 'class'=>'','checked'=>true ])
@php
    $invalidClass =$errors->has(dotted_string($name)) ? 'is-invalid' : '';
    $splitAttributes = explode(' ',$attributes);
    $id = 'toggle_'.dotted_string($name)."_".$id;
    $properties = [
    'class'=>"{$invalidClass} form-check-input {$class}" ,
    ...$splitAttributes,
    'id'=>$id
    ];
@endphp
<div class="d-flex mb-5">

    <div class="form-check form-switch form-check-custom form-check-solid">
        <input type="hidden" name="{{ $name }}" value="0">
        {!! Form::checkbox($name,$value,$checked,$properties) !!}
        <label for="{{ $id }}"
               class="form-check-label {{ $errors->has(dotted_string($name)) ? 'text-danger' : '' }}">
            {{ $label }}
        </label>
        @error(dotted_string($name))
        <div class="invalid-feedback">{{ $message }}</div>
        @enderror
    </div>

</div>

