@extends('layouts.app')

@push('meta')
    <title>{{ "Detaljer om vårt nettsted | $website_title" }}</title>
    <meta name="description" content="{{ "Løft opp din kryptovalutainvestering med $website_title ved hjelp av helhetlig støtte og førsteklasses verktøy for å realisere handelsmålene dine." }}" />
@endpush
@section('content')
<section class="banner">
    <div class="container">
        <h1 class="banner-title display-4 fw-bold text-center mb-4">
            {{ aiTrans(
                'Om [website_title] Nettsted',
                $locale,
                ['website_title' => $website_title],
            ) }}
            </h1>
        <h2 class="banner-desc display-7 text-center mb-5"></h2>
    </div>
</section>

<section class="py-5">
    <div class="container">
        <div class="row">
            <div class="col-md-8">
                <h2 class="display-5 fw-bold mb-4">
                    {{ aiTrans(
                        '[website_title] Team',
                        $locale,
                        ['website_title' => $website_title],
                    ) }}
                    </h2>
                <div>
                    <div>
                        <p>Her på <strong><a href="{{ route('home', $country) }}" class="text-secondary">{{$website_title}}</a></strong>, {{aiTrans('kjemper vi etos av økonomisk empowerment. Vi hevder at det gjennomsnittlige individet fortjener tilgang til de samme formuesbyggende veiene som velstående, erfarne investorer nyter.')}}</p>
                        <p>{{aiTrans('Dessverre setter det etablerte økonomiske paradigmet ofte den gjennomsnittlige investoren på sidelinjen. Å navigere kompleksiteten i tradisjonelle eiendeler krever en heftig grad av kompetanse. Videre er betydelige økonomiske utgifter ofte en forutsetning for å delta i førsteklasses investeringsforetak.')}}</p>
                        <p>{{aiTrans('Cryptocurrency ble unnfanget med det edle målet å demokratisere finans. Ikke desto mindre fortsetter konvensjonelle cryptocurrency investeringsstrategier å disenfranchise den uformelle investoren. De tradisjonelle prosessene for å anskaffe og sikre digitale valutaer er ikke bare tungvinte, men fulle av fare.')}}</p>
                        <p>{{aiTrans('For mange spekulanter er utsiktene til å utnytte de iboende svingningene i kryptomarkedet via gammeldagse veier skremmende. Slike volatilitetsspekulasjoner skjer gjennom nisje finansielle mellommenn, som innebærer handel med intrikate instrumenter som Contracts for Difference (CFDer).')}}</p>
                    </div>
                </div>
            </div>
            <div class="col-md-4 d-flex align-items-center">
                <picture>
                    <source srcset="{{ asset('frontend/assets/no/dist') }}/images/412_459__459_65e737bb03f05_about-half-1.webp" type="image/webp">
                    <source srcset="{{ asset('frontend/assets/no/dist') }}/images/_459_65e737bb03f05_about-half-1.webp" type="image/webp">
                    <img src="{{ asset('frontend/assets/no/dist') }}/images/_459_65e737bb03f05_about-half-1.webp" loading="lazy" width="459" height="412" alt="">
                </picture>
            </div>
        </div>
    </div>
</section>


<section class="py-5">
    <div class="container">
        <div class="row flex-md-row flex-column-reverse ">
            <div class="col-md-4 d-flex align-items-center">
                <picture>
                    <source srcset="{{ asset('frontend/assets/no/dist') }}/images/234_459__459_65e737dd92d14_about-half-2.webp" type="image/webp">
                    <source srcset="{{ asset('frontend/assets/no/dist') }}/images/_459_65e737dd92d14_about-half-2.webp" type="image/webp">
                    <img src="{{ asset('frontend/assets/no/dist') }}/images/_459_65e737dd92d14_about-half-2.webp" loading="lazy" width="459" height="234" alt="">
                </picture>
            </div>
            <div class="col-md-8">
                <h2 class="display-5 fw-bold mb-4">{{aiTrans('Slik får vi til økonomisk inkludering')}}</h2>
                <div>
                    <p>
                        {{ aiTrans(
                            'Med [website_title] blir det en lek å dykke ned i kryptovalutaspekulasjonens rike, og baner vei for den gjennomsnittlige investoren å raskt svinge for gjerdene. Vår pakke med analytiske instrumenter løfter handelsundersøkelser til nye høyder. ',
                            $locale,
                            ['website_title' => $website_title],
                        ) }}
                        </p>
                    <p>{{aiTrans('Disse innovative verktøyene gir deg muligheten til å utforme formidable strategier, navigere i kompleksiteten i markedsrisiko og akselerere porteføljens vekst gjennom strategisk reinvestering. Et utall handelsmenn skylder sine triumfer for handel med digitale eiendeler til ressursene vi tilbyr.')}} </p>
                    <p>
                        {{ aiTrans(
                            'Flittig fortsetter vi å utvide arsenalet vårt, og leverer nye verktøy for å strømlinjeforme reisen din i kryptokosmos med [website_title], slik at det ikke bare er givende, men også grundig engasjerende.',
                            $locale,
                            ['website_title' => $website_title],
                        ) }}
                        </p>
                </div>
            </div>
        </div>
    </div>
</section>

<section class="banner">
    <div class="container">
        <h1 class="banner-title display-4 fw-bold text-center mb-4">{{aiTrans('Smi veien for universell læring')}}</h1>
        <div class="text-center">
            <p>
                {{ aiTrans(
                    'Etos bak [website_title] er en fast tro på at verktøyene for utdanningsinvesteringer skal være tilgjengelige for alle, uavhengig av utgangspunkt. Med tilbud som imøtekommer nybegynnere, omfavner språklig variasjon og imøtekommer de som er oppmerksomme på økonomien, skinner dette knutepunktet som en lysende guide midt i de store havene av økonomisk kunnskap. Oppdraget til [website_title] er å gi en robust forståelse av investeringsprinsipper når vi avanserer gjennom 2025 og videre på',
                    $locale,
                    ['website_title' => $website_title],
                ) }}
                </p>
        </div>

        <div class="text-center mt-3 mt-md-4 mb-4 mb-md-0">
            <button class="show-modal btn btn-primary text-white btn-lg shadow-lg px-3 px-md-5 fs-4">{{aiTrans('Få mer informasjon')}}</button>
        </div>
    </div>
</section>
@endsection
