<?php $__env->startPush('meta'); ?>
    <title><?php echo e("$website_title | 너의 프라이버시 보호 지침"); ?></title>
    <meta name="description" content="<?php echo e("$website_title - 이 웹사이트에서 당신의 개인정보를 어떻게 안전하게 보호하는지 확인해 보십시오. 우리의 정책은 모든 정보를 최적으로 보호하기 위해 설계되었습니다."); ?>" />
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
<div class="container terms py-4">
    <h1 class="bold text-center">데이터 개인 정보 보호 통지</h1>
    <h2>통지의 목적</h2>
    <p><?php echo e(aiTrans('이 데이터 개인 정보 보호 통지의 목적은')); ?> (the<strong>"Notice"</strong>) <?php echo e(aiTrans('이 설명하는 것입니다.')); ?> <?php echo e($website_title); ?> (<strong>"<?php echo e($website_title); ?>"</strong>또는<strong>"We"</strong>또는<strong>"Us"</strong>)는 귀하가 웹사이트 <?php echo e($website_title); ?> (the<strong>"Website"</strong>)를 방문할 때 제공하는 귀하의 개인 데이터를 데이터 관리자으로 처리할 것입니다. <?php echo e(aiTrans('또는 우리가 귀하가 관심을 가질 수 있는 전문가와 연락을 취할 수 있도록 제3자로부터 수신한 데이터입니다.')); ?></p>
    <h2><?php echo e(aiTrans('어떤 범주의 개인 데이터가 처리됩니까?')); ?></h2>
    <p>
        <?php echo e(aiTrans(
            '[website_title]는 귀하에 대한 다음 범주의 개인 데이터를 수집하고 처리합니다:',
            $locale,
            ['website_title' => $website_title],
        )); ?>

        </p>
        <figure class="table">
            <table>
                <thead>
                    <tr>
                        <th><strong><?php echo e(aiTrans('개인 데이터 범주')); ?></strong></th>
                        <th><strong><?php echo e(aiTrans('정의')); ?></strong></th>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td><?php echo e(aiTrans('식별 데이터')); ?></td>
                        <td><?php echo e(aiTrans('전체 이름 및 연락처 정보(전화 번호 및 이메일 주소).')); ?></td>
                    </tr>
                    <tr>
                        <td><?php echo e(aiTrans('탐색 정보')); ?></td>
                        <td><?php echo e(aiTrans('IP 주소, 접근 시간, 접근 날짜, 방문한 웹 및 모바일 페이지, 사용 언어, 소프트웨어 충돌 보고서 및 사용한 브라우저 유형, 귀하가 사용한 장치에 대한 정보, 쿠키, 웹 서버, 픽셀 및 웹 비콘과 같이 자동으로 수집된 귀하의 온라인 행동.')); ?></td>
                    </tr>
                </tbody>
            </table>
        </figure>
        <h2><?php echo e(aiTrans('귀하의 데이터는 어떻게 수집됩니까?')); ?></h2>
        <p><?php echo e(aiTrans('우리는 귀하의 개인 데이터를 수집할 것입니다:')); ?></p>
        <ul>
            <li><?php echo e(aiTrans('귀하가 우리 웹사이트에서 식별 데이터를 제공할 때 직접적으로; 및/또는')); ?></li>
            <li><?php echo e(aiTrans('간접적으로:')); ?>

                <ul>
                    <li><?php echo e(aiTrans('우리가 제3자로부터 귀하에 대한 식별 데이터를 수신할 때')); ?></li>
                    <li><?php echo e(aiTrans('쿠키 또는 유사한 기술을 사용하여 우리 웹사이트의 탐색과 관련된 데이터를 수집할 때 (쿠키 정책에 정의된 바와 같이).')); ?></li>
                </ul>
            </li>
        </ul>
        <p><?php echo e(aiTrans('귀하는 우리에게 개인 데이터를 제공할 의무가 없습니다. 그러나 개인 데이터를 제공하지 않으면 귀하가 관심을 가질 수 있는 전문가와 연락을 취할 수 없습니다.')); ?></p>
        <h2><?php echo e(aiTrans('우리의 처리 목적과 법적 근거는 무엇입니까?')); ?></h2>
    <p>
        <?php echo e(aiTrans(
            '[website_title]는 다음 목적을 위해 귀하의 개인 데이터를 처리합니다:',
            $locale,
            ['website_title' => $website_title],
        )); ?>

        </p>
    <figure class="table">
        <table>
            <thead>
                <tr>
                    <th><strong><?php echo e(aiTrans('목적')); ?></strong></th>
                    <th><strong><?php echo e(aiTrans('법적 근거')); ?></strong></th>
                    <th><strong><?php echo e(aiTrans('처리된 개인 데이터 범주')); ?></strong></th>
                </tr>
            </thead>
            <tbody>
                <tr>
                    <td><?php echo e(aiTrans('귀하가 관심을 가질 수 있는 서비스를 제공하는 전문가와 귀하의 개인 데이터를 공유하기')); ?></td>
                    <td><?php echo e(aiTrans('귀하의 동의')); ?></td>
                    <td><?php echo e(aiTrans('식별 데이터')); ?></td>
                </tr>
                <tr>
                    <td><?php echo e(aiTrans('요청 및 법적 요구 사항에 응답하고 이를 준수하기 위해 규제 기관 또는 귀하의 모국 내외의 기타 권한으로부터.')); ?></td>
                    <td><?php echo e(aiTrans('적용 가능한 법적 및 규제 요건 준수.')); ?></td>
                    <td><?php echo e(aiTrans('식별 데이터')); ?><br><?php echo e(aiTrans('탐색 정보')); ?></td>
                </tr>
                <tr>
                    <td><?php echo e(aiTrans('우리의 권리를 시행하고 방어하기')); ?></td>
                    <td><?php echo e(aiTrans('우리의 사용자(귀하 포함)에 대한 방어를 위한 우리의 정당한 이익, 사법, 행정 및/또는 법 집행 당국.')); ?></td>
                    <td><?php echo e(aiTrans('식별 데이터')); ?><br><?php echo e(aiTrans('탐색 정보')); ?></td>
                </tr>
                <tr>
                    <td><?php echo e(aiTrans('우리 웹사이트의 운영 및 보안 보장하기')); ?></td>
                    <td><?php echo e(aiTrans('잘 작동하고 안전한 웹사이트를 보장하기 위한 우리의 정당한 이익.')); ?></td>
                    <td><?php echo e(aiTrans('탐색 정보')); ?></td>
                </tr>
            </tbody>
        </table>
    </figure>
    <h2><?php echo e(aiTrans('내 개인 데이터는 누구와 공유됩니까?')); ?></h2>
    <p><?php echo e(aiTrans('우리는 귀하의 개인 데이터를 공유할 것입니다:')); ?></p>
    <ul>
        <li><?php echo e(aiTrans('우리 그룹 내에서;')); ?></li>
        <li><?php echo e(aiTrans('귀하가 사전에 동의한 경우, 우리 파트너와 그들 자신의 처리 목적으로, 귀하가 관심을 가질 수 있는 서비스 및 제품에 대한 정보를 제공하기 위해.')); ?></li>
        <li><?php echo e(aiTrans('저장 및 호스팅 제공업체 분석, 기술 및 진단 서비스를 포함하여 우리에게 서비스를 제공하는 제3자와;')); ?></li>
        <li><?php echo e(aiTrans('우리의 법률 고문과, 특히 회계, 감사 및 내부 통제 측면에서 우리의 법적 의무를 준수하기 위해;')); ?></li>
        <li><?php echo e(aiTrans('우리 회사 및 자산의 일부 또는 전부를 제3자에게 판매하는 것 또는 사업 재조정 또는 재구성을 위한 (해산 또는 청산 포함); 그리고')); ?></li>
        <li><?php echo e(aiTrans('적용 가능한 법률에 따라 요구되거나 허용되는 경우, 정부 당국, 법원, 외부 자문 및 유사한 제3자에게.')); ?></li>
    </ul>
    <h2><?php echo e(aiTrans('국경 간 데이터 전송')); ?></h2>
    <p>
        <?php echo e(aiTrans(
            '[website_title]는 귀하의 개인 데이터를 유럽 경제 지역(<strong>“EEA”</strong>) 외부로 전송합니다. 일부 수신자는 유럽 위원회가 적정성 결정을 내린 국가에 위치해 있습니다. 즉, 이스라엘, [필요 시 완료할 수 있습니다]. 따라서 이 전송은 유럽 데이터 보호 법률 관점에서 적절한 데이터 보호 수준을 제공하는 것으로 인식됩니다 (Art. 45 GDPR).',
            $locale,
            ['website_title' => $website_title],
        )); ?>

        </p>
    <p><?php echo e(aiTrans('귀하의 개인 데이터의 일부 수신자는 유럽 위원회가 이 나라가 적절한 수준의 데이터 보호를 보장한다는 결정을 내리지 않은 다른 국가에 위치하고 있습니다. 즉, [필요 시 완료할 수 있습니다].')); ?></p>
<p><?php echo e(aiTrans('적절한 데이터 전송 계약을 체결함으로써, 표준 계약 조항(2021/914/EU) 및 Art. 46 (2) (c) GDPR에 언급된 기타 적절한 수단을 기반으로, 아래의 연락처를 통해 접근할 수 있는 모든 EEA 외부에 위치한 수신자가 개인 데이터에 대해 적절한 수준의 데이터 보호를 제공하며, 개인 데이터를 우발적 또는 불법적인 파괴, 우발적 손실 또는 변경, 무단 공개 또는 접근 및 모든 기타 불법적인 처리 형태로부터 보호하기 위한 적절한 기술적 및 조직적 보안 조치가 마련되어 있음을 확인했습니다. 모든 전송(우리의 계열사를 포함하여 EEA 외부)도 적용 가능한 법률에 의해 요구되는 적절한 전송 요건의 적용을 받습니다.')); ?></p>
    <h2><?php echo e(aiTrans('보유')); ?></h2>
    <p>
        <?php echo e(aiTrans(
            '[website_title]는 이 통지에서 언급된 처리 목적을 달성하는 데 엄격히 필요한 기간 동안만 수집된 개인 데이터를 저장합니다. [website_title]가 더 이상 귀하의 개인 데이터를 사용할 필요가 없을 때, 해당 데이터는 삭제되거나 익명화되어 개인을 식별할 수 없도록 합니다(법적 또는 규제 의무를 준수하기 위해 필요한 경우를 제외하고, 법적 청구를 제기하거나 방어하는 경우).',
            $locale,
            ['website_title' => $website_title],
        )); ?>

        </p>
    <h2><?php echo e(aiTrans('귀하의 권리')); ?></h2>
<p><?php echo e(aiTrans('적용 가능한 데이터 개인 정보 보호 법률에 따라, 귀하는 다음과 같은 권리가 있습니다:')); ?></p>
<ol>
    <li><strong><?php echo e(aiTrans('접근 권리:')); ?></strong><?php echo e(aiTrans('귀하는 개인 데이터가 처리되고 있는지 여부에 대한 확인을 요청할 권리가 있으며, 그 경우 개인 데이터에 대한 접근을 요청할 수 있습니다. 접근 정보에는 처리 목적, 관련 개인 데이터 범주 및 개인 데이터가 공개된 수신자 또는 수신자 범주가 포함됩니다.')); ?><br><?php echo e(aiTrans('귀하는 처리 중인 개인 데이터의 사본을 요청할 권리가 있습니다. 귀하가 요청한 추가 사본에 대해, 우리는 관리 비용을 기준으로 합리적인 요금을 청구할 수 있습니다.')); ?></li>
    <li><strong><?php echo e(aiTrans('수정 권리:')); ?></strong><?php echo e(aiTrans('귀하는 부정확한 개인 데이터의 수정을 요청할 권리가 있습니다. 처리 목적에 따라, 귀하는 불완전한 개인 데이터를 보완할 권리가 있으며, 추가 진술을 제공하는 방법으로 가능합니다.')); ?></li>
    <li><strong><?php echo e(aiTrans('삭제 권리(잊혀질 권리):')); ?></strong><?php echo e(aiTrans('귀하는 귀하의 개인 데이터 삭제를 요청할 권리가 있습니다.')); ?></li>
    <li><strong><?php echo e(aiTrans('처리 제한 권리:')); ?></strong><?php echo e(aiTrans('귀하는 귀하의 개인 데이터 처리 제한을 요청할 권리가 있습니다. 이 경우, 해당 데이터는 표시되며 특정 목적을 위해서만 우리에 의해 처리될 수 있습니다.')); ?></li>
    <li><strong><?php echo e(aiTrans('데이터 이동 권리:')); ?></strong><?php echo e(aiTrans('귀하는 귀하가 우리에게 제공한 개인 데이터를 구조적이고 일반적으로 사용되는 기계 판독 가능한 형식으로 받을 권리가 있으며, 귀하의 개인 데이터를 다른 엔티티로 방해받지 않고 전송할 권리가 있습니다.')); ?></li>
    <li><strong><?php echo e(aiTrans('반대 권리:')); ?></strong><?php echo e(aiTrans('귀하는 귀하의 특정 상황과 관련하여 언제든지 개인 데이터 처리에 반대할 권리가 있으며, 우리는 귀하의 개인 데이터를 더 이상 처리하지 않아야 합니다. 귀하가 반대할 권리가 있고 이를 행사할 경우, 귀하의 개인 데이터는 더 이상 그러한 목적을 위해 우리에 의해 처리되지 않을 것입니다. 이 권리를 행사하는 것은 어떠한 비용도 발생하지 않습니다. 반대할 권리는 특히 개인 데이터 처리가 계약 체결 전 조치를 취하거나 이미 체결된 계약을 수행하는 데 필요한 경우에는 존재하지 않을 수 있습니다.')); ?></li>
    <li><strong><?php echo e(aiTrans('동의 철회 권리:')); ?></strong><?php echo e(aiTrans('귀하의 개인 데이터 처리의 법적 근거가 귀하의 동의인 경우, 귀하는 언제든지 동의를 철회할 권리가 있습니다. 그러한 동의를 철회하는 권리는 귀하가 이전에 우리에게 부여한 동의에 기반한 처리의 합법성에 영향을 미치지 않습니다.')); ?></li>
    <li><strong><?php echo e(aiTrans('사후 데이터 권리:')); ?></strong><?php echo e(aiTrans('귀하는 사후 개인 데이터 보존, 삭제 및 전달과 관련된 지침을 제공할 권리가 있습니다.')); ?></li>
</ol>
<p><?php echo e(aiTrans('이러한 권리는 적용 가능한 지역 데이터 개인 정보 보호 법률에 따라 제한될 수 있음을 유의하시기 바랍니다.')); ?></p>
<p><?php echo e(aiTrans('이러한 권리를 행사하고자 하는 경우, 아래의 연락처 섹션에 명시된 대로 우리에게 연락해 주시기 바랍니다.')); ?></p>
<p><?php echo e(aiTrans('귀하는 또한 프랑스의 데이터 개인 정보 감독 기관인 CNIL에 불만을 제기할 권리가 있습니다.')); ?></p>
<h2><?php echo e(aiTrans('문의하기')); ?></h2>
<p><?php echo e(aiTrans('이 통지에 대한 질문이 있는 개인은 다음 주소로 연락해야 합니다:')); ?> <a href="mailto:info<?php echo e('@'.$website_title); ?>">info<?php echo e('@'.$website_title); ?></a></p>
<h2><?php echo e(aiTrans('개인 정보 보호 통지 변경')); ?></h2>
<p><?php echo e(aiTrans('이 개인 정보 보호 통지는 변경될 수 있습니다. 그러한 변경 사항에 대해 적절히 통지받을 것입니다.')); ?></p>
<p><?php echo e(aiTrans('최종 업데이트: 2024.11.01')); ?></p>
</div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/enng1/public_html/immediate13.com/resources/views/frontend/ko/privacy.blade.php ENDPATH**/ ?>