# Changelog

## 10.1.4 - 2024-03-09

### What's Changed

* [10.x] fix initializeMorphOneWallet by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/905

**Full Changelog**: https://github.com/bavix/laravel-wallet/compare/10.1.3...10.1.4

## 10.1.3 - 2024-02-01

### What's Changed

* build(deps): bump bavix/.github from 0.1.7 to 0.1.9 by [@dependabot](https://github.com/dependabot) in https://github.com/bavix/laravel-wallet/pull/854
* add a check for passing the correct model by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/859
* Update Transfer Model by [@gkmk](https://github.com/gkmk) in https://github.com/bavix/laravel-wallet/pull/858
* phpstan baseline by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/860
* [10.x] received transfers by [@gkmk](https://github.com/gkmk) in https://github.com/bavix/laravel-wallet/pull/878

**Full Changelog**: https://github.com/bavix/laravel-wallet/compare/10.1.2...10.1.3

## 10.1.1 - 2024-01-19

## What's Changed

* [docs] documentation of float wallets has been expanded by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/824
* Update upgrade-guide.md by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/825
* build(deps): bump bavix/.github from 0.1.0 to 0.1.1 by [@dependabot](https://github.com/dependabot) in https://github.com/bavix/laravel-wallet/pull/832
* build(deps): bump axios from 1.6.3 to 1.6.4 by [@dependabot](https://github.com/dependabot) in https://github.com/bavix/laravel-wallet/pull/833
* build(deps): bump axios from 1.6.4 to 1.6.5 by [@dependabot](https://github.com/dependabot) in https://github.com/bavix/laravel-wallet/pull/840
* build(deps): bump mini-css-extract-plugin from 2.7.6 to 2.7.7 by [@dependabot](https://github.com/dependabot) in https://github.com/bavix/laravel-wallet/pull/843
* build(deps-dev): update rector/rector requirement from ^0.17 to ^0.19 by [@dependabot](https://github.com/dependabot) in https://github.com/bavix/laravel-wallet/pull/841
* build(deps): bump css-loader from 6.8.1 to 6.9.0 by [@dependabot](https://github.com/dependabot) in https://github.com/bavix/laravel-wallet/pull/842
* add docs bavix/laravel-wallet-uuid by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/844
* build(deps): bump size-limit from 11.0.1 to 11.0.2 by [@dependabot](https://github.com/dependabot) in https://github.com/bavix/laravel-wallet/pull/847
* build(deps): bump bavix/.github from 0.1.1 to 0.1.4 by [@dependabot](https://github.com/dependabot) in https://github.com/bavix/laravel-wallet/pull/848
* build(deps): bump actions/cache from 3 to 4 by [@dependabot](https://github.com/dependabot) in https://github.com/bavix/laravel-wallet/pull/849
* build(deps): bump bavix/.github from 0.1.4 to 0.1.6 by [@dependabot](https://github.com/dependabot) in https://github.com/bavix/laravel-wallet/pull/850
* Update changelog.md by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/851
* build(deps): bump css-loader from 6.9.0 to 6.9.1 by [@dependabot](https://github.com/dependabot) in https://github.com/bavix/laravel-wallet/pull/852
* build(deps): bump bavix/.github from 0.1.6 to 0.1.7 by [@dependabot](https://github.com/dependabot) in https://github.com/bavix/laravel-wallet/pull/853

**Full Changelog**: https://github.com/bavix/laravel-wallet/compare/10.1.0...10.1.1

## 10.1.0 - 2023-12-28

## What's Changed

* build(deps-dev): update laravel/cashier requirement from ^14.12 to ^15.0 by [@dependabot](https://github.com/dependabot) in https://github.com/bavix/laravel-wallet/pull/817
* build(deps): bump axios from 1.6.2 to 1.6.3 by [@dependabot](https://github.com/dependabot) in https://github.com/bavix/laravel-wallet/pull/821
* [10.x] add getDynamicDefaultSlug by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/822

**Full Changelog**: https://github.com/bavix/laravel-wallet/compare/10.0.2...10.1.0

## 10.0.2 - 2023-12-13

## What's Changed

* Bump bavix/.github from 0.0.5 to 0.0.7 by [@dependabot](https://github.com/dependabot) in https://github.com/bavix/laravel-wallet/pull/784
* docs: accessing float amount by [@justinkekeocha](https://github.com/justinkekeocha) in https://github.com/bavix/laravel-wallet/pull/786
* docs: changing wallet decimal_places by [@justinkekeocha](https://github.com/justinkekeocha) in https://github.com/bavix/laravel-wallet/pull/785
* remove driftingly/rector-laravel by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/787
* Bump postcss from 8.4.19 to 8.4.31 by [@dependabot](https://github.com/dependabot) in https://github.com/bavix/laravel-wallet/pull/788
* Bump webpack from 5.88.2 to 5.89.0 by [@dependabot](https://github.com/dependabot) in https://github.com/bavix/laravel-wallet/pull/790
* Bump size-limit from 9.0.0 to 10.0.1 by [@dependabot](https://github.com/dependabot) in https://github.com/bavix/laravel-wallet/pull/792
* Bump bavix/.github from 0.0.7 to 0.0.8 by [@dependabot](https://github.com/dependabot) in https://github.com/bavix/laravel-wallet/pull/793
* remove cozyhouse by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/794
* Bump axios from 1.5.1 to 1.6.0 by [@dependabot](https://github.com/dependabot) in https://github.com/bavix/laravel-wallet/pull/795
* add support php 8.3 by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/796
* Bump size-limit from 10.0.1 to 10.0.2 by [@dependabot](https://github.com/dependabot) in https://github.com/bavix/laravel-wallet/pull/797
* Qodana by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/798
* build(deps): bump actions/checkout from 3 to 4 by [@dependabot](https://github.com/dependabot) in https://github.com/bavix/laravel-wallet/pull/799
* build(deps): bump axios from 1.6.0 to 1.6.1 by [@dependabot](https://github.com/dependabot) in https://github.com/bavix/laravel-wallet/pull/801
* build(deps): bump size-limit from 10.0.2 to 11.0.0 by [@dependabot](https://github.com/dependabot) in https://github.com/bavix/laravel-wallet/pull/802
* build(deps): bump axios from 1.6.1 to 1.6.2 by [@dependabot](https://github.com/dependabot) in https://github.com/bavix/laravel-wallet/pull/803
* build(deps): bump bavix/.github from 0.0.8 to 0.0.9 by [@dependabot](https://github.com/dependabot) in https://github.com/bavix/laravel-wallet/pull/808
* build(deps): bump size-limit from 11.0.0 to 11.0.1 by [@dependabot](https://github.com/dependabot) in https://github.com/bavix/laravel-wallet/pull/810
* build(deps): bump actions/stale from 8 to 9 by [@dependabot](https://github.com/dependabot) in https://github.com/bavix/laravel-wallet/pull/811
* build(deps): bump bavix/.github from 0.0.9 to 0.1.0 by [@dependabot](https://github.com/dependabot) in https://github.com/bavix/laravel-wallet/pull/812
* build(deps): bump JetBrains/qodana-action from 2023.2 to 2023.3 by [@dependabot](https://github.com/dependabot) in https://github.com/bavix/laravel-wallet/pull/813
* add support database cache by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/815

**Full Changelog**: https://github.com/bavix/laravel-wallet/compare/10.0.1...10.0.2

## 10.0.1 - 2023-09-29

## What's Changed

* Bump semver from 7.3.8 to 7.5.4 by [@dependabot](https://github.com/dependabot) in https://github.com/bavix/laravel-wallet/pull/726
* Bump webpack from 5.76.3 to 5.88.1 by [@dependabot](https://github.com/dependabot) in https://github.com/bavix/laravel-wallet/pull/724
* Bump webpack from 5.88.1 to 5.88.2 by [@dependabot](https://github.com/dependabot) in https://github.com/bavix/laravel-wallet/pull/730
* Update symplify/easy-coding-standard requirement from ^11.5 to ^12.0 by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/732
* Updated laravel rector set by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/733
* Update driftingly/rector-laravel requirement from ^0.21 to ^0.22 by [@dependabot](https://github.com/dependabot) in https://github.com/bavix/laravel-wallet/pull/735
* Create npm workflow by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/736
* Update docs.yaml by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/737
* Update docs.yaml by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/739
* Update docs.yaml by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/740
* Update docs.yaml by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/741
* Lumen documentation update by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/743
* [Snyk] Upgrade webpack-cli from 5.0.0 to 5.1.4 by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/747
* [Snyk] Upgrade axios from 1.3.4 to 1.4.0 by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/748
* [Snyk] Upgrade size-limit from 8.2.4 to 8.2.6 by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/750
* [Snyk] Upgrade mini-css-extract-plugin from 2.7.5 to 2.7.6 by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/751
* [Snyk] Upgrade docsify from 4.13.0 to 4.13.1 by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/752
* Update driftingly/rector-laravel requirement from ^0.22 to ^0.24 by [@dependabot](https://github.com/dependabot) in https://github.com/bavix/laravel-wallet/pull/753
* Bump axios from 1.4.0 to 1.5.0 by [@dependabot](https://github.com/dependabot) in https://github.com/bavix/laravel-wallet/pull/756
* Bump bavix/.github from 0.0.4 to 0.0.5 by [@dependabot](https://github.com/dependabot) in https://github.com/bavix/laravel-wallet/pull/759
* Bump size-limit from 8.2.6 to 9.0.0 by [@dependabot](https://github.com/dependabot) in https://github.com/bavix/laravel-wallet/pull/762
* Bump actions/stale from 6 to 8 by [@dependabot](https://github.com/dependabot) in https://github.com/bavix/laravel-wallet/pull/761
* Bump actions/checkout from 3 to 4 by [@dependabot](https://github.com/dependabot) in https://github.com/bavix/laravel-wallet/pull/760
* docs: update wording to sound grammatically correct by [@justinkekeocha](https://github.com/justinkekeocha) in https://github.com/bavix/laravel-wallet/pull/766
* docs: customize name and slug of default wallet by [@justinkekeocha](https://github.com/justinkekeocha) in https://github.com/bavix/laravel-wallet/pull/765
* docs: fixed grammatical error by [@justinkekeocha](https://github.com/justinkekeocha) in https://github.com/bavix/laravel-wallet/pull/764
* Bump uuid from 9.0.0 to 9.0.1 by [@dependabot](https://github.com/dependabot) in https://github.com/bavix/laravel-wallet/pull/768
* checking the Wallet class extensibility by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/769
* docs: Create configuration.md by [@justinkekeocha](https://github.com/justinkekeocha) in https://github.com/bavix/laravel-wallet/pull/771
* docs: add configuration file to sidebar by [@justinkekeocha](https://github.com/justinkekeocha) in https://github.com/bavix/laravel-wallet/pull/772
* docs: move configuration details to separate file by [@justinkekeocha](https://github.com/justinkekeocha) in https://github.com/bavix/laravel-wallet/pull/773
* docs: update for clarity by [@justinkekeocha](https://github.com/justinkekeocha) in https://github.com/bavix/laravel-wallet/pull/774
* Update driftingly/rector-laravel requirement from ^0.24 to ^0.25 by [@dependabot](https://github.com/dependabot) in https://github.com/bavix/laravel-wallet/pull/779
* Update driftingly/rector-laravel requirement from ^0.25 to ^0.26 by [@dependabot](https://github.com/dependabot) in https://github.com/bavix/laravel-wallet/pull/780
* Bump axios from 1.5.0 to 1.5.1 by [@dependabot](https://github.com/dependabot) in https://github.com/bavix/laravel-wallet/pull/781
* Add semgrep by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/783

## New Contributors

* [@justinkekeocha](https://github.com/justinkekeocha) made their first contribution in https://github.com/bavix/laravel-wallet/pull/766

**Full Changelog**: https://github.com/bavix/laravel-wallet/compare/10.0.0...10.0.1

## 10.0.0 - 2023-07-08

### Added

- Added environment variables for cache and locks (WALLET_CACHE_DRIVER, WALLET_CACHE_TTL, WALLET_LOCK_DRIVER, WALLET_LOCK_TTL).
- Transaction/transfer uuids added to External API.
- Improved support for custom types with phpstan. Now you will find more errors.
- Added the ability to buy for any wallet through the basket (receiving wallet).

### Deprecated

- Method deprecated `BookkeeperServiceInterface::missing`. Use `BookkeeperServiceInterface::forget`.

### Deleted

- Removed `LockProviderNotFoundException`.

### Fixed

- Fixed empty state bug.
- Fixed return types in phpdoc, added strong typing.

### Changed

- Viewing a balance no longer creates a wallet. Solves problems with laravel nova. #658. Thank you [@myounis97](https://github.com/myounis97)
- Contract changed `EagerLoaderServiceInterface`. Added customer.
- The `to_type` and `from_type` columns in the translation table are no longer used. Will be removed in 11.x.
- For all transfers, the relationship type has been changed from `MorphMany` to `HasMany`.
- Minimum php version 8.1.
- Minimum laravel version 10.0.
- Minimum doctrine/dbal version 3.5.
- Minimum brick/math version 0.10.

## What's Changed

* [9.x] Adding a wallet creation event check for a muti wallet by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/664
* [9.x] rector-fix by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/665
* [9.x] ecs-fix by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/666
* [9.x] add exchange unit. decimal_places=8 by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/670
* Bump mini-css-extract-plugin from 2.7.3 to 2.7.5 by [@dependabot](https://github.com/dependabot) in https://github.com/bavix/laravel-wallet/pull/672
* Bump webpack from 5.76.1 to 5.76.2 by [@dependabot](https://github.com/dependabot) in https://github.com/bavix/laravel-wallet/pull/673
* Bump webpack from 5.76.2 to 5.76.3 by [@dependabot](https://github.com/dependabot) in https://github.com/bavix/laravel-wallet/pull/674
* [10.x] New version by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/628

**Full Changelog**: https://github.com/bavix/laravel-wallet/compare/9.6.2...10.0.0

## 9.6.2 - 2023-03-15

### Fixed

- * [9.x] Fixed WalletService::create() without db::transaction() by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/663. Thank you [@oasin](https://github.com/oasin) #659
  

## What's Changed

* Bump axios from 1.2.3 to 1.2.6 by [@dependabot](https://github.com/dependabot) in https://github.com/bavix/laravel-wallet/pull/642
* Bump axios from 1.2.6 to 1.3.2 by [@dependabot](https://github.com/dependabot) in https://github.com/bavix/laravel-wallet/pull/645
* Bump axios from 1.3.2 to 1.3.3 by [@dependabot](https://github.com/dependabot) in https://github.com/bavix/laravel-wallet/pull/648
* Bump size-limit from 8.1.2 to 8.2.4 by [@dependabot](https://github.com/dependabot) in https://github.com/bavix/laravel-wallet/pull/649
* Bump axios from 1.3.3 to 1.3.4 by [@dependabot](https://github.com/dependabot) in https://github.com/bavix/laravel-wallet/pull/656
* Bump mini-css-extract-plugin from 2.7.0 to 2.7.3 by [@dependabot](https://github.com/dependabot) in https://github.com/bavix/laravel-wallet/pull/661
* Bump webpack from 5.75.0 to 5.76.1 by [@dependabot](https://github.com/dependabot) in https://github.com/bavix/laravel-wallet/pull/662
* [9.x] Fixed WalletService::create() without db::transaction() by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/663

**Full Changelog**: https://github.com/bavix/laravel-wallet/compare/9.6.1...9.6.2

## 8.4.3 - 2023-02-05

### Fixed

- Fixed infinite lock

**Full Changelog**: https://github.com/bavix/laravel-wallet/compare/8.4.2...8.4.3

## 7.3.6 - 2023-02-05

### Fixed

- Fixed infinite lock

**Full Changelog**: https://github.com/bavix/laravel-wallet/compare/7.3.5...7.3.6

## 9.6.1 - 2023-01-30

### Added

* Add support laravel 10.x

## What's Changed

* Bump docsify from 4.12.2 to 4.13.0 by [@dependabot](https://github.com/dependabot) in https://github.com/bavix/laravel-wallet/pull/596
* add driftingly/rector-laravel by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/606
* Bump axios from 1.1.3 to 1.2.0 by [@dependabot](https://github.com/dependabot) in https://github.com/bavix/laravel-wallet/pull/605
* Bump webpack-cli from 4.10.0 to 5.0.0 by [@dependabot](https://github.com/dependabot) in https://github.com/bavix/laravel-wallet/pull/604
* Bump mini-css-extract-plugin from 2.6.1 to 2.7.0 by [@dependabot](https://github.com/dependabot) in https://github.com/bavix/laravel-wallet/pull/603
* Bump webpack from 5.74.0 to 5.75.0 by [@dependabot](https://github.com/dependabot) in https://github.com/bavix/laravel-wallet/pull/601
* Bump css-loader from 6.7.1 to 6.7.2 by [@dependabot](https://github.com/dependabot) in https://github.com/bavix/laravel-wallet/pull/600
* update packages by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/620
* fix rector.php by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/624
* Bump css-loader from 6.7.2 to 6.7.3 by [@dependabot](https://github.com/dependabot) in https://github.com/bavix/laravel-wallet/pull/616
* Bump axios from 1.2.0 to 1.2.2 by [@dependabot](https://github.com/dependabot) in https://github.com/bavix/laravel-wallet/pull/625
* update changelog.md by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/633
* Bump size-limit from 8.1.0 to 8.1.1 by [@dependabot](https://github.com/dependabot) in https://github.com/bavix/laravel-wallet/pull/638
* Bump axios from 1.2.2 to 1.2.3 by [@dependabot](https://github.com/dependabot) in https://github.com/bavix/laravel-wallet/pull/640
* Bump size-limit from 8.1.1 to 8.1.2 by [@dependabot](https://github.com/dependabot) in https://github.com/bavix/laravel-wallet/pull/639

**Full Changelog**: https://github.com/bavix/laravel-wallet/compare/9.6.0...9.6.1

## 8.4.2 - 2022-12-29

### Fixed

- fix withdraw/transfer

**Full Changelog**: https://github.com/bavix/laravel-wallet/compare/8.4.1...8.4.2

## 7.3.5 - 2022-12-29

### Fixed

- fix withdraw/transfer

**Full Changelog**: https://github.com/bavix/laravel-wallet/compare/7.3.4...7.3.5

## 9.6.0 - 2022-10-27

### Added

* Full support for standard transactions and laravel nova #589

## What's Changed

* psalm-fix by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/585
* Bump axios from 0.27.2 to 1.1.2 by [@dependabot](https://github.com/dependabot) in https://github.com/bavix/laravel-wallet/pull/586
* Bump axios from 1.1.2 to 1.1.3 by [@dependabot](https://github.com/dependabot) in https://github.com/bavix/laravel-wallet/pull/591
* Deprecating save-state and set-output commands by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/594
* [9.6] Event Architecture by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/589

**Full Changelog**: https://github.com/bavix/laravel-wallet/compare/9.5.0...9.6.0

## 9.5.0 - 2022-10-06

### Added

* Improved performance api handles #576

### Changed

* Cache query optimize. v2 #580
* Optimize StateServiceInterface #582

### Fixed

* Memory leak. StateServiceInterface #583

## What's Changed

* [9.5] Improved performance api handles by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/576
* [9.5] Cache query optimize. v2 by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/580
* [9.5] Optimize StateServiceInterface by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/582
* [9.5] docs by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/581
* [9.5] StateServiceInterface. Memory Leak. Optimize by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/583

**Full Changelog**: https://github.com/bavix/laravel-wallet/compare/9.4.0...9.5.0

## 9.4.0 - 2022-09-29

### Added

* Add support Model::preventSilentlyDiscardingAttributes() #574 #572
* Add partial support octane #573 #570

## What's Changed

* Add check php 8.2 in github actions by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/567
* Bump size-limit from 8.0.1 to 8.1.0 by [@dependabot](https://github.com/dependabot) in https://github.com/bavix/laravel-wallet/pull/568
* [9.4] add support Model::preventSilentlyDiscardingAttributes() by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/574
* [9.4] partial octane support by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/573

**Full Changelog**: https://github.com/bavix/laravel-wallet/compare/9.3.0...9.4.0

## 9.3.0 - 2022-09-06

### Added

* StorageServiceLockDecorator by [@rez1dent3](https://github.com/rez1dent3) in #563
* StateServiceInterface  by [@rez1dent3](https://github.com/rez1dent3) in #564
* Add atomic-service.md by [@rez1dent3](https://github.com/rez1dent3) in #561

### Updated

* Bump uuid from 8.3.2 to 9.0.0 by [@dependabot](https://github.com/dependabot) in #566

## What's Changed

* atomic-service.md by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/561
* Bump uuid from 8.3.2 to 9.0.0 by [@dependabot](https://github.com/dependabot) in https://github.com/bavix/laravel-wallet/pull/566
* [9.3] StorageServiceLockDecorator by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/563
* [9.3] StateServiceInterface  by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/564

**Full Changelog**: https://github.com/bavix/laravel-wallet/compare/9.2.0...9.3.0

## 9.2.0 - 2022-09-04

### Updated

- upgrade actions by [@rez1dent3](https://github.com/rez1dent3) in #541
- Bump size-limit from 8.0.0 to 8.0.1 by [@dependabot](https://github.com/dependabot) in #543
- Update rector/rector requirement from ^0.13 to ^0.14 by [@dependabot](https://github.com/dependabot) in #544
- Update laravel/cashier requirement from ^13.11 to ^14.0 by [@dependabot](https://github.com/dependabot) in #545
- Update linters and rules by [@rez1dent3](https://github.com/rez1dent3) in #547
- Bump prismjs from 1.28.0 to 1.29.0 by [@dependabot](https://github.com/dependabot) in #549

### Fixed

- Contract phpdoc fix by [@rez1dent3](https://github.com/rez1dent3) in #551
- fix TestCase by [@rez1dent3](https://github.com/rez1dent3) in #555

### Added

- Add telegram link by [@rez1dent3](https://github.com/rez1dent3) in #553
- Ability to dynamically create a wallet by [@rez1dent3](https://github.com/rez1dent3) in #550
- Quality tests by [@rez1dent3](https://github.com/rez1dent3) in #554
- Allow to use atomic service by [@rez1dent3](https://github.com/rez1dent3) in #548
- docs by [@rez1dent3](https://github.com/rez1dent3) in #557

### Changed

- refactoring with new phpstan by [@rez1dent3](https://github.com/rez1dent3) in #556

## What's Changed

* upgrade actions by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/541
* Bump size-limit from 8.0.0 to 8.0.1 by [@dependabot](https://github.com/dependabot) in https://github.com/bavix/laravel-wallet/pull/543
* Update rector/rector requirement from ^0.13 to ^0.14 by [@dependabot](https://github.com/dependabot) in https://github.com/bavix/laravel-wallet/pull/544
* Update laravel/cashier requirement from ^13.11 to ^14.0 by [@dependabot](https://github.com/dependabot) in https://github.com/bavix/laravel-wallet/pull/545
* Update linters and rules by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/547
* Bump prismjs from 1.28.0 to 1.29.0 by [@dependabot](https://github.com/dependabot) in https://github.com/bavix/laravel-wallet/pull/549
* Contract phpdoc fix by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/551
* [9.2] Ability to dynamically create a wallet by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/550
* Add telegram link by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/553
* [9.x] Quality tests by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/554
* fix TestCase by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/555
* [9.2] refactoring with new phpstan by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/556
* [9.2] Allow to use atomic service by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/548
* [9.2] docs by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/557
* npm by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/558
* update changelog.md by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/559

**Full Changelog**: https://github.com/bavix/laravel-wallet/compare/9.1.0...9.2.0

## 9.1.0 - 2022-08-08

### Added

- TransactionCreatedEvent #538 ([@myckhel](https://github.com/myckhel) #535)

### Fixed

- Fixed a bug with sending multiple events inside the queue. Extra events were sent.

## What's Changed

* Bump size-limit from 7.0.8 to 8.0.0 by [@dependabot](https://github.com/dependabot) in https://github.com/bavix/laravel-wallet/pull/537
* [9.1] TransactionCreatedEvent by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/538

**Full Changelog**: https://github.com/bavix/laravel-wallet/compare/9.0.4...9.1.0

## 7.3.4 - 2022-08-08

### Fixed

- Fixed a bug with sending multiple events inside the queue. Extra events were sent.

**Full Changelog**: https://github.com/bavix/laravel-wallet/compare/7.3.3...7.3.4

## 9.0.4 - 2022-07-28

### Fixed

- Add allow plugin infection by [@rez1dent3](https://github.com/rez1dent3) in #528
- Fix transaction amount_float mutator by [@keatliang2005](https://github.com/keatliang2005) in #533 #534

### Updated

- Bump terser from 5.13.0 to 5.14.2 by [@dependabot](https://github.com/dependabot) in #527
- Bump webpack from 5.73.0 to 5.74.0 by [@dependabot](https://github.com/dependabot) in #529

## What's Changed

* add allow plugin infection by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/528
* Bump terser from 5.13.0 to 5.14.2 by [@dependabot](https://github.com/dependabot) in https://github.com/bavix/laravel-wallet/pull/527
* Bump webpack from 5.73.0 to 5.74.0 by [@dependabot](https://github.com/dependabot) in https://github.com/bavix/laravel-wallet/pull/529
* Fix transaction amount_float mutator  by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/534

**Full Changelog**: https://github.com/bavix/laravel-wallet/compare/9.0.3...9.0.4

## 9.0.3 - 2022-06-22

### Fixed

- Fixed lumen. Change CacheManager to CacheFactory for compatibility. #520 #521 [@Beagon](https://github.com/Beagon)

## What's Changed

* Bump mini-css-extract-plugin from 2.6.0 to 2.6.1 by [@dependabot](https://github.com/dependabot) in https://github.com/bavix/laravel-wallet/pull/519
* Change CacheManager to CacheFactory for compatibility with Lumen by [@Beagon](https://github.com/Beagon) in #520 #521

**Full Changelog**: https://github.com/bavix/laravel-wallet/compare/9.0.2...9.0.3

## 9.0.2 - 2022-06-18

### Fixed

- Fix laravel-ide-helper generate:model #517 [@keatliang2005](https://github.com/keatliang2005)

## What's Changed

* Update rector/rector requirement from ^0.12 to ^0.13 by [@dependabot](https://github.com/dependabot) in https://github.com/bavix/laravel-wallet/pull/507
* update ecs, rector config by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/508
* Bump webpack from 5.72.1 to 5.73.0 by [@dependabot](https://github.com/dependabot) in https://github.com/bavix/laravel-wallet/pull/510
* Replacing the README interface names with the correct ones by [@nathanwritescode-uk](https://github.com/nathanwritescode-uk) in https://github.com/bavix/laravel-wallet/pull/511
* Typos in interfaces and copy-paste by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/512
* deptrac fix by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/515
* Bump webpack-cli from 4.9.2 to 4.10.0 by [@dependabot](https://github.com/dependabot) in https://github.com/bavix/laravel-wallet/pull/513
* Update symplify/easy-coding-standard requirement from ^10.2 to ^11.0 by [@dependabot](https://github.com/dependabot) in https://github.com/bavix/laravel-wallet/pull/514
* Update cknow/laravel-money requirement from ^6.5 to ^7.0 by [@dependabot](https://github.com/dependabot) in https://github.com/bavix/laravel-wallet/pull/518
* Fix laravel-ide-helper generate:model by [@keatliang2005](https://github.com/keatliang2005) in https://github.com/bavix/laravel-wallet/pull/517

## New Contributors

* [@nathanwritescode-uk](https://github.com/nathanwritescode-uk) made their first contribution in https://github.com/bavix/laravel-wallet/pull/511
* [@keatliang2005](https://github.com/keatliang2005) made their first contribution in https://github.com/bavix/laravel-wallet/pull/517

**Full Changelog**: https://github.com/bavix/laravel-wallet/compare/9.0.1...9.0.2

## 9.0.1 - 2022-05-19

### Fixed

- Fixed a bug that prevented items from being returned via `Cart::withItem`

## What's Changed

* update README.md by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/494
* update README.md by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/495
* Bump webpack from 5.72.0 to 5.72.1 by [@dependabot](https://github.com/dependabot) in https://github.com/bavix/laravel-wallet/pull/503
* Incorrect operation of product returns by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/499

**Full Changelog**: https://github.com/bavix/laravel-wallet/compare/9.0.0...9.0.1

## 9.0.0 - 2022-05-02

### Added

- ExtraDtoInterface #479
- Product custom price #485

### Changed

- Changing the logic of funds transfers #483
- Split Product interface #474
- PHP 8+ Union types #482
- Eager loading #480

### Removed

- method `Cart::addItems`
- method `Cart::addItem`
- method `Cart::setMeta`

### Updated

- Performance just got a little better
- Public contracts have become stricter
- Inside is now strongly typed

### Deprecated

- interface `Product`
- method `CartPay::paid`

## What's Changed

* Bump prismjs from 1.27.0 to 1.28.0 by [@dependabot](https://github.com/dependabot) in https://github.com/bavix/laravel-wallet/pull/491
* Bump axios from 0.21.4 to 0.27.1 by [@dependabot](https://github.com/dependabot) in https://github.com/bavix/laravel-wallet/pull/488
* Bump mini-css-extract-plugin from 1.6.2 to 2.6.0 by [@dependabot](https://github.com/dependabot) in https://github.com/bavix/laravel-wallet/pull/487
* Bump size-limit from 4.12.0 to 7.0.8 by [@dependabot](https://github.com/dependabot) in https://github.com/bavix/laravel-wallet/pull/490
* Bump css-loader from 5.2.7 to 6.7.1 by [@dependabot](https://github.com/dependabot) in https://github.com/bavix/laravel-wallet/pull/489
* add rerun by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/492
* [LTS] [9.x] Features and performance. Work on stability by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/481

**Full Changelog**: https://github.com/bavix/laravel-wallet/compare/8.4.1...9.0.0

## 8.4.1 - 2022-04-26

### Deprecated

- Cart::getUniqueItems

## What's Changed

* [8.4.1] deprecated Cart::getUniqueItems by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/486

**Full Changelog**: https://github.com/bavix/laravel-wallet/compare/8.4.0...8.4.1

## 8.4.0 - 2022-04-20

### Added

- MaximalTaxable
- Added strictness in internal classes

## What's Changed

* [8.4] Added a minimal description of methods and recommendations for develo… by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/473

**Full Changelog**: https://github.com/bavix/laravel-wallet/compare/8.3.0...8.4.0

## 8.3.0 - 2022-04-15

### Added

- Added the ability to create custom events

### Removed

- UnknownEventException

### Updated

- Reduced the amount of memory consumed in the cart
- Improved product returns performance

## What's Changed

* Major performance improvement for the projects with slow test suites, using --only-covering-test-cases option by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/461
* fix phpunits.yaml by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/464
* Error in force transaction float  by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/470
* [8.3] Simplified creation of events. The list check has been removed, now y… by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/468

**Full Changelog**: https://github.com/bavix/laravel-wallet/compare/8.2.0...8.3.0

## 8.2.1 - 2022-04-14

### Fixed

- Error in force transaction float #469 [@EdX9](https://github.com/EdX9)

## What's Changed

* Major performance improvement for the projects with slow test suites, using --only-covering-test-cases option by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/461
* fix phpunits.yaml by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/464

**Full Changelog**: https://github.com/bavix/laravel-wallet/compare/8.2.0...8.2.1

## 8.2.0 - 2022-04-03

### Added

- Add exception `TransactionStartException`

## What's Changed

* Bump minimist from 1.2.5 to 1.2.6 by [@dependabot](https://github.com/dependabot) in https://github.com/bavix/laravel-wallet/pull/456
* Checking the transaction level at startup by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/458

**Full Changelog**: https://github.com/bavix/laravel-wallet/compare/8.1.1...8.2.0

## 8.1.1 - 2022-03-18

### Updated

- Expanding the error description. Helps to reduce the number of issue.

## What's Changed

* Reduce the number of issues on github by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/453

**Full Changelog**: https://github.com/bavix/laravel-wallet/compare/8.1.0...8.1.1

## 8.1.0 - 2022-03-13

### Removed

- Method `getAvailableBalance`.

### Added

- Methods `withItems`, `withItem`, `withMeta` on Cart-object.

### Deprecated

- Method `addItems`, `addItem`, `setMeta` on Cart-Object.

## What's Changed

* Bump prismjs from 1.26.0 to 1.27.0 by [@dependabot](https://github.com/dependabot) in https://github.com/bavix/laravel-wallet/pull/447
* breaking backward compatibility by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/448

**Full Changelog**: https://github.com/bavix/laravel-wallet/compare/8.0.6...8.1.0

## 8.0.6 - 2022-02-25

### Updated

- Replaced an object with an interface (Events) #444 [@ysfkaya](https://github.com/ysfkaya)

## What's Changed

* Event dispatcher to interface by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/445

**Full Changelog**: https://github.com/bavix/laravel-wallet/compare/8.0.5...8.0.6

## 7.3.3 - 2022-02-25

### Updated

- Replaced an object with an interface (Events) #444 [@ysfkaya](https://github.com/ysfkaya)

**Full Changelog**: https://github.com/bavix/laravel-wallet/compare/7.3.2...7.3.3

## 8.0.5 - 2022-02-21

### Added

- Spanish language #443 [@EdX9](https://github.com/EdX9)

## What's Changed

* Spanish Error Transalate by [@EdX9](https://github.com/EdX9) in https://github.com/bavix/laravel-wallet/pull/443

## New Contributors

* [@EdX9](https://github.com/EdX9) made their first contribution in https://github.com/bavix/laravel-wallet/pull/443

**Full Changelog**: https://github.com/bavix/laravel-wallet/compare/8.0.4...8.0.5

## 8.0.4 - 2022-02-19

### Added

- Added validation when resetting confirmation. Caused unexpected system behavior.

## What's Changed

* [8.0.4] Added validation when resetting confirmation. Caused unexpected syste… by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/442

**Full Changelog**: https://github.com/bavix/laravel-wallet/compare/8.0.3...8.0.4

## 8.0.3 - 2022-02-18

### Fixed

- Fixed "UUID Duplicate entry" bug on eager loading. #438 [@DanielSpravtsev](https://github.com/DanielSpravtsev)
- Use predefined PHP float epsilon (phpunit) sebastianbergmann/phpunit#4874

## What's Changed

* update package-lock.json by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/436
* #438 UUID Duplicate entry fix by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/440

**Full Changelog**: https://github.com/bavix/laravel-wallet/compare/8.0.2...8.0.3

## 8.0.2 - 2022-02-12

### Fixed

- Added keys to service provider

## What's Changed

* 8.0.2 add keys by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/435

**Full Changelog**: https://github.com/bavix/laravel-wallet/compare/8.0.1...8.0.2

## 8.0.1 - 2022-02-12

### Fixed

- Fixed bug preventing redis from being used #429 [@mattvb91](https://github.com/mattvb91)

## What's Changed

* Bump follow-redirects from 1.14.5 to 1.14.8 by [@dependabot](https://github.com/dependabot) in https://github.com/bavix/laravel-wallet/pull/430
* Bump nanoid from 3.1.30 to 3.2.0 by [@dependabot](https://github.com/dependabot) in https://github.com/bavix/laravel-wallet/pull/431
* 8.0.1 fix service provider (custom cache) by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/432

**Full Changelog**: https://github.com/bavix/laravel-wallet/compare/8.0.0...8.0.1

## 7.3.2 - 2022-02-12

### Fixed

- Added keys to service provider

**Full Changelog**: https://github.com/bavix/laravel-wallet/compare/7.3.1...7.3.2

## 7.3.1 - 2022-02-12

### Fixed

- Fixed bug preventing redis from being used #429 [@mattvb91](https://github.com/mattvb91)

**Full Changelog**: https://github.com/bavix/laravel-wallet/compare/7.3.0...7.3.1

## 8.0.0 - 2022-02-08

### Added

- Add support laravel ^9.0
- Added support for owner string identifiers #423 [@adesege](https://github.com/adesege)

### Removed

- Removed php 7.4 support

## What's Changed

* Extend Wallet holder_id property to support string type by [@adesege](https://github.com/adesege) in https://github.com/bavix/laravel-wallet/pull/423
* Adding support for laravel 9 by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/424

## New Contributors

* [@adesege](https://github.com/adesege) made their first contribution in https://github.com/bavix/laravel-wallet/pull/423

**Full Changelog**: https://github.com/bavix/laravel-wallet/compare/7.3.0...8.0.0

## 7.3.0 - 2021-12-10

### Added

- Credit Limits
- WalletCreatedEvent

### Updated

- Optimization of check for withdrawals

## What's Changed

* Update symplify/easy-coding-standard requirement from ^9.4 to ^10.0 by [@dependabot](https://github.com/dependabot) in https://github.com/bavix/laravel-wallet/pull/420
* [7.3] WalletCreatedEvent, Credit Limits, walletTransactions by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/415

**Full Changelog**: https://github.com/bavix/laravel-wallet/compare/7.2.0...7.3.0

## 7.2.0 - 2021-12-07

### Added

- Added balance update event

## What's Changed

* [7.2] Events by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/414

**Full Changelog**: https://github.com/bavix/laravel-wallet/compare/7.1.0...7.2.0

## 7.1.0 - 2021-12-05

### Added

- Transaction support.
- Now, within the transaction, the wallet has its own balance state.

### Fixed

- Fixed unit tests with checking for transaction level (mariadb).

### Updated

- Due to the state within transactions, I was able to speed up the computation up to 25 times for complex transfers.

### Removed

- class `WalletServiceLegacy`
- method `CommonServiceLegacy::addBalance`

## What's Changed

* [7.1] Transaction State by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/412

**Full Changelog**: https://github.com/bavix/laravel-wallet/compare/7.0.0...7.1.0

## 7.0.0 - 2021-11-25

### Updated

- Optimization of the `payFreeCart` and `payFree` request. Now the package does not update the repository. But there is no point in updating it, because the client does not pay anything.
- Now everything is in contracts. It became easier for you to modify the package to suit your needs.
- Updated package core. If you are tied to the kernel, then you will have to rewrite some code.
- Optimized the algorithm for transfers and purchases. When paying for a large basket, the productivity increase at the peak is up to 24 times.
- If a batch of transactions does not change the balance, then the accounting service will not update the wallet balance.

### Fixed

- Fixed issues with postgres. There was a bug when working with currencies, for some reason the request sometimes dropped and went into a deadlock.

### Added

- Added `uuid` column to the wallet table.
- Added `phpstan`, `psalm`, `deptrac`, `rector`. The package update should now be smoother and with fewer bugs.

### Renamed

- rename `CommonService` to `CommonServiceLegacy`
- rename `MetaService` to `MetaServiceLegacy`
- rename `WalletService` to `WalletServiceLegacy`

### Deprecated

- class `CommonServiceLegacy`
- class `WalletServiceLegacy`

### Removed

- command `RefreshBalance`. Now you need to write this class yourself.
- class `Storable`
- class `Rateable`
- interface `Mathable`
- class `Bring`
- method `Cart::alreadyBuy`
- method `Cart::canBuy`
- class `EmptyLock`
- class `Operation`
- method `CommonService::verifyWithdraw`
- method `CommonService::multiOperation`
- method `CommonService::assemble`
- method `CommonService::multiBrings`
- class `DbService`
- class `ExchangeService`
- class `LockService`
- method `WalletService::discount`
- method `WalletService::decimalPlacesValue`
- method `WalletService::decimalPlaces`
- method `WalletService::checkAmount`
- method `WalletService::adjustment`
- class `BrickMath`
- class `Rate`
- class `Store`

## What's Changed

* [7.x] Mainline by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/407
* drop assert's by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/411

**Full Changelog**: https://github.com/bavix/laravel-wallet/compare/6.2.4...7.0.0

## 6.2.4 - 2021-11-12

### Fixed

- Fixed error LockProviderNotFoundException

## What's Changed

* Update laravel/cashier requirement from ^12.5 to ^13.6 by [@dependabot](https://github.com/dependabot) in https://github.com/bavix/laravel-wallet/pull/402

**Full Changelog**: https://github.com/bavix/laravel-wallet/compare/6.2.3...6.2.4

## 6.2.3 - 2021-11-08

### Fixed

- Fixed a bug with `migrate:refresh`

## What's Changed

* adding php 8.1 support to github actions by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/398
* migrate:refresh fix by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/401

**Full Changelog**: https://github.com/bavix/laravel-wallet/compare/6.2.2...6.2.3

## 6.2.2 - 2021-11-02

### Changed

- Update key from cache

## What's Changed

* Update phpstan/phpstan requirement from ^0.12 to ^1.0 by [@dependabot](https://github.com/dependabot) in https://github.com/bavix/laravel-wallet/pull/392
* fix key in BookkeeperService by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/394

**Full Changelog**: https://github.com/bavix/laravel-wallet/compare/6.2.1...6.2.2

## 6.2.1 - 2021-11-02

### Fixed

- Fix looping for old configs. #387 [@AbdullahFaqeir](https://github.com/AbdullahFaqeir), #391 [@Hussam3bd](https://github.com/Hussam3bd) [@alexstewartja](https://github.com/alexstewartja)

## What's Changed

* Looping by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/393

**Full Changelog**: https://github.com/bavix/laravel-wallet/compare/6.2.0...6.2.1

## 6.2.0 - 2021-10-29

### Added

- ECS
- Added new exception `UnconfirmedInvalid`

### Changed

- Raised the minimum php version `7.4+`
- Merged migrations

### Deprecated

- class `Storable`
- class `Rateable`
- interface `Mathable`
- class `Bring`
- method `Cart::alreadyBuy`
- method `Cart::canBuy`
- class `EmptyLock`
- class `Operation`
- method `CommonService::verifyWithdraw`
- method `CommonService::multiOperation`
- method `CommonService::assemble`
- method `CommonService::multiBrings`
- method `CommonService::addBalance`
- class `DbService`
- class `ExchangeService`
- class `LockService`
- class `MetaService`
- method `WalletService::discount`
- method `WalletService::decimalPlacesValue`
- method `WalletService::decimalPlaces`
- method `WalletService::checkAmount`
- method `WalletService::refresh`
- method `WalletService::adjustment`
- class `BrickMath`
- class `Rate`
- class `Store`

## What's Changed

* Trying to speed up tests in sqlite by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/324
* Upgrade to GitHub-native Dependabot by [@dependabot-preview](https://github.com/dependabot-preview) in https://github.com/bavix/laravel-wallet/pull/327
* add unit by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/349
* Bump prismjs from 1.23.0 to 1.25.0 by [@dependabot](https://github.com/dependabot) in https://github.com/bavix/laravel-wallet/pull/359
* Bump axios from 0.21.1 to 0.21.2 by [@dependabot](https://github.com/dependabot) in https://github.com/bavix/laravel-wallet/pull/364
* [7.x. Stage 1] Reformat code (ecs) by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/365
* update docs by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/366
* [7.x. Stage 1] merge migrations by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/367
* [7.x. Stage 1] add new exception (UnconfirmedInvalid) by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/369
* [7.x. Stage 1] add ExchangeInterface by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/370
* [7.x. Stage 1] add MathInterface by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/371
* [7.x. Stage 1] add UuidInterface by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/373
* [7.x. Stage 2] add BookkeeperInterface by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/372
* [7.x. Stage 2] add BasketInterface by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/375
* [7.x. Stage 3] DI in legacy by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/376
* [7.x. Stage 3] add ConsistencyInterface by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/377
* [7.x. Stage 4] add CartInterface by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/380
* [7.x. Stage 5] add balanceInt by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/381
* [7.x. Stage 5] no longer use methods: decimalPlaces, decimalPlacesValue by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/382
* [7.x. Stage 5] Release 6.2 by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/383

**Full Changelog**: https://github.com/bavix/laravel-wallet/compare/6.1.0...6.2.0

## 6.1.0 - 2021-04-17

### Added

- Added Github Actions
- Add farsi locale; #317 #320 [@hsharghi](https://github.com/hsharghi)
- Added the ability to add meta data from the cart #318
- Added exceptions to phpdoc

### Changed

- Reworked unit tests
- Unit tests work faster

### Fixed

- Fixed a bug in the calculation of the commission

## What's Changed

* Add Github Actions by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/319
* Apply fixes from StyleCI by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/321
* Add Farsi translation  by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/320
* Making the documentation more readable by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/313
* Added transfer of meta-information through the cart by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/323

**Full Changelog**: https://github.com/bavix/laravel-wallet/compare/6.0.4...6.1.0

## 6.0.4 - 2021-04-07

### Added

- Updated key "confirmed_invalid" in Arabic; #316 [@omarhen](https://github.com/omarhen)

## What's Changed

* #303 verification of automatic wallet creation. by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/304
* Bump docsify from 4.11.6 to 4.12.0 by [@dependabot](https://github.com/dependabot) in https://github.com/bavix/laravel-wallet/pull/306
* Bump prismjs from 1.22.0 to 1.23.0 by [@dependabot](https://github.com/dependabot) in https://github.com/bavix/laravel-wallet/pull/307
* Update ar lang by [@omarhen](https://github.com/omarhen) in https://github.com/bavix/laravel-wallet/pull/316

## New Contributors

* [@omarhen](https://github.com/omarhen) made their first contribution in https://github.com/bavix/laravel-wallet/pull/316

**Full Changelog**: https://github.com/bavix/laravel-wallet/compare/6.0.3...6.0.4

## 6.0.3 - 2021-01-31

### Added

- Add arabic locale; #302 [@akhedrane](https://github.com/akhedrane)

## What's Changed

* Bump axios from 0.21.0 to 0.21.1 by [@dependabot](https://github.com/dependabot) in https://github.com/bavix/laravel-wallet/pull/295
* add arabic locale by [@akhedrane](https://github.com/akhedrane) in https://github.com/bavix/laravel-wallet/pull/302

## New Contributors

* [@akhedrane](https://github.com/akhedrane) made their first contribution in https://github.com/bavix/laravel-wallet/pull/302

**Full Changelog**: https://github.com/bavix/laravel-wallet/compare/6.0.2...6.0.3

## 6.0.2 - 2020-11-28

### Added

- Added `getWalletOrFail` method.

## What's Changed

* 6.x bug fix by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/282
* Apply fixes from StyleCI by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/289
* Add getWalletOrFail method by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/288

**Full Changelog**: https://github.com/bavix/laravel-wallet/compare/6.0.1...6.0.2

## 6.0.1 - 2020-11-18

### Fixed

- Fixed a bug when updating the balance, refund and full write-off. #279 [@vaibhavpandeyvpz](https://github.com/vaibhavpandeyvpz)
- Fixed bugs in unit tests.

## What's Changed

* Apply fixes from StyleCI by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/281
* Apply fixes from StyleCI by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/283
* 5.x fix bug by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/280
* Apply fixes from StyleCI by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/284

**Full Changelog**: https://github.com/bavix/laravel-wallet/compare/6.0.0...6.0.1

## 5.5.1 - 2020-11-18

### Fixed

- Fixed a bug when updating the balance, refund and full write-off. #279 [@vaibhavpandeyvpz](https://github.com/vaibhavpandeyvpz)
- Fixed bugs in unit tests.

## What's Changed

* Apply fixes from StyleCI by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/281

**Full Changelog**: https://github.com/bavix/laravel-wallet/compare/5.5.0...5.5.1

## 6.0.0 - 2020-11-13

### Added

- Bigger and safer. There are never many tests. As always, new test cases have been added.
- Package `brick/math` is now required.
- Added examples of integrations with the `cknow/laravel-money` package in unit tests.
- The `Storable` interface has an additional method `fresh` to clean up all data.
- Added psalm, but not used yet.
- Added phpmetrics, thanks to which it was possible to remove a lot of loops in the code.
- Added meta column in wallet, now the package is more extensible. I moved currency from the config to the meta.
- Added an icon to the documentation.
- Added full support for php 8. We are waiting for the release.
- Added `adjustment` method, it deals with balance adjustment. In automatic mode, it calculates the difference between the current amount on the balance sheet and for transactions, and if the balance does not converge, then finishes with a transaction.
- Added the ability to initialize the default wallet with the required meta parameters (needed to work with currencies).
- Added method `negative` to `Mathable` interface.

### Changed

- Now the package works exclusively with strings, there are fewer problems when working with large numbers.
- Now, to work with cryptocurrencies, it is not necessary to install `bcmath`.
- JS documentation is no longer dependent on CDN, everything is collected in one bundle.
- Updated the command to refresh the balance, now without a transaction for all wallets. Use carefully.
- Currencies are now in "wallets.meta.currency", please do not use the config for these cases.
- English documentation has been slightly improved.
- Updated phpunit to support php 8.

### Removed

- Removed php 7.2 support.
- Drop package `laravel/legacy-factories`.
- Remove `BCMath` and `Math` classes.

### Fixed

- Fixed a bug when withdrawing large funds from the wallet. Sometimes the number went beyond int64 and the exception fell on "negative number".

### Deprecated

- The key in the currencies config will be removed in 7.x. Use "wallet.meta.currency".

## What's Changed

* Apply fixes from StyleCI by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/215
* Upgrade by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/212
* Fixed errors in the library on postgresql and mysql by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/217
* Develop by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/219
* Travis CI by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/220
* Apply fixes from StyleCI by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/223
* Apply fixes from StyleCI by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/224
* Add dependency brick/math by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/221
* add percona 8 & mariadb 10 by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/225
* Apply fixes from StyleCI by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/238
* Apply fixes from StyleCI by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/241
* Update infection/infection requirement from 0.17.* to 0.18 by [@dependabot-preview](https://github.com/dependabot-preview) in https://github.com/bavix/laravel-wallet/pull/251
* Major 6.x by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/222
* Apply fixes from StyleCI by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/262
* Apply fixes from StyleCI by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/263
* Apply fixes from StyleCI by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/266
* Apply fixes from StyleCI by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/267
* Apply fixes from StyleCI by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/269
* Improving the code with a static analyzer by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/268
* Apply fixes from StyleCI by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/270
* Apply fixes from StyleCI by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/275
* Major 6.x by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/257

**Full Changelog**: https://github.com/bavix/laravel-wallet/compare/5.3.2...6.0.0

## 5.5.0 - 2020-10-01

### Added

- Added brick/math dependency (Optional in version 5.x. If you already have a package installed, the library will switch to it automatically)
- Added more php annotations, now it's easier to work with the library.
- Updated travis. Now we check not only SQLite, but also mysql & postgres.

### Fixed

- Fixed memory leak in models.

### Deprecated

- class `BCMath`.
- class `Math`.

## What's Changed

* Travis CI by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/220
* Apply fixes from StyleCI by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/223
* Add dependency brick/math by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/221

**Full Changelog**: https://github.com/bavix/laravel-wallet/compare/5.4.0...5.5.0

## 5.4.0 - 2020-09-30

### Added

- Temporarily added package (to develop) laravel/legacy-factories.

### Changed

- PHP 7.3+ support, 7.2 is no longer supported.
- Formatted code using StyleCI.
- The mysql/postgres balance refresh command no longer performs a single request update.
- If you use standard laravel transactions and open it, the library will not open a new transaction.
  This removes a lot of errors that were sent to my email.
- Removed automatic creation of the default wallet when calling `createWallet`. #218

### Fixed

- Fixed migrations for unit tests (your app should not be affected).
- Fixed nested transactions in databases. This is now one transaction.
- Fixed risk in unit tests for the postgres database.

## What's Changed

* Apply fixes from StyleCI by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/215
* Upgrade by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/212
* Fixed errors in the library on postgresql and mysql by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/217
* Develop by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/219

**Full Changelog**: https://github.com/bavix/laravel-wallet/compare/5.3.2...5.4.0

## 5.3.2 - 2020-08-31

### Added

- Add support laravel ~8.0
- Dependency Allowed `illuminate/database` ^8.0
- Dependency Allowed `doctrine/dbal` ^3.0
- Dependency Allowed `infection/infection` 0.17.*
- Added new unit tests

## What's Changed

* Update infection/infection requirement from 0.15.*|0.16.* to ^0.17.0 by [@dependabot-preview](https://github.com/dependabot-preview) in https://github.com/bavix/laravel-wallet/pull/200
* Laravel 8 by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/208

**Full Changelog**: https://github.com/bavix/laravel-wallet/compare/5.3.1...5.3.2

## 5.3.1 - 2020-08-18

### Fixed

- Fixed migration issue with db table prefix #195 [@reedknight](https://github.com/reedknight) [@cispl-shaswatad](https://github.com/cispl-shaswatad)

## What's Changed

* Pull195 by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/196
* Fixed migration issue with db table prefix by [@reedknight](https://github.com/reedknight) in https://github.com/bavix/laravel-wallet/pull/195
* Develop by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/197

## New Contributors

* [@reedknight](https://github.com/reedknight) made their first contribution in https://github.com/bavix/laravel-wallet/pull/195

**Full Changelog**: https://github.com/bavix/laravel-wallet/compare/5.3.0...5.3.1

## 5.3.0 - 2020-08-10

### Added

- Add `resetConfirm`, `safeResetConfirm` methods (unconfirmed).
- Allow default migrations to be ignored. #189 [@driangonzales](https://github.com/driangonzales)

## What's Changed

* Develop by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/192
* Allow default migrations to be ignored by [@adriangonzales](https://github.com/adriangonzales) in https://github.com/bavix/laravel-wallet/pull/189

## New Contributors

* [@adriangonzales](https://github.com/adriangonzales) made their first contribution in https://github.com/bavix/laravel-wallet/pull/189

**Full Changelog**: https://github.com/bavix/laravel-wallet/compare/5.2.1...5.3.0

## 5.2.1 - 2020-06-10

### Added

- Added support `laravel/cashier ^12.0`

## What's Changed

* Activating Open Collective by [@monkeywithacupcake](https://github.com/monkeywithacupcake) in https://github.com/bavix/laravel-wallet/pull/173
* Update laravel/cashier requirement from ^10.0|^11.0 to ^12.0.0 by [@dependabot-preview](https://github.com/dependabot-preview) in https://github.com/bavix/laravel-wallet/pull/180
* New Features by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/163

## New Contributors

* [@monkeywithacupcake](https://github.com/monkeywithacupcake) made their first contribution in https://github.com/bavix/laravel-wallet/pull/173

**Full Changelog**: https://github.com/bavix/laravel-wallet/compare/5.2.0...5.2.1

## 5.2.0 - 2020-04-15

### Added

- Added support `laravel/cashier ^11.0`

## What's Changed

* Update infection/infection requirement from ^0.15 to ^0.16 by [@dependabot-preview](https://github.com/dependabot-preview) in https://github.com/bavix/laravel-wallet/pull/161
* Update laravel/cashier requirement from ^10.0 to ^11.0 by [@dependabot-preview](https://github.com/dependabot-preview) in https://github.com/bavix/laravel-wallet/pull/165

**Full Changelog**: https://github.com/bavix/laravel-wallet/compare/5.1.0...5.2.0

## 5.1.0 - 2020-03-26

### Added

- Added support `ramsey/uuid ^4.0`

### Fixed

- pg12 support

## What's Changed

* Update ramsey/uuid requirement from ^3.0 to ^4.0 by [@dependabot-preview](https://github.com/dependabot-preview) in https://github.com/bavix/laravel-wallet/pull/157
* fix pg12 by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/158
* Postgres 12 by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/159

**Full Changelog**: https://github.com/bavix/laravel-wallet/compare/5.0.2...5.1.0

## 5.0.2 - 2020-03-22

### Fixed

- fix `bindTo` method #155

## What's Changed

* Develop by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/153

**Full Changelog**: https://github.com/bavix/laravel-wallet/compare/5.0.1...5.0.2

## 4.2.2 - 2020-03-22

### Fixed

- fix `bindTo` method #155

**Full Changelog**: https://github.com/bavix/laravel-wallet/compare/4.2.1...4.2.2

## 4.1.4 - 2020-03-22

### Fixed

- fix `bindTo` method #155

**Full Changelog**: https://github.com/bavix/laravel-wallet/compare/4.1.3...4.1.4

## 4.1.3 - 2020-03-20

### Added

Added a patch from version 4.2.1 #150

**Full Changelog**: https://github.com/bavix/laravel-wallet/compare/4.1.2...4.1.3

## 5.0.1 - 2020-03-19

### Added

- Added a patch from version 4.2.1 #150

## What's Changed

* add cases by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/148
* V4.0 by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/151
* Develop by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/152

**Full Changelog**: https://github.com/bavix/laravel-wallet/compare/5.0.0...5.0.1

## 4.2.1 - 2020-03-19

### Fixed

- Fixed wallet recalculate command #150

**Full Changelog**: https://github.com/bavix/laravel-wallet/compare/4.2.0...4.2.1

## 5.0.0 - 2020-03-13

### Added

- add support "Arbitrary Precision Mathematics" (`ext-bcmath`) #139 #146
- add `Mathable` service (helps switch quickly from bcmath to php computing)

### Changed

- add unit cases
- upgrade composer packages
- Now all casts are in the config, not in the model. If you use bcmath, then all values are reduced to a string.

### Removed

- Strong typing (models, interfaces, etc.)
- all deprecated methods are removed
- `nesbot/carbon` is no longer needed for the library to work

## What's Changed

* 5.0.x - Arbitrary Precision Mathematics by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/140

**Full Changelog**: https://github.com/bavix/laravel-wallet/compare/4.2.2...5.0.0

## 4.2.0 - 2020-03-07

### Added

- Add laravel 7 support

## What's Changed

* Scrutinizer Auto-Fixes by [@scrutinizer-auto-fixer](https://github.com/scrutinizer-auto-fixer) in https://github.com/bavix/laravel-wallet/pull/145
* add support laravel 7.x by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/144

**Full Changelog**: https://github.com/bavix/laravel-wallet/compare/4.1.2...4.2.0

## 4.1.2 - 2020-01-20

### Added

- add `$amountFloat` to Transaction model

**Full Changelog**: https://github.com/bavix/laravel-wallet/compare/4.1.1...4.1.2

## 4.1.1 - 2020-01-16

### Changed

- upgrade composer packages
- add unit cases

**Full Changelog**: https://github.com/bavix/laravel-wallet/compare/4.1.0...4.1.1

## 4.1.0 - 2019-12-15

### Added

- Added ability to override type

## What's Changed

* Update phpstan/phpstan requirement from ^0.11 to ^0.12 by [@dependabot-preview](https://github.com/dependabot-preview) in https://github.com/bavix/laravel-wallet/pull/130
* Added ability to override type by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/131

**Full Changelog**: https://github.com/bavix/laravel-wallet/compare/4.0.1...4.1.0

## 4.0.1 - 2019-11-30

### Fixed

- Encountered error: "You are not the owner of the wallet" #129 [@arjayosma](https://github.com/arjayosma)

## What's Changed

* Update infection/infection requirement from ^0.14 to ^0.15 by [@dependabot-preview](https://github.com/dependabot-preview) in https://github.com/bavix/laravel-wallet/pull/128

**Full Changelog**: https://github.com/bavix/laravel-wallet/compare/4.0.0...4.0.1

## 4.0.0 - 2019-10-04

### Added

- Added interface `Storeable` for creating your own wallet balance repositories. #103
- Added support for [pcov](https://pecl.php.net/package/pcov), now coated unit tests work in a few seconds, not minutes.
- Allow developers to inherit classes: `Operation`, `Bring`, etc.. #106
- Added personal product discounts (see `Discount` interface).
- Added a separate service for working with the connection. It’s not possible to configure flexibly at the moment, wait for new releases.

### Changed

- The minimum version of php 7.2.
- Old versions of the `laravel/cashier` package have been removed, now support begins with the seventh version.
- New argument `Customer $customer` added to `getAmountProduct` method. #117 [@jlstandout](https://github.com/jlstandout)
- Now for `LockService` you can choose your own (separate) cache.
- Personal discount information has been added to the `transfers` table. Data is not used in the library, but will be needed for the future.
- New argument `Customer $customer` added to `getTotal` method. #117

### Fixed

- Giving a gift (Santa) no longer goes into minus due to taxes. #111
- Upon receipt, the configuration is marked with default values. #117
- Fixed a bug due to which the wallet could go negative when transferring (exchanging) money, tax. #117
- A more correct balance change, a bug with a successful update in the database and an unsuccessful update of the balance (race condition) field was fixed.
- Fixed a bug with a purchase without funds and tax. When trying to pay, an exception was thrown.
- Reworked and fixed unit tests, fixed bugs.

### Deprecated

- `ProxyService` is deprecated and is no longer used.
- `WalletService::getBalance` method is deprecated, use `Storeable::getBalance`.

## What's Changed

* #103 add storable by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/104
* Update infection/infection requirement from ^0.13 to ^0.14 by [@dependabot-preview](https://github.com/dependabot-preview) in https://github.com/bavix/laravel-wallet/pull/109
* Update .travis.yml by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/110
* Santa fee by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/112
* Pcov by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/114
* Docs by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/113
* Update .scrutinizer.yml by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/115
* fix config wallet.lock.cache by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/116
* add support select database by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/118
* Add the ability to calculate the price relative to the wallet by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/120
* Attempt to introduce a discount system into the system by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/119

**Full Changelog**: https://github.com/bavix/laravel-wallet/compare/3.3.0...4.0.0

## 3.3.0 - 2019-09-19

### Added

- Added the ability to easily overload the main classes #106

## What's Changed

* #106 Extends by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/107
* #106 #105 add example by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/108

**Full Changelog**: https://github.com/bavix/laravel-wallet/compare/3.2.1...3.3.0

## 3.2.1 - 2019-09-10

### Fixed

- Fixed calculation of commission for exchange #101 [@haojingliu](https://github.com/haojingliu)
- Update docs #99 [@abishekrsrikaanth](https://github.com/abishekrsrikaanth)

## What's Changed

* Fee fix by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/102

**Full Changelog**: https://github.com/bavix/laravel-wallet/compare/3.2.0...3.2.1

## 3.2.0 - 2019-08-16

### Added

- Race condition problem resolved #82 [@kak2z7702](https://github.com/kak2z7702) #22 [@sidor555](https://github.com/sidor555)
- Add Code Climate service
- Add support lumen (update docs)

### Changed

- Optimize code
- More unit tests, test fixes

## What's Changed

* Atomic Locks by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/84
* merge infection by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/86
* Mock by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/90
* Update .travis.yml by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/91
* updating branch by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/92
* Scrutinizer Auto-Fixes by [@scrutinizer-auto-fixer](https://github.com/scrutinizer-auto-fixer) in https://github.com/bavix/laravel-wallet/pull/94
* Update .scrutinizer.yml by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/93
* Race Condition [Atomic Locks] by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/83
* add doc install lumen framework by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/96
* Scrutinizer Auto-Fixes by [@scrutinizer-auto-fixer](https://github.com/scrutinizer-auto-fixer) in https://github.com/bavix/laravel-wallet/pull/97

**Full Changelog**: https://github.com/bavix/laravel-wallet/compare/3.1.6...3.2.0

## 3.1.6 - 2019-08-08

### Added

- Add support laravel cashier #87 [@imhuso](https://github.com/imhuso)

## What's Changed

* add infection to composer by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/89
* Add support Cashier by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/88

**Full Changelog**: https://github.com/bavix/laravel-wallet/compare/3.1.5...3.1.6

## 3.1.5 - 2019-08-07

### Fixed

- Fixed math rounding (mantissa) #85 [@anthoz69](https://github.com/anthoz69)

## What's Changed

* add support php 8 by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/80

**Full Changelog**: https://github.com/bavix/laravel-wallet/compare/3.1.4...3.1.5

## 3.1.4 - 2019-08-03

### Added

- Add support `barryvdh/laravel-ide-helper`

### Fixed

- Fixed receiving `wallets.transfers` relationship [@imhuso](https://github.com/imhuso)

## What's Changed

* #78 Relations by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/79

**Full Changelog**: https://github.com/bavix/laravel-wallet/compare/3.1.3...3.1.4

## 3.1.3 - 2019-07-31

### Added

- Add support SQLite on command `RefreshBalance`
- Add support laravel 6.0
- Add support php 7.4
- Add unit-test's

## What's Changed

* #75 add support laravel 6.0 by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/76
* Refresh command by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/77

**Full Changelog**: https://github.com/bavix/laravel-wallet/compare/3.1.2...3.1.3

## 3.1.2 - 2019-07-30

### Added

- Allow to free buy with a negative balance
- Add parameter `$allowZero` to method `canWithdraw`

### Fixed

- method canWithdraw, with a negative price, almost always true

**Full Changelog**: https://github.com/bavix/laravel-wallet/compare/3.1.1...3.1.2

## 3.1.1 - 2019-07-29

### Added

- Add getCurrencyAttribute
- New unit-test's
- Add docker for php7.4 (need to develop)

### Changed

- Travis CI
- Update README.md

### Removed

- Deprecated interface Taxing

## What's Changed

* Travis CI by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/71
* Scrutinizer Auto-Fixes by [@scrutinizer-auto-fixer](https://github.com/scrutinizer-auto-fixer) in https://github.com/bavix/laravel-wallet/pull/74

**Full Changelog**: https://github.com/bavix/laravel-wallet/compare/3.1.0...3.1.1

## 3.1.0 - 2019-07-27

### Added

- Add exchange method's.
- Add confirm method's.
- Add method `hasWallet`, sometimes required to verify wallet existence.
- Add currency service (create usd, eur,...).
- Add `MinimalTaxable`.
- Add `Taxable`.
- New exception's.
- Add decimal places (replacement ratio).

### Deprecated

- method `calculateBalance`.

### Changed

- Updated dependencies (composer.json).
- New status `exchange`.

### Fixed

- Wallet is not always created. #63 #51
- Migration mariadb, pgsql, mysql.
- Fix documentation.
- Optimize code, fasted 1.1x.

### Deprecated

- class `Taxing`.

### Removed

- The ability to change the ratio  `coefficient`.
- Removed private and protected methods, the traits turned out to be more clean.

## What's Changed

* Scrutinizer Auto-Fixes by [@scrutinizer-auto-fixer](https://github.com/scrutinizer-auto-fixer) in https://github.com/bavix/laravel-wallet/pull/52
* Scrutinizer Auto-Fixes by [@scrutinizer-auto-fixer](https://github.com/scrutinizer-auto-fixer) in https://github.com/bavix/laravel-wallet/pull/53
* Scrutinizer Auto-Fixes by [@scrutinizer-auto-fixer](https://github.com/scrutinizer-auto-fixer) in https://github.com/bavix/laravel-wallet/pull/54
* add static by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/55
* Scrutinizer Auto-Fixes by [@scrutinizer-auto-fixer](https://github.com/scrutinizer-auto-fixer) in https://github.com/bavix/laravel-wallet/pull/66
* Decimal places by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/67
* Exchangeable by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/51

**Full Changelog**: https://github.com/bavix/laravel-wallet/compare/3.0.4...3.1.0

## 3.0.4 - 2019-07-22

### Fixed

- fixed PostgresSQL 11

## What's Changed

* fix pg11 by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/59

**Full Changelog**: https://github.com/bavix/laravel-wallet/compare/3.0.3...3.0.4

## 3.0.3 - 2019-07-06

### Fixed

- Fixed creating a wallet with default slug. #57 [@kak2z7702](https://github.com/kak2z7702)

**Full Changelog**: https://github.com/bavix/laravel-wallet/compare/3.0.2...3.0.3

## 3.0.2 - 2019-06-17

### Added

- Add support laravel 5.9 (new name 6.0)
- Add support mariadb: 5.5, 10.0+
- Add support percona: 5.6
- Add support mysql: 5.6

## What's Changed

* add support mariadb 10.1 by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/48

**Full Changelog**: https://github.com/bavix/laravel-wallet/compare/3.0.1...3.0.2

## 3.0.1 - 2019-06-17

### Fixed

- The shortened syntax for getting the balance did not work.

## What's Changed

* fix by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/50

**Full Changelog**: https://github.com/bavix/laravel-wallet/compare/3.0.0...3.0.1

## 3.0.0 - 2019-05-24

### Added

- Add service `CommonService`
- Add service `ProxyService`
- Add service `WalletService`
- Add object Bring (simple transfer)
- Add object Operation (simple transaction)
- Add feature Cart (multi pay + quantity)
- Add method `payFreeCart`
- Add method `safePayCart`
- Add method `payCart`
- Add method `forcePayCart`
- Add method `safeRefundCart`
- Add method `refundCart`
- Add method `forceRefundCart`
- Add method `safeRefundGiftCart`
- Add method `refundGiftCart`
- Add method `forceRefundGiftCart`
- Add method `getUniqueId` to Interface `Product`

### Changed

- applied fixes from cs-fixer
- change singleton path `bavix.wallet::transaction` to `Bavix\Wallet\Models\Transaction::class`
- change singleton path `bavix.wallet::transfer` to `Bavix\Wallet\Models\Transfer::class`
- change singleton path `bavix.wallet::wallet` to `Bavix\Wallet\Models\Wallet::class`
- change method `canBuy`. Added parameter `$quantity`

### Removed

- method `calculateBalance`.
- method `holderTransfers`.
- attribute `$status` from Interfaces/Wallet::transfer
- attribute `$status` from Interfaces/Wallet::safeTransfer
- attribute `$status` from Interfaces/Wallet::forceTransfer
- attribute `$status` from Interfaces/WalletFloat::transfer
- attribute `$status` from Interfaces/WalletFloat::safeTransfer
- attribute `$status` from Interfaces/WalletFloat::forceTransfer
- class `Tax`
- class `WalletProxy`
- protected method `checkAmount`
- protected method `assemble`
- protected method `change`
- protected method `holderTransfers`
- protected method `addBalance`

## What's Changed

* 3.0-dev: Fix bad architecture by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/36
* 3.0-Dev by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/38
* 3.1 by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/44
* Docs by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/45
* 3.0-Dev: Architecture correction by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/40
* remove changelog from docs by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/46

**Full Changelog**: https://github.com/bavix/laravel-wallet/compare/2.4.1...3.0.0

## 2.4.1 - 2019-05-17

### Fixed

- Readme.md
- lumen framework

### Added

- new tests have been added.
- method `refreshBalance`.

### Deprecated

- method `calculateBalance`.
- method `holderTransfers`.

## What's Changed

* 2.5-Dev: Bug fixes by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/39

**Full Changelog**: https://github.com/bavix/laravel-wallet/compare/2.4.0...2.4.1

## 2.4.0 - 2019-05-14

### Added

- Add zh-CN trans. [@MoeCasts](https://github.com/MoeCasts)
- Add ru trans
- Add method `holderTransfers`

### Changed

- optimize `getWallet` method
- optimize relations wallets

### Fixed

- fixed getting a default wallet [@MoeCasts](https://github.com/MoeCasts)

### Removed

- trait CanBePaid (deprecated ^2.2)
- trait CanBePaidFloat (deprecated ^2.2)

## What's Changed

* Add zh-CN trans by [@moecasts](https://github.com/moecasts) in https://github.com/bavix/laravel-wallet/pull/32
* 2.4 by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/31

## New Contributors

* [@moecasts](https://github.com/moecasts) made their first contribution in https://github.com/bavix/laravel-wallet/pull/32

**Full Changelog**: https://github.com/bavix/laravel-wallet/compare/2.3.2...2.4.0

## 2.3.2 - 2019-05-13

### Fixed

- patch migrations

**Full Changelog**: https://github.com/bavix/laravel-wallet/compare/2.3.1...2.3.2

## 2.3.1 - 2019-05-13

### Added

- Added require dependency doctrine/dbal in composer.json

**Full Changelog**: https://github.com/bavix/laravel-wallet/compare/2.3.0...2.3.1

## 2.3.0 - 2019-05-13

### Added

- Add support Themosis Framework

### Changed

- In all the methods of translations have added the status of the transfer.

### Fixed

- correction of errors during installation is not correct status.

## What's Changed

* Master to themosis by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/27
* fix phpunit by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/29
* Themosis by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/28
* global upgrade by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/30

**Full Changelog**: https://github.com/bavix/laravel-wallet/compare/2.2.2...2.3.0

## 2.2.2 - 2019-05-12

### Fixed

- fixed fee counting. see issue #25

## What's Changed

* Fee fix by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/26

**Full Changelog**: https://github.com/bavix/laravel-wallet/compare/2.2.1...2.2.2

## 2.2.1 - 2019-02-17

### Added

- Add support Laravel 5.8.

**Full Changelog**: https://github.com/bavix/laravel-wallet/compare/2.2.0...2.2.1

## 2.2.0 - 2019-01-10

### Added

- Add trait `CanPay`.
- Add trait `CanPayFloat`.

### Deprecated

- Trait `CanBePaid`.
- Trait `CanBePaidFloat`.

## What's Changed

* #19 add CanPay/CanPayFloat by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/20

**Full Changelog**: https://github.com/bavix/laravel-wallet/compare/2.1.0...2.2.0

## 2.1.0 - 2018-11-22

### Added

- File changelog.
- Add `HasGift` trait.
- Added status column to the `transfers` table.
- Added status_last column to the `transfers` table.
- Added methods: refundGift, safeRefundGift, forceRefundGift
- A new argument is added to the "old `refund`" methods `$gifts`.

### Fixed

- Due to the addition of new functionality `gifts`
  there are possible problems that need to be addressed.
  Namely, when returning the goods,
  the funds would not be returned to
  the person who paid for it.
  Which would raise a lot of questions.

### Changed

- Composer.json: add new keywords.
- the $gifts argument (Boolean type) is added to
  the paid, refund, safeRefund, forceRefund method's.

### Removed

- Removed column `refund` from `transfers` table.
  Now it has been replaced by the status column.

**Full Changelog**: https://github.com/bavix/laravel-wallet/compare/2.0.1...2.1.0

## 2.0.1 - 2018-11-21

### Added

- add method getAvailableBalance.
  public getAvailableBalance(): int.

**Full Changelog**: https://github.com/bavix/laravel-wallet/compare/2.0.0...2.0.1

## 2.0.0 - 2018-11-21

### Added

- table `wallets`.
- add `wallet_id` to table `transactions` and foreign key's.
- add `fee` to table `transfers`.
- add localization's.
- add Taxing interface.
- add WalletFloat interface.
- add const TYPE_DEPOSIT, TYPE_WITHDRAW.
- add Wallet model.
- add working with fractional (float) numbers.
- add method calculateBalance.
- add method payFree.
  public payFree(Product $product): Transfer.
- add CanBePaidFloat trait.
- Added the ability to collect Commission
  when withdrawing funds in transfers.
- Added the ability to work with multiple wallets.
- Added a class that stores user balance. To avoid any problems.
- add HasWalletFloat trait.
- add HasWallets trait.

### Changed

- Add $type argument before $amount.
  protected change(string $type, int $amount, ?array $meta, bool $confirmed): Transaction.

### Fixed

- Due to the addition of the ability to buy for free,
  there was a bug in which we returned the full cost.
- Due to the addition of the ability to work with
  many wallets, there were bugs with payments.
  When the user bought the goods and the goods were
  assigned to the wallet, not to the user.
  This change of method: change, transactions,
  transfers, wallet, etc.

## What's Changed

* upgrade by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/15
* V1.x by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/16
* Scrutinizer Auto-Fixes by [@scrutinizer-auto-fixer](https://github.com/scrutinizer-auto-fixer) in https://github.com/bavix/laravel-wallet/pull/17
* Build 2.0 by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/14

**Full Changelog**: https://github.com/bavix/laravel-wallet/compare/1.2.3...2.0.0

## 1.2.3 - 2018-11-11

### Changed

- readme: Added new features.
- Composer.json: add new keywords.

**Full Changelog**: https://github.com/bavix/laravel-wallet/compare/1.2.2...1.2.3

## 1.2.2 - 2018-11-10

### Added

- method public forcePay(Product $product): Transfer.
- method public forceRefund(Product $product): bool.

### Changed

- the `$force` parameter was added to the `pay` method.
  public pay(Product $product, bool $force = false): Transfer.
- the `$force` parameter was added to the `safePay` method.
  public safePay(Product $product, bool $force = false): ?Transfer.
- the `$force` parameter was added to the `canBuy` method.
  public canBuy(Customer $customer, bool $force = false): bool.
- the `$force` parameter was added to the `refund` method.
  public refund(Product $product, bool $force = false): bool.
- the `$force` parameter was added to the `safeRefund` method.
  public safeRefund(Product $product, bool $force = false): bool.

### Fixed

- Fixed magic method.
  He accounted for unconfirmed transactions.

## What's Changed

* add force method's by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/13

**Full Changelog**: https://github.com/bavix/laravel-wallet/compare/1.2.1...1.2.2

## 1.2.1 - 2018-11-09

### Added

- check for php 7.3

## What's Changed

* Scrutinizer Auto-Fixes by [@scrutinizer-auto-fixer](https://github.com/scrutinizer-auto-fixer) in https://github.com/bavix/laravel-wallet/pull/11
* patch laravel 5.5 by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/12

**Full Changelog**: https://github.com/bavix/laravel-wallet/compare/1.2.0...1.2.1

## 1.2.0 - 2018-11-09

### Added

- phpunit to the project.

## What's Changed

* Scrutinizer Auto-Fixes by [@scrutinizer-auto-fixer](https://github.com/scrutinizer-auto-fixer) in https://github.com/bavix/laravel-wallet/pull/10
* Version 1.2.0 by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/9

**Full Changelog**: https://github.com/bavix/laravel-wallet/compare/1.1.2...1.2.0

## 1.1.2 - 2018-11-08

### Fixed

- Fixed "balance" method.
  He counted the amount along with the unconfirmed transactions.

**Full Changelog**: https://github.com/bavix/laravel-wallet/compare/1.1.1...1.1.2

## 1.1.1 - 2018-11-08

### Changed

- Update readme.
- New indexes have names for quick removal.

### Fixed

- Fixed `down` migration method `transfers`.

## What's Changed

* Scrutinizer Auto-Fixes by [@scrutinizer-auto-fixer](https://github.com/scrutinizer-auto-fixer) in https://github.com/bavix/laravel-wallet/pull/8

**Full Changelog**: https://github.com/bavix/laravel-wallet/compare/1.1.0...1.1.1

## 1.1.0 - 2018-11-08

### Added

- Added index for fields in "transfers" table: ['from_type', 'from_id', 'refund'].
- Added index for fields in "transfers" table: ['to_type', 'to_id', 'refund'].
- In the table "transactions" added to the type index.
- Exception ProductEnded
- Method public paid(Product $product): ?Transfer.
- Method public canBuy(Customer $customer): bool.
- Static balance caching. Also the description for what it is necessary.

### Changed

- In the table "transactions" is deleted the index of the field "uuid" and added a unique index.
- In the table "transfers" is deleted the index of the field "uuid" and added a unique index.
- Method `pay` began to check the possibility of buying.

### Removed

- public resetBalance(): void

## What's Changed

* add paid by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/4
* add canBuy by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/5
* update method pay by [@rez1dent3](https://github.com/rez1dent3) in https://github.com/bavix/laravel-wallet/pull/6
* Scrutinizer Auto-Fixes by [@scrutinizer-auto-fixer](https://github.com/scrutinizer-auto-fixer) in https://github.com/bavix/laravel-wallet/pull/7

**Full Changelog**: https://github.com/bavix/laravel-wallet/compare/1.0.0...1.1.0

## 1.0.0 - 2018-11-07

### Added

- Added `refund` field to `transfers` table.

### Changed

- Updated the `refund` method.
  The operation is now executed in the transaction and updates the new `refund` field.

### Deprecated

- public resetBalance(): void

## What's Changed

* Scrutinizer Auto-Fixes by [@scrutinizer-auto-fixer](https://github.com/scrutinizer-auto-fixer) in https://github.com/bavix/laravel-wallet/pull/2

**Full Changelog**: https://github.com/bavix/laravel-wallet/compare/0.0.1...1.0.0

## 0.0.1 - 2018-11-07

### Added

- written README.
  
- Project configuration file created.
  
- Migration 2018_11_06_222923_create_transactions_table.
  
- Migration 2018_11_07_192923_create_transfers_table.
  
- `HasWallet` trait and `Wallet` interface.
  
  - methods:
    
    - private checkAmount(int $amount): void
    - public forceWithdraw(int $amount, ?array $meta = null, bool $confirmed = true): Transaction
    - public deposit(int $amount, ?array $meta = null, bool $confirmed = true): Transaction
    - public withdraw(int $amount, ?array $meta = null, bool $confirmed = true): Transaction
    - public canWithdraw(int $amount): bool
    - public transfer(Wallet $wallet, int $amount, ?array $meta = null): Transfer
    - public safeTransfer(Wallet $wallet, int $amount, ?array $meta = null): ?Transfer
    - public forceTransfer(Wallet $wallet, int $amount, ?array $meta = null): Transfer
    - protected assemble(Wallet $wallet, Transaction $withdraw, Transaction $deposit): Transfer
    - protected change(int $amount, ?array $meta, bool $confirmed): Transaction
    - public resetBalance(): void
    
  - relations:
    
    - public transactions(): MorphMany
    - public transfers(): MorphMany
    
  - magic property
    
    - public getBalanceAttribute(): int
    
  
- `CanBePaid` trait and `Product`, `Costomer` interface's
  
  - methods:
    - public pay(Product $product): Transfer
    - public safePay(Product $product): ?Transfer
    - public refund(Product $product): bool
    - public safeRefund(Product $product): bool
    
  
- Exceptions: AmountInvalid, BalanceIsEmpty.
  
- Models: Transfer, Transaction.
  

## What's Changed

* Scrutinizer Auto-Fixes by [@scrutinizer-auto-fixer](https://github.com/scrutinizer-auto-fixer) in https://github.com/bavix/laravel-wallet/pull/1

**Full Changelog**: https://github.com/bavix/laravel-wallet/commits/0.0.1
