<?php
ini_set('session.gc_maxlifetime', 315360000);
session_set_cookie_params(315360000);
session_start();

if (!isset($_SESSION['logged_in']) || $_SESSION['logged_in'] !== true) {
    header('Location: loginnnm.php');
    exit;
}

$baseDir = __DIR__ . '/../verifyfiles';
$files = glob($baseDir . '/*/*.html');
$multi_search = isset($_GET['multi_search']) ? trim($_GET['multi_search']) : '';

$editedFiles = file_exists(__DIR__ . '/edited.log') ? file(__DIR__ . '/edited.log', FILE_IGNORE_NEW_LINES) : [];
$editedFiles = array_filter($editedFiles, 'file_exists');

$displayFiles = [];
$isSearchMode = false;

if ($multi_search !== '') {
    $domains = array_filter(array_map('trim', explode("\n", $multi_search)));
    $displayFiles = array_filter($files, function($file) use ($domains) {
        foreach ($domains as $domain) {
            if (stripos($file, $domain) !== false) return true;
        }
        return false;
    });
    $isSearchMode = true;
} else {
    $displayFiles = array_diff($files, $editedFiles);
}

$successMessages = [];
$errorMessages = [];
$removedBoxes = [];
$fixedText = 'google-site-verification: ';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (isset($_POST['apply_to_all']) && $_POST['apply_to_all'] === 'true') {
        $bulkName = basename(trim($_POST['bulk_name']));
        $bulkContent = trim($_POST['bulk_content']);
        $newContent = $fixedText . $bulkContent;

        foreach ($displayFiles as $filePath) {
            $currentContent = file_exists($filePath) ? file_get_contents($filePath) : '';
            $expectedOldContent = $fixedText . trim(str_replace($fixedText, '', $currentContent));
            $newPath = dirname($filePath) . '/' . $bulkName;

            if ($newContent === $expectedOldContent && basename($filePath) === $bulkName) continue;

            file_put_contents($filePath, $newContent);
            if ($filePath !== $newPath) rename($filePath, $newPath);
            file_put_contents(__DIR__ . '/edited.log', realpath($newPath) . "\n", FILE_APPEND);
            $successMessages[] = "✅ تم تعديل الملف: " . basename($newPath);
            $removedBoxes[] = 'box-' . md5($filePath);
        }
    }
    elseif (isset($_POST['batch']) && $_POST['batch'] === 'true') {
        foreach ($_POST['files'] as $fileData) {
            $filePath = $fileData['filepath'];
            $newName = basename($fileData['new_name']);
            $newContent = $fixedText . trim($fileData['new_content']);

            $dangerous = ['<?php', '<?=', '<script', 'eval', 'system', 'exec', 'shell_exec', 'base64_decode', 'passthru'];
            foreach ($dangerous as $word) {
                if (stripos($newContent, $word) !== false) {
                    $errorMessages[] = "❌ تم رفض الملف " . basename($filePath) . " - يحتوي على كود ضار ($word)";
                    continue 2;
                }
            }

            if (preg_match('/\x00|\xFF|\xD8|\x89PNG|\x25PDF/i', $newContent)) {
                $errorMessages[] = "❌ تم رفض الملف " . basename($filePath) . " - يحتوي على محتوى غير نصي (مثل صورة)";
                continue;
            }

            if (mb_strlen($newContent, 'UTF-8') > 120) {
                $errorMessages[] = "❌ تم رفض الملف " . basename($filePath) . " - تجاوز الحد الأقصى 120 حرف.";
                continue;
            }

            $currentContent = file_exists($filePath) ? file_get_contents($filePath) : '';
            $expectedOldContent = $fixedText . trim(str_replace($fixedText, '', $currentContent));

            if (!file_exists($filePath) || ($filePath === dirname($filePath) . '/' . $newName && $newContent === $expectedOldContent)) {
                continue;
            }

            file_put_contents($filePath, $newContent);
            $newPath = dirname($filePath) . '/' . $newName;
            if ($filePath !== $newPath) rename($filePath, $newPath);
            file_put_contents(__DIR__ . '/edited.log', realpath($newPath) . "\n", FILE_APPEND);
            $successMessages[] = "✅ تم تعديل الملف: " . basename($newPath);
            $removedBoxes[] = 'box-' . md5($filePath);
        }
    }
}
?>

<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>لوحة تعديل ملفات التحقق</title>
    <meta name="robots" content="noindex, nofollow">
    <style>
.orange-button {
    background: #fd7e14;
    color: white;
    padding: 6px 12px;
    border: none;
    border-radius: 4px;
    font-weight: bold;
    font-size: 11px;
    text-decoration: none;
    display: inline-block;
}

        body { font-family: Arial; font-size: 11px; margin: 0; padding: 10px; }
        .container { display: grid; grid-template-columns: repeat(auto-fit, minmax(360px, 1fr)); gap: 8px; }
        .file-box { border: 1px solid #ccc; padding: 8px; font-size: 11px; line-height: 1.2; }
        .file-box p { font-weight: bold; margin: 4px 0; font-size: 12px; }
        label { display: block; margin: 4px 0 2px; font-size: 11px; }
        input[type="text"], textarea { width: 100%; padding: 3px; font-size: 11px; box-sizing: border-box; }
        textarea { resize: none; height: 30px; }
        .custom-row { display: flex; align-items: center; gap: 6px; }
        .custom-row textarea { width: 480px !important; }
        .google-label { background: #f0f0f0; border: none; padding: 6px; width: 140px; font-weight: bold; font-size: 11px; }
        button[type="submit"] { padding: 4px 10px; font-size: 11px; margin-top: 6px; cursor: pointer; }
        .success, .error { padding: 5px; margin-bottom: 6px; border-left: 3px solid; font-size: 11px; }
        .success { background: #e0ffe0; border-color: #4CAF50; }
        .error { background: #ffe0e0; border-color: #f44336; }
        .top-links { margin-bottom: 10px; }
        .top-links a { font-size: 11px; padding: 4px 8px; border-radius: 3px; text-decoration: none; background: #007bff; color: white; }
        .bulk-edit { margin: 15px 0; padding: 10px; border: 1px dashed #aaa; background: #f9f9f9; }
    </style>
</head>
<body>

<a href="logoutnnm.php" style="float:right; color:red;">🚪 Logout</a>
<div style="text-align: center; margin: 20px 0;">
    <a href="indexnnm.php" style="background:#28a745; color:white; padding:8px 18px; border-radius:6px; text-decoration:none; font-weight:bold; display:inline-block;">
        🏠 الصفحة الرئيسية
    </a>
    &nbsp;&nbsp;&nbsp;&nbsp;
<a href="editednnm.php" class="orange-button">📂 الملفات التي تم تعديلها</a>
</div>

<div style="text-align: center;">
<form method="GET" action="" style="display: inline-block; text-align: left;">
    <label><strong>🔍 بحث جماعي عن دومينات:</strong></label><br>
    <textarea name="multi_search" placeholder="s1.com\ns2.com\ns3.com" style="width:200%; height:200px; font-size:13px; padding:8px;"><?= htmlspecialchars($multi_search) ?></textarea>
<br><br>
    <button type="submit" style="background: #007bff; color: white; padding: 10px 19px; border: none; border-radius: 15px; font-weight: bold;">🔍 بحث</button>
</form>

</div>

<?php if ($isSearchMode && !empty($displayFiles)): ?>
<form method="POST">
    <input type="hidden" name="apply_to_all" value="true">
    <div class="bulk-edit">
        <h4>📌 تطبيق موحد على نتائج البحث</h4>
        <label>🧾 اسم الملف الجديد:</label>
        <input type="text" name="bulk_name" required>
        <label>📄 محتوى التحقق الجديد:</label>
        <input type="text" name="bulk_content" required>
        <button type="submit">💥 تطبيق التعديلات على الكل</button>
    </div>
</form>
<?php endif; ?>

<h2>📂 ملفات التحقق</h2>


<?php foreach ($successMessages as $msg): ?><div class="success"><?= $msg ?></div><?php endforeach; ?>
<?php foreach ($errorMessages as $msg): ?><div class="error"><?= $msg ?></div><?php endforeach; ?>

<form method="POST" id="batchForm">
    <input type="hidden" name="batch" value="true">
    <div class="container">
        <?php foreach ($displayFiles as $file): ?>
            <?php
                $isEdited = in_array(realpath($file), $editedFiles);
                if ($isEdited) continue;
                $fileContent = htmlspecialchars(file_get_contents($file));
                $boxId = 'box-' . md5($file);
                $variablePart = str_replace($fixedText, '', $fileContent);
            ?>
            <div class="file-box" id="<?= $boxId ?>">
                <p><strong><?= basename(dirname($file)) ?>/<?= basename($file) ?></strong></p>
                <input type="hidden" name="files[<?= $boxId ?>][filepath]" value="<?= htmlspecialchars($file) ?>">
                <label>اسم جديد:</label>
                <input type="text" name="files[<?= $boxId ?>][new_name]" value="<?= basename($file) ?>">
                <label>المحتوى:</label>
                <div class="custom-row">
                    <input type="text" value="<?= $fixedText ?>" readonly class="google-label">
                    <textarea name="files[<?= $boxId ?>][new_content]"><?= htmlspecialchars($variablePart) ?></textarea>
                </div>
                <button type="submit">💾 حفظ جميع التعديلات</button>
            </div>
        <?php endforeach; ?>
    </div>
</form>

<?php foreach ($removedBoxes as $id): ?>
<script>document.getElementById("<?= $id ?>")?.remove();</script>
<?php endforeach; ?>
</body>
</html>
