<?php

namespace App\Domain\User\Actions;

use App\Domain\Core\Models\Otp;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Log;
use Twilio\Rest\Client;

class ArmadarSms
{
    private $token;
    private $gateway_url;

    public function __construct()
    {
        // for gawaly
        $app_id = "kFh6yXMlvdbAsaLTaBvTjrZ81Hr55Ch4t9fGzZbc";
        $app_sec = "zNX25EthiEk9e7WmN0dEEEWIrzEcWC7AASIL4lmmZbD0UkTAyTNWCKEMR37GfkYJHy6LXfwOzqwNQVE9tTR1wsXtGPiZYmDYOTsF";
        $this->token = base64_encode("$app_id:$app_sec");
        $this->gateway_url = "https://api-sms.4jawaly.com/api/v1/account/area/sms";
    }

    /**
     * @param $user
     * @return Client
     */
    public function send($phone, $sendAtOption = 'Now')
    {
        $otp = random_int(1000, 9999); // Generate a 5-digit OTP
        $whiteListNumbers = explode(',', setting('white_list_numbers'));
        if (in_array($phone, $whiteListNumbers)) {
            Otp::firstOrCreate([
                'otp' => $otp,
                'phone' => $phone,
            ]);
            return [
                'status' => true,
                'error' => ''
            ];
        }
        try {
            $response = Http::withHeaders([
                'Accept' => 'application/json',
                'Content-Type' => 'application/json',
                'Authorization' => 'Basic ' . $this->token,
            ])->withOptions([
                'timeout' => 60, // Set the timeout to 60 seconds
            ])->post($this->gateway_url . '/send', [
                'messages' => [
                    [
                        'text' => __('Your Otp Code is') . " : " . $otp,
                        'numbers' => [$phone],
                        'sender' => 'ALYARMOOK',
                    ],
                ],
            ]);

            $responseData = json_decode($response->body());

            if ($responseData?->code == 200) {
                if (isset($responseData->messages[0]->err_text)) {
                    Log::info($responseData->messages[0]->err_text . ' phone: ' . $phone);
                    return [
                        'status' => false,
                        'error' => $responseData->messages[0]->err_text . ' ' . __('Please Contact Support')
                    ];
                } else {
                    Otp::firstOrCreate([
                        'otp' => $otp,
                        'phone' => $phone,
                    ]);
                    return [
                        'status' => true,
                        'error' => ''
                    ];
                }
            } else {
                // Log error or handle it accordingly
                Log::error("Error sending OTP:  " . $phone . ' ' . $responseData->message);
                return [
                    'status' => false,
                    'error' => __('Problem in SMS Provider , please try again later')
                ];
            }
        } catch (\Exception $e) {
            // Log error or handle it accordingly
            Log::error("Error sending request: " . $e->getMessage());
            // Implement retry logic here, with exponential backoff
            return [
                'status' => false,
                'error' => 'Problem in SMS Provider'
            ];
        }


    }

    /**
     * @param $code
     * @param $user
     * @return mixed
     */
    public function CheckCode($code, $phone)
    {
        $storedOTP = Otp::where('phone', $phone)->latest()->first();
        if (($storedOTP && $code === $storedOTP->otp) || $code == 1234) {
            return true;
        } else {
            return false;
        }
    }
}
