<?php

namespace App\Domain\User\Models;

use App\Support\Concerns\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Domain\Core\Models\Administration\User;
class FcmToken extends Model
{
    use HasFactory;

    protected $guarded = [];

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public static function reset(User $user, $type)
    {
        self::where([
            'user_id' => $user->id,
            'type' => $type,
        ])->delete();
    }
}
