<?php

namespace App\Http\Controllers\Dashboard\Core;

use App\Domain\Core\Models\Administration\User;
use App\Domain\Core\Models\Transaction;

use Carbon\Carbon;
use Illuminate\Routing\Controller as BaseController;

class HomeController extends BaseController
{
    public function superAdminDashboard()
    {

        $companyCount = 1;
        $jobsCount = 1;
        $jobApplyCount = 1;


        return view('dashboard.home', compact(
            'companyCount',
            'jobsCount',
            'jobApplyCount',
        ));
    }

    private function getEarningsByMonth($year)
    {
        $start = Carbon::createFromDate($year, 1, 1)->startOfYear();
        $end = Carbon::createFromDate($year, 1, 1)->endOfYear();

        return Transaction::whereBetween('created_at', [$start, $end])
            ->where('status', 'success')
            ->selectRaw('MONTH(created_at) AS month, SUM(amount) AS sum')
            ->groupBy('month')
            ->orderBy('month', 'asc')
            ->pluck('sum', 'month')
            ->toArray();
    }

    private function populateEarnings($year, $earningsByMonth, $allMonths)
    {

        return $allMonths->map(function ($month) use ($earningsByMonth) {
            return isset($earningsByMonth[Carbon::createFromFormat('M Y', $month)->month])
                ? $earningsByMonth[Carbon::createFromFormat('M Y', $month)->month]
                : 0;
        });
    }

    private function getMonthsWithEarnings($year)
    {
        return Transaction::where('status', 'success')
            ->whereYear('created_at', $year)
            ->selectRaw('MONTH(created_at) AS month, SUM(amount) AS sum')
            ->groupBy('month')
            ->orderBy('sum', 'desc')
            ->limit(2)
            ->get();
    }

    private function getTotalTransaction($year)
    {
        return Transaction::where('status', 'success')
            ->whereYear('created_at', $year)
            ->sum('amount');
    }

    private function getSelectableYears()
    {
        return collect(range(Carbon::now()->subYears(5)->year, Carbon::now()->addYears(5)->year))->mapWithKeys(function ($year) {
            return [$year => $year];
        });
    }
}
