<?php

namespace App\Http\Controllers\Frontend;

use App\Domain\Core\Models\Article;
use App\Http\Controllers\Controller;
use JeroenG\Explorer\Application\Results;
use JeroenG\Explorer\Domain\Aggregations\TermsAggregation;
use JeroenG\Explorer\Infrastructure\Scout\ElasticEngine;
class AggregateController extends Controller
{
    public function __invoke(Request $request)
    {
        $search = Article::search();

        $search->aggregation('places', new TermsAggregation('place'));

        /** @var Results $results */
        $results = $search->raw();

        return view('articles', [
            'aggregations' => $results->aggregations(),
            'query' => ElasticEngine::debug()->json(),
        ]);
    }
}
