<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
class CheckCountry
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle($request, Closure $next)
    {
        $country = $request->segment(1) ?? 'en';
       

        // List of valid countries
        $validCountries = langs();
        
        if (!in_array($country, $validCountries)) {
            abort(404); // If the country is invalid, return a 404 error
        }

        return $next($request);
    }
}
