<?php

use App\Domain\Core\Enums\CorePermissions;
use HsmFawaz\UI\Support\Sidebar\SidebarGenerator;

return static function (SidebarGenerator $sidebar) {
    $sidebar
        ->addModule(__('User'), 2)
        ->addMenu(
            name: __('Users'),
            icon: 'fas fa-list',
            show_menu: request()->routeIs('dashboard.user.admins.*') ||
            request()->routeIs('dashboard.user.drivers.*') ||
            request()->routeIs('dashboard.core.administration.users.*'),
            permission: CorePermissions::admins()->can('read'),
            links: function ($menu) {
                $menu->addLink(
                    name: __('Admins'),
                    url: route('dashboard.user.admins.index'),
                    icon: 'fas fa-users',
                    permission: CorePermissions::admins()->can('read')
                );
            }
        )
        ->addLink(
            name: __('Roles and Permissions'),
            url: route('dashboard.core.administration.roles.index'),
            icon: 'fas fa-key',
            permission: CorePermissions::roles()->can('read')
        );

};
