<x-ui::layout title="{{ __('Results') }}">
    <div class="card">
        <div class="card-header">
            <h3 class="card-title">Publish Translated Article</h3>
        </div>

        <div class="card-body">
            <form id="publishForm" class="form">
                <div class="mb-10">
                    <label class="form-label required">Post ID</label>
                    <input type="number" id="postId" class="form-control" readonly required value="{{$model->id}}"/>
                </div>

                <div class="mb-10">
                    <button type="submit" id="publishBtn" class="btn btn-primary">
                    <span class="indicator-label">
                        Publish Article
                    </span>
                        <span class="indicator-progress">
                        Publishing... <span class="spinner-border spinner-border-sm align-middle ms-2"></span>
                    </span>
                    </button>
                </div>

                <div class="d-none" id="outputWrapper">
                    <div class="separator my-10"></div>

                    <h4 class="mb-5">Console Output</h4>
                    <div id="output" class="bg-dark px-6 py-4 rounded" style="height: 300px; overflow-y: auto;">
                        <pre class="text-light" style="white-space: pre-wrap;"></pre>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <x-slot:scripts>
        <script type="text/javascript">
            "use strict";

            // Class definition
            var KTArticlePublish = function () {
                // Private variables
                var form;
                var submitButton;
                var outputWrapper;
                var outputContainer;
                var eventSource;

                // Private functions
                var initForm = function() {
                    // Get elements
                    form = document.getElementById('publishForm');
                    submitButton = document.getElementById('publishBtn');
                    outputWrapper = document.getElementById('outputWrapper');
                    outputContainer = outputWrapper.querySelector('pre');

                    // Handle form submission
                    form.addEventListener('submit', function(e) {
                        e.preventDefault();

                        // Show loading indication
                        submitButton.setAttribute('data-kt-indicator', 'on');
                        submitButton.disabled = true;

                        // Show output container
                        outputWrapper.classList.remove('d-none');
                        outputContainer.textContent = '';

                        // Close any existing EventSource
                        if (eventSource) {
                            eventSource.close();
                        }

                        // Get post ID
                        const postId = document.getElementById('postId').value;

                        // Create new EventSource connection
                        eventSource = new EventSource(`/dashboard/blog/publish-to-websites/${postId}`);

                        eventSource.onmessage = function(event) {
                            const data = JSON.parse(event.data);

                            if (data.output) {
                                appendOutput(data.output);
                            }
                            if (data.error) {
                                appendOutput(data.error, 'error');
                            }
                            if (data.finished) {
                                eventSource.close();
                                submitButton.removeAttribute('data-kt-indicator');
                                submitButton.disabled = false;

                                // Show success message
                                toastr.success('Article published successfully!');
                            }
                        };

                        eventSource.onerror = function() {
                            appendOutput('Connection error. Please try again.', 'error');
                            eventSource.close();
                            submitButton.removeAttribute('data-kt-indicator');
                            submitButton.disabled = false;

                            // Show error message
                            toastr.error('Failed to publish article. Please try again.');
                        };
                    });
                }

                var appendOutput = function(text, type = 'normal') {
                    const textNode = document.createTextNode(text + "\n");
                    if (type === 'error') {
                        const span = document.createElement('span');
                        span.style.color = '#f1416c';  // Metronic danger color
                        span.appendChild(textNode);
                        outputContainer.appendChild(span);
                    } else {
                        outputContainer.appendChild(textNode);
                    }
                    outputWrapper.scrollTop = outputWrapper.scrollHeight;
                }

                // Public methods
                return {
                    init: function () {
                        initForm();
                    }
                };
            }();

            // On document ready
            KTUtil.onDOMContentLoaded(function () {
                KTArticlePublish.init();
            });
        </script>
    </x-slot:scripts>
</x-ui::layout>
