<script>
    $(document).ready(function () {
        window.loadAjaxFormData = loadAjaxFormData
        $(".dashboard-form-select-ajax").each(function () {
            loadAjaxFormData($(this))
        });

        function loadAjaxFormData(that) {
            const model = that;
            const modelClass = model.data('model-class');
            const modelDilagId = model.data('model-dialog-id');
            const currentClass = model.data('current-class');
            const columnName = model.data('column-name');
            const whereColumnName = model.data('where-column-name');
            const exclude_id = model.data('exclude-id');
            const whereColumnId = model.data('where-column-id');
            const placeholderAjax = model.data('placeholder-ajax');
            const selectedId = model.data('selected-id');
            const route = model.data('route');
            const selectedRoute = model.data('selected-route');
            console.log(exclude_id);
            model.select2({
                dropdownParent: (modelDilagId) ? $('#' + modelDilagId) : null,
                ajax: {
                    url: route,
                    dataType: 'json',
                    delay: 250,
                    type: 'post',

                    data: function (params) {
                        return {
                            q: params.term, // search term
                            page: params.page,
                            columnName: columnName,
                            exclude_id: exclude_id,
                            whereColumnName: whereColumnName,
                            whereColumnId: whereColumnId,
                        };
                    },
                    processResults: function (data, params) {
                        params.page = params.page || 1;

                        return {
                            results: data.data,
                            pagination: {
                                more: params.page < data.last_page
                            }
                        };
                    },
                    cache: false
                },
                placeholder: placeholderAjax,
                allowClear: true
            });


            if (selectedId) {
                $.ajax({
                    type: 'post',
                    url: selectedRoute,
                }).then(function (data) {
                    // create the option and append to Select2
                    var option = new Option(data.text, data.id, true, true);
                    model.append(option).trigger('change');

                    // manually trigger the `select2:select` event
                    model.trigger({
                        type: 'select2:select',
                        params: {
                            data: data
                        }
                    });

                });
            }


        }
    });
</script>