@extends('layouts.app')
@push('meta')
    <title>{{ "$website_title ™ | 最新の公式サイト【2025】" }}</title>
    <meta name="description" content="{{ "$website_title は、ユーザー中心のインターフェースで暗号通貨取引プラットフォームの中で際立っており、トレーダーが暗号通貨取引を簡単に行えるようにしています" }}" />
@endpush


@section('content')
<section id="hero" class="hero-section">
    <div class="uk-container">
        <div class="hero-inner">

            <div class="hero-meta uk-text-center">
                <h1>{{ $website_title }} </h1>
                <h2><span class="change-by-command">{{ "あなたの主要なデジタル資産と暗号通貨の守りと取引ができます。$website_title" }}</span> </h2>
            </div>

            <div class="uk-grid-small" uk-grid>
                <div class="uk-width-expand@s">
                    <img class="hero-img" src="{{asset('frontend/assets/ja/dist')}}/images/block-chain.jpg" alt="">
                </div>
                <div class="uk-width-1-2@s">
                    @include('frontend.ja.components.form')
                </div>
            </div>

        </div>
    </div>
</section>


<section class="section2">
    <div class="uk-container">
        <div class="uk-grid-large" uk-grid>
            <div class="uk-width-expand@s">

                <div class="uk-padding-small">
                    <h2>{{aiTrans('なに')}} {{ $website_title }} </h2>
                    <p>
                        {{ aiTrans(
                            '[website_title] は、ユーザー中心のインターフェースで暗号通貨取引プラットフォームの中で際立っており、トレーダーが暗号通貨取引を簡単に行えるようにしています。 このプラットフォームはデジタル通貨へのアクセスを提供し、重要なツールとチャートを組み込みます。 これらのリソースは市場トレンドを分析するために不可欠であり、トレーダーが十分な情報に基づいて投資決定を下せるようになります。 その上、 [website_title] は暗号通貨資産のセキュリティを優先し、その安全性を確保するための信頼できるストレージ ソリューションを提供します。',
                            $locale,
                            ['website_title' => $website_title],
                        ) }}
                        </p>
                    <p>
                        {{ aiTrans(
                            'セキュリティは [website_title] サービスの基本的な柱です イベックス。 このプラットフォームは、高度な暗号化、多要素認証、コールド ストレージ方式を組み込んだ堅牢なセキュリティ システムを採用し、ユーザーの資産をさまざまな脅威から保護します。 このレベルのセキュリティにより、トレーダーは自分の投資が安全であるという安心感を得ることができます。 その上、 [website_title] は、資産保管ソリューションを提供することでセキュリティ対策を強化します。 これらは、特に予期せぬ状況におけるデジタル資産の損失に対する追加の保護層として機能します。 高レベルのセキュリティを維持するというこの取り組みはプラットフォームの特徴であり、ユーザーの暗号通貨投資の保護に対するその取り組みを強調しています。',
                            $locale,
                            ['website_title' => $website_title],
                        ) }}
                        </p>
                    <p>
                        {{ aiTrans(
                            '分析面では、 [website_title] は、市場の技術的側面に対処するために設計された幅広いツールを提供します。 ユーザーは、リアルタイムの価格チャート、詳細な履歴データ、移動平均、RSI (相対力指数)、ボリンジャーバンドなどの主要なテクニカル指標を含む多くのリソースにアクセスできます。 この豊富な情報により、トレーダーは十分な情報に基づいた意思決定を行い、市場に参入または市場から撤退する最適な時期を特定することができます。 このプラットフォームは、カスタマイズ可能なダッシュボードとパーソナライズされたアラートを提供することで取引体験を強化し、暗号通貨市場をうまくナビゲートするために重要な情報をユーザーに提供します。',
                            $locale,
                            ['website_title' => $website_title],
                        ) }}
                        </p>

                    <a class="c-button" href="#">

                        <span class="button-text">{{aiTrans("詳細")}}</span>
                        <span class="button-icon">
                            <svg aria-hidden="true" class="e-font-icon-svg e-fas-arrow-right" viewBox="0 0 448 512" xmlns="http://www.w3.org/2000/svg">
                                <path d="M190.5 66.9l22.2-22.2c9.4-9.4 24.6-9.4 33.9 0L441 239c9.4 9.4 9.4 24.6 0 33.9L246.6 467.3c-9.4 9.4-24.6 9.4-33.9 0l-22.2-22.2c-9.5-9.5-9.3-25 .4-34.3L311.4 296H24c-13.3 0-24-10.7-24-24v-32c0-13.3 10.7-24 24-24h287.4L190.9 101.2c-9.8-9.3-10-24.8-.4-34.3z"></path>
                            </svg> </span>
                    </a>
                </div>


            </div>
            <div class="uk-width-1-3@s">
                <img src="{{asset('frontend/assets/ja/dist')}}/images/steps-img-1184x1536.webp" alt="">
            </div>
        </div>

    </div>
</section>


<section class="section3">
    <div class="uk-container">

        <h2>{{aiTrans('取引プラットフォームを選ぶ理由')}} </br> {{ $website_title }} </h2>


        <div class="uk-child-width-1-3@s" uk-grid>

            <div>
                <div class="sec3-box">
                    <svg aria-hidden="true" class="e-font-icon-svg e-far-user-circle" viewBox="0 0 496 512" xmlns="http://www.w3.org/2000/svg">
                        <path d="M248 104c-53 0-96 43-96 96s43 96 96 96 96-43 96-96-43-96-96-96zm0 144c-26.5 0-48-21.5-48-48s21.5-48 48-48 48 21.5 48 48-21.5 48-48 48zm0-240C111 8 0 119 0 256s111 248 248 248 248-111 248-248S385 8 248 8zm0 448c-49.7 0-95.1-18.3-130.1-48.4 14.9-23 40.4-38.6 69.6-39.5 20.8 6.4 40.6 9.6 60.5 9.6s39.7-3.1 60.5-9.6c29.2 1 54.7 16.5 69.6 39.5-35 30.1-80.4 48.4-130.1 48.4zm162.7-84.1c-24.4-31.4-62.1-51.9-105.1-51.9-10.2 0-26 9.6-57.6 9.6-31.5 0-47.4-9.6-57.6-9.6-42.9 0-80.6 20.5-105.1 51.9C61.9 339.2 48 299.2 48 256c0-110.3 89.7-200 200-200s200 89.7 200 200c0 43.2-13.9 83.2-37.3 115.9z"></path>
                    </svg>
                    <h3>{{aiTrans('デモアカウント')}}</h3>
                    <p>{{aiTrans('当社の取引プラットフォームのデモ口座は、ユーザーが仮想資金を使用して安全な環境で取引を練習できるため、財務上のリスクを排除するための重要な機能です。 初心者にとっては、当社のプラットフォームに慣れ、安全にさまざまな取引戦略を試すことができるため、大きなメリットがあります。 経験豊富なトレーダーにとって、当社のデモ口座は、実際の取引に移る前に新しい取引スタイルを試してスキルを磨き、成功の可能性を高めるための優れたツールです。')}}</p>
                </div>
            </div>

            <div>
                <div class="sec3-box">
                    <svg aria-hidden="true" class="e-font-icon-svg e-fas-book-open" viewBox="0 0 576 512" xmlns="http://www.w3.org/2000/svg">
                        <path d="M542.22 32.05c-54.8 3.11-163.72 14.43-230.96 55.59-4.64 2.84-7.27 7.89-7.27 13.17v363.87c0 11.55 12.63 18.85 23.28 13.49 69.18-34.82 169.23-44.32 218.7-46.92 16.89-.89 30.02-14.43 30.02-30.66V62.75c.01-17.71-15.35-31.74-33.77-30.7zM264.73 87.64C197.5 46.48 88.58 35.17 33.78 32.05 15.36 31.01 0 45.04 0 62.75V400.6c0 16.24 13.13 29.78 30.02 30.66 49.49 2.6 149.59 12.11 218.77 46.95 10.62 5.35 23.21-1.94 23.21-13.46V100.63c0-5.29-2.62-10.14-7.27-12.99z"></path>
                    </svg>
                    <h3>{{aiTrans('教育ツール')}}</h3>
                    <p>
                        {{ aiTrans(
                            'En [website_title]  教育ツールは、効果的な取引に不可欠な知識とスキルをユーザーに提供する上で重要な役割を果たします。 これらのツールは、チュートリアルやガイドから、市場力学、分析手法、リスク管理戦略の詳細な説明に至るまで、さまざまな教育コンテンツへのアクセスを提供します。 これらの教材を利用できるようにすることで、トレーダーが十分な情報に基づいた意思決定を行い、自信を高め、金融界での長期的な成果の見通しを高めることができるようになります。',
                            $locale,
                            ['website_title' => $website_title],
                        ) }}
                        </p>
                </div>
            </div>

            <div>
                <div class="sec3-box">
                    <svg aria-hidden="true" class="e-font-icon-svg e-far-newspaper" viewBox="0 0 576 512" xmlns="http://www.w3.org/2000/svg">
                        <path d="M552 64H112c-20.858 0-38.643 13.377-45.248 32H24c-13.255 0-24 10.745-24 24v272c0 30.928 25.072 56 56 56h496c13.255 0 24-10.745 24-24V88c0-13.255-10.745-24-24-24zM48 392V144h16v248c0 4.411-3.589 8-8 8s-8-3.589-8-8zm480 8H111.422c.374-2.614.578-5.283.578-8V112h416v288zM172 280h136c6.627 0 12-5.373 12-12v-96c0-6.627-5.373-12-12-12H172c-6.627 0-12 5.373-12 12v96c0 6.627 5.373 12 12 12zm28-80h80v40h-80v-40zm-40 140v-24c0-6.627 5.373-12 12-12h136c6.627 0 12 5.373 12 12v24c0 6.627-5.373 12-12 12H172c-6.627 0-12-5.373-12-12zm192 0v-24c0-6.627 5.373-12 12-12h104c6.627 0 12 5.373 12 12v24c0 6.627-5.373 12-12 12H364c-6.627 0-12-5.373-12-12zm0-144v-24c0-6.627 5.373-12 12-12h104c6.627 0 12 5.373 12 12v24c0 6.627-5.373 12-12 12H364c-6.627 0-12-5.373-12-12zm0 72v-24c0-6.627 5.373-12 12-12h104c6.627 0 12 5.373 12 12v24c0 6.627-5.373 12-12 12H364c-6.627 0-12-5.373-12-12z"></path>
                    </svg>
                    <h3>{{aiTrans('ニュースと分析')}}</h3>
                    <p>
                        {{ aiTrans(
                            'ニュースと分析的洞察は、 [website_title]、資産価値と市場の方向性に大きな影響を与える可能性のある最新情報をトレーダーに提供します。 最新の経済動向、企業声明、世界的な出来事に関する情報を常に入手することは、トレーダーが十分な情報に基づいて取引の意思決定を行い、戦略を微調整するのに役立ちます。 さらに、専門的な分析と市場解説へのアクセスは、複雑な市場情報を解釈するのに役立ち、市場をナビゲートする際のトレーダーの自信を高めます。',
                            $locale,
                            ['website_title' => $website_title],
                        ) }}
                        </p>
                </div>
            </div>

        </div>

    </div>
</section>



<section class="section2">
    <div class="uk-container">
        <div class="uk-grid-large" uk-grid>
            <div class="uk-width-expand@s">

                <div class="uk-padding-small uk-text-center">

                    <h2>{{aiTrans('オペラコンを楽しむ')}} {{ $website_title }} </h2>
                    <p>{{aiTrans('当社のプラットフォームで取引を開始するプロセスは、次の XNUMX つの簡単なステップから始まります。')}}</p>
                </div>

                <b>{{aiTrans('ステップ 1 – 登録')}}</b>
                <p>
                    {{ aiTrans(
                        '皮切りに [website_title]  シンプルかつ高速です。 ページの上部にアクセスし、登録フォームに記入してください。 名前、メールアドレス、電話番号などの基本情報を入力する必要があります。 登録プロセスは効率的で、通常は数分もかかりません。',
                        $locale,
                        ['website_title' => $website_title],
                    ) }}
                    </p>

                <b>{{aiTrans('ステップ 2: アカウント マネージャーに会う')}}</b>
                <p>{{aiTrans('ご登録後、当社チームが専任のアカウントマネージャーを割り当てます。 彼らはパーソナライズされたガイダンスを提供し、プラットフォームを理解し、質問に答え、取引に関する洞察を提供し、独自の目標とリスク選好に合った戦略を設計するのに役立ちます。')}}</p>

            </div>
            <div class="uk-width-1-2@s">
                <img src="{{asset('frontend/assets/ja/dist')}}/images/no-scam-img2-1.webp" alt="">
                <b>{{aiTrans('ステップ 3: 取引を開始する')}}</b>
                <p>
                    {{ aiTrans(
                        '最後のステップはアカウントに資金を追加することで、取引を開始する準備が整います。 と [website_title] では、市場の動きを監視し、実質的な取引機会を特定し、利益を獲得するのに役立つ多数のツールにアクセスできます。 暗号通貨取引が初めての場合でも、取引パフォーマンスの向上を目指している場合でも、 [website_title] 引体験を向上させるために必要なリソースを提供します。',
                        $locale,
                        ['website_title' => $website_title],
                    ) }}
                    </p>
            </div>
        </div>

        <div class="uk-text-center">
            <a class="c-button" href="#">

                <span class="button-text">{{aiTrans('詳細')}}</span>
                <span class="button-icon">
                    <svg aria-hidden="true" class="e-font-icon-svg e-fas-arrow-right" viewBox="0 0 448 512" xmlns="http://www.w3.org/2000/svg">
                        <path d="M190.5 66.9l22.2-22.2c9.4-9.4 24.6-9.4 33.9 0L441 239c9.4 9.4 9.4 24.6 0 33.9L246.6 467.3c-9.4 9.4-24.6 9.4-33.9 0l-22.2-22.2c-9.5-9.5-9.3-25 .4-34.3L311.4 296H24c-13.3 0-24-10.7-24-24v-32c0-13.3 10.7-24 24-24h287.4L190.9 101.2c-9.8-9.3-10-24.8-.4-34.3z"></path>
                    </svg> </span>
            </a>
        </div>

    </div>
</section>


<section class="section3">
    <div class="uk-container">

        <div class="uk-text-center">
            <h2>{{aiTrans('採用すべき事業戦略')}}</h2>
            <p>{{aiTrans('取引戦略は、トレーダーが株、仮想通貨、商品などのさまざまな金融資産をいつ売買するかを決定するために使用する体系的なアプローチです。 この計画は通常、業務の開始と終了、リスクの管理、財務目標の達成のための正確なガイドライン、基準、戦術で構成されています。')}}</p>
            <p>{{aiTrans('トレーディング戦略は多様で、短期的な利益から長期的な投資まで多岐にわたります。 トレーダーは、市場トレンド、テクニカル分析、ファンダメンタルズ評価、またはトレーダーの好みや資産の性質に応じたその他の側面に基づいて戦略を立てます。')}}</p>
            <p>
                {{ aiTrans(
                    'の専門家 [website_title] 彼らは、さまざまな取引戦略と、それぞれの戦略に伴う関連リスクについて教育するためにここにいます。 各戦略には、リスクと潜在的な報酬の独自のバランスがあります。 これらは私たちがあなたに提示できる取引戦略の一部です:',
                    $locale,
                    ['website_title' => $website_title],
                ) }}
                </p>
        </div>


        <div class="uk-child-width-1-3@s uk-grid-small uk-margin-large-top" uk-grid>

            <div class="uk-grid-item-match">
                <div class="sec5-box">
                    <h3>{{aiTrans('日々の取引')}}</h3>
                    <p>{{aiTrans('デイトレードでは、同じ取引日内に金融商品を売買して、短期的な市場の動きを利用します。 このアプローチには、多くの場合、テクニカル分析と即時の市場データを使用して取引機会を特定する、毎日数回の取引を実行することが含まれます。 通常、デイトレーダーはポジションを一晩保持することに伴うリスクを軽減するために、ポジションを翌日に繰り越しません。')}}</p>
                </div>
            </div>
            <div class="uk-grid-item-match">
                <div class="sec5-box">
                    <h3>{{aiTrans('スイングトレード')}}</h3>
                    <p>{{aiTrans('スイングトレードは、トレーダーが中期的な値動きを利用することを目的として、数日または数週間ポジションを保有し続ける手法です。 このアプローチは、スイングトレーダーが毎日数回の取引しか行わないという点でデイトレードとは対照的です。 彼らは多くの場合、テクニカル分析とファンダメンタル分析を組み合わせて最適なエントリーポイントとエグジットポイントを特定し、短期および中期の金融市場のトレンドを活用しようとしています。 保有期間中に市場動向が変化する可能性があり、価格変動が予想どおりに実現しない場合には損失が発生する可能性があることを覚えておくことが重要です。')}}</p>
                </div>
            </div>
            <div class="uk-grid-item-match">
                <div class="sec5-box">
                    <h3>{{aiTrans('皮むき')}}</h3>
                    <p>{{aiTrans('スキャルピング戦略は、数秒または数分で実行される高頻度の取引を伴う、急速で小さな価格変化から利益を得るために適用されます。 この方法では、多くの場合、一時的な市場機会を捉えるためにテクニカル分析とインジケーターが必要になります。 取引回数が多いため、スキャルピングには正確な実行、迅速な意思決定、および低い取引手数料が必要です。 この戦略を選択することは危険であり、トレーダーは迅速に行動し、広範な意思決定にほとんど時間を費やす必要がありません。')}}</p>
                </div>
            </div>
            <div class="uk-width-1-1">
                <div class="sec5-box">
                    <h3>{{aiTrans('HODLトレーディング')}}</h3>
                    <p>{{aiTrans('「HODL」戦略は、「holding」の有名なスペルミスにちなんで名付けられ、仮想通貨を長期にわたって購入および保持することで構成されています。 ホドラーは短期的な市場変動を無視し、代わりに長期的な上昇の可能性に焦点を当てることがよくあります。 この方法は、暗号資産の将来価値を強く信じており、頻繁に取引したり、市場のタイミングを測ることに興味がない人に最適です。 これは長期的なビジョンと忍耐が必要な戦略です。')}}</p>
                </div>
            </div>

        </div>

    </div>
</section>


<section class="section2">
    <div class="uk-container uk-container-xsmall">


        <h2 class="uk-text-center">
            {{ aiTrans(
                'よくある質問 [website_title] ',
                $locale,
                ['website_title' => $website_title],
            ) }}
            </h2>

        <ul uk-accordion="collapsible: false: ; active: false">

            <li>
                <a class="uk-accordion-title" href><svg class="e-font-icon-svg e-fas-caret-right" viewBox="0 0 192 512" xmlns="http://www.w3.org/2000/svg">
                        <path d="M0 384.662V127.338c0-17.818 21.543-26.741 34.142-14.142l128.662 128.662c7.81 7.81 7.81 20.474 0 28.284L34.142 398.804C21.543 411.404 0 402.48 0 384.662z"></path>
                    </svg>
                    {{ aiTrans(
                        'プラットフォーム [website_title] 登録料はかかりますか?',
                        $locale,
                        ['website_title' => $website_title],
                    ) }}
                    </a>
                <div class="uk-accordion-content">
                    <p>{{aiTrans('プラットフォームの使用には費用はかかりません。無料です。 そして一番いいところは？ 当社は入金に手数料を課しません。 このプロセスには数分しかかかりません。 取引を開始する準備ができたら、アカウントに資金を入金する必要があることに注意してください。')}}</p>
                </div>
            </li>
            <li>
                <a class="uk-accordion-title" href><svg class="e-font-icon-svg e-fas-caret-right" viewBox="0 0 192 512" xmlns="http://www.w3.org/2000/svg">
                        <path d="M0 384.662V127.338c0-17.818 21.543-26.741 34.142-14.142l128.662 128.662c7.81 7.81 7.81 20.474 0 28.284L34.142 398.804C21.543 411.404 0 402.48 0 384.662z"></path>
                    </svg>
                    {{ aiTrans(
                        'Es [website_title] ウナ・エスタファ？',
                        $locale,
                        ['website_title' => $website_title],
                    ) }}
                    </a>
                <div class="uk-accordion-content">
                    <p>
                        {{ aiTrans(
                            '[website_title] は、適用される規制の枠組み内で運営される合法的な暗号通貨取引プラットフォームです。 当社は最先端のテクノロジーを使用してお客様の資金とデータを保護するため、お客様のセキュリティを最優先に考えています。 安全で信頼できる取引体験を提供する当社を信頼してください。',
                            $locale,
                            ['website_title' => $website_title],
                        ) }}
                        </p>
                </div>
            </li>
            <li>
                <a class="uk-accordion-title" href><svg class="e-font-icon-svg e-fas-caret-right" viewBox="0 0 192 512" xmlns="http://www.w3.org/2000/svg">
                        <path d="M0 384.662V127.338c0-17.818 21.543-26.741 34.142-14.142l128.662 128.662c7.81 7.81 7.81 20.474 0 28.284L34.142 398.804C21.543 411.404 0 402.48 0 384.662z"></path>
                    </svg>{{aiTrans('資金を引き出すにはどうすればよいですか?')}}</a>
                <div class="uk-accordion-content">
                    <p>
                        {{ aiTrans(
                            '賞金の出金は簡単です。ご希望の支払いオプションへの送金を開始すると、わずか数時間でアカウントに入金が表示されます。 [website_title] 銀行口座、クレジット カード、または PayPal への直接引き出しが可能で、プロセスが簡単かつ便利になります。',
                            $locale,
                            ['website_title' => $website_title],
                        ) }}
                        </p>
                </div>
            </li>
            <li>
                <a class="uk-accordion-title" href><svg class="e-font-icon-svg e-fas-caret-right" viewBox="0 0 192 512" xmlns="http://www.w3.org/2000/svg">
                        <path d="M0 384.662V127.338c0-17.818 21.543-26.741 34.142-14.142l128.662 128.662c7.81 7.81 7.81 20.474 0 28.284L34.142 398.804C21.543 411.404 0 402.48 0 384.662z"></path>
                    </svg>
                    {{ aiTrans(
                        'どのような暗号通貨をサポートしていますか? [website_title] ',
                        $locale,
                        ['website_title' => $website_title],
                    ) }}
                    </a>
                <div class="uk-accordion-content">
                    <p>
                        {{ aiTrans(
                            '[website_title] は、ビッ は、ビットコイン、イーサリアム、ドージコイン、ライトコインなどを含むいくつかの主要な暗号通貨の取引オプションを提供します。 他の投資と同様、これらのデジタル資産に投資する前にリサーチを行うことが重要です。',
                            $locale,
                            ['website_title' => $website_title],
                        ) }}
                        </p>
                </div>
            </li>


        </ul>

        <div class="uk-text-center">
            <a class="c-button" href="#">

                <span class="button-text">{{aiTrans('詳細')}}</span>
                <span class="button-icon">
                    <svg aria-hidden="true" class="e-font-icon-svg e-fas-arrow-right" viewBox="0 0 448 512" xmlns="http://www.w3.org/2000/svg">
                        <path d="M190.5 66.9l22.2-22.2c9.4-9.4 24.6-9.4 33.9 0L441 239c9.4 9.4 9.4 24.6 0 33.9L246.6 467.3c-9.4 9.4-24.6 9.4-33.9 0l-22.2-22.2c-9.5-9.5-9.3-25 .4-34.3L311.4 296H24c-13.3 0-24-10.7-24-24v-32c0-13.3 10.7-24 24-24h287.4L190.9 101.2c-9.8-9.3-10-24.8-.4-34.3z"></path>
                    </svg> </span>
            </a>
        </div>


    </div>
</section>

@endsection
