@extends('layouts.app')
@push('meta')
    <title>{{ "$website_title | 当サイト利用のルールと規定" }}</title>
    <meta name="description" content="{{ "$website_title の利用規約をご理解いただくためのご案内。当ウェブサイトの規約は、全てのユーザーの権利と義務、そしてサービスを確実に保護しながら利用するための具体例を提供しています。" }}" />
@endpush
@section('content')
<div class="banner uk-text-center">
    <h1>利用規約</h1>
</div>

<section class="section2">
    <div class="uk-container">
        <div>
            <p class="gt-block">{{aiTrans('1．一般')}}<br>1.1. {{ $website_title }} {{aiTrans('(以下「ウェブサイト」) へようこそ')}}。</p>
            <p>{{aiTrans('1.2. 本ウェブサイトには、ビットコインを取引するためのサードパーティ プラットフォーム（以下「サードパーティ プラットフォーム」）（以下「サービス」）に関する情報が含まれています。')}}</p>
            <p>{{aiTrans('1.3。 これらの利用規約（「規約」）は、あなた（「あなた」、「あなたの」または「ユーザー」）がウェブサイトまたはサービスを使用することを規定します。 本サービスを使用する前に、これらの規約全体を注意深くお読みください。 これらの条件は、お客様と当社の間の法的拘束力のある契約を構成し、これらの条件のいずれかの条項に同意しない場合は、直ちにWebサイトの使用を停止する必要があることに注意してください。 ウェブサイトを使用することにより、定期的に変更される条件に同意したことになります。')}}</p>
            <p>{{aiTrans('これらの規約には当社のプライバシーポリシーが組み込まれており、これらの規約に同意することにより、当社のプライバシーポリシーにも同意し、同意したことになります（ここをクリックしてプライバシーポリシーを確認できます）。')}}</p>
            <p class="gt-block">2.{{aiTrans('適格性')}}<br>{{aiTrans('2.1。 以下のすべてに準拠する場合にのみ、Webサイトを使用する権利があります。')}}</p>
            <p>{{aiTrans('2.1.1。 あなたは18歳以上です。')}}</p>
            <p>{{aiTrans('2.1.2。 2.1.2。 あなたには、これらの条件に同意し、これらのすべての条件を遵守する権利、権限、および能力があります。')}}</p>
            <p>{{aiTrans('2.1.3。 お客様は、本ウェブサイトの使用中に居住国または居住国の法律に従って、本ウェブサイトおよび/または本サービスを使用することを禁じられていません。')}}</p>
            <p>{{aiTrans('2.2。 当社は、明示または黙示を問わず、ウェブサイトおよび/またはサービスの合法性および/またはウェブサイトおよび/またはサービスの個人による使用に関して、表明または保証を行わず、ウェブサイトの違法な使用について責任を負いません。および/またはユーザーによるサービス。')}}</p>
            <p class="gt-block">3.{{aiTrans('制限された領域')}}<br>{{aiTrans('3.1. 上記の一般性にかかわらず、当社は独自の裁量により、ウェブサイトおよび/またはサービス (ま​​たはその一部) の利用を (i) あらゆる地域 (「制限地域」) のユーザーに制限することができます。 ii) 当社の AML (マネーロンダリング防止) および/または KYC (顧客確認) ポリシーおよび慣行を遵守しないユーザー、または (iii) お客様を法的、規制的、評判的または経済的リスクにさらす可能性があると当社が合理的に判断したユーザーリスク。')}}</p>
            <p>{{aiTrans('3.2。 [usa\'kanada\' ]の地域は、これらの規約から明確に除外されており、制限された地域を構成します。')}}</p>
            <p>{{aiTrans('3.3。 関連する地域の法的または規制環境（および/またはその中の実際のまたは提案された変更）が、当社が提供を継続する場合、またはウェブサイトおよび/またはサービス（またはその一部）を当該地域のユーザーが利用できるようにする場合、当社は当該地域を制限地域として指定する決定を通知する場合があり、かかる通知後、直ちにウェブサイトの使用を停止し、 /またはサービス。')}}</p>
            <p>{{aiTrans('3.4。 当社は、独自の裁量により、特定の国に居住する、または特定の国から居住するユーザーを受け入れる前に、追加の要件または条件を課す場合があります。 さらに、ユーザーが制限区域に旅行した場合、ウェブサイトおよび/または当社のサービスが利用できない、および/またはそれらからブロックされる可能性があることが認識されています。')}}</p>
            <p class="gt-block">4 {{aiTrans('禁止されている活動')}}<br>{{aiTrans('4.1。 あなたは、ウェブサイトとサービスを敬意を持って使用することに同意し、以下に同意しないものとします。')}}</p>
            <p>{{aiTrans('4.1.1。 （a）知的財産権、プライバシー権の保護などの権利を侵害する方法で情報またはその他の資料をアップロード、ダウンロード、配布、公開、または送信するために、Webサイトにリンクする、および/またはWebサイトを使用する右; （b）脅迫、危害、侮辱、誹謗中傷、名誉毀損、人種差別または不適切なコンテンツを構成するものとして公開または使用が禁止されている情報またはその他の資料。 （c）当社または第三者のコンピューターシステムに損害を与える可能性のある、または他者によるWebサイトの使用を制限または阻止する可能性のあるウイルスまたはその他のソフトウェアを含む、情報またはその他の資料。 （d）法律に違反する情報またはその他の資料。 または（e）当社の事前の書面による許可なしに、あらゆる種類の広告を含む情報またはその他の資料。')}}</p>
            <p>{{aiTrans('4.1.2。 ウェブサイト上の帰属、法的通知、その他の指定またはプロパティラベルを削除または変更します。')}}</p>
            <p>{{aiTrans('4.1.3。 ウェブサイト以外のインターフェースを使用してサービスを使用します。')}}</p>
            <p>{{aiTrans('4.1.4。 他のユーザーによるウェブサイトおよび/またはサービスの使用を妨害する。')}}</p>
            <p>{{aiTrans('4.1.5。 ボットまたはその他の自動化された方法を使用して、Webサイトおよび/またはサービスにアクセスまたは使用します。')}}</p>
            <p>{{aiTrans('4.1.6。 当社の明示的な許可なしに、Webバグ、Cookie、またはその他の同様のものを含むがこれらに限定されない、情報の収集または送信のための受動的または能動的なメカニズムとして機能する資料をアップロードまたは送信する（またはアップロードまたは送信を試みる）スパイウェアデバイス。')}}</p>
            <p>{{aiTrans('4.1.7. サービスの外観や機能のフレーミング、ミラーリング、またはその他の形式のシミュレーションに従事します。')}}</p>
            <p>{{aiTrans('4.1.8。 適用される法律または規制に違反し、著作権侵害、商標違反、名誉毀損、プライバシーの侵害、個人情報の盗難、著作権侵害、偽造ソフトウェアのクラッキングまたは配布を含むがこれらに限定されない違法行為を奨励または促進します。')}}</p>
            <p>{{aiTrans('4.1.9。 ウェブサイトのソースコードに変更を加えたり、何らかの方法で干渉したり、会社、ウェブサイト、またはその他の第三者に損害を与えたり損害を与えたりする可能性のあるソフトウェアやアプリケーションをロードします。')}}</p>
            <p>{{aiTrans('4.1.10。 ウェブサイトに含まれている、またはサービスの提供に使用されているソフトウェアまたはその他のテクノロジーを逆アセンブル、逆コンパイル、またはリバースエンジニアリングします。')}}</p>
            <p>{{aiTrans('4.2。 お客様は、当社の他の権利を害することなく、お客様によるWebサイトの使用が本規約または適用法の規定に準拠していないことを当社が懸念する場合、当社がお客様の使用を追跡する場合があることを認めます。ウェブサイトまたはサービス、ウェブサイトへのアクセスの防止、ウェブサイトでの行動パターンの第三者への転送、および当社がお客様の財産および/または権利および/または第三者の権利を保護するために適切とみなすその他の行動。')}}</p>
            <p class="gt-block">5 {{aiTrans('知的財産権')}}<br>{{aiTrans('5.1。 ビデオ素材、テキスト、写真、ロゴ、デザイン、音楽、音声、図、ブランド、およびWebサイトに含まれるその他のコンテンツを含む、Webサイトとそのコンテンツは、当社または第三者の知的財産権によって保護されています。')}}</p>
            <p>{{aiTrans('5.2。 当社とユーザーの間で、当社はウェブサイトおよびサービスに関するすべての権利、権原、および利益を保持します。 ウェブサイトおよび/またはサービスの使用は、以下の条件に従ってウェブサイトおよび/またはサービスを使用する権利を除き、ウェブサイトおよび/またはサービスに組み込まれた知的財産権をユーザーに付与するものではありません。これらの条件。')}}</p>
            <p>{{aiTrans('5.3。 ユーザーは、個人的および非営利目的でのみウェブサイトおよび/またはサービスを使用することができます。')}}</p>
            <p>{{aiTrans('5.4。 ユーザーは、他の当事者が変更、逆コンパイル、逆アセンブル、リバースエンジニアリング、コピー、転送、派生物の作成、レンタル、サブライセンス、配布、フレーム化の複製、再発行、スクレイプ、ダウンロード、表示、送信、投稿、を許可することはできません。いかなる形式または手段によっても、全体的または部分的に、本規約に従ってウェブサイトまたはサービスを使用する以外の目的で使用する、または明示的かつ事前にウェブサイトのコンテンツを悪用する以外の目的でリースまたは販売する当社の書面による許可。')}}</p>
            <p class="gt-block">6.{{aiTrans('責任の制限')}}<br>{{aiTrans('6.1。 ウェブサイトおよび/またはサービスの使用は、ご自身の責任と費用で行ってください。 法律で許可されている範囲で、当社は、商品性、所有権、特定目的への適合性、または非侵害、有用性の黙示の保証を含む、ウェブサイトおよびサービスとその使用に関連する、明示または黙示のすべての保証を否認します。 、権限、正確性、完全性、適時性。 したがって、ウェブサイト上で利用可能またはウェブサイトを通じてアクセスされるすべてのコンテンツおよび機能を含むサービスは、「現状有姿」、「利用可能」、および「すべての欠陥あり」で提供されます。')}}</p>
            <p>{{aiTrans('6.2。 上記の一般性にかかわらず、当社は（a）ウェブサイトに含まれるコンテンツの誤り、誤り、または不正確さについて責任を負いません。 （b）ウェブサイトへの、またはウェブサイトからの、またはサービスを介した送信の中断または停止。 （c）第三者によってウェブサイトまたはサービスに、またはそれらを介して送信される可能性のあるエラー、ウイルス、トロイの木馬など。')}}</p>
            <p>{{aiTrans('6.3。 お客様は、ウェブサイトおよび/またはサービスに関して、お客様および/またはその他の第三者に直接的または間接的に生じた損失から会社を無害にすることに同意し、お客様が以下に基づいて行う決定に対して単独で責任を負います。ウェブサイトおよび/またはサービスのコンテンツ。')}}</p>
            <p>{{aiTrans('6.4。 いかなる場合も、当社は、お客様または第三者に対して、お客様によるWebサイトの使用および/または使用に起因する利益の損失またはデータの損失を含む、特別、直接的、間接的、偶発的、特別、懲罰的または結果的な損害について責任を負わないものとします。保証、契約、不法行為、またはその他の法理論に基づくかどうか、および当社がこれらの損害の可能性について警告されているかどうかにかかわらず、ウェブサイト上またはウェブサイトを通じて、またはサービスの一部としてアクセスまたはダウンロードされたサービスまたはその他の資料また、司法当局が当社に責任があると判断した場合、その責任は1.000米ドルを超えないものとします。 上記の責任の制限は、該当する法域の法律で許可される最大限の範囲で適用されます。')}}</p>
            <p>{{aiTrans('6.5。 お客様は、当社がユーザーコンテンツまたは第三者の名誉毀損、攻撃的または違法な行為に対して責任を負わないこと、および上記による損害または危害のリスクは完全にお客様にあることを明確に認めます。')}}</p>
            <p>{{aiTrans('6.6。 当社は、電話またはネットワーク回線、オンラインコンピュータシステム、サーバーまたはプロバイダー、ハードウェア、ソフトウェア、技術的問題または混雑による障害の問題または技術的誤動作について責任を負いません。インターネットトラフィック（またはインターネットへのアクセス不能）、またはWebサイトまたはサービスとお客様のブラウザーおよび/またはその他の機器との間の非互換性。 上記の一般性にかかわらず、当社はお客様によるインターネットの使用について一切の責任またはリスクを負わないものとします。')}}</p>
            <p class="gt-block">7.{{aiTrans('サードパーティのコンテンツまたはサービス')}}<br>{{aiTrans('7.1。 サービスの使用中、サードパーティプラットフォームでの広告やレビューなど、サードパーティが提供するコンテンツまたはサービスを表示できます。')}}</p>
            <p>{{aiTrans('7.2。 当社は、そのようなコンテンツまたはサービスを管理、承認、または採用することはなく、それらが常に正確または最新であるとは限りません。')}}</p>
            <p>{{aiTrans('7.3。 したがって、すべての情報を信頼する前に独自に確認することをお勧めします。そのような情報に基づいて行われる決定またはアクションは、お客様の単独の責任です。')}}</p>
            <p class="gt-block">8.{{aiTrans('リンク')}}<br>{{aiTrans('8.1。 ウェブサイトには、第三者によって管理または提供されている他のウェブサイトまたはソフトウェアからのリンク、コンテンツ、広告、プロモーション、ロゴ、およびその他の資料が含まれている場合があります（「リンク」）。 これらのウェブサイトまたはソフトウェアを通じて、またはそのような資料に基づいて何かを取得、使用、依存、または購入する前に、そのようなウェブサイト、ソフトウェア、または資料の使用に伴うリスクを確実に理解することをお勧めします。 このようなリンクはお客様の便宜のためにのみ提供されており、他のWebサイトまたはソフトウェアで利用可能なコンテンツ、商品、またはサービスの使用または依存によって生じた損失または損害について、いかなる状況においても当社が責任を負わないことに同意するものとします。')}}</p>
            <p>{{aiTrans('8.2。 ウェブサイトにリンクを含めることは、当社とこれらのウェブサイト、ソフトウェア、またはそれらの運営者との間の承認、承認、後援、提携、またはその他の関係を構成するものではありません。')}}</p>
            <p>{{aiTrans('8.3。 これらのリンクの一部またはすべてを確認しておらず、参照されているWebサイトまたはソフトウェアのコンテンツについて責任を負いません。 これらのウェブサイトまたはソフトウェアを通じて何かを回復、使用、信頼、または購入する前に、そのようなウェブサイトまたはソフトウェアの使用に伴うリスクを確実に理解することをお勧めします。 いかなる状況においても、他のウェブサイトまたはソフトウェアで利用可能なコンテンツ、商品、またはサービスの使用または依存によって生じた損失または損害について、当社は責任を負いません。')}}</p>
            <p class="gt-block">9.{{aiTrans('各種')}}<br>{{aiTrans('9.1。 当社は、独自の裁量により、本サービスのいずれかを随時修正、変更、または中止する場合があり、および/または新しいサービスを導入する場合があります。 当社は、かかる変更の結果としてお客様が被ったいかなる損失についても責任を負わず、お客様はこの点に関して当社に対して請求を行うことはありません。')}}</p>
            <p>{{aiTrans('9.2。 当社は、これらの規約を随時変更する場合があります。 その際、最新バージョンを投稿し、このページの上部にある日付を確認して通知します。変更は、投稿後すぐに有効になります。 変更が有効になった後も引き続きウェブサイトを使用する場合は、改訂された規約に同意したものとみなされます。')}}</p>
            <p>{{aiTrans('9.3。 ユーザーは、ウェブサイトへの、またはウェブサイトからの情報の送信が、これらの条件で指定されたものから逸脱する関係をユーザーと会社の間に作成しないことに同意します。')}}</p>
            <p>{{aiTrans('9.4。 これらの条件とプライバシーポリシーは、その変更を加えて、会社とユーザーの間の唯一の有効な合意を構成し、ポリシーのプライバシーポリシーの条件に含まれていない、書面または口頭を問わず、宣言、約束、同意、またはコミットメントはありません。当事者を拘束します。')}}</p>
            <p>{{aiTrans('9.5。 この文書の規定による権利、権力、またはリソースの行使における当社側の違反または遅延は、それを放棄することを意味するものではなく、権利、権力、またはリソースの単独または部分的な行使が他のいかなるものも妨げるものでもありません。その他の権利、権力、または資源の行使または行使。')}}</p>
            <p>{{aiTrans('9.6。 管轄裁判所が、これらの条件のいずれかの条項が適用法の下で執行可能でないと判断した場合、当該条項はこれらの条件から除外され、残りの条項は、当該条項が除外され、執行可能であるかのように解釈されます。その条件に従って; ただし、そのような場合、これらの条件は、可能な限り、適用法で許可されているものに従って、当該裁判所によって決定された除外条項の意味および意図を有効にするように解釈されます。管轄権。')}}</p>
            <p>{{aiTrans('9.7。 当社は、本書に基づく当社の権利および義務のすべてを第三者に譲渡または譲渡する場合があります。 上記にかかわらず、ウェブサイトおよび/またはサービスのいずれかは第三者によって運営される場合があります。 お客様は、これらの条件に基づくお客様の権利または義務を譲渡、譲渡、または誓約することはできません。')}}</p>
        </div>
    </div>
</section>
@endsection
