@extends('layouts.app')
@push('meta')
    <title>{{ "Zasady dotyczące prywatności - $website_title" }}</title>
    <meta name="description" content="{{ "Zobacz, na co zwraca uwagę $website_title, aby chronić Twoje dane. Polityka prywatności wyjaśnia, jak postępujemy w kwestii transparentności danych." }}" />
@endpush

@section('content')
    <div class="container page-inner pt-5">
        <h1>Polityka prywatności</h1>
        <main>
            <p><span class="b">{{ aiTrans('Dostawca', $locale) }}</span> (“{{ aiTrans('my', $locale) }}”,
                “{{ aiTrans('my', $locale) }}”, lub “{{ aiTrans('nasz', $locale) }}”) {{ aiTrans('działa na', $locale) }}
                <span class="u">{{ $website_title }}</span> {{ aiTrans('stronie internetowej (zwanej „Usługą”).', $locale) }}</p>
            <p>{{ aiTrans('Ta strona informuje Cię o naszych zasadach dotyczących zbierania, wykorzystywania i ujawniania danych osobowych, gdy korzystasz z naszej Usługi oraz wyborach, które masz związane z tymi danymi.', $locale) }}
            </p>
            <p>{{ aiTrans('My,', $locale) }} <a href="{{ route('home', $country) }}">{{ $website_title }}</a>,
                {{ aiTrans('używamy Twoich danych do świadczenia i ulepszania Usługi. Korzystając z Usługi, zgadzasz się na zbieranie i wykorzystywanie informacji zgodnie z tą polityką. O ile nie zdefiniowano inaczej w tej Polityce prywatności, terminy używane w tej Polityce prywatności mają te same znaczenia, co w naszych Warunkach korzystania, dostępnych pod adresem', $locale) }}
                <span class="u">{{ $website_title }}</span></p>
            <div id="toc_container" class="no_bullets">
                <ul class="toc_list">
                    <ul>
                        <li>
                            <ul>
                                <li><a href="#Definicje"><span class="toc_number toc_depth_3">0.0.1</span>
                                        {{ aiTrans('Definicje', $locale) }}</a>
                                    <ul>
                                        <li><a href="#Usługa"><span class="toc_number toc_depth_4">0.0.1.1</span>
                                                {{ aiTrans('Usługa', $locale) }}</a></li>
                                    </ul>
                                </li>
                                <li><a href="#Dane_osobowe"><span class="toc_number toc_depth_3">0.0.2</span>
                                        {{ aiTrans('Dane osobowe', $locale) }}</a></li>
                                <li><a href="#Dane_użytkowania"><span class="toc_number toc_depth_3">0.0.3</span>
                                        {{ aiTrans('Dane użytkowania', $locale) }}</a></li>
                                <li><a href="#Ciasteczka"><span class="toc_number toc_depth_3">0.0.4</span>
                                        {{ aiTrans('Ciasteczka', $locale) }}</a></li>
                                <li><a href="#Administrator_danych"><span class="toc_number toc_depth_3">0.0.5</span>
                                        {{ aiTrans('Administrator danych', $locale) }}</a></li>
                                <li><a href="#Podmioty_przetwarzające_lub_dostawcy_usług"><span
                                            class="toc_number toc_depth_3">0.0.6</span>
                                        {{ aiTrans('Podmioty przetwarzające dane (lub dostawcy usług)', $locale) }}</a></li>
                                <li><a href="#Podmiot_danych_lub_użytkownik"><span class="toc_number toc_depth_3">0.0.7</span>
                                        {{ aiTrans('Podmiot danych (lub użytkownik)', $locale) }}</a></li>
                            </ul>
                        </li>
                    </ul>
                    <li><a href="#Zbieranie_i_użytkowanie_informacji"><span class="toc_number toc_depth_1">1</span>
                            {{ aiTrans('Zbieranie i użytkowanie informacji', $locale) }}</a>
                        <ul>
                            <li>
                                <ul>
                                    <li><a href="#Rodzaje_zbieranych_danych"><span class="toc_number toc_depth_3">1.0.1</span>
                                            {{ aiTrans('Rodzaje zbieranych danych', $locale) }}</a></li>
                                    <li><a href="#Dane_osobowe-2"><span class="toc_number toc_depth_3">1.0.2</span>
                                            {{ aiTrans('Dane osobowe', $locale) }}</a></li>
                                    <li><a href="#Dane_użytkowania-2"><span class="toc_number toc_depth_3">1.0.3</span>
                                            {{ aiTrans('Dane użytkowania', $locale) }}</a></li>
                                    <li><a href="#Dane_ciasteczek_śledzących"><span class="toc_number toc_depth_3">1.0.4</span>
                                            {{ aiTrans('Dane ciasteczek śledzących', $locale) }}</a></li>
                                    <li><a href="#Wykorzystanie_danych"><span class="toc_number toc_depth_3">1.0.5</span>
                                            {{ aiTrans('Wykorzystanie danych', $locale) }}</a></li>
                                    <li><a
                                            href="#Podstawa_prawna_przetwarzania_danych_osobowych_zgodnie_z_Rozporządzeniem_o_ochronie_danych_osobowych_GDPR"><span
                                                class="toc_number toc_depth_3">1.0.6</span>
                                            {{ aiTrans('Podstawa prawna przetwarzania danych osobowych zgodnie z ogólnym rozporządzeniem o ochronie danych (GDPR)', $locale) }}</a>
                                    </li>
                                    <li><a href="#Przechowywanie_danych"><span class="toc_number toc_depth_3">1.0.7</span>
                                            {{ aiTrans('Przechowywanie danych', $locale) }}</a></li>
                                </ul>
                            </li>
                        </ul>
                    </li>
                    <li><a href="#Transfer_danych"><span class="toc_number toc_depth_1">2</span>
                            {{ aiTrans('Transfer danych', $locale) }}</a>
                        <ul>
                            <li>
                                <ul>
                                    <li><a href="#Ujawnienie_danych"><span class="toc_number toc_depth_3">2.0.1</span>
                                            {{ aiTrans('Ujawnienie danych', $locale) }}</a>
                                        <ul>
                                            <li><a href="#Transakcja_gospodarcza"><span
                                                        class="toc_number toc_depth_4">2.0.1.1</span>
                                                    {{ aiTrans('Transakcja gospodarcza', $locale) }}</a></li>
                                        </ul>
                                    </li>
                                    <li><a href="#Wymagania_prawne"><span class="toc_number toc_depth_3">2.0.2</span>
                                            {{ aiTrans('Wymagania prawne', $locale) }}</a></li>
                                    <li><a href="#Bezpieczeństwo_danych"><span class="toc_number toc_depth_3">2.0.3</span>
                                            {{ aiTrans('Bezpieczeństwo danych', $locale) }}</a></li>
                                    <li><a
                                            href="#Twoje_prawa_ochrony_danych_zgodnie_z_Rozporządzeniem_o_ochronie_danych_osobowych_GDPR"><span
                                                class="toc_number toc_depth_3">2.0.4</span>
                                            {{ aiTrans('Twoje prawa ochrony danych zgodnie z ogólnym rozporządzeniem o ochronie danych (GDPR)', $locale) }}</a>
                                    </li>
                                </ul>
                            </li>
                        </ul>
                    </li>
                    <li><a href="#Dostawcy_usług"><span class="toc_number toc_depth_1">3</span>
                            {{ aiTrans('Dostawcy usług', $locale) }}</a>
                        <ul>
                            <li>
                                <ul>
                                    <li><a href="#Analiza"><span class="toc_number toc_depth_3">3.0.1</span>
                                            {{ aiTrans('Analiza', $locale) }}</a></li>
                                    <li><a href="#Reklama"><span class="toc_number toc_depth_3">3.0.2</span>
                                            {{ aiTrans('Reklama', $locale) }}</a></li>
                                    <li><a href="#Remarketing_behawioralny"><span class="toc_number toc_depth_3">3.0.3</span>
                                            {{ aiTrans('Remarketing behawioralny', $locale) }}</a></li>
                                    <li><a href="#Linki_do_innych_stron"><span class="toc_number toc_depth_3">3.0.4</span>
                                            {{ aiTrans('Linki do innych stron', $locale) }}</a></li>
                                    <li><a href="#Prywatność_dzieci"><span class="toc_number toc_depth_3">3.0.5</span>
                                            {{ aiTrans('Prywatność dzieci', $locale) }}</a></li>
                                    <li><a href="#Zmiany_w_tym_polityka_prywatności"><span
                                                class="toc_number toc_depth_3">3.0.6</span>
                                            {{ aiTrans('Zmiany w tej polityce prywatności', $locale) }}</a></li>
                                    <li><a href="#Skontaktuj_się_z_nami"><span class="toc_number toc_depth_3">3.0.7</span>
                                            {{ aiTrans('Skontaktuj się z nami', $locale) }}</a></li>
                                </ul>
                            </li>
                        </ul>
                    </li>
                </ul>
            </div>
            <h4><span id="Definicje">{{ aiTrans('Definicje', $locale) }}</span></h4>
            <h5><span id="Usługa">{{ aiTrans('Usługa', $locale) }}</span></h5>
            <p>{{ aiTrans('Usługa to', $locale) }} <span class="u">{{ $website_title }}</span>
                {{ aiTrans('strona internetowa prowadzona przez', $locale) }} <span class="b">Dostawcę</span></p>
            <h4><span id="Dane_osobowe">{{ aiTrans('Dane osobowe', $locale) }}</span></h4>
            <p>{{ aiTrans('Dane osobowe oznaczają dane dotyczące żywej osoby, która może być identyfikowana na podstawie tych danych (lub na podstawie tych i innych informacji, które są w naszej posiadaniu lub które mogą znaleźć się w naszej posiadaniu).', $locale) }}
            </p>
            <h4><span id="Dane_użytkowania">{{ aiTrans('Dane użytkowania', $locale) }}</span></h4>
            <p>{{ aiTrans('Dane użytkowania to dane zbierane automatycznie, generowane przez korzystanie z Usługi lub z infrastruktury Usługi (na przykład czas wizyty na stronie).', $locale) }}
            </p>
            <h4><span id="Ciasteczka">{{ aiTrans('Ciasteczka', $locale) }}</span></h4>
            <p>{{ aiTrans('Ciasteczka to małe pliki danych przechowywane na Twoim urządzeniu (komputerze lub urządzeniu mobilnym).', $locale) }}
            </p>
            <h4><span id="Administrator_danych">{{ aiTrans('Administrator danych', $locale) }}</span></h4>
            <p>{{ aiTrans('Administrator danych oznacza osobę fizyczną lub prawną, która (samodzielnie lub wspólnie z innymi osobami) określa cele i sposób przetwarzania danych osobowych. Na potrzeby tej Polityki prywatności jesteśmy administratorem danych Twoich danych osobowych.', $locale) }}
            </p>
            <h4><span
                    id="Podmioty_przetwarzające_lub_dostawcy_usług">{{ aiTrans('Podmioty przetwarzające dane (lub dostawcy usług)', $locale) }}</span>
            </h4>
            <p>{{ aiTrans('Podmiot przetwarzający (lub dostawca usług) oznacza każdą osobę fizyczną lub prawną, która przetwarza dane w imieniu administratora danych. Możemy korzystać z usług różnych dostawców usług, aby skuteczniej przetwarzać Twoje dane.', $locale) }}
            </p>
            <h4><span id="Podmiot_danych_lub_użytkownik">{{ aiTrans('Podmiot danych (lub użytkownik)', $locale) }}</span></h4>
            <p>{{ aiTrans('Podmiot danych to każda żywa osoba, która korzysta z naszej Usługi i jest przedmiotem danych osobowych.', $locale) }}
            </p>
            <h2><span id="Zbieranie_i_użytkowanie_informacji">{{ aiTrans('Zbieranie i użytkowanie informacji', $locale) }}</span>
            </h2>
            <p>{{ aiTrans('Zbieramy kilka różnych rodzajów informacji w różnych celach, aby zapewnić i ulepszyć naszą Usługę dla Ciebie.', $locale) }}
            </p>
            <h4><span id="Rodzaje_zbieranych_danych">{{ aiTrans('Rodzaje zbieranych danych', $locale) }}</span></h4>
            <h4><span id="Dane_osobowe-2">{{ aiTrans('Dane osobowe', $locale) }}</span></h4>
            <p>{{ aiTrans('Korzystając z naszej Usługi, możemy poprosić Cię o podanie nam pewnych danych osobowych, które mogą być używane do kontaktu lub identyfikacji Ciebie (“Dane osobowe”). Dane osobowe mogą obejmować, ale nie są ograniczone do:', $locale) }}
            </p>
            <ul>
                <li>{{ aiTrans('Adres e-mail', $locale) }}</li>
                <li>{{ aiTrans('Imię i nazwisko', $locale) }}</li>
                <li>{{ aiTrans('Numer telefonu', $locale) }}</li>
                <li>{{ aiTrans('Adres, stan, prowincja, kod pocztowy, miasto', $locale) }}</li>
                <li>{{ aiTrans('Ciasteczka i dane użytkowania', $locale) }}</li>
            </ul>
            <p>{{ aiTrans('Możemy używać Twoich danych osobowych, aby kontaktować się z Tobą w sprawie newsletterów, materiałów marketingowych lub promocyjnych oraz innych informacji, które mogą Cię zainteresować. Możesz zrezygnować z otrzymywania dowolnej lub wszystkich tych komunikacji od nas, klikając link rezygnacji lub postępując zgodnie z instrukcjami zawartymi w dowolnym e-mailu, który wysyłamy, lub kontaktując się z nami.', $locale) }}
            </p>
            <h4><span id="Dane_użytkowania-2">{{ aiTrans('Dane użytkowania', $locale) }}</span></h4>
            <p>{{ aiTrans('Możemy również zbierać informacje o tym, jak Usługa jest uzyskiwana i używana (“Dane użytkowania”). Te Dane użytkowania mogą zawierać informacje, takie jak adres protokołu internetowego (np. adres IP) Twojego komputera, typ przeglądarki, wersja przeglądarki, strony naszej Usługi, które odwiedzasz, czas i datę wizyty, czas spędzony na tych stronach, unikalne identyfikatory urządzenia i inne dane diagnostyczne.', $locale) }}
            </p>
            <h4><span id="Dane_ciasteczek_śledzących">{{ aiTrans('Dane ciasteczek śledzących', $locale) }}</span></h4>
            <p>{{ aiTrans('Używamy ciasteczek i podobnych technologii śledzenia, aby śledzić aktywność na naszej Usłudze i przechowywać określone informacje.', $locale) }}
            </p>
            <p>{{ aiTrans('Ciasteczka to pliki z niewielką ilością danych, które mogą zawierać anonimowy unikalny identyfikator. Ciasteczka są wysyłane do Twojej przeglądarki z witryny internetowej i przechowywane na Twoim urządzeniu. Inne technologie śledzące to sygnały, tagi i skrypty, które zbierają i śledzą informacje oraz poprawiają i analizują naszą Usługę.', $locale) }}
            </p>
            <p>{{ aiTrans('Możesz poinstruować swoją przeglądarkę, aby odrzucała wszystkie ciasteczka lub informowała, gdy ciasteczko jest wysyłane. Jednak jeśli nie zaakceptujesz ciasteczek, możesz nie być w stanie korzystać z niektórych części naszej Usługi.', $locale) }}
            </p>
            <p>{{ aiTrans('Przykłady ciasteczek, które używamy:', $locale) }}</p>
            <ul>
                <li><strong>{{ aiTrans('Ciasteczka sesyjne.', $locale) }}</strong>
                    {{ aiTrans('Używamy ciasteczek sesyjnych do działania naszej Usługi.', $locale) }}</li>
                <li><strong>{{ aiTrans('Ciasteczka preferencyjne.', $locale) }}</strong>
                    {{ aiTrans('Używamy ciasteczek preferencyjnych, aby zapamiętać Twoje preferencje i różne ustawienia.', $locale) }}
                </li>
                <li><strong>{{ aiTrans('Ciasteczka zabezpieczające.', $locale) }}</strong>
                    {{ aiTrans('Używamy ciasteczek zabezpieczających w celach bezpieczeństwa.', $locale) }}</li>
                <li><strong>{{ aiTrans('Ciasteczka reklamowe.', $locale) }}</strong>
                    {{ aiTrans('Ciasteczka reklamowe są używane do serwowania reklam, które mogą być istotne dla Ciebie i Twoich zainteresowań.', $locale) }}
                </li>
            </ul>
            <h4><span id="Wykorzystanie_danych">{{ aiTrans('Wykorzystanie danych', $locale) }}</span></h4>
            <p><span class="b">Dostawca</span> {{ aiTrans('używa zebranych danych do różnych celów:', $locale) }}
            </p>
            <ul>
                <li>{{ aiTrans('Aby zapewnić i utrzymać naszą Usługę', $locale) }}</li>
                <li>{{ aiTrans('Aby powiadomić Cię o zmianach w naszej Usłudze', $locale) }}</li>
                <li>{{ aiTrans('Aby umożliwić Ci udział w interaktywnych funkcjach naszej Usługi, gdy zdecydujesz się to zrobić', $locale) }}
                </li>
                <li>{{ aiTrans('Aby zapewnić wsparcie klienta', $locale) }}</li>
                <li>{{ aiTrans('Aby zbierać analizy lub wartościowe informacje, abyśmy mogli poprawić naszą Usługę', $locale) }}
                </li>
                <li>{{ aiTrans('Aby monitorować korzystanie z naszej Usługi', $locale) }}</li>
                <li>{{ aiTrans('Aby wykrywać, zapobiegać i rozwiązywać problemy techniczne', $locale) }}</li>
                <li>{{ aiTrans('Aby dostarczać Ci wiadomości, oferty specjalne i ogólne informacje o innych towarach, usługach i wydarzeniach, które oferujemy i które są podobne do tych, które już kupiłeś lub o które pytałeś, chyba że zdecydowałeś się nie otrzymywać takich informacji', $locale) }}
                </li>
            </ul>
            <h4><span
                    id="Podstawa_prawna_przetwarzania_danych_osobowych_zgodnie_z_Rozporządzeniem_o_ochronie_danych_osobowych_GDPR">{{ aiTrans('Podstawa prawna przetwarzania danych osobowych zgodnie z ogólnym rozporządzeniem o ochronie danych (GDPR)', $locale) }}</span>
            </h4>
            <p>{{ aiTrans('Jeśli jesteś z Europejskiego Obszaru Gospodarczego (EOG),', $locale) }} <span
                    class="b">Dostawca</span>
                {{ aiTrans('podstawa prawna zbierania i wykorzystywania danych osobowych opisanych w tej Polityce prywatności zależy od danych osobowych, które zbieramy, oraz konkretnego kontekstu, w którym je zbieramy.', $locale) }}
            </p>
            <p><span class="b">Dostawca</span> {{ aiTrans('może przetwarzać Twoje dane osobowe, ponieważ:', $locale) }}</p>
            <ul>
                <li>{{ aiTrans('Musimy wykonać umowę z Tobą', $locale) }}</li>
                <li>{{ aiTrans('Dałeś nam pozwolenie na to', $locale) }}</li>
                <li>{{ aiTrans('Przetwarzanie leży w naszych uzasadnionych interesach i nie jest nadrzędne w stosunku do Twoich praw', $locale) }}
                </li>
                <li>{{ aiTrans('Aby przestrzegać prawa', $locale) }}</li>
            </ul>
            <h4><span id="Przechowywanie_danych">{{ aiTrans('Przechowywanie danych', $locale) }}</span></h4>
            <p><span class="b">Dostawca</span>
                {{ aiTrans('będzie przechowywał Twoje dane osobowe tylko tak długo, jak to konieczne w celu realizacji celów określonych w tej Polityce prywatności. Będziemy przechowywać i wykorzystywać Twoje dane osobowe w zakresie koniecznym do przestrzegania naszych zobowiązań prawnych (na przykład, jeśli jesteśmy zobowiązani do przechowywania Twoich danych, aby przestrzegać obowiązujących przepisów prawa), rozwiązywać spory i egzekwować nasze umowy prawne i polityki.', $locale) }}
            </p>
            <p><span class="b">Dostawca</span>
                {{ aiTrans('będzie również przechowywał dane użytkowania do celów analizy wewnętrznej. Dane użytkowania są generalnie przechowywane przez krótszy okres, chyba że te dane są wykorzystywane do wzmocnienia bezpieczeństwa lub poprawy funkcjonalności naszej Usługi, lub jesteśmy prawnie zobowiązani do przechowywania tych danych przez dłuższy czas.', $locale) }}
            </p>
            <h2><span id="Transfer_danych">{{ aiTrans('Transfer danych', $locale) }}</span></h2>
            <p>{{ aiTrans('Twoje informacje, w tym dane osobowe, mogą być przesyłane do — i przechowywane na — komputerach znajdujących się poza Twoim stanem, prowincją, krajem lub inną jurysdykcją rządową, gdzie przepisy dotyczące ochrony danych mogą różnić się od tych w Twojej jurysdykcji.', $locale) }}
            </p>
            <p>{{ aiTrans('Jeśli znajdujesz się poza Bułgarią i zdecydujesz się dostarczyć nam informacje, pamiętaj, że przesyłamy dane, w tym dane osobowe, do Bułgarii i przetwarzamy je tam.', $locale) }}
            </p>
            <p>{{ aiTrans('Twoja zgoda na tę Politykę prywatności, poprzedzona przesłaniem takich informacji, stanowi Twoją zgodę na ten transfer.', $locale) }}
            </p>
            <p><span class="b">Dostawca</span>
                {{ aiTrans('podejmie wszystkie kroki, które są rozsądnie konieczne, aby zapewnić, że Twoje dane są traktowane w sposób bezpieczny i zgodnie z tą Polityką prywatności, a transfer Twoich danych osobowych nie będzie miał miejsca do organizacji ani kraju, chyba że będą zapewnione odpowiednie zabezpieczenia, w tym bezpieczeństwo Twoich danych i innych informacji osobistych.', $locale) }}
            </p>
            <h4><span id="Ujawnienie_danych">{{ aiTrans('Ujawnienie danych', $locale) }}</span></h4>
            <h5><span id="Transakcja_gospodarcza">{{ aiTrans('Transakcja gospodarcza', $locale) }}</span></h5>
            <p>{{ aiTrans('Jeśli', $locale) }} <span class="b">Dostawca</span>
                {{ aiTrans('jest zaangażowany w fuzję, przejęcie lub sprzedaż aktywów, Twoje dane osobowe mogą być przesyłane. Poinformujemy Cię przed tym, jak Twoje dane osobowe zostaną przesłane i będą podlegały innej Polityce prywatności.', $locale) }}
            </p>
            <h4><span id="Wymagania_prawne">{{ aiTrans('Wymagania prawne', $locale) }}</span></h4>
            <p><span class="b">Dostawca</span>
                {{ aiTrans('może ujawnić Twoje dane osobowe w dobrej wierze, że takie działanie jest konieczne, aby:', $locale) }}
            </p>
            <ul>
                <li>{{ aiTrans('Aby przestrzegać zobowiązania prawnego', $locale) }}</li>
                <li>{{ aiTrans('Aby chronić i bronić praw lub własności', $locale) }} <span
                        class="b">Dostawcy</span></li>
                <li>{{ aiTrans('Aby zapobiegać lub prowadzić dochodzenia w sprawie potencjalnych nadużyć w związku z Usługą', $locale) }}
                </li>
                <li>{{ aiTrans('Aby chronić bezpieczeństwo osobiste użytkowników Usługi lub społeczeństwa', $locale) }}</li>
                <li>{{ aiTrans('Aby chronić przed odpowiedzialnością prawną', $locale) }}</li>
            </ul>
            <h4><span id="Bezpieczeństwo_danych">{{ aiTrans('Bezpieczeństwo danych', $locale) }}</span></h4>
            <p>{{ aiTrans('Bezpieczeństwo Twoich danych jest dla nas ważne, ale pamiętaj, że żadna metoda transmisji przez Internet ani metoda przechowywania elektronicznego nie jest w 100% bezpieczna. Choć staramy się korzystać z akceptowanych komercyjnie środków w celu ochrony Twoich danych osobowych, nie możemy zagwarantować ich całkowitego bezpieczeństwa.', $locale) }}
            </p>
            <h4><span
                    id="Twoje_prawa_ochrony_danych_zgodnie_z_Rozporządzeniem_o_ochronie_danych_osobowych_GDPR">{{ aiTrans('Twoje prawa ochrony danych zgodnie z ogólnym rozporządzeniem o ochronie danych (GDPR)', $locale) }}</span>
            </h4>
            <p>{{ aiTrans('Jeśli jesteś mieszkańcem Europejskiego Obszaru Gospodarczego (EOG), masz określone prawa dotyczące ochrony danych.', $locale) }}
                <span class="b">Dostawca</span>
                {{ aiTrans('dąży do podjęcia rozsądnych kroków, aby umożliwić Ci poprawienie, zmodyfikowanie, usunięcie lub ograniczenie korzystania z Twoich danych osobowych.', $locale) }}
            </p>
            <p>{{ aiTrans('Jeśli chcesz wiedzieć, jakie dane osobowe posiadamy o Tobie i chcesz, aby zostały one usunięte z naszych systemów, skontaktuj się z nami.', $locale) }}
            </p>
            <p>{{ aiTrans('W niektórych okolicznościach masz następujące prawa dotyczące ochrony danych:', $locale) }}</p>
            <p><strong>{{ aiTrans('Prawo do dostępu, aktualizacji lub usunięcia informacji, które mamy o Tobie.', $locale) }}</strong>
                {{ aiTrans('Gdy tylko to możliwe, możesz uzyskać dostęp, zaktualizować lub zażądać usunięcia swoich danych osobowych bezpośrednio w sekcji ustawień swojego konta. Jeśli nie jesteś w stanie samodzielnie wykonać tych działań, skontaktuj się z nami, aby Ci w tym pomóc.', $locale) }}<br>
                <strong>{{ aiTrans('Prawo do poprawienia danych.', $locale) }}</strong>
                {{ aiTrans('Masz prawo do poprawienia swoich informacji, jeśli te informacje są niedokładne lub niekompletne.', $locale) }}<br>
                <strong>{{ aiTrans('Prawo do sprzeciwu.', $locale) }}</strong>
                {{ aiTrans('Masz prawo sprzeciwić się przetwarzaniu Twoich danych osobowych.', $locale) }}<br>
                <strong>{{ aiTrans('Prawo do ograniczenia przetwarzania.', $locale) }}</strong>
                {{ aiTrans('Masz prawo do zażądania ograniczenia przetwarzania Twoich informacji osobowych.', $locale) }}<br>
                <strong>{{ aiTrans('Prawo do przenoszenia danych.', $locale) }}</strong>
                {{ aiTrans('Masz prawo do otrzymania kopii informacji, które mamy o Tobie w strukturalnym, nadającym się do przetwarzania maszynowego i powszechnie używanym formacie.', $locale) }}<br>
                <strong>{{ aiTrans('Prawo do wycofania zgody.', $locale) }}</strong>
                {{ aiTrans('Masz również prawo do wycofania swojej zgody w dowolnym momencie, gdy', $locale) }} <span
                    class="b">Dostawca</span>
                {{ aiTrans('polegał na Twojej zgodzie, aby przetwarzać Twoje informacje osobowe.', $locale) }}</p>
            <p>{{ aiTrans('Pamiętaj, że możemy poprosić Cię o potwierdzenie tożsamości przed odpowiedzią na takie prośby.', $locale) }}
            </p>
            <p>{{ aiTrans('Masz prawo do złożenia skargi do organu ochrony danych w sprawie naszego zbierania i wykorzystywania Twoich danych osobowych. Aby uzyskać więcej informacji, skontaktuj się z lokalnym organem ochrony danych w Europejskim Obszarze Gospodarczym (EOG).', $locale) }}
            </p>
            <h2><span id="Dostawcy_usług">{{ aiTrans('Dostawcy usług', $locale) }}</span></h2>
            <p>{{ aiTrans('Możemy zatrudniać firmy i osoby trzecie w celu ułatwienia naszej Usługi („Dostawcy usług”), aby świadczyć Usługę w naszym imieniu, wykonywać usługi związane z Usługą lub pomagać nam w analizowaniu, jak nasza Usługa jest używana.', $locale) }}
            </p>
            <p>{{ aiTrans('Ci zewnętrzni dostawcy mają dostęp do Twoich danych osobowych tylko w celu wykonania tych zadań w naszym imieniu i są zobowiązani do nieujawniania ani nieużywania ich do żadnych innych celów.', $locale) }}
            </p>
            <h4><span id="Analiza">{{ aiTrans('Analiza', $locale) }}</span></h4>
            <p>{{ aiTrans('Możemy korzystać z usług dostawców zewnętrznych w celu monitorowania i analizowania korzystania z naszej Usługi.', $locale) }}
            </p>
            <p><strong>{{ aiTrans('Google Analytics', $locale) }}</strong><br>
                {{ aiTrans('Google Analytics to usługa analizy internetowej oferowana przez Google, która śledzi i raportuje ruch na stronie internetowej. Google wykorzystuje zebrane dane do śledzenia i monitorowania korzystania z naszej Usługi. Te dane są udostępniane innym usługom Google. Google może używać zebranych danych do kontekstualizacji i personalizacji reklam własnej sieci reklamowej. Możesz zrezygnować z udostępnienia swojej aktywności w Usłudze Google Analytics, instalując dodatek do przeglądarki do rezygnacji z Google Analytics. Dodatek zapobiega, aby JavaScript Google Analytics (ga.js, analytics.js i dc.js) dzielił się informacjami z Google Analytics o aktywności wizyt. Aby uzyskać więcej informacji na temat praktyk prywatności Google, odwiedź stronę internetową warunków prywatności Google:', $locale) }}
                <a href="https://www.google.com/intl/en/policies/privacy/" target="_blank"
                    rel="noopener">http://www.google.com/intl/en/policies/privacy/</a></p>
            <h4><span id="Reklama">{{ aiTrans('Reklama', $locale) }}</span></h4>
            <p>{{ aiTrans('Możemy korzystać z dostawców zewnętrznych, aby wyświetlać reklamy dla Ciebie, aby wspierać i utrzymywać naszą Usługę.', $locale) }}
            </p>
            <p><strong>{{ aiTrans('Ciasteczko Google AdSense DoubleClick', $locale) }}</strong><br>
                {{ aiTrans('Google, jako zewnętrzny dostawca, używa ciasteczek do wyświetlania reklam na naszej Usłudze. Użycie ciasteczka DoubleClick przez Google umożliwia jemu i jego partnerom wyświetlanie reklam naszym użytkownikom na podstawie ich wizyty w naszej Usłudze lub innych stronach internetowych w Internecie. Możesz zrezygnować z używania ciasteczka DoubleClick w reklamach opartych na zainteresowaniach, odwiedzając stronę internetową ustawień reklam Google:', $locale) }}
                <a href="https://www.google.com/ads/preferences/" target="_blank"
                    rel="noopener">http://www.google.com/ads/preferences/</a></p>
            <h4><span id="Remarketing_behawioralny">{{ aiTrans('Remarketing behawioralny', $locale) }}</span></h4>
            <p><span class="b">Dostawca</span>
                {{ aiTrans('używa usług remarketingowych do reklamowania się na stronach trzecich po tym, jak odwiedziłeś naszą Usługę. My i nasi zewnętrzni dostawcy używamy ciasteczek, aby informować, optymalizować i serwować reklamy na podstawie Twoich wcześniejszych wizyt w naszej Usłudze.', $locale) }}
            </p>
            <p><strong>{{ aiTrans('Google AdWords', $locale) }}</strong><br>
                {{ aiTrans('Usługa remarketingu Google AdWords jest świadczona przez Google Inc. Możesz zrezygnować z Google Analytics w celu reklamy displayowej i dostosować reklamy sieci Google Display, odwiedzając stronę ustawień reklam Google: http://www.google.com/settings/ads Google zaleca również zainstalowanie dodatku do przeglądarki Google Analytics Opt-out – https://tools.google.com/dlpage/gaoptout – dla Twojej przeglądarki internetowej. Dodatek Google Analytics Opt-out daje odwiedzającym możliwość zapobiegania zbieraniu i wykorzystywaniu ich danych przez Google Analytics. Aby uzyskać więcej informacji na temat praktyk prywatności Google, odwiedź stronę internetową warunków prywatności Google:', $locale) }}
                <a href="https://www.google.com/intl/en/policies/privacy/" target="_blank"
                    rel="noopener">http://www.google.com/intl/en/policies/privacy/</a></p>
            <p><strong>{{ aiTrans('Facebook', $locale) }}</strong><br>
                {{ aiTrans('Usługa remarketingu Facebooka jest świadczona przez Facebook Inc. Możesz dowiedzieć się więcej o reklamach opartych na zainteresowaniach z Facebooka, odwiedzając tę stronę:', $locale) }}
                <a href="https://www.facebook.com/help/164968693837950" target="_blank"
                    rel="noopener">https://www.facebook.com/help/164968693837950</a>
                {{ aiTrans('Aby zrezygnować z reklam opartych na zainteresowaniach Facebooka, postępuj zgodnie z tymi instrukcjami od Facebooka:', $locale) }}
                <a href="https://www.facebook.com/help/568137493302217" target="_blank"
                    rel="noopener">https://www.facebook.com/help/568137493302217</a>
                {{ aiTrans('Facebook przestrzega zasad samoregulacyjnych dla reklam behawioralnych w Internecie ustanowionych przez Digital Advertising Alliance. Możesz również zrezygnować z Facebooka i innych uczestniczących firm poprzez Digital Advertising Alliance w USA', $locale) }}
                <a href="http://www.aboutads.info/choices/" target="_blank"
                    rel="noopener">http://www.aboutads.info/choices/</a>,
                {{ aiTrans('Digital Advertising Alliance of Canada w Kanadzie', $locale) }} <a
                    href="http://youradchoices.ca/" target="_blank" rel="noopener">http://youradchoices.ca/</a>
                {{ aiTrans('lub Europejska Interaktywna Digital Advertising Alliance w Europie', $locale) }} <a
                    href="http://www.youronlinechoices.eu/" target="_blank"
                    rel="noopener">http://www.youronlinechoices.eu/</a>,
                {{ aiTrans('lub zrezygnować, korzystając z ustawień urządzenia mobilnego. Aby uzyskać więcej informacji na temat praktyk prywatności Facebooka, odwiedź stronę Polityki danych Facebooka:', $locale) }}
                <a href="https://www.facebook.com/privacy/explanation" target="_blank"
                    rel="noopener">https://www.facebook.com/privacy/explanation</a></p>
            <h4><span id="Linki_do_innych_stron">{{ aiTrans('Linki do innych stron', $locale) }}</span></h4>
            <p>{{ aiTrans('Nasza Usługa może zawierać linki do innych witryn, które nie są przez nas obsługiwane. Jeśli klikniesz w link do strony trzeciej, zostaniesz przekierowany na stronę tej strony trzeciej. Zdecydowanie zalecamy zapoznanie się z Polityką prywatności każdej witryny, którą odwiedzasz.', $locale) }}
            </p>
            <p>{{ aiTrans('Nie mamy kontroli nad ani nie ponosimy odpowiedzialności za treści, polityki prywatności lub praktyki jakichkolwiek stron lub usług osób trzecich.', $locale) }}
            </p>
            <h4><span id="Prywatność_dzieci">{{ aiTrans('Prywatność dzieci', $locale) }}</span></h4>
            <p>{{ aiTrans('Nasza Usługa nie jest skierowana do nikogo poniżej 18 roku życia (“Dzieci”).', $locale) }}</p>
            <p>{{ aiTrans('Nie zbieramy świadomie danych osobowych od nikogo poniżej 18 roku życia. Jeśli jesteś rodzicem lub opiekunem i wiesz, że Twoje Dzieci przekazały nam dane osobowe, skontaktuj się z nami. Jeśli dowiemy się, że zebraliśmy dane osobowe od dzieci bez weryfikacji zgody rodziców, podejmiemy kroki, aby usunąć te informacje z naszych serwerów.', $locale) }}
            </p>
            <h4><span id="Zmiany_w_tym_polityka_prywatności">{{ aiTrans('Zmiany w tej polityce prywatności', $locale) }}</span>
            </h4>
            <p>{{ aiTrans('Możemy aktualizować naszą Politykę prywatności od czasu do czasu. Poinformujemy Cię o wszelkich zmianach, publikując nową Politykę prywatności na tej stronie.', $locale) }}
            </p>
            <p>{{ aiTrans('Powiadomimy Cię za pomocą wiadomości e-mail i/lub wyraźnego powiadomienia na naszej Usłudze, przed tym, jak zmiana wejdzie w życie, i zaktualizujemy “datę wejścia w życie” na górze tej Polityki prywatności.', $locale) }}
            </p>
            <p>{{ aiTrans('Zaleca się okresowe przeglądanie tej Polityki prywatności w celu sprawdzenia wszelkich zmian. Zmiany w tej Polityce prywatności są skuteczne, gdy zostaną opublikowane na tej stronie.', $locale) }}
            </p>
            <h4><span id="Skontaktuj_się_z_nami">{{ aiTrans('Skontaktuj się z nami', $locale) }}</span></h4>
            <p>{{ aiTrans('Jeśli masz jakiekolwiek pytania dotyczące tej Polityki prywatności, skontaktuj się z nami za pośrednictwem e-maila.', $locale) }}
            </p>
        </main>
    </div>
@endsection
