
<?php $__env->startPush('meta'); ?>
    <title><?php echo e("$website_title ™ | A hivatalos és frissített webhely 2025"); ?></title>
    <meta name="description" content="<?php echo e("Ismerje meg, hogyan segíti a $website_title a kriptovaluta-befektetési stratégiáit. Platformunk fejlett eszközöket és teljes körű támogatást kínál a sikeres kereskedéshez."); ?>" />
<?php $__env->stopPush(); ?>
<?php $__env->startSection('content'); ?>
<!-- Hero -->
<section id="hero" class="hero-section">
    <div class="uk-container">
        <div class="hero-inner">

            <div class="hero-meta uk-text-center">
                <h1><?php echo e($website_title); ?> </h1>
            </div>

            <div class="uk-grid-small" uk-grid>
                <div class="uk-width-expand@s">
                    <img class="hero-img" src="<?php echo e(asset('frontend/assets/hu/dist')); ?>/images/laptop-tablet-with-business-reports-1536x1009.jpg" alt="">
                </div>
                <div class="uk-width-1-2@s">

                    <h3 class="form-above uk-text-center"><?php echo e(aiTrans('Fedezze fel')); ?> <?php echo e($website_title); ?></h3>
                    <div class="hero-form">
                        <div class="main-form-title">
                            <h2><?php echo e(aiTrans('Fedezze fel')); ?> <span><?php echo e($website_title); ?></span></h2>
                        </div>

                        <div class="form_panel">
                            <?php echo $__env->make('frontend.hu.components.form', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </div>

                    </div>
                </div>
            </div>

        </div>
    </div>
</section>

<section class="section2">
    <div class="uk-container">

        <div class="uk-grid-small" uk-grid>
            <div class="uk-width-expand@s">

                <h2><?php echo e(aiTrans('Mi az?')); ?> <?php echo e($website_title); ?>?</h2>
                <div class="gt-block">
                    <span class="change-by-command">
                      <?php echo e("En $website_title, örömmel üdvözöljük Önt egy olyan élvonalbeli platformon, amelynek célja, hogy kapcsolatba lépjen a felhasználókkal a befektetési oktatásra szakosodott vezető oktatási vállalatokkal. Átfogó platformunk hozzáférést biztosít számos befektetési oktatási forráshoz az oktatási cégekkel kötött globális partnerségünkön keresztül."); ?>

                    </span>
                </div>
                <p class="gt-block"><?php echo e(aiTrans('Legyen szó kezdő befektetőről, aki ugrásszerűen szeretné elindítani az utazását, vagy tapasztalt szakember, aki a stratégiáit szeretné finomítani, mi mindenre megtaláljuk a választ. Platformunk egyablakos célpontként szolgál, ahol a felhasználók felfedezhetik, tanulhatnak, és kapcsolatba léphetnek neves oktatási vállalatokkal szerte a világon.')); ?></p>
                <p class="gt-block">
                    <?php echo e(aiTrans(
                        'De ami igazán megkülönböztet [website_title] Ez a minőség iránti elkötelezettségünk. Gondosan kiválasztunk minden, a platformunkon szereplő oktatási vállalatot, biztosítva, hogy Ön csak a legmegbízhatóbb és legelismertebb útmutatást kapja. Val vel [website_title], bízhat abban, hogy a szakma legjobbjaitól tanul. Tegye meg az első lépést a pénzügyi felhatalmazás felé – fedezze fel a platformot még ma, és fedezze fel a lehetőségek világát. Jövőbeli éned hálás lesz neked.',
                        $locale,
                        ['website_title' => $website_title],
                    )); ?>

                    </p>

            </div>
            <div class="uk-width-2-5@s">
                <img class="br20" src="<?php echo e(asset('frontend/assets/hu/dist')); ?>/images/woman-workin.jpg" alt="">
            </div>
        </div>

    </div>
</section>

<section class="section1 section2">
    <div class="uk-container">

        <div class="uk-text-center padding-10">
            <h2>
                <?php echo e(aiTrans(
                    'Az oktatási cégek előnyeinek felszabadítása ezzel [website_title]',
                    $locale,
                    ['website_title' => $website_title],
                )); ?>

                </h2>
            <p class="f20">
                <?php echo e(aiTrans(
                    'Interakció oktatási cégekkel keresztül [website_title] megnyitja az ajtót egy sor olyan előny előtt, amelyek célja a befektetési út fokozása. Amikor kölcsönhatásba lép az oktatási cégekkel keresztül [website_title] , felbecsülhetetlen értékű forrásokhoz és támogatáshoz férhet hozzá, amely képessé teszi Önt arra, hogy megalapozott befektetési döntéseket hozzon és elérje pénzügyi céljait. Használja ki ezeket az előnyöket még ma, és induljon el a befektetési siker felé vezető úton.',
                    $locale,
                    ['website_title' => $website_title],
                )); ?>

                </p>
        </div>

        <div class="uk-grid-small uk-margin-medium-top" uk-grid>
            <div class="uk-width-1-3@s uk-grid-item-match">
                <div class="gird-box">
                    <h3><?php echo e(aiTrans("Személyre szabott tanácsok")); ?></h3>
                    <p><?php echo e(aiTrans('Szakértői útmutatást és személyre szabott ajánlásokat kaphat, amelyek összhangban vannak egyedi igényeivel és céljaival. Az oktatási társaságok személyre szabott támogatást kínálnak, hogy segítsenek önbizalommal eligazodni a befektetés összetettségei között. Ez a személyre szabott megközelítés biztosítja, hogy a stratégiák igazodjanak az egyéni kockázati toleranciához és a befektetési célokhoz, és alkalmazkodjanak a változó életkörülményekhez, maximalizálva a személyes pénzügyi siker lehetőségét.')); ?></p>
                </div>
            </div>
            <div class="uk-width-1-3@s uk-grid-item-match">
                <div class="gird-box">
                    <h3><?php echo e(aiTrans("Tanfolyamok kiterjedt katalógusa")); ?></h3>
                    <p><?php echo e(aiTrans('Fedezze fel a tanfolyamok széles skáláját, amelyek különböző befektetési témákat és készségszinteket fednek le. Akár kezdő, aki szeretné megérteni az alapokat, akár tapasztalt befektető, aki haladó stratégiákat keres, a tapasztalati szintjére szabott tanfolyamokat talál. Ez az átfogó választék lehetővé teszi a hallgatók számára, hogy folyamatosan fejlesszék befektetési ismereteiket és készségeiket, elősegítve az egész életen át tartó tanulási utat, amely lépést tart a folyamatosan változó pénzügyi környezettel és a személyes növekedési célokkal.')); ?></p>
                </div>
            </div>
            <div class="uk-width-1-3@s uk-grid-item-match">
                <div class="gird-box">
                    <h3><?php echo e(aiTrans("Az összetett kifejezések leegyszerűsítve")); ?></h3>
                    <p><?php echo e(aiTrans('Világossá válik, ahogy az oktatási vállalatok könnyen érthető nyelven lebontják az összetett befektetési koncepciókat. Mondjon búcsút a zavarodottságnak, és köszönjön a megértésnek, miközben könnyedén elmélyül a befektetés bonyolultságában. Ez a megközelítés demisztifikálja a pénzügyek világát, hozzáférhetővé teszi az emberek számára, függetlenül a származásuktól, és több embert ösztönöz arra, hogy megalapozott befektetési döntések meghozatalával vegyék kezükbe pénzügyi jövőjük irányítását.')); ?></p>
                </div>
            </div>
            <div class="uk-width-1-1@s">
                <div class="gird-box gird-box-border">
                    <h3><?php echo e(aiTrans("Értse a kockázatkezelést")); ?></h3>
                    <p><?php echo e(aiTrans('Sajátítsd el a hatékony kockázatkezelés művészetét a speciális kurzusokkal, amelyek segítenek megvédeni és maximalizálni a befektetés megtérülését. Az oktatási cégek értékes információkat és stratégiákat kínálnak a kockázatok mérséklésére és a befektetési döntések optimalizálására. Azáltal, hogy megtanulják azonosítani, elemezni és kezelni a potenciális kockázatokat, a befektetők megóvhatják eszközeiket és felfedezhetik a növekedési lehetőségeket, így biztosítva a biztonságosabb és virágzóbb befektetési utat.')); ?></p>
                </div>
            </div>
        </div>

        <div uk-grid>
            <div class="uk-width-2-5@s">
                <img class="br20" src="<?php echo e(asset('frontend/assets/hu/dist')); ?>/images/stock-exchange-trading-forex-finance-graphic-concept-1536x1248.jpg" alt="">
            </div>
            <div class="uk-width-expand@s">
                <h2>
                    <?php echo e(aiTrans(
                        'Hogyan indítsa be befektetési oktatását [website_title]',
                        $locale,
                        ['website_title' => $website_title],
                    )); ?>

                    </h2>
                <p class="gt-block">
                    <?php echo e(aiTrans(
                        'Befektetési oktatási útjára indulni izgalmas és [website_title] itt van, hogy útmutatást adjon az út minden lépéséhez. A befektetési út megkezdése előtt elengedhetetlen, hogy értékelje jelenlegi befektetési tapasztalatait. Mérje fel tudását és készségeit helyzetének meghatározásához. Ez az önértékelés segít azonosítani a fejlesztendő területeket és reális tanulási célokat kitűzni.',
                        $locale,
                        ['website_title' => $website_title],
                    )); ?>

                    </p>
                <p class="gt-block"><?php echo e(aiTrans('Ezután készítsen tervet a tanulási útjára. Határozza meg céljait és azt, hogy mit szeretne elérni befektetési oktatásával. Akár az alapvető befektetési elvek megértése, akár a fejlett stratégiákba való belemerülés a célja, egy világos ütemterv birtokában tarthatja a pályán és motiváltan.')); ?></p>
                <p class="gt-block">
                    <?php echo e(aiTrans(
                        'Miután meghatározta a céljait, ideje használni [website_title]. Platformunk rengeteg személyre szabott erőforrást és támogatást kínál az Ön oktatási igényeinek kielégítésére. A kezdő oktatóanyagoktól a szakértők által vezetett workshopokig átfogó eszközöket biztosítunk a befektetési koncepciók jobb megértéséhez.',
                        $locale,
                        ['website_title' => $website_title],
                    )); ?>

                    </p>
            </div>
        </div>

        <div uk-grid>
            <div class="uk-width-expand@s">
                <h2><?php echo e(aiTrans('Befektetési kilátások: feltörekvő trendek')); ?></h2>
                <p class="gt-block"><?php echo e(aiTrans('Napjaink befektetési környezetében számos figyelemre méltó tendencia alakítja a befektetők stratégiáinak kialakítását és erőforrásaik elosztását. Először is, a feltörekvő piacok egyre nagyobb figyelmet kapnak, mivel a befektetők a hagyományosokon túlmutató növekedési lehetőségeket keresnek. Az olyan régiókban, mint Ázsia, Latin-Amerika és Afrika, az urbanizáció, a technológiai fejlődés és a változó fogyasztói demográfia miatt gyors fejlődés tapasztalható. Ezek a piacok csábító kilátásokat kínálnak a befektetők számára, akik szeretnék kihasználni növekedési pályájukat, és új megtérülési forrásokat szeretnének elérni.')); ?></p>
                <p class="gt-block"><?php echo e(aiTrans('Ezen túlmenően a fenntartható befektetés fontos trendté vált, egyre nagyobb hangsúlyt fektetve a környezeti, társadalmi és kormányzási (ESG) tényezőkre. A befektetők egyre inkább beépítik a fenntarthatósági szempontokat döntéshozatali folyamataikba, hogy összhangba hozzák pénzügyi céljaikat szélesebb társadalmi és környezeti célkitűzésekkel. A megújuló energiával kapcsolatos projektektől a társadalmilag felelős vállalkozásokig a fenntartható befektetés olyan lehetőségeket kínál, amelyek pozitív hatást és pénzügyi megtérülést eredményeznek. A mesterséges intelligencia, a nagy adatelemzés és a blokklánc technológia technológiai újításai átformálják a befektetési környezetet. Ezek a fejlesztések jobb adatbetekintést, hatékonyabb kereskedési mechanizmusokat és innovatív befektetési termékeket, például kriptovalutákat és decentralizált pénzügyi (DeFi) platformokat biztosítanak a befektetőknek.')); ?></p>
                <p class="gt-block"><?php echo e(aiTrans('E trendek felkarolása és a befektetési stratégiák adaptálása kulcsfontosságú azon befektetők számára, akik hatékonyan kívánnak eligazodni a változó piaci dinamikában és kiaknázni azt.')); ?></p>
            </div>
            <div class="uk-width-2-5@s">
                <img class="br20" src="<?php echo e(asset('frontend/assets/hu/dist')); ?>/images/9642-1536x1536.jpg" alt="">
            </div>
        </div>

    </div>
</section>

<section class="section2">
    <div class="uk-container">

        <div class="uk-text-center padding-10">
            <h2>
                <?php echo e(aiTrans(
                    'Előnyeinek feltárása [website_title]',
                    $locale,
                    ['website_title' => $website_title],
                )); ?>

                </h2>
            <p class="f20">
                <?php echo e(aiTrans(
                    'Fedezze fel a különleges előnyöket [website_title] A befektetési oktatás legjobb célpontja:',
                    $locale,
                    ['website_title' => $website_title],
                )); ?>

                </p>
        </div>

        <div class="uk-grid-small uk-margin-medium-top" uk-grid>
            <div class="uk-width-1-3@s uk-grid-item-match">
                <div class="gird-box">
                    <h3><?php echo e(aiTrans('Globális oktatási egyesületek:')); ?></h3>
                    <p>
                        <?php echo e(aiTrans(
                            'A vezető oktatási cégek kiterjedt hálózatával szerte a világon, [website_title]  páratlan hozzáférést biztosít a világszínvonalú tanulási lehetőségekhez. Partnerkapcsolataink biztosítják, hogy szakértői útmutatást és átfogó, a befektetési útjára szabott erőforrásokat kapjon.',
                            $locale,
                            ['website_title' => $website_title],
                        )); ?></p>
                </div>
            </div>
            <div class="uk-width-1-3@s uk-grid-item-match">
                <div class="gird-box">
                    <h3><?php echo e(aiTrans('Tanfolyamok kiterjedt katalógusa')); ?></h3>
                    <p>
                        <?php echo e(aiTrans(
                            '[website_title] Ez túlmutat a tudás átadásán; Támogatjuk a hosszú távú növekedésre és vagyonteremtésre irányuló gondolkodásmódot. Válogatott tartalmaink és útmutatásaink lehetővé teszik a fegyelem és a stratégiai gondolkodás kialakítását, amely elengedhetetlen a sikerhez a befektetés dinamikus világában.',
                            $locale,
                            ['website_title' => $website_title],
                        )); ?>

                        </p>
                </div>
            </div>
            <div class="uk-width-1-3@s uk-grid-item-match">
                <div class="gird-box">
                    <h3><?php echo e(aiTrans('Az átlátható gyakorlatok népszerűsítése:')); ?></h3>
                    <p>
                        <?php echo e(aiTrans(
                            'Az átláthatóság és az etika a filozófia középpontjában áll [website_title]. Támogatjuk az átlátható és etikus befektetési gyakorlatokat, biztosítva Önnek azokat a tudást és eszközöket, amelyekkel megalapozott döntéseket hozhat a pénzügyi piacok összetettségei között.',
                            $locale,
                            ['website_title' => $website_title],
                        )); ?>

                        </p>
                </div>
            </div>
            <div class="uk-width-1-1@s">
                <div class="gird-box gird-box-border">
                    <h3><?php echo e(aiTrans('A fenntartható befektetés bajnoka:')); ?></h3>
                    <p>
                        <?php echo e(aiTrans(
                            'En [website_title], elismerjük a fenntartható és társadalmilag felelős befektetés fontosságát. Hangsúlyozzuk a pénzügyi célok és a környezetvédelmi, társadalmi és kormányzási (ESG) megfontolások összehangolásának fontosságát, lehetővé téve, hogy céltudatos módon fektessen be, és pozitív hatással legyen a világra.',
                            $locale,
                            ['website_title' => $website_title],
                        )); ?>

                        </p>
                    <p>
                        <?php echo e(aiTrans(
                            'a [website_title] Megbízható partnereként induljon el a tanulás, a növekedés és a felelősségteljes befektetés útjára. Csatlakozzon hozzánk, hogy kiaknázza befektetési kezdeményezéseiben rejlő lehetőségeket.',
                            $locale,
                            ['website_title' => $website_title],
                        )); ?>

                        </p>
                </div>
            </div>
        </div>

    </div>
</section>

<section class="section1 section2">
    <div class="uk-container">

        <div class="uk-text-center padding-10">
            <h2><?php echo e(aiTrans('Globális piacok áttekintése')); ?></h2>
            <p class="f20"><?php echo e(aiTrans('A globális pénzügyi piacok számos tőzsdét, platformot és intézményt foglalnak magukban, ahol különféle pénzügyi eszközökkel kereskednek, beleértve a részvényeket, kötvényeket, valutákat, árukat és származékos termékeket. Ezek a piacok döntő szerepet játszanak a tőkeallokáció, a kockázatkezelés és a gazdasági növekedés elősegítésében globális szinten.')); ?></p>
            <p class="f20"><?php echo e(aiTrans('A feltörekvő piacok továbbra is felkeltik a figyelmet gyors gazdasági növekedésüknek, bővülő középosztályuknak és kiaknázatlan befektetési lehetőségeiknek köszönhetően. Ezek a piacok magas potenciális megtérülést és magas kockázatot jelentenek, beleértve a politikai instabilitást, a szabályozási bizonytalanságot és az árfolyam-ingadozásokat. A technológiai fejlődés, beleértve az algoritmikus kereskedést, a blokkláncot és a mesterséges intelligenciát, átformálja a globális pénzügyi piacokat. Ezek az innovációk javítják a hatékonyságot, a likviditást és a hozzáférhetőséget, miközben új kiberbiztonsági és piaci integritási kihívásokat vezetnek be.')); ?></p>
        </div>

    </div>
</section>

<section class="section2">
    <div class="uk-container">

        <div class="uk-text-center padding-10">
            <h2>
                <?php echo e(aiTrans(
                    'kihasználni [website_title] a személyes és szakmai fejlődésért a befektetés sikerében',
                    $locale,
                    ['website_title' => $website_title],
                )); ?>

                </h2>
            <p class="f20">
                <?php echo e(aiTrans(
                    '[website_title] Alapvető fontosságú a személyes és szakmai fejlődés elősegítése, különösen a befektetés sikere szempontjából. Így járulhat hozzá:',
                    $locale,
                    ['website_title' => $website_title],
                )); ?>

                </p>
        </div>

        <div class="uk-grid-small uk-margin-medium-top" uk-grid>
            <div class="uk-width-1-3@s uk-grid-item-match">
                <div class="gird-box">
                    <h3><?php echo e(aiTrans('Hozzáférés a tapasztalatokhoz')); ?></h3>
                    <p>

                        <?php echo e(aiTrans(
                            '[website_title] hozzáférést biztosít a befektetési terület szakértői által összeállított rengeteg tudáshoz. Kurzusok, szemináriumok és források révén az egyének kiaknázhatják a tapasztalt szakemberek tudását és tapasztalatait, és olyan értékes betekintést nyerhetnek, amely megalapozhatja befektetési stratégiájukat.',
                            $locale,
                            ['website_title' => $website_title],
                        )); ?>

                        </p>
                </div>
            </div>
            <div class="uk-width-1-3@s uk-grid-item-match">
                <div class="gird-box gird-box-border">
                    <h3><?php echo e(aiTrans('Képességfejlesztés:')); ?></h3>
                    <p><?php echo e(aiTrans('Partnereink különféle tanfolyamokat kínálnak a sikeres befektetéshez elengedhetetlen pénzügyi ismeretek fejlesztésére. Ezek közé tartozhat a gazdasági elemzés, a kockázatkezelés, a portfólió diverzifikációja és a piaci dinamika megértése. Ezen készségek csiszolásával az egyének magabiztosabban hozhatnak megalapozottabb döntéseket, és eligazodhatnak a befektetési környezet összetettségei között.')); ?></p>
                </div>
            </div>
            <div class="uk-width-1-3@s uk-grid-item-match">
                <div class="gird-box">
                    <h3><?php echo e(aiTrans('Az erőforrások elérhetősége:')); ?></h3>
                    <p><?php echo e(aiTrans('Azok az oktatási cégek, amelyekkel együtt dolgozunk, átfogó forrástárat kínálnak, beleértve a cikkeket, esettanulmányokat és kutatási jelentéseket, amelyek a befektetés különböző aspektusait lefedik. Ezek az erőforrások értékes referenciákként szolgálnak ahhoz, hogy naprakészek maradjanak a piaci trendekkel, új befektetési lehetőségeket fedezzenek fel, és megértsék a pénzügyi világ legújabb fejleményeit.')); ?></p>
                </div>
            </div>
        </div>

    </div>
</section>

<section class="section1 section2">
    <div class="uk-container">
        <div uk-grid>
            <div class="uk-width-2-5@s">
                <img class="br20" src="<?php echo e(asset('frontend/assets/hu/dist')); ?>/images/top-view-colorful-business-report-cup-coffee-1536x1024.jpg" alt="">
            </div>
            <div class="uk-width-expand@s">
                <h2><?php echo e(aiTrans('Következtetés: ösztönözze a folyamatos tanulást')); ?></h2>
                <p class="gt-block">
                    <?php echo e(aiTrans(
                        'A befektetések dinamikus világában a folyamatos tanulás nemcsak értékes, hanem elengedhetetlen is. [website_title] kaput kínál rengeteg tudáshoz, tapasztalathoz és erőforráshoz, amelyek sikeresek lehetnek befektetési útján. Miközben a pénzügyi piacok összetettségei között navigál, ne feledje, hogy a tudás keresése hatékony eszköz. [website_title] biztosítja a boldoguláshoz szükséges ismereteket és készségeket, akár indul, akár finomítani szeretné stratégiáit.',
                        $locale,
                        ['website_title' => $website_title],
                    )); ?>

                    </p>
                <p class="gt-block">
                    <?php echo e(aiTrans(
                        'Fedezze fel az ajánlatokat [website_title], merüljön el a tanfolyamokon, lépjen kapcsolatba a közösséggel, és használja ki a lehetőséget, hogy jobban megértse a befektetési elveket. A folyamatos tanulás elköteleződésével felvértezi magát a megalapozott döntések meghozatalához, a kockázatok hatékony kezeléséhez és a növekedési lehetőségek kihasználásához szükséges eszközökkel.',
                        $locale,
                        ['website_title' => $website_title],
                    )); ?>

                    </p>
            </div>
        </div>
    </div>
</section>

<section class="section2">
    <div class="uk-container uk-container-small">
        <h2 class="uk-text-center f70">
            <?php echo e(aiTrans(
                'Gyakran ismételt kérdések a [website_title] ',
                $locale,
                ['website_title' => $website_title],
            )); ?>

            </h2>
        <div class="uk-container">
            <div uk-grid>
                <div class="uk-width-1-4@s"></div>
                <div class="uk-width-expand@s">
                    <ul uk-accordion="collapsible: false; active: false">
                        <li>
                            <a class="uk-accordion-title" href="#"><svg class="e-font-icon-svg e-fas-caret-right" viewBox="0 0 192 512" xmlns="http://www.w3.org/2000/svg">
                                    <path d="M0 384.662V127.338c0-17.818 21.543-26.741 34.142-14.142l128.662 128.662c7.81 7.81 7.81 20.474 0 28.284L34.142 398.804C21.543 411.404 0 402.48 0 384.662z"></path>
                                </svg>
                                <?php echo e(aiTrans(
                                    '[website_title] Egyszerű használhatóságot kínál?',
                                    $locale,
                                    ['website_title' => $website_title],
                                )); ?>

                                </a>
                            <div class="uk-accordion-content">
                                <p>
                                    <?php echo e(aiTrans(
                                        'a [website_title], a navigáció és a platform használata intuitív és egyszerű. A weboldal célja, hogy leegyszerűsítse a regisztrációt, és összekapcsolja Önt a nagyszerű oktatási társaságokkal.',
                                        $locale,
                                        ['website_title' => $website_title],
                                    )); ?>

                                    </p>
                            </div>
                        </li>
                        <li>
                            <a class="uk-accordion-title" href="#"><svg class="e-font-icon-svg e-fas-caret-right" viewBox="0 0 192 512" xmlns="http://www.w3.org/2000/svg">
                                    <path d="M0 384.662V127.338c0-17.818 21.543-26.741 34.142-14.142l128.662 128.662c7.81 7.81 7.81 20.474 0 28.284L34.142 398.804C21.543 411.404 0 402.48 0 384.662z"></path>
                                </svg>
                                <?php echo e(aiTrans(
                                    'El [website_title] Ennek nincs költsége?',
                                    $locale,
                                    ['website_title' => $website_title],
                                )); ?>

                                </a>
                            <div class="uk-accordion-content">
                                <p>
                                    <?php echo e(aiTrans(
                                        'Igen, [website_title] 24 teljesen ingyenes. A regisztráció nem kerül semmibe, és nincsenek rejtett díjak. Nyitott minden, a pénzügyi ismeretek elsajátítása iránt érdeklődő számára.',
                                        $locale,
                                        ['website_title' => $website_title],
                                    )); ?>

                                    </p>
                            </div>
                        </li>
                        <li>
                            <a class="uk-accordion-title" href="#"><svg class="e-font-icon-svg e-fas-caret-right" viewBox="0 0 192 512" xmlns="http://www.w3.org/2000/svg">
                                    <path d="M0 384.662V127.338c0-17.818 21.543-26.741 34.142-14.142l128.662 128.662c7.81 7.81 7.81 20.474 0 28.284L34.142 398.804C21.543 411.404 0 402.48 0 384.662z"></path>
                                </svg>
                                <?php echo e(aiTrans(
                                    '[website_title] Kínál befektetési leckéket?',
                                    $locale,
                                    ['website_title' => $website_title],
                                )); ?>

                                </a>
                            <div class="uk-accordion-content">
                                <p>
                                    <?php echo e(aiTrans(
                                        'En [website_title] A befektetési oktatást nem kínálják közvetlenül, mivel ez nem oktatási egység. Inkább összekötőként működik a befektetés iránt érdeklődők és a releváns befektetési oktatási szolgáltatók között.',
                                        $locale,
                                        ['website_title' => $website_title],
                                    )); ?>

                                    </p>
                            </div>
                        </li>
                    </ul>
                </div>
                <div class="uk-width-1-4@s"></div>
            </div>
        </div>
    </div>
</section>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/enng1/public_html/immediate13.com/resources/views/frontend/hu/home.blade.php ENDPATH**/ ?>