<?php $__env->startPush('meta'); ?>
    <title><?php echo e("$website_title - Sécurité et Confidentialité"); ?></title>
    <meta name="description" content="<?php echo e("Nos stricts mécanismes de sécurité sur $website_title vous garantissent un parcours en ligne sécurisé et paisible pour vos données"); ?>" />
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
    <div class="container page-inner pt-5">
        <h1><?php echo e(aiTrans('Politique de confidentialité')); ?></h1>
        <main>
            <p><span class="b"><?php echo e(aiTrans('Fournisseur')); ?></span> <?php echo e(aiTrans('("nous", "notre" ou "notre") exploite le')); ?>

                <span class="u"><?php echo e($website_title); ?></span>
                <?php echo e(aiTrans('site Web (le “Service”).')); ?></p>
            <p><?php echo e(aiTrans('Cette page vous informe de nos politiques concernant la collecte, l’utilisation et la divulgation de données personnelles lorsque vous utilisez notre Service et des choix que vous avez associés à ces données.')); ?>

            </p>
            <p><?php echo e(aiTrans('Cette page vous informe de nos politiques concernant la collecte, l’utilisation et la divulgation de données personnelles lorsque vous utilisez notre Service et des choix que vous avez associés à ces données.')); ?>

            </p>
            <p><?php echo e(aiTrans('Nous,')); ?> <a href="<?php echo e(route('home', $country)); ?>"> <?php echo e($website_title); ?></a>,
                <?php echo e(aiTrans('utilisons vos données pour fournir et améliorer le Service. En utilisant le Service, vous consentez à la collecte et à l’utilisation d’informations conformément à cette politique. Sauf définition contraire dans cette Politique de confidentialité, les termes utilisés dans cette Politique de confidentialité ont la même signification que dans nos Conditions générales, accessibles depuis')); ?>

                <span class="u"><?php echo e($website_title); ?></span></p>
            <div id="toc_container" class="no_bullets">
                <ul class="toc_list">
                    <ul>
                        <li>
                            <ul>
                                <li><a href="#Definitions"><span class="toc_number toc_depth_3">0.0.1</span>
                                        <?php echo e(aiTrans('Définitions')); ?></a>
                                    <ul>
                                        <li><a href="#Service"><span class="toc_number toc_depth_4">0.0.1.1</span>
                                                <?php echo e(aiTrans('Service')); ?></a></li>
                                    </ul>
                                </li>
                                <li><a href="#Personal_Data"><span class="toc_number toc_depth_3">0.0.2</span>
                                        <?php echo e(aiTrans('Données personnelles')); ?></a></li>
                                <li><a href="#Usage_Data"><span class="toc_number toc_depth_3">0.0.3</span>
                                        <?php echo e(aiTrans('Données d’utilisation')); ?></a></li>
                                <li><a href="#Cookies"><span class="toc_number toc_depth_3">0.0.4</span>
                                        <?php echo e(aiTrans('Cookies')); ?></a></li>
                                <li><a href="#Data_Controller"><span class="toc_number toc_depth_3">0.0.5</span>
                                        <?php echo e(aiTrans('Responsable du traitement des données')); ?></a></li>
                                <li><a href="#Data_Processors_or_Service_Providers"><span
                                            class="toc_number toc_depth_3">0.0.6</span>
                                        <?php echo e(aiTrans('Sous-traitants de données (ou fournisseurs de services)')); ?></a></li>
                                <li><a href="#Data_Subject_or_User"><span class="toc_number toc_depth_3">0.0.7</span>
                                        <?php echo e(aiTrans('Personne concernée (ou utilisateur)')); ?></a></li>
                            </ul>
                        </li>
                    </ul>
                    <li><a href="#Information_Collection_And_Use"><span class="toc_number toc_depth_1">1</span>
                            <?php echo e(aiTrans('Collecte et utilisation des informations')); ?></a>
                        <ul>
                            <li>
                                <ul>
                                    <li><a href="#Types_of_Data_Collected"><span class="toc_number toc_depth_3">1.0.1</span>
                                            <?php echo e(aiTrans('Types de données collectées')); ?></a></li>
                                    <li><a href="#Personal_Data-2"><span class="toc_number toc_depth_3">1.0.2</span>
                                            <?php echo e(aiTrans('Données personnelles')); ?></a></li>
                                    <li><a href="#Usage_Data-2"><span class="toc_number toc_depth_3">1.0.3</span>
                                            <?php echo e(aiTrans('Données d’utilisation')); ?></a></li>
                                    <li><a href="#Tracking_Cookies_Data"><span class="toc_number toc_depth_3">1.0.4</span>
                                            <?php echo e(aiTrans('Données des cookies de suivi')); ?></a></li>
                                    <li><a href="#Use_of_Data"><span class="toc_number toc_depth_3">1.0.5</span>
                                            <?php echo e(aiTrans('Utilisation des données')); ?></a></li>
                                    <li><a
                                            href="#Legal_Basis_for_Processing_Personal_Data_Under_General_Data_Protection_Regulation_GDPR"><span
                                                class="toc_number toc_depth_3">1.0.6</span>
                                            <?php echo e(aiTrans('Base légale pour le traitement des données personnelles en vertu du Règlement général sur la protection des données (RGPD)')); ?></a>
                                    </li>
                                    <li><a href="#Retention_of_Data"><span class="toc_number toc_depth_3">1.0.7</span>
                                            <?php echo e(aiTrans('Conservation des données')); ?></a></li>
                                </ul>
                            </li>
                        </ul>
                    </li>
                    <li><a href="#Transfer_Of_Data"><span class="toc_number toc_depth_1">2</span>
                            <?php echo e(aiTrans('Transfert de données')); ?></a>
                        <ul>
                            <li>
                                <ul>
                                    <li><a href="#Disclosure_Of_Data"><span class="toc_number toc_depth_3">2.0.1</span>
                                            <?php echo e(aiTrans('Divulgation des données')); ?>

                                            <ul>
                                                <li><a href="#Business_Transaction"><span
                                                            class="toc_number toc_depth_4">2.0.1.1</span>
                                                        <?php echo e(aiTrans('Transaction commerciale')); ?></a></li>
                                            </ul>
                                    </li>
                                    <li><a href="#Legal_Requirements"><span class="toc_number toc_depth_3">2.0.2</span>
                                            <?php echo e(aiTrans('Exigences légales')); ?></a></li>
                                    <li><a href="#Security_Of_Data"><span class="toc_number toc_depth_3">2.0.3</span>
                                            <?php echo e(aiTrans('Sécurité des données')); ?></a></li>
                                    <li><a
                                            href="#Your_Data_Protection_Rights_Under_General_Data_Protection_Regulation_GDPR"><span
                                                class="toc_number toc_depth_3">2.0.4</span>
                                            <?php echo e(aiTrans('Vos droits en matière de protection des données en vertu du Règlement général sur la protection des données (RGPD)')); ?></a>
                                    </li>
                                </ul>
                            </li>
                        </ul>
                    </li>

                    <li><a href="#Service_Providers"><span class="toc_number toc_depth_1">3</span>
                            <?php echo e(aiTrans('Fournisseurs de services')); ?></a>
                        <ul>
                            <li>
                                <ul>
                                    <li><a href="#Analytics"><span class="toc_number toc_depth_3">3.0.1</span>
                                            <?php echo e(aiTrans('Analyse')); ?></a></li>
                                    <li><a href="#Advertising"><span class="toc_number toc_depth_3">3.0.2</span>
                                            <?php echo e(aiTrans('Publicité')); ?></a></li>
                                    <li><a href="#Behavioral_Remarketing"><span class="toc_number toc_depth_3">3.0.3</span>
                                            <?php echo e(aiTrans('Remarketing comportemental')); ?></a></li>
                                    <li><a href="#Links_To_Other_Sites"><span class="toc_number toc_depth_3">3.0.4</span>
                                            <?php echo e(aiTrans('Liens vers d’autres sites')); ?></a></li>
                                    <li><a href="#Children8217s_Privacy"><span class="toc_number toc_depth_3">3.0.5</span>
                                            <?php echo e(aiTrans('Vie privée des enfants')); ?></a></li>
                                    <li><a href="#Changes_To_This_Privacy_Policy"><span
                                                class="toc_number toc_depth_3">3.0.6</span>
                                            <?php echo e(aiTrans('Modifications de cette politique de confidentialité')); ?></a></li>
                                    <li><a href="#Contact_Us"><span class="toc_number toc_depth_3">3.0.7</span>
                                            <?php echo e(aiTrans('Contactez-nous')); ?></a></li>
                                </ul>
                            </li>
                        </ul>
                    </li>
                </ul>
            </div>

            <h4><span id="Definitions"><?php echo e(aiTrans('Définitions')); ?></span></h4>
            <h5><span id="Service"><?php echo e(aiTrans('Service')); ?></span></h5>
            <p><?php echo e(aiTrans('Le service est le')); ?> <span class="u"><?php echo e($website_title); ?></span>
                <?php echo e(aiTrans('site Web exploité par')); ?> <span class="b"><?php echo e(aiTrans('Fournisseur')); ?></span></p>
            <h4><span id="Personal_Data"><?php echo e(aiTrans('Données personnelles')); ?></span></h4>

            

            
            <p><?php echo e(aiTrans('Les données personnelles désignent les données concernant une personne vivante qui peut être identifiée à partir de ces données  .')); ?>

            ou à partir de celles-ci ainsi que d'autres informations que nous possédons ou qui pourraient éventuellement devenir disponibles pour nous.
            </p>

            <h4><span id="Usage_Data"><?php echo e(aiTrans('Données d’utilisation')); ?></span></h4>
            <p><?php echo e(aiTrans('Les données d’utilisation sont des données collectées automatiquement, soit générées par l’utilisation du Service, soit provenant de l’infrastructure même du Service (par exemple, la durée d’une visite de page).')); ?>

            </p>
            <h4><span id="Cookies"><?php echo e(aiTrans('Cookies')); ?></span></h4>
            <p><?php echo e(aiTrans('Les cookies sont de petits morceaux de données stockés sur votre appareil (ordinateur ou appareil mobile).')); ?></p>
            <h4><span id="Data_Controller"><?php echo e(aiTrans('Responsable du traitement des données')); ?></span></h4>
            <p><?php echo e(aiTrans('Le responsable du traitement des données désigne la personne physique ou morale qui (seul ou conjointement ou en commun avec d’autres personnes) détermine les finalités pour lesquelles et les moyens par lesquels toute information personnelle est, ou doit être, traitée. Pour les besoins de cette politique de confidentialité, nous sommes un responsable du traitement de vos données personnelles.')); ?>

            </p>
            <h4><span
                    id="Data_Processors_or_Service_Providers"><?php echo e(aiTrans('Sous-traitants de données (ou fournisseurs de services)')); ?></span>
            </h4>
            <p><?php echo e(aiTrans('Le sous-traitant de données (ou fournisseur de services) désigne toute personne physique ou morale qui traite les données pour le compte du responsable du traitement. Nous pouvons utiliser les services de divers fournisseurs de services afin de traiter vos données plus efficacement.')); ?>

            </p>
            <h4><span id="Data_Subject_or_User"><?php echo e(aiTrans('Personne concernée (ou utilisateur)')); ?></span></h4>

            <p><?php echo e(aiTrans('La personne concernée est toute personne vivante qui utilise notre Service et fait l’objet de données personnelles.')); ?>

            </p>
            <h2><span id="Information_Collection_And_Use"><?php echo e(aiTrans('Collecte et utilisation des informations')); ?></span></h2>
            <p><?php echo e(aiTrans('Nous collectons plusieurs types d’informations à diverses fins afin de vous fournir et d’améliorer notre Service.')); ?>

            </p>
            <h4><span id="Types_of_Data_Collected"><?php echo e(aiTrans('Types de données collectées')); ?></span></h4>
            <h4><span id="Personal_Data-2"><?php echo e(aiTrans('Données personnelles')); ?></span></h4>
            <p><?php echo e(aiTrans('Lorsque vous utilisez notre Service, nous pouvons vous demander de nous fournir certaines informations personnellement identifiables pouvant être utilisées pour vous contacter ou vous identifier (“Données personnelles”). Les informations personnellement identifiables peuvent inclure, mais ne sont pas limitées à :')); ?>

            </p>
            <ul>
                <li><?php echo e(aiTrans('Adresse e-mail')); ?></li>
                <li><?php echo e(aiTrans('Prénom et nom de famille')); ?></li>
                <li><?php echo e(aiTrans('Numéro de téléphone')); ?></li>
                <li><?php echo e(aiTrans('Adresse, État, Province, Code postal, Ville')); ?></li>
                <li><?php echo e(aiTrans('Cookies et données d’utilisation')); ?></li>
            </ul>
            <p><?php echo e(aiTrans('Nous pouvons utiliser vos données personnelles pour vous contacter avec des bulletins d’information, des matériaux de marketing ou de promotion et d’autres informations qui pourraient vous intéresser. Vous pouvez choisir de ne pas recevoir l’une ou l’ensemble de ces communications de notre part en suivant le lien de désinscription ou les instructions fournies dans tout e-mail que nous envoyons ou en nous contactant.')); ?>

            </p>
            <h4><span id="Usage_Data-2"><?php echo e(aiTrans('Données d’utilisation')); ?></span></h4>
            <p><?php echo e(aiTrans('Nous pouvons également collecter des informations sur la façon dont le Service est accessible et utilisé (“Données d’utilisation”). Ces données d’utilisation peuvent inclure des informations telles que l’adresse de protocole Internet (IP) de votre ordinateur (par exemple, adresse IP), le type de navigateur, la version du navigateur, les pages de notre Service que vous visitez, la date et l’heure de votre visite, le temps passé sur ces pages, des identifiants d’appareil uniques et d’autres données de diagnostic.')); ?>

            </p>
            <h4><span id="Tracking_Cookies_Data"><?php echo e(aiTrans('Données des cookies de suivi')); ?></span></h4>
            <p><?php echo e(aiTrans('Nous utilisons des cookies et des technologies de suivi similaires pour suivre l’activité sur notre Service et détenir certaines informations.')); ?>

            </p>
            <p><?php echo e(aiTrans('Les cookies sont des fichiers contenant un petit nombre de données qui peuvent inclure un identifiant unique anonyme. Les cookies sont envoyés à votre navigateur à partir d’un site Web et sont stockés sur votre appareil. Les technologies de suivi utilisées comprennent également des balises, des balises et des scripts pour collecter et suivre des informations et pour améliorer et analyser notre Service.')); ?>

            </p>
            <p><?php echo e(aiTrans('Vous pouvez indiquer à votre navigateur de refuser tous les cookies ou de signaler lorsqu’un cookie est envoyé. Cependant, si vous n’acceptez pas les cookies, vous ne pourrez peut-être pas utiliser certaines parties de notre Service.')); ?>

            </p>
            <p><?php echo e(aiTrans('Exemples de cookies que nous utilisons :')); ?></p>
            <ul>
                <li><strong><?php echo e(aiTrans('Cookies de session.')); ?></strong>
                    <?php echo e(aiTrans('Nous utilisons des cookies de session pour faire fonctionner notre Service.')); ?></li>
                <li><strong><?php echo e(aiTrans('Cookies de préférence.')); ?></strong>
                    <?php echo e(aiTrans('Nous utilisons des cookies de préférence pour mémoriser vos préférences et divers paramètres.')); ?></li>
                <li><strong><?php echo e(aiTrans('Cookies de sécurité.')); ?></strong>
                    <?php echo e(aiTrans('Nous utilisons des cookies de sécurité à des fins de sécurité.')); ?></li>
                <li><strong><?php echo e(aiTrans('Cookies publicitaires.')); ?></strong>
                    <?php echo e(aiTrans('Les cookies publicitaires sont utilisés pour vous servir des publicités qui pourraient être pertinentes pour vous et vos intérêts.')); ?>

                </li>
            </ul>
            <h4><span id="Use_of_Data"><?php echo e(aiTrans('Utilisation des données')); ?></span></h4>
            <p><span class="b"><?php echo e(aiTrans('Fournisseur')); ?></span>
                <?php echo e(aiTrans('utilise les données collectées à diverses fins :')); ?></p>
            <ul>
                <li><?php echo e(aiTrans('Pour fournir et maintenir notre Service')); ?></li>
                <li><?php echo e(aiTrans('Pour vous notifier des changements apportés à notre Service')); ?></li>
                <li><?php echo e(aiTrans('Pour vous permettre de participer à des fonctionnalités interactives de notre Service lorsque vous choisissez de le faire')); ?>

                </li>
                <li><?php echo e(aiTrans('Pour fournir un support client')); ?></li>
                <li><?php echo e(aiTrans('Pour recueillir des analyses ou des informations précieuses afin que nous puissions améliorer notre Service')); ?></li>
                <li><?php echo e(aiTrans('Pour surveiller l’utilisation de notre Service')); ?></li>
                <li><?php echo e(aiTrans('Pour détecter, prévenir et résoudre des problèmes techniques')); ?></li>
                <li><?php echo e(aiTrans('Pour vous fournir des nouvelles, des offres spéciales et des informations générales sur d’autres biens, services et événements que nous offrons et qui sont similaires à ceux que vous avez déjà achetés ou demandés, sauf si vous avez choisi de ne pas recevoir ces informations')); ?>

                </li>
            </ul>
            <h4><span
                    id="Legal_Basis_for_Processing_Personal_Data_Under_General_Data_Protection_Regulation_GDPR"><?php echo e(aiTrans('Base légale pour le traitement des données personnelles en vertu du Règlement général sur la protection des données (RGPD)')); ?></span>
            </h4>
            <p><?php echo e(aiTrans('Si vous êtes dans l’Espace économique européen (EEE),')); ?> <span
                    class="b"><?php echo e(aiTrans('Fournisseur')); ?></span>
                <?php echo e(aiTrans('la base légale pour la collecte et l’utilisation des informations personnelles décrites dans cette Politique de confidentialité dépend des données personnelles que nous collectons et du contexte spécifique dans lequel nous les collectons.')); ?>

            </p>
            <p><span class="b"><?php echo e(aiTrans('Fournisseur')); ?></span>
                <?php echo e(aiTrans('peut traiter vos données personnelles parce que :')); ?></p>
            <ul>
                <li><?php echo e(aiTrans('Nous devons exécuter un contrat avec vous')); ?></li>
                <li><?php echo e(aiTrans('Vous nous avez donné la permission de le faire')); ?></li>
                <li><?php echo e(aiTrans('Le traitement est dans nos intérêts légitimes et n’est pas dépassé par vos droits')); ?>

                </li>
                <li><?php echo e(aiTrans('Pour respecter la loi')); ?></li>
            </ul>
            <h4><span id="Retention_of_Data"><?php echo e(aiTrans('Conservation des données')); ?></span></h4>
            <p><span class="b"><?php echo e(aiTrans('Fournisseur')); ?></span>
                <?php echo e(aiTrans('conservera vos données personnelles uniquement aussi longtemps que nécessaire aux fins énoncées dans cette Politique de confidentialité. Nous conserverons et utiliserons vos données personnelles dans la mesure nécessaire pour respecter nos obligations légales (par exemple, si nous sommes tenus de conserver vos données pour nous conformer aux lois applicables), résoudre des litiges et faire respecter nos accords et politiques légaux.')); ?>

            </p>
            <p><span class="b"><?php echo e(aiTrans('Fournisseur')); ?></span>
                <?php echo e(aiTrans('conservera également les données d’utilisation à des fins d’analyse interne. Les données d’utilisation sont généralement conservées pendant une période plus courte, sauf lorsque ces données sont utilisées pour renforcer la sécurité ou améliorer la fonctionnalité de notre Service, ou si nous sommes légalement tenus de conserver ces données plus longtemps.')); ?>

            </p>
            <h2><span id="Transfer_Of_Data"><?php echo e(aiTrans('Transfert de données')); ?></span></h2>

            <p><?php echo e(aiTrans('Vos informations, y compris les données personnelles, peuvent être transférées vers — et maintenues sur — des ordinateurs situés en dehors de votre état, province, pays ou autre juridiction gouvernementale où les lois sur la protection des données peuvent différer de celles de votre juridiction.')); ?>

            </p>
            <p><?php echo e(aiTrans('Si vous êtes situé en dehors de la Bulgarie et choisissez de nous fournir des informations, veuillez noter que nous transférons les données, y compris les données personnelles, en Bulgarie et les traitons là-bas.')); ?>

            </p>
            <p><?php echo e(aiTrans('Votre consentement à cette Politique de confidentialité, suivi de votre soumission de telles informations, représente votre accord à ce transfert.')); ?>

            </p>
            <p><span class="b"><?php echo e(aiTrans('Fournisseur')); ?></span>
                <?php echo e(aiTrans('prendra toutes les mesures raisonnablement nécessaires pour s’assurer que vos données sont traitées en toute sécurité et conformément à cette Politique de confidentialité, et aucun transfert de vos données personnelles n’aura lieu vers une organisation ou un pays à moins qu’il n’y ait des contrôles adéquats en place, y compris la sécurité de vos données et d’autres informations personnelles.')); ?>

            </p>
            <h4><span id="Disclosure_Of_Data"><?php echo e(aiTrans('Divulgation des données')); ?></span></h4>
            <h5><span id="Business_Transaction"><?php echo e(aiTrans('Transaction commerciale')); ?></span></h5>
            <p><?php echo e(aiTrans('Si')); ?> <span class="b"><?php echo e(aiTrans('Fournisseur')); ?></span>
                <?php echo e(aiTrans('est impliqué dans une fusion, une acquisition ou une vente d’actifs, vos données personnelles peuvent être transférées. Nous vous informerons avant que vos données personnelles ne soient transférées et deviennent soumises à une autre Politique de confidentialité.')); ?>

            </p>
            <h4><span id="Legal_Requirements"><?php echo e(aiTrans('Exigences légales')); ?></span></h4>
            <p><span class="b"><?php echo e(aiTrans('Fournisseur')); ?></span>
                <?php echo e(aiTrans('peut divulguer vos données personnelles dans la conviction de bonne foi que cette action est nécessaire pour :')); ?>

            </p>
            <ul>
                <li><?php echo e(aiTrans('Se conformer à une obligation légale')); ?></li>
                <li><?php echo e(aiTrans('Protéger et défendre les droits ou la propriété de')); ?> <span
                        class="b"><?php echo e(aiTrans('Fournisseur')); ?></span></li>
                <li><?php echo e(aiTrans('Prévenir ou enquêter sur un éventuel méfait en lien avec le Service')); ?></li>
                <li><?php echo e(aiTrans('Protéger la sécurité personnelle des utilisateurs du Service ou du public')); ?></li>
                <li><?php echo e(aiTrans('Se protéger contre la responsabilité légale')); ?></li>
            </ul>
            <h4><span id="Security_Of_Data"><?php echo e(aiTrans('Sécurité des données')); ?></span></h4>
            <p><?php echo e(aiTrans('La sécurité de vos données est importante pour nous, mais rappelez-vous qu’aucun mode de transmission sur Internet, ni méthode de stockage électronique n’est 100 % sécurisé. Bien que nous nous efforçons d’utiliser des moyens commercialement acceptables pour protéger vos données personnelles, nous ne pouvons pas garantir sa sécurité absolue.')); ?>

            </p>
            <h4><span
                    id="Your_Data_Protection_Rights_Under_General_Data_Protection_Regulation_GDPR"><?php echo e(aiTrans('Vos droits en matière de protection des données en vertu du Règlement général sur la protection des données (RGPD)')); ?></span>
            </h4>
            <p><?php echo e(aiTrans('Si vous êtes un résident de l’Espace économique européen (EEE), vous avez certains droits en matière de protection des données.')); ?>

                <span class="b"><?php echo e(aiTrans('Fournisseur')); ?></span>
                <?php echo e(aiTrans('vise à prendre des mesures raisonnables pour vous permettre de corriger, modifier, supprimer ou limiter l’utilisation de vos données personnelles.')); ?>

            </p>
            <p><?php echo e(aiTrans('Si vous souhaitez savoir quelles données personnelles nous détenons à votre sujet et si vous souhaitez qu’elles soient supprimées de nos systèmes, veuillez nous contacter.')); ?>

            </p>
            <p><?php echo e(aiTrans('Dans certaines circonstances, vous avez les droits suivants en matière de protection des données :')); ?></p>
            <p><strong><?php echo e(aiTrans('Le droit d’accès, de mise à jour ou de suppression des informations que nous avons sur vous.')); ?></strong>
                <?php echo e(aiTrans('Lorsque cela est possible, vous pouvez accéder, mettre à jour ou demander la suppression de vos données personnelles directement dans la section de paramètres de votre compte. Si vous ne pouvez pas effectuer ces actions vous-même, veuillez nous contacter pour vous aider.')); ?><br>
                <strong><?php echo e(aiTrans('Le droit de rectification.')); ?></strong>
                <?php echo e(aiTrans('Vous avez le droit de faire rectifier vos informations si elles sont inexactes ou incomplètes.')); ?><br>
                <strong><?php echo e(aiTrans('Le droit de s’opposer.')); ?></strong>
                <?php echo e(aiTrans('Vous avez le droit de vous opposer à notre traitement de vos données personnelles.')); ?><br>
                <strong><?php echo e(aiTrans('Le droit de restriction.')); ?></strong>
                <?php echo e(aiTrans('Vous avez le droit de demander que nous limitions le traitement de vos informations personnelles.')); ?><br>
                <strong><?php echo e(aiTrans('Le droit à la portabilité des données.')); ?></strong>
                <?php echo e(aiTrans('Vous avez le droit de recevoir une copie des informations que nous avons sur vous dans un format structuré, lisible par machine et couramment utilisé.')); ?><br>
                <strong><?php echo e(aiTrans('Le droit de retirer son consentement.')); ?></strong>
                <?php echo e(aiTrans('Vous avez également le droit de retirer votre consentement à tout moment lorsque')); ?> <span
                    class="b"><?php echo e(aiTrans('Fournisseur')); ?></span>
                <?php echo e(aiTrans('s’est fondé sur votre consentement pour traiter vos informations personnelles.')); ?></p>
            <p><?php echo e(aiTrans('Veuillez noter que nous pouvons vous demander de vérifier votre identité avant de répondre à de telles demandes.')); ?>

            </p>
            <p><?php echo e(aiTrans('Vous avez le droit de porter plainte auprès d’une autorité de protection des données concernant notre collecte et notre utilisation de vos données personnelles. Pour plus d’informations, veuillez contacter votre autorité locale de protection des données dans l’Espace économique européen (EEE).')); ?>

            </p>
            <h2><span id="Service_Providers"><?php echo e(aiTrans('Fournisseurs de services')); ?></span></h2>


            <p><?php echo e(aiTrans('Nous pouvons employer des entreprises et des individus tiers pour faciliter notre Service (“Fournisseurs de services”), fournir le Service en notre nom, exécuter des services liés au Service ou nous aider à analyser comment notre Service est utilisé.')); ?>

            </p>
            <p><?php echo e(aiTrans('Ces tiers ont accès à vos données personnelles uniquement pour effectuer ces tâches en notre nom et sont tenus de ne pas les divulguer ou les utiliser à d’autres fins.')); ?>

            </p>

            <h4><span id="Analytics"><?php echo e(aiTrans('Analyse')); ?></span></h4>
            <p><?php echo e(aiTrans('Nous pouvons utiliser des Fournisseurs de services tiers pour surveiller et analyser l’utilisation de notre Service.')); ?>

            </p>

            <p><strong><?php echo e(aiTrans('Google Analytics')); ?></strong><br>
                <?php echo e(aiTrans('
                Google Analytics est un service d’analyse Web proposé par Google qui suit et rapporte le trafic des sites Web. Google utilise les données collectées pour suivre et surveiller l’utilisation de notre Service. Ces données sont partagées avec d’autres services de Google. Google peut utiliser les données collectées pour contextualiser et personnaliser les annonces de son propre réseau publicitaire. Vous pouvez choisir de ne pas rendre votre activité sur le Service accessible à Google Analytics en installant le module complémentaire de désinscription de Google Analytics. Le module complémentaire empêche le JavaScript de Google Analytics (ga.js, analytics.js, and dc.js) de partager des informations avec Google Analytics concernant le comportement des visites. Pour plus de détails sur les pratiques de confidentialité de Google, veuillez visiter la page des Conditions de confidentialité de Google:
                ')); ?>

http://www.google.com/intl/en/policies/privacy/
            <h4><span id="Advertising"><?php echo e(aiTrans('Publicité')); ?></span></h4>
            <p><?php echo e(aiTrans('Nous pouvons utiliser des Fournisseurs de services tiers pour vous montrer des publicités afin d’aider à soutenir et à maintenir notre Service.')); ?>

            </p>
            <p><strong><?php echo e(aiTrans('Cookie DoubleClick de Google AdSense')); ?></strong><br>
                <?php echo e(aiTrans('Google, en tant que fournisseur tiers, utilise des cookies pour diffuser des annonces sur notre Service. L’utilisation par Google du cookie DoubleClick permet à lui et à ses partenaires de diffuser des annonces à nos utilisateurs en fonction de leur visite à notre Service ou à d’autres sites Web sur Internet. Vous pouvez choisir de ne pas utiliser le cookie DoubleClick pour la publicité basée sur les intérêts en visitant la page des paramètres des annonces de Google :')); ?>

                http://www.google.com/ads/preferences</p>
            <h4><span id="Behavioral_Remarketing"><?php echo e(aiTrans('Remarketing comportemental')); ?></span></h4>
            <p><span class="b"><?php echo e(aiTrans('Fournisseur')); ?></span>
                <?php echo e(aiTrans('utilise des services de remarketing pour faire de la publicité sur des sites Web tiers après que vous ayez visité notre Service. Nous et nos fournisseurs tiers utilisons des cookies pour informer, optimiser et servir des annonces en fonction de vos visites passées à notre Service.')); ?>

            </p>
            <p><strong><?php echo e(aiTrans('Google AdWords')); ?></strong><br>
                <?php echo e(aiTrans('Le service de remarketing Google AdWords est fourni par Google Inc. Vous pouvez vous désinscrire de Google Analytics pour la publicité Display et personnaliser les annonces du réseau Display de Google en visitant la page des paramètres des annonces de Google :')); ?>

                <a href="http://www.google.com/settings/ads" target="_blank"
                    rel="noopener"><?php echo e(aiTrans('http://www.google.com/settings/ads')); ?></a>
                <?php echo e(aiTrans('Google recommande également d’installer le module complémentaire pour le navigateur pour la désinscription de Google Analytics –')); ?> <a
                    href="https://tools.google.com/dlpage/gaoptout" target="_blank"
                    rel="noopener">https://tools.google.com/dlpage/gaoptout</a> –
                <?php echo e(aiTrans('pour votre navigateur Web. Le module complémentaire de désinscription de Google Analytics offre aux visiteurs la possibilité d’empêcher leurs données d’être collectées et utilisées par Google Analytics. Pour plus d’informations sur les pratiques de confidentialité de Google, veuillez visiter la page des Conditions de confidentialité de Google :')); ?>

                <a href="https://www.google.com/intl/en/policies/privacy/" target="_blank"
                    rel="noopener">http://www.google.com/intl/en/policies/privacy</a></p>
            <p><strong><?php echo e(aiTrans('Facebook')); ?></strong><br>
                <?php echo e(aiTrans('Le service de remarketing de Facebook est fourni par Facebook Inc. Vous pouvez en savoir plus sur la publicité basée sur les intérêts de Facebook en visitant cette page :')); ?>

                <a href="<?php echo e(route('home', $country)); ?>" target="_blank"
                    rel="noopener"><?php echo e(route('home', $country)); ?></a>
                <?php echo e(aiTrans('Pour vous désinscrire des annonces basées sur les intérêts de Facebook, suivez ces instructions de Facebook :')); ?> https://www.facebook.com/help/568137493302217
                <?php echo e(aiTrans('Facebook respecte les Principes d’Autorégulation pour la Publicité Comportementale en Ligne établis par l’Alliance pour la Publicité Numérique. Vous pouvez également vous désinscrire de Facebook et d’autres entreprises participantes par l’intermédiaire de l’Alliance pour la Publicité Numérique aux États-Unis')); ?>

                ,
                <?php echo e(aiTrans('l’Alliance pour la Publicité Numérique du Canada au Canada')); ?> 
                <?php echo e(aiTrans('ou l’Alliance Européenne pour la Publicité Numérique Interactive en Europe')); ?> ,
                <?php echo e(aiTrans('ou vous désinscrire en utilisant les paramètres de votre appareil mobile. Pour plus d’informations sur les pratiques de confidentialité de Facebook, veuillez consulter la Politique de données de Facebook :')); ?>

                </p>
            <h4><span id="Links_To_Other_Sites"><?php echo e(aiTrans('Liens vers d’autres sites')); ?></span></h4>
            <p><?php echo e(aiTrans('Notre Service peut contenir des liens vers d’autres sites qui ne sont pas exploités par nous. Si vous cliquez sur un lien tiers, vous serez dirigé vers le site de ce tiers. Nous vous conseillons fortement de consulter la Politique de confidentialité de chaque site que vous visitez.')); ?>

            </p>
            <p><?php echo e(aiTrans('Nous n’avons aucun contrôle sur et n’assumons aucune responsabilité pour le contenu, les politiques de confidentialité ou les pratiques de tout site ou service tiers.')); ?>

            </p>
            <h4><span id="Children8217s_Privacy"><?php echo e(aiTrans('Vie privée des enfants')); ?></span></h4>
            <p><?php echo e(aiTrans('Notre Service ne s’adresse à personne de moins de 18 ans (“Enfants”).')); ?></p>
            <p><?php echo e(aiTrans('Nous ne collectons pas sciemment d’informations personnellement identifiables de quiconque âgé de moins de 18 ans. Si vous êtes un parent ou un tuteur et que vous êtes au courant que vos Enfants nous ont fourni des données personnelles, veuillez nous contacter. Si nous apprenons que nous avons collecté des données personnelles d’enfants sans vérification du consentement parental, nous prenons des mesures pour supprimer ces informations de nos serveurs.')); ?>

            </p>
            <h4><span id="Changes_To_This_Privacy_Policy"><?php echo e(aiTrans('Modifications de cette politique de confidentialité')); ?></span></h4>
            <p><?php echo e(aiTrans('Nous pouvons mettre à jour notre Politique de confidentialité de temps à autre. Nous vous informerons de tout changement en publiant la nouvelle Politique de confidentialité sur cette page.')); ?>

            </p>
            <p><?php echo e(aiTrans('Nous vous informerons par e-mail et/ou par un avis visible sur notre Service, avant que le changement ne devienne effectif et mettrons à jour la “date d’entrée en vigueur” en haut de cette Politique de confidentialité.')); ?>

            </p>
            <p><?php echo e(aiTrans('Vous êtes conseillé de revoir cette Politique de confidentialité périodiquement pour tout changement. Les changements apportés à cette Politique de confidentialité entrent en vigueur lorsqu’ils sont publiés sur cette page.')); ?>

            </p>
            <h4><span id="Contact_Us"><?php echo e(aiTrans('Contactez-nous')); ?></span></h4>
            <p><?php echo e(aiTrans('Si vous avez des questions concernant cette Politique de confidentialité, veuillez nous contacter .')); ?></p>
        </main>
    </div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/enng1/public_html/immediate13.com/resources/views/frontend/fr/privacy.blade.php ENDPATH**/ ?>