<?php $__env->startPush('meta'); ?>
    <title><?php echo e("$website_title - 关于您的信息隐私政策声明"); ?></title>
    <meta name="description" content="<?php echo e("$website_title 的网络隐私保护全攻略：详尽剖析我们的政策，附上防护策略，坚决保护您的信息安全，使信息管理完全透明，我们承诺给您提供专业和值得信赖的安全保障。"); ?>" />
<?php $__env->stopPush(); ?>
<?php $__env->startSection('content'); ?>
    <div class="container page-inner pt-5">
        <h1><?php echo e(aiTrans('隱私政策')); ?></h1>
        <main>
            <p><span class="b"><?php echo e(aiTrans('提供者')); ?></span> <?php echo e(aiTrans('("我們", "我們", 或 "我們的") 經營')); ?>

                <span class="u"><?php echo e($website_title); ?></span>
                <?php echo e(aiTrans('網站 (本“服務”).')); ?></p>
            <p><?php echo e(aiTrans('本頁面告知您我們關於收集、使用和披露個人數據的政策，當您使用我們的服務時，以及您與該數據相關的選擇。')); ?>

            </p>
            <p><?php echo e(aiTrans('本頁面告知您我們關於收集、使用和披露個人數據的政策，當您使用我們的服務時，以及您與該數據相關的選擇。')); ?>

            </p>
            <p><?php echo e(aiTrans('我們，')); ?> <a href="<?php echo e(route('home', $country)); ?>"> <?php echo e($website_title); ?></a>,
                <?php echo e(aiTrans('使用您的數據來提供和改善服務。通過使用本服務，您同意根據本政策收集和使用信息。除非在本隱私政策中另有定義，否則本隱私政策中使用的術語具有與我們的條款和條件相同的含義，條款和條件可從')); ?>

                <span class="u"><?php echo e($website_title); ?></span></p>
            <div id="toc_container" class="no_bullets">
                <ul class="toc_list">
                    <ul>
                        <li>
                            <ul>
                                <li><a href="#定義"><span class="toc_number toc_depth_3">0.0.1</span>
                                        <?php echo e(aiTrans('定義')); ?></a>
                                    <ul>
                                        <li><a href="#服務"><span class="toc_number toc_depth_4">0.0.1.1</span>
                                                <?php echo e(aiTrans('服務')); ?></a></li>
                                    </ul>
                                </li>
                                <li><a href="#個人數據"><span class="toc_number toc_depth_3">0.0.2</span>
                                        <?php echo e(aiTrans('個人數據')); ?></a></li>
                                <li><a href="#使用數據"><span class="toc_number toc_depth_3">0.0.3</span>
                                        <?php echo e(aiTrans('使用數據')); ?></a></li>
                                <li><a href="#Cookies"><span class="toc_number toc_depth_3">0.0.4</span>
                                        <?php echo e(aiTrans('Cookies')); ?></a></li>
                                <li><a href="#數據控制者"><span class="toc_number toc_depth_3">0.0.5</span>
                                        <?php echo e(aiTrans('數據控制者')); ?></a></li>
                                <li><a href="#數據處理者或服務提供者"><span
                                            class="toc_number toc_depth_3">0.0.6</span>
                                        <?php echo e(aiTrans('數據處理者 (或服務提供者)')); ?></a></li>
                                <li><a href="#數據主體或用戶"><span class="toc_number toc_depth_3">0.0.7</span>
                                        <?php echo e(aiTrans('數據主體 (或用戶)')); ?></a></li>
                            </ul>
                        </li>
                    </ul>
                    <li><a href="#信息收集與使用"><span class="toc_number toc_depth_1">1</span>
                            <?php echo e(aiTrans('信息收集與使用')); ?></a>
                        <ul>
                            <li>
                                <ul>
                                    <li><a href="#收集的數據類型"><span class="toc_number toc_depth_3">1.0.1</span>
                                            <?php echo e(aiTrans('收集的數據類型')); ?></a></li>
                                    <li><a href="#個人數據-2"><span class="toc_number toc_depth_3">1.0.2</span>
                                            <?php echo e(aiTrans('個人數據')); ?></a></li>
                                    <li><a href="#使用數據-2"><span class="toc_number toc_depth_3">1.0.3</span>
                                            <?php echo e(aiTrans('使用數據')); ?></a></li>
                                    <li><a href="#追踪Cookies數據"><span class="toc_number toc_depth_3">1.0.4</span>
                                            <?php echo e(aiTrans('追踪Cookies數據')); ?></a></li>
                                    <li><a href="#數據的使用"><span class="toc_number toc_depth_3">1.0.5</span>
                                            <?php echo e(aiTrans('數據的使用')); ?></a></li>
                                    <li><a
                                            href="#根據一般數據保護條例GDPR處理個人數據的法律依據"><span
                                                class="toc_number toc_depth_3">1.0.6</span>
                                            <?php echo e(aiTrans('根據一般數據保護條例 (GDPR) 處理個人數據的法律依據')); ?></a>
                                    </li>
                                    <li><a href="#數據的保留"><span class="toc_number toc_depth_3">1.0.7</span>
                                            <?php echo e(aiTrans('數據的保留')); ?></a></li>
                                </ul>
                            </li>
                        </ul>
                    </li>
                    <li><a href="#數據的轉移"><span class="toc_number toc_depth_1">2</span>
                            <?php echo e(aiTrans('數據的轉移')); ?></a>
                        <ul>
                            <li>
                                <ul>
                                    <li><a href="#數據的披露"><span class="toc_number toc_depth_3">2.0.1</span>
                                            <?php echo e(aiTrans('數據的披露')); ?>

                                            <ul>
                                                <li><a href="#商業交易"><span
                                                            class="toc_number toc_depth_4">2.0.1.1</span>
                                                        <?php echo e(aiTrans('商業交易')); ?></a></li>
                                            </ul>
                                    </li>
                                    <li><a href="#法律要求"><span class="toc_number toc_depth_3">2.0.2</span>
                                            <?php echo e(aiTrans('法律要求')); ?></a></li>
                                    <li><a href="#數據的安全性"><span class="toc_number toc_depth_3">2.0.3</span>
                                            <?php echo e(aiTrans('數據的安全性')); ?></a></li>
                                    <li><a
                                            href="#根據一般數據保護條例GDPR的您的數據保護權利"><span
                                                class="toc_number toc_depth_3">2.0.4</span>
                                            <?php echo e(aiTrans('根據一般數據保護條例 (GDPR) 的您的數據保護權利')); ?></a>
                                    </li>
                                </ul>
                            </li>
                        </ul>
                    </li>
                    <li><a href="#服務提供者"><span class="toc_number toc_depth_1">3</span>
                            <?php echo e(aiTrans('服務提供者')); ?></a>
                        <ul>
                            <li>
                                <ul>
                                    <li><a href="#分析"><span class="toc_number toc_depth_3">3.0.1</span>
                                            <?php echo e(aiTrans('分析')); ?></a></li>
                                    <li><a href="#廣告"><span class="toc_number toc_depth_3">3.0.2</span>
                                            <?php echo e(aiTrans('廣告')); ?></a></li>
                                    <li><a href="#行為再營銷"><span class="toc_number toc_depth_3">3.0.3</span>
                                            <?php echo e(aiTrans('行為再營銷')); ?></a></li>
                                    <li><a href="#鏈接到其他網站"><span class="toc_number toc_depth_3">3.0.4</span>
                                            <?php echo e(aiTrans('鏈接到其他網站')); ?></a></li>
                                    <li><a href="#兒童隱私"><span class="toc_number toc_depth_3">3.0.5</span>
                                            <?php echo e(aiTrans('兒童隱私')); ?></a></li>
                                    <li><a href="#對本隱私政策的更改"><span
                                                class="toc_number toc_depth_3">3.0.6</span>
                                            <?php echo e(aiTrans('對本隱私政策的更改')); ?></a></li>
                                    <li><a href="#聯繫我們"><span class="toc_number toc_depth_3">3.0.7</span>
                                            <?php echo e(aiTrans('聯繫我們')); ?></a></li>
                                </ul>
                            </li>
                        </ul>
                    </li>
                </ul>
            </div>
            <h4><span id="定義"><?php echo e(aiTrans('定義')); ?></span></h4>
            <h5><span id="服務"><?php echo e(aiTrans('服務')); ?></span></h5>
            <p><?php echo e(aiTrans('服務是由')); ?> <span class="u"><?php echo e($website_title); ?></span>
                <?php echo e(aiTrans('運營的網站')); ?> <span class="b"><?php echo e(aiTrans('提供者')); ?></span></p>
            <h4><span id="個人數據"><?php echo e(aiTrans('個人數據')); ?></span></h4>
            <p><?php echo e(aiTrans('個人數據是指可以從這些數據中識別出生活個體的數據（或從這些數據和我們擁有的其他信息中可以識別的數據）。')); ?>

            </p>
            <h4><span id="使用數據"><?php echo e(aiTrans('使用數據')); ?></span></h4>
            <p><?php echo e(aiTrans('使用數據是自動收集的數據，無論是通過服務的使用生成，還是來自服務基礎設施本身（例如，頁面訪問的持續時間）。')); ?>

            </p>
            <h4><span id="Cookies"><?php echo e(aiTrans('Cookies')); ?></span></h4>
            <p><?php echo e(aiTrans('Cookies是存儲在您的設備（計算機或移動設備）上的小數據片段。')); ?></p>
            <h4><span id="數據控制者"><?php echo e(aiTrans('數據控制者')); ?></span></h4>
            <p><?php echo e(aiTrans('數據控制者是指決定個人信息的處理目的和方式的自然人或法人（無論是單獨、共同還是與其他人共同）。在本隱私政策中，我們是您的個人數據的數據控制者。')); ?>

            </p>
            <h4><span
                    id="數據處理者或服務提供者"><?php echo e(aiTrans('數據處理者 (或服務提供者)')); ?></span>
            </h4>
            <p><?php echo e(aiTrans('數據處理者（或服務提供者）是指代表數據控制者處理數據的任何自然人或法人。我們可能會使用各種服務提供者的服務，以便更有效地處理您的數據。')); ?>

            </p>
            <h4><span id="數據主體或用戶"><?php echo e(aiTrans('數據主體 (或用戶)')); ?></span></h4>
            <p><?php echo e(aiTrans('數據主體是指使用我們的服務並且是個人數據主體的任何生活個體。')); ?>

            </p>
            <h2><span id="信息收集與使用"><?php echo e(aiTrans('信息收集與使用')); ?></span></h2>
            <p><?php echo e(aiTrans('我們收集多種類型的信息，旨在為您提供和改善我們的服務。')); ?>

            </p>
            <h4><span id="收集的數據類型"><?php echo e(aiTrans('收集的數據類型')); ?></span></h4>
            <h4><span id="個人數據-2"><?php echo e(aiTrans('個人數據')); ?></span></h4>
            <p><?php echo e(aiTrans('在使用我們的服務時，我們可能會要求您提供某些可識別個人的信息，可用於聯繫或識別您（“個人數據”）。可識別個人的信息可能包括但不限於：')); ?>

            </p>
            <ul>
                <li><?php echo e(aiTrans('電子郵件地址')); ?></li>
                <li><?php echo e(aiTrans('名字和姓氏')); ?></li>
                <li><?php echo e(aiTrans('電話號碼')); ?></li>
                <li><?php echo e(aiTrans('地址、州、省、郵政編碼、城市')); ?></li>
                <li><?php echo e(aiTrans('Cookies和使用數據')); ?></li>
            </ul>
            <p><?php echo e(aiTrans('我們可能會使用您的個人數據與您聯繫，發送新聞稿、營銷或促銷材料及其他可能對您感興趣的信息。您可以通過點擊我們發送的電子郵件中的退訂鏈接或說明，或者通過聯繫我們選擇不接收任何或所有這些通信。')); ?>

            </p>
            <h4><span id="使用數據-2"><?php echo e(aiTrans('使用數據')); ?></span></h4>
            <p><?php echo e(aiTrans('我們也可能收集有關服務的訪問和使用的信息（“使用數據”）。這些使用數據可能包括您的計算機的互聯網協議地址（例如IP地址）、瀏覽器類型、瀏覽器版本、您訪問的我們服務的頁面、訪問的時間和日期、在這些頁面上花費的時間、唯一設備標識符和其他診斷數據。')); ?>

            </p>
            <h4><span id="追踪Cookies數據"><?php echo e(aiTrans('追踪Cookies數據')); ?></span></h4>
            <p><?php echo e(aiTrans('我們使用Cookies和類似的追踪技術來跟踪我們服務的活動並保存某些信息。')); ?>

            </p>
            <p><?php echo e(aiTrans('Cookies是包含小量數據的文件，可能包括匿名唯一標識符。Cookies會從網站發送到您的瀏覽器並存儲在您的設備上。還使用了追踪技術，包括信標、標籤和腳本來收集和跟踪信息，並改善和分析我們的服務。')); ?>

            </p>
            <p><?php echo e(aiTrans('您可以指示您的瀏覽器拒絕所有Cookies或指示何時發送Cookies。但是，如果您不接受Cookies，您可能無法使用我們服務的某些部分。')); ?>

            </p>
            <p><?php echo e(aiTrans('我們使用的Cookies示例：')); ?></p>
            <ul>
                <li><strong><?php echo e(aiTrans('會話Cookies。')); ?></strong>
                    <?php echo e(aiTrans('我們使用會話Cookies來運營我們的服務。')); ?></li>
                <li><strong><?php echo e(aiTrans('偏好Cookies。')); ?></strong>
                    <?php echo e(aiTrans('我們使用偏好Cookies來記住您的偏好和各種設置。')); ?></li>
                <li><strong><?php echo e(aiTrans('安全Cookies。')); ?></strong>
                    <?php echo e(aiTrans('我們出於安全目的使用安全Cookies。')); ?></li>
                <li><strong><?php echo e(aiTrans('廣告Cookies。')); ?></strong>
                    <?php echo e(aiTrans('廣告Cookies用於向您提供可能與您及您的興趣相關的廣告。')); ?>

                </li>
            </ul>
            <h4><span id="數據的使用"><?php echo e(aiTrans('數據的使用')); ?></span></h4>
            <p><span class="b"><?php echo e(aiTrans('提供者')); ?></span>
                <?php echo e(aiTrans('將收集到的數據用於多種目的：')); ?></p>
            <ul>
                <li><?php echo e(aiTrans('提供和維護我們的服務')); ?></li>
                <li><?php echo e(aiTrans('通知您有關我們服務的變更')); ?></li>
                <li><?php echo e(aiTrans('允許您在選擇時參加我們服務的互動功能')); ?>

                </li>
                <li><?php echo e(aiTrans('提供客戶支持')); ?></li>
                <li><?php echo e(aiTrans('收集分析或有價值的信息，以便我們可以改善我們的服務')); ?></li>
                <li><?php echo e(aiTrans('監控我們服務的使用情況')); ?></li>
                <li><?php echo e(aiTrans('檢測、防止和處理技術問題')); ?></li>
                <li><?php echo e(aiTrans('向您提供新聞、特別優惠和有關我們提供的其他商品、服務和事件的一般信息，這些商品、服務和事件與您已經購買或詢問過的相似，除非您選擇不接收此類信息')); ?>

                </li>
            </ul>
            <h4><span
                    id="根據一般數據保護條例GDPR處理個人數據的法律依據"><?php echo e(aiTrans('根據一般數據保護條例 (GDPR) 處理個人數據的法律依據')); ?></span>
            </h4>
            <p><?php echo e(aiTrans('如果您來自歐洲經濟區 (EEA)，')); ?> <span
                    class="b"><?php echo e(aiTrans('提供者')); ?></span>
                <?php echo e(aiTrans('收集和使用本隱私政策中描述的個人信息的法律依據取決於我們收集的個人數據及其具體上下文。')); ?>

            </p>
            <p><span class="b"><?php echo e(aiTrans('提供者')); ?></span>
                <?php echo e(aiTrans('可能處理您的個人數據，因為：')); ?></p>
            <ul>
                <li><?php echo e(aiTrans('我們需要與您履行合同')); ?></li>
                <li><?php echo e(aiTrans('您已給予我們這樣做的許可')); ?></li>
                <li><?php echo e(aiTrans('處理符合我們的合法利益，且不被您的權利所覆蓋')); ?>

                </li>
                <li><?php echo e(aiTrans('遵守法律')); ?></li>
            </ul>
            <h4><span id="數據的保留"><?php echo e(aiTrans('數據的保留')); ?></span></h4>
            <p><span class="b"><?php echo e(aiTrans('提供者')); ?></span>
                <?php echo e(aiTrans('僅在本隱私政策中列出的目的所需的時間內保留您的個人數據。我們將在法律義務範圍內保留和使用您的個人數據（例如，當我們需要保留您的數據以遵守適用法律時）、解決爭議和執行我們的法律協議和政策。')); ?>

            </p>
            <p><span class="b"><?php echo e(aiTrans('提供者')); ?></span>
                <?php echo e(aiTrans('還將出於內部分析目的保留使用數據。使用數據一般保留的時間較短，除非該數據用於加強安全性或改善我們服務的功能，或者我們有法律義務長時間保留該數據。')); ?>

            </p>
            <h2><span id="數據的轉移"><?php echo e(aiTrans('數據的轉移')); ?></span></h2>
            <p><?php echo e(aiTrans('您的信息，包括個人數據，可能會轉移到您所在的州、省、國家或其他政府管轄區以外的計算機上，並且在那裡維護，該數據保護法可能與您所在的管轄區有所不同。')); ?>

            </p>
            <p><?php echo e(aiTrans('如果您位於保加利亞以外並選擇向我們提供信息，請注意，我們將數據，包括個人數據，轉移到保加利亞並在那裡進行處理。')); ?>

            </p>
            <p><?php echo e(aiTrans('您對本隱私政策的同意以及您提交該信息的行為表明您同意該轉移。')); ?>

            </p>
            <p><span class="b"><?php echo e(aiTrans('提供者')); ?></span>
                <?php echo e(aiTrans('將採取一切合理必要的措施，確保您的數據安全地根據本隱私政策處理，並且在未設置充分的控制措施之前不會將您的個人數據轉移到任何組織或國家，包括您的數據和其他個人信息的安全性。')); ?>

            </p>
            <h4><span id="數據的披露"><?php echo e(aiTrans('數據的披露')); ?></span></h4>
            <h5><span id="商業交易"><?php echo e(aiTrans('商業交易')); ?></span></h5>
            <p><?php echo e(aiTrans('如果')); ?> <span class="b"><?php echo e(aiTrans('提供者')); ?></span>
                <?php echo e(aiTrans('參與合併、收購或資產出售，您的個人數據可能會被轉移。我們將在您的個人數據被轉移並受不同隱私政策約束之前提供通知。')); ?>

            </p>
            <h4><span id="法律要求"><?php echo e(aiTrans('法律要求')); ?></span></h4>
            <p><span class="b"><?php echo e(aiTrans('提供者')); ?></span>
                <?php echo e(aiTrans('可能出於善意信念披露您的個人數據，認為此舉是必要的：')); ?>

            </p>
            <ul>
                <li><?php echo e(aiTrans('遵守法律義務')); ?></li>
                <li><?php echo e(aiTrans('保護和捍衛')); ?> <span
                        class="b"><?php echo e(aiTrans('提供者')); ?></span><?php echo e(aiTrans('的權利或財產')); ?></li>
                <li><?php echo e(aiTrans('防止或調查與服務相關的潛在不當行為')); ?></li>
                <li><?php echo e(aiTrans('保護服務用戶或公眾的人身安全')); ?></li>
                <li><?php echo e(aiTrans('防範法律責任')); ?></li>
            </ul>
            <h4><span id="數據的安全性"><?php echo e(aiTrans('數據的安全性')); ?></span></h4>
            <p><?php echo e(aiTrans('您的數據安全對我們來說很重要，但請記住，互聯網傳輸方法或電子存儲方法都不是100%安全的。雖然我們努力使用商業上可接受的手段來保護您的個人數據，但我們無法保證其絕對安全。')); ?>

            </p>
            <h4><span
                    id="根據一般數據保護條例GDPR的您的數據保護權利"><?php echo e(aiTrans('根據一般數據保護條例 (GDPR) 的您的數據保護權利')); ?></span>
            </h4>
            <p><?php echo e(aiTrans('如果您是歐洲經濟區 (EEA) 的居民，您擁有某些數據保護權利。')); ?>

                <span class="b"><?php echo e(aiTrans('提供者')); ?></span>
                <?php echo e(aiTrans('旨在採取合理步驟，讓您能夠更正、修改、刪除或限制對您個人數據的使用。')); ?>

            </p>
            <p><?php echo e(aiTrans('如果您希望獲得我們擁有的有關您的個人數據的信息，並希望將其從我們的系統中刪除，請聯繫我們。')); ?>

            </p>
            <p><?php echo e(aiTrans('在某些情況下，您擁有以下數據保護權利：')); ?></p>
            <p><strong><?php echo e(aiTrans('訪問、更新或刪除我們擁有的有關您的信息的權利。')); ?></strong>
                <?php echo e(aiTrans('只要有可能，您可以在您的帳戶設置部分直接訪問、更新或請求刪除您的個人數據。如果您無法自行執行這些操作，請聯繫我們以協助您。')); ?><br>
                <strong><?php echo e(aiTrans('更正的權利。')); ?></strong>
                <?php echo e(aiTrans('如果該信息不準確或不完整，您有權更正您的信息。')); ?><br>
                <strong><?php echo e(aiTrans('反對的權利。')); ?></strong>
                <?php echo e(aiTrans('您有權反對我們處理您的個人數據。')); ?><br>
                <strong><?php echo e(aiTrans('限制的權利。')); ?></strong>
                <?php echo e(aiTrans('您有權請求我們限制對您的個人信息的處理。')); ?><br>
                <strong><?php echo e(aiTrans('數據可攜性的權利。')); ?></strong>
                <?php echo e(aiTrans('您有權獲得我們擁有的有關您的信息的副本，格式為結構化的、機器可讀的和常用的。')); ?><br>
                <strong><?php echo e(aiTrans('撤回同意的權利。')); ?></strong>
                <?php echo e(aiTrans('您也有權隨時撤回您的同意，當')); ?> <span
                    class="b"><?php echo e(aiTrans('提供者')); ?></span>
                <?php echo e(aiTrans('依賴您的同意來處理您的個人信息。')); ?></p>
            <p><?php echo e(aiTrans('請注意，我們可能會要求您在回應此類請求之前驗證您的身份。')); ?>

            </p>
            <p><?php echo e(aiTrans('您有權向數據保護機構投訴有關我們收集和使用您個人數據的情況。欲了解更多信息，請聯繫您在歐洲經濟區 (EEA) 的當地數據保護機構。')); ?>

            </p>
            <h2><span id="服務提供者"><?php echo e(aiTrans('服務提供者')); ?></span></h2>
            <p><?php echo e(aiTrans('我們可能聘請第三方公司和個人來促進我們的服務（“服務提供者”），代表我們提供服務，執行與服務相關的服務或幫助我們分析我們的服務的使用情況。')); ?>

            </p>
            <p><?php echo e(aiTrans('這些第三方僅可以訪問您的個人數據，以執行這些任務，並且有義務不會將其披露或用於其他目的。')); ?>

            </p>
            <h4><span id="分析"><?php echo e(aiTrans('分析')); ?></span></h4>
            <p><?php echo e(aiTrans('我們可能會使用第三方服務提供者來監控和分析我們服務的使用。')); ?>

            </p>
            <p><strong><?php echo e(aiTrans('Google Analytics')); ?></strong><br>
                <?php echo e(aiTrans('Google Analytics是由Google提供的網絡分析服務，跟踪和報告網站流量。Google使用收集的數據來跟踪和監控我們的服務的使用情況。這些數據與其他Google服務共享。Google還可能使用收集的數據來上下文化和個性化其自身廣告網絡的廣告。您可以通過安裝Google Analytics退訂瀏覽器附加組件來選擇不將您在服務上的活動提供給Google Analytics。該附加組件防止Google Analytics JavaScript（ga.js，analytics.js和dc.js）與Google Analytics共享有關訪問活動的信息。要了解有關Google隱私實踐的更多信息，請訪問Google隱私條款網頁：')); ?>

                http://www.google.com/intl/en/policies/privacy/</p>
            <h4><span id="廣告"><?php echo e(aiTrans('廣告')); ?></span></h4>
            <p><?php echo e(aiTrans('我們可能會使用第三方服務提供者向您展示廣告，以幫助支持和維護我們的服務。')); ?>

            </p>
            <p><strong><?php echo e(aiTrans('Google AdSense DoubleClick Cookie')); ?></strong><br>
                <?php echo e(aiTrans('Google作為第三方供應商，使用Cookies在我們的服務上投放廣告。Google對DoubleClick Cookie的使用使其及其合作夥伴能夠根據用戶訪問我們的服務或互聯網上的其他網站來向用戶投放廣告。您可以通過訪問Google廣告設置網頁選擇退出基於興趣的廣告：')); ?>

                http://www.google.com/ads/preferences</p>
            <h4><span id="行為再營銷"><?php echo e(aiTrans('行為再營銷')); ?></span></h4>
            <p><span class="b"><?php echo e(aiTrans('提供者')); ?></span>
                <?php echo e(aiTrans('使用再營銷服務在您訪問我們的服務後，在第三方網站上向您廣告。我們和我們的第三方供應商使用Cookies來通知、優化和根據您過去訪問我們的服務的情況投放廣告。')); ?>

            </p>
            <p><strong><?php echo e(aiTrans('Google AdWords')); ?></strong><br>
                <?php echo e(aiTrans('Google AdWords再營銷服務由Google Inc.提供。您可以通過訪問Google廣告設置頁面選擇退出Google Analytics的顯示廣告並自定義Google展示廣告網絡的廣告：')); ?>

                <a href="http://www.google.com/settings/ads" target="_blank"
                    rel="noopener"><?php echo e(aiTrans('http://www.google.com/settings/ads')); ?></a>
                <?php echo e(aiTrans('Google還建議安裝Google Analytics退訂瀏覽器附加組件——')); ?> <a
                    href="https://tools.google.com/dlpage/gaoptout" target="_blank"
                    rel="noopener">https://tools.google.com/dlpage/gaoptout</a> –
                <?php echo e(aiTrans('以便為您的網絡瀏覽器使用。Google Analytics退訂瀏覽器附加組件使訪問者能夠防止其數據被Google Analytics收集和使用。要了解有關Google隱私實踐的更多信息，請訪問Google隱私條款網頁：')); ?>

                <a href="https://www.google.com/intl/en/policies/privacy/" target="_blank"
                    rel="noopener">http://www.google.com/intl/en/policies/privacy</a></p>
            <p><strong><?php echo e(aiTrans('Facebook')); ?></strong><br>
                <?php echo e(aiTrans('Facebook再營銷服務由Facebook Inc.提供。您可以通過訪問此頁面了解有關Facebook基於興趣的廣告的更多信息：')); ?>

                
                <?php echo e(aiTrans('要選擇退出Facebook的基於興趣的廣告，請遵循Facebook的這些指示：')); ?> https://www.facebook.com/help/568137493302217
                <?php echo e(aiTrans('Facebook遵循數字廣告聯盟建立的在線行為廣告自律原則。您還可以通過數字廣告聯盟選擇退出Facebook和其他參與公司')); ?>

                ,
                <?php echo e(aiTrans('在加拿大的數字廣告聯盟')); ?> 
                <?php echo e(aiTrans('或在歐洲的歐洲互動數字廣告聯盟')); ?> ,
                <?php echo e(aiTrans('或使用您的移動設備設置選擇退出。要了解有關Facebook隱私實踐的更多信息，請訪問Facebook的數據政策：')); ?>

                </p>
            <h4><span id="鏈接到其他網站"><?php echo e(aiTrans('鏈接到其他網站')); ?></span></h4>
            <p><?php echo e(aiTrans('我們的服務可能包含指向我們未經運營的其他網站的鏈接。如果您點擊第三方鏈接，您將被引導到該第三方的網站。我們強烈建議您查看每個您訪問的網站的隱私政策。')); ?>

            </p>
            <p><?php echo e(aiTrans('我們無法控制，並對任何第三方網站或服務的內容、隱私政策或做法不承擔任何責任。')); ?>

            </p>
            <h4><span id="兒童隱私"><?php echo e(aiTrans('兒童隱私')); ?></span></h4>
            <p><?php echo e(aiTrans('我們的服務不針對18歲以下的任何人（“兒童”）。')); ?></p>
            <p><?php echo e(aiTrans('我們不會故意收集任何18歲以下人士的可識別個人的信息。如果您是父母或監護人，並且您知道您的兒童向我們提供了個人數據，請聯繫我們。如果我們意識到我們在未經父母同意的情況下收集了兒童的個人數據，我們將採取措施從我們的伺服器上刪除該信息。')); ?>

            </p>
            <h4><span id="對本隱私政策的更改"><?php echo e(aiTrans('對本隱私政策的更改')); ?></span></h4>
            <p><?php echo e(aiTrans('我們可能會不時更新我們的隱私政策。我們將通過在此頁面上發布新的隱私政策來通知您任何變更。')); ?>

            </p>
            <p><?php echo e(aiTrans('在變更生效之前，我們將通過電子郵件和/或在我們服務上的顯著通知告知您，並在本隱私政策的頂部更新“生效日期”。')); ?>

            </p>
            <p><?php echo e(aiTrans('我們建議您定期查看本隱私政策以了解任何變更。對本隱私政策的更改在發布於本頁面時生效。')); ?>

            </p>
            <h4><span id="聯繫我們"><?php echo e(aiTrans('聯繫我們')); ?></span></h4>
            <p><?php echo e(aiTrans('如果您對本隱私政策有任何疑問，請通過電子郵件聯繫我們。')); ?></p>
        </main>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/enng1/public_html/immediate13.com/resources/views/frontend/zh/privacy.blade.php ENDPATH**/ ?>