<?php $__env->startPush('header'); ?>
    <!-- Include CodeMirror library CSS -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/codemirror/5.58.3/codemirror.min.css">
    <!-- Include CodeMirror theme CSS (Monokai theme) -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/codemirror/5.58.3/theme/monokai.min.css">
    <style>
        /* Style the code editor elements with a border */
        .CodeMirror {

            border: 1px solid black;
        }
    </style>
<?php $__env->stopPush(); ?>
<?php $__env->startPush('scripts'); ?>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/codemirror/5.62.0/codemirror.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/codemirror/5.62.0/mode/css/css.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/codemirror/5.62.0/mode/javascript/javascript.min.js"></script>



    <script>
        $(document).ready(function () {
            // Initialize CodeMirror for CSS code editor
            let cssEditors = document.querySelectorAll('.css-code-editor');

            cssEditors.forEach(editor => {
                // Initialize CodeMirror for each CSS code editor
                let cssEditor = CodeMirror.fromTextArea(editor, {
                    mode: 'text/css',
                    lineNumbers: false,
                    theme: 'monokai', // Set the dark theme here
                    smartIndent: true,
                    autofocus: true
                });
            });


            let JsEditors = document.querySelectorAll('.js-code-editor');

            JsEditors.forEach(editor => {
                // Initialize CodeMirror for each CSS code editor
                let jsEditor = CodeMirror.fromTextArea(editor, {
                    mode: 'text/javascript',
                    lineNumbers: false,
                    theme: 'monokai', // Set the dark theme here
                    smartIndent: true,
                    autofocus: true
                });
            });
        });

    </script>
    <script src="<?php echo e(asset('vendor/hsmfawaz/ui/metronic/assets/plugins/custom/tinymce/tinymce.bundle.js')); ?>"></script>

    <script>

        let options = {
            selector: ".tinymce",
            height: "480",
            plugins: "code",
            toolbar: ' undo redo styleselect bold italic alignleft aligncenter alignright alignjustify | bullist numlist outdent indent code'

        };

        tinymce.init(options);
        $(document).ready(function (e) {
            $('a[data-bs-toggle="tab"]').on("click", function () {
                let newUrl;
                let hash = $(this).attr("href");
                hash = hash.substring(1, hash.length);
                newUrl = '<?php echo e(url()->current()); ?>/?tab=' + hash;
                history.replaceState(null, null, newUrl);
            });
            $('.nav-tabs a[href="#<?php echo e(request('tab')); ?>"]').tab('show');

            $("#crud-modal-form input").on("invalid", function () {
                //find tab id
                let $closest = $(this).closest('.tab-pane');
                let id = $closest.attr('id');
                //goto tab id
                $('.nav-tabs a[href="#' + id + '"]').tab('show');
            });

            <?php if($errors->any()): ?>
            $('.nav-tabs a[href="#<?php echo e(request('tab')); ?>"]').tab('show');
            <?php endif; ?>
        });

    </script>
<?php $__env->stopPush(); ?>
<?php $__env->startSection('content'); ?>
    <?php $__env->startSection('actions'); ?>
        <button form="crud-modal-form" type="submit" class="btn btn-success mx-2 px-5">
            <?php echo e(__('Save Data')); ?>

        </button>
        <a href="<?php echo e(route('dashboard.core.settings.index')); ?>"
           class="btn btn-secondary btn-back">
            <!-- <?php echo e(__('Go Back')); ?> -->

            <i class="fas fa-arrow-left"></i>
        </a>
    <?php $__env->stopSection(); ?>
    <div class="card">
        <div class="col-span-12">
            <div class=" card-body ">
                <?php if(session('status')): ?>
                    <div class="alert alert-success">
                        <?php echo e(session('status')); ?>

                    </div>
                <?php endif; ?>
                <?php echo Form::open(['route' => 'dashboard.core.settings.store', 'files' => true,'id'=>'crud-modal-form']); ?>

                <?php echo csrf_field(); ?>

                <?php $i=0; ?>
                <?php $tabcount=0; ?>
                <?php if(count(config('setting_fields', [])) ): ?>
                    <ul class="nav nav-custom nav-tabs nav-line-tabs nav-line-tabs-2x border-0 fs-4 fw-bold mb-n2"
                        id="nav-tabs" role="tablist">
                        <?php $__currentLoopData = config('setting_fields'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $section => $fields): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                            <?php $tabcount++; ?>
                            <li class="nav-item">
                                <a class="nav-link text-active-primary pb-4 <?php if($tabcount == 1): ?> active <?php endif; ?>"
                                   id="home-tab-<?php echo e($section); ?>" data-bs-toggle="tab"
                                   href="#<?php echo e($fields['tab']); ?>">

                                    <?php echo e(__($fields['title'])); ?>

                                </a>
                            </li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                    <div class="tab-content">
                        <?php $__currentLoopData = config('setting_fields'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $section => $fields): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php $i++; ?>
                            <div class="tab-pane fade <?php if($i == 1): ?> active show <?php endif; ?>" id="<?php echo e($fields['tab']); ?>"
                                 role="tab-panel">
                                <div class="row">
                                    <?php $__currentLoopData = $fields['elements']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $field): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php echo $__env->make('dashboard.core.settings.fields.' . $field['file_type'] , \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                            </div>
                            <!-- end panel for  -->
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                <?php endif; ?>

                <?php echo Form::close(); ?>

            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('ui::layout.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/enng1/public_html/immediate13.com/resources/views/dashboard/core/settings/index.blade.php ENDPATH**/ ?>